/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.FKPropertyDialogOraclev9i;

public class FKProxyOracle
extends IndexProxy
implements StorageObjectListener {
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static List initiallyList = Arrays.asList(INITIALLY);
    private static Set initiallySet = null;
    private String initially = INITIALLY[0];
    private String deferrable = "NO";
    private String rely = "NO";
    private String enable = "YES";
    private String validate = "YES";
    private TableProxyOracle exceptionsTable = null;

    public FKProxyOracle(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public FKProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return "ForeignKey";
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        this.fireChange(event);
    }

    public String getColumns() {
        return this.getColumns(this.getStorageDesign());
    }

    public String getColumns(StorageDesign storageDesign) {
        StringBuffer result = new StringBuffer();
        ColumnProxy[] columns = this.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                result.append(",\n");
            }
            String name = storageDesign.getFormatedName(columns[i]);
            result.append("     ").append(name);
        }
        return result.toString();
    }

    public FKContainer getFKTable() {
        return this.getIndex().getFKAssociation().getRemoteTable();
    }

    public String getReferenceTable() {
        RelationalObjectProxy tableProxy = null;
        FKContainer remoteTable = this.getFKTable();
        if (remoteTable instanceof Table) {
            tableProxy = this.getStorageDesign().getTableProxySet().getProxy(remoteTable.getObjectID());
        } else if (remoteTable instanceof TableView) {
            tableProxy = this.getStorageDesign().getTableViewProxySet().getProxy(remoteTable.getObjectID());
        }
        if (tableProxy != null) {
            return tableProxy.getLongName();
        }
        return "";
    }

    public String getReferenceTableDDL() {
        RelationalObjectProxy tableProxy = null;
        FKContainer remoteTable = this.getFKTable();
        if (remoteTable instanceof Table) {
            tableProxy = this.getStorageDesign().getTableProxySet().getProxy(remoteTable.getObjectID());
        } else if (remoteTable instanceof TableView) {
            tableProxy = this.getStorageDesign().getTableViewProxySet().getProxy(remoteTable.getObjectID());
        }
        if (tableProxy != null) {
            return tableProxy.getLongNameDDL();
        }
        return "";
    }

    public String getReferenceColumns() {
        return this.getReferenceColumns(this.getStorageDesign());
    }

    public String getReferenceColumns(StorageDesign storageDesign) {
        StringBuffer result = new StringBuffer();
        KeyObject remoteIndex = this.getIndex().getFKAssociation().getRemoteIndex();
        ContainedObject[] columns = remoteIndex.getElements();
        for (int i = 0; i < columns.length; ++i) {
            ModelIDObject columnObject;
            if (i > 0) {
                result.append(",\n");
            }
            if ((columnObject = storageDesign.getColumnProxySet().getProxy(columns[i].getObjectID())) == null) {
                columnObject = columns[i];
            }
            String name = storageDesign.getFormatedName(columnObject);
            result.append("     ").append(name);
        }
        return result.toString();
    }

    public ContainedObject[] getRefColumns() {
        KeyObject remoteIndex = this.getIndex().getFKAssociation().getRemoteIndex();
        return remoteIndex.getElements();
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    protected boolean checkInitially(String value) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(FKProxyOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(value);
    }

    public void setInitially(String initially) {
        if (this.checkInitially(initially)) {
            this.initially = initially;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setRely(String rely) {
        if (ConstantsOracle.checkYesNo(rely)) {
            this.rely = rely;
            this.fireDataFieldChange();
        }
    }

    public String getRely() {
        return this.rely;
    }

    public void setDeferrable(String deferrable) {
        if (ConstantsOracle.checkYesNo(deferrable)) {
            this.deferrable = deferrable;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setEnable(String enable) {
        if (ConstantsOracle.checkYesNo(enable)) {
            this.enable = enable;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String validate) {
        if (ConstantsOracle.checkYesNo(validate)) {
            this.validate = validate;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle exceptionsTable) {
        this.exceptionsTable = exceptionsTable;
        this.fireDataFieldChange();
    }

    public static List getInitiallyValues() {
        return initiallyList;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FKPropertyDialogOraclev9i dialog = new FKPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String name = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            name = index.getFKAssociation().getName();
        }
        name = this.applyNameSubstitution(name);
        return name;
    }
}

