/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnIdentityDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.ColumnPropertyDialogDB2v80;
import oracle.dbtools.crest.util.options.Settings;

public class ColumnProxyDB2v80
extends ColumnProxyDB2 {
    private boolean orderChanged;
    private String generationExpression = "";
    private String autoIncrementDDL = "";
    public static final String TRIGGER = "TRIGGER";
    public static final String IDENTITY_CLAUSE = "IDENTITY_CLAUSE";
    public static final String[] AUTOINCREMENTDDL = new String[]{"", "NONE", "TRIGGER", "IDENTITY_CLAUSE"};

    public ColumnProxyDB2v80(Column column, StorageDesign storage) {
        super(column, storage);
    }

    public ColumnProxyDB2v80(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public void setIdentity(ColumnIdentityDB2v80 identity) {
        if (this.identity != identity) {
            this.identity = identity;
            this.fireDataFieldChange();
        }
    }

    @Override
    public ColumnIdentityDB2 createColumnIdentity() {
        if (this.identity == null) {
            this.identity = ((StorageDesignDB2v80)this.getStorageDesign()).getColumnIdentitySet().createColumnIdentity();
        }
        return this.identity;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogDB2v80 dialog = new ColumnPropertyDialogDB2v80(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    public static String[] getAutoIncrementDDLChoices() {
        return AUTOINCREMENTDDL;
    }

    public String getAutoIncrementDDL() {
        return this.autoIncrementDDL;
    }

    public void setAutoIncrementDDL(String autoIncrementDDL) {
        this.autoIncrementDDL = autoIncrementDDL;
    }

    public String getDDLTypeForAutoIncCol() {
        String autoIncrementDDL = this.getAutoIncrementDDL();
        if (autoIncrementDDL.equals("")) {
            Settings settings = this.getAppView().getSettings();
            Column columnObj = (Column)this.getObject();
            if (columnObj.isIdentityColumn()) {
                String dt;
                autoIncrementDDL = settings.getDefaultDB2IdentityDDL();
                if (autoIncrementDDL.equals(IDENTITY_CLAUSE) && ((dt = columnObj.getDatatypeString(this.getStorageDesign().getRDBMSType().getName())).toUpperCase().indexOf("CHAR") > -1 || columnObj.getTable().isBST())) {
                    autoIncrementDDL = settings.getDefaultDB2AutoIncDDL();
                }
            } else {
                autoIncrementDDL = settings.getDefaultDB2AutoIncDDL();
            }
            if (columnObj.getParentObject() != null && autoIncrementDDL.equals(IDENTITY_CLAUSE)) {
                autoIncrementDDL = TRIGGER;
            }
        }
        return autoIncrementDDL;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Column column = (Column)targetDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxyDB2v80 columnProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignDB2v80)targetDesign).getColumnProxySet().getProxy(column.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            columnProxy = (ColumnProxyDB2v80)storageObject;
        }
        if (columnProxy != null) {
            columnProxy.setName(this.getName());
            columnProxy.setBitData(this.getBitData());
            columnProxy.setDefault(this.getDefault());
            columnProxy.setDefaultValue(this.getDefaultValue());
            columnProxy.setDefaultValueConstant(this.getDefaultValueConstant());
            columnProxy.setProgram(this.getProgram());
            columnProxy.setConstant(this.getConstant());
            columnProxy.setLabel(this.getLabel());
            columnProxy.setUseIdentity(this.isUseIdentity());
            if (this.getColumnIdentity() != null) {
                ColumnIdentityDB2v80 colIdentity = (ColumnIdentityDB2v80)((StorageDesignDB2v80)targetDesign).getColumnIdentitySet().getByName(this.getColumnIdentity().getName());
                if (colIdentity == null) {
                    ColumnIdentityDB2v80 newIdentity = (ColumnIdentityDB2v80)((StorageDesignDB2v80)targetDesign).getColumnIdentitySet().createColumnIdentity();
                    newIdentity.setName(this.getColumnIdentity().getName());
                    newIdentity.setRawObject(true);
                    newIdentity.setColumn(columnProxy);
                    columnProxy.setColumnIdentity(newIdentity);
                } else {
                    colIdentity.setColumn(columnProxy);
                    columnProxy.setColumnIdentity(colIdentity);
                }
            }
            columnProxy.setGenerationExpression(this.getGenerationExpression());
            columnProxy.setComment(this.getComment());
            columnProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            columnProxy.setRawObject(false);
            columnProxy.setAutoIncrementDDL(this.getAutoIncrementDDL());
        }
    }

    public boolean isOrderChanged() {
        return this.orderChanged;
    }

    public void setOrderChanged(boolean orderChanged) {
        this.orderChanged = orderChanged;
    }

    public String getGenerationExpression() {
        return this.generationExpression;
    }

    public void setGenerationExpression(String generationExpression) {
        this.generationExpression = generationExpression;
    }
}

