/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.RDBMSObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.SubstitutionPattern;

public abstract class StorageObject
extends ModelIDObject
implements UpdateSubject,
RDBMSObject {
    public final ObjectChangeEvent GENERATED_IN_RDBMS_CHANGED = new ObjectChangeEvent("generated in RDBMS");
    public final ObjectChangeEvent DATAFIELD_CHANGED = new ObjectChangeEvent("Some data field changed");
    public static final String[] RELATIVE_PATH_DUMMY = new String[]{"proxy_or_site_elm", "object_type_elm"};
    private StorageDesign storageDesign = null;
    private boolean generatedInRDBMS = false;
    private boolean markedGenerate = true;
    private UpdateSubjectImpl updateDelegate = new UpdateSubjectImpl();
    private boolean isNullInstance = false;
    private boolean storableNullInstance = false;
    private boolean rawObject = false;
    public static final String NAME_SUBSTITUTION_TYPE = "Unsupported Type";
    protected SchemaObject schemaObject;
    private boolean nameChanged = false;

    public List<JMenuItem> getAdditionalActions() {
        return new ArrayList<JMenuItem>();
    }

    public String getFullyQualifiedName() {
        if (this instanceof OwnedObject) {
            Owner owner = ((OwnedObject)((Object)this)).getOwner();
            String name = "";
            if (!owner.isNullInstance() && (name = owner.isNameChanged() ? new StringBuffer(owner.getName()).append('.').append(this.getName()).toString() : (owner.getSchemaObject() != null ? new StringBuffer(owner.getSchemaObject().getName()).append('.').append(this.getName()).toString() : new StringBuffer(owner.getName()).append('.').append(this.getName()).toString())).indexOf(46) == 0 && name.length() > 0) {
                String string = name.substring(1);
            }
        }
        return this.getName();
    }

    @Override
    public String getLongName() {
        return this.getFullyQualifiedName();
    }

    public String getLongNameDDL() {
        if (this.getStorageDesign().getAppView().getSettings().isIncludeSchemaInDDL()) {
            return this.getLongName();
        }
        return this.getName();
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public PropertyHolder getPropertyHolder() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        RepositoryObject pac;
        if (this.isNullInstance() && !this.isStorableNullInstance()) {
            return true;
        }
        if (!this.isPAC_Element() && (pac = this.getPAC_Element()).getRepositoryOID() != null && this.getDesign().isLoadFromDB() && !this.getStorageDesign().isLoading()) {
            return !pac.isCheckedOutByMe();
        }
        if (this.getRepositoryOID() != null && this.getDesign().isLoadFromDB() && !this.getStorageDesign().isLoading()) {
            return !this.isCheckedOutByMe();
        }
        return this.readOnly;
    }

    public boolean isPhysicalObjectProxy() {
        return false;
    }

    public boolean isNullInstance() {
        return this.isNullInstance;
    }

    public void setIsNullInstance(boolean value) {
        this.isNullInstance = value;
    }

    public void addObjectListener(StorageObjectListener listener) {
        this.getListeners().add(listener);
    }

    public void removeObjectListener(StorageObjectListener listener) {
        this.getListeners().remove(listener);
    }

    protected void fireDataFieldChange() {
        this.fireChange(this.DATAFIELD_CHANGED);
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
        Object saveAffected = event.getAffected();
        event.setAffected(this);
        this.setDirty(true);
        this.getChange().setTimeNow();
        Object[] array = this.getListeners().toArray();
        for (int i = 0; i < array.length; ++i) {
            StorageObjectListener listener = (StorageObjectListener)array[i];
            listener.changed(this, event);
        }
        this.fireUpdate();
        event.setAffected(saveAffected);
    }

    protected void fireChangeNoDirty(ObjectChangeEvent event) {
        Object saveAffected = event.getAffected();
        event.setAffected(this);
        Object[] array = this.getListeners().toArray();
        for (int i = 0; i < array.length; ++i) {
            StorageObjectListener listener = (StorageObjectListener)array[i];
            listener.changed(this, event);
        }
        this.fireUpdate();
        event.setAffected(saveAffected);
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        RepositoryObject pac = this.getPAC_Element();
        if (pac != null) {
            pac.setDirty(dirty);
        }
        if (dirty && this.storageDesign != null) {
            this.storageDesign.setDirty(dirty);
        }
    }

    protected void fireUpdate() {
        this.updateDelegate.fireChange();
    }

    @Override
    public void addUpdateListener(UpdateListener listener) {
        this.updateDelegate.addUpdateListener(listener);
    }

    @Override
    public void removeUpdateListener(UpdateListener listener) {
        this.updateDelegate.removeUpdateListener(listener);
    }

    @Override
    public boolean isGeneratedInRDBMS() {
        return this.generatedInRDBMS;
    }

    @Override
    public void setGeneratedInRDBMS(boolean value) {
        this.generatedInRDBMS = value;
        this.fireChange(this.GENERATED_IN_RDBMS_CHANGED);
    }

    @Override
    public boolean isMarkedGenerate() {
        return this.getStorageDesign().isOpen() && this.markedGenerate && !this.isNullInstance();
    }

    @Override
    public void setMarkedGenerate(boolean value) {
        this.markedGenerate = value;
    }

    @Override
    public boolean belongsTo(StorageDesign storageDesign) {
        if (this.getStorageDesign() == null) {
            return false;
        }
        return this.getStorageDesign().equals(storageDesign) && this.belongsToDesign();
    }

    public RDBMSSite getRDBMSSite() {
        return this.getStorageDesign().getRDBMSSite();
    }

    public RDBMSType getRDBMSType() {
        return this.getStorageDesign().getRDBMSType();
    }

    public String[] getRelativePath() {
        return RELATIVE_PATH_DUMMY;
    }

    public boolean isSiteStorageObject() {
        return true;
    }

    public final boolean isDesignStorageObject() {
        return !this.isSiteStorageObject();
    }

    public boolean isOwnedObject() {
        return this instanceof OwnedObject;
    }

    public OwnedObject asOwnedObject() {
        return (OwnedObject)((Object)this);
    }

    public void clearChildren() {
    }

    public void remove(boolean force) {
        if (!this.isNullInstance) {
            if (!force) {
                this.remove();
            } else if (this.getStorageDesign() != null) {
                RepositoryObject pac;
                StorageObjectSet set = (StorageObjectSet)this.getObjectSet();
                if (set == null && (set = this.getStorageDesign().getStorageObjectSetForType(this.getObjectTypeName())) == null) {
                    set = this.getStorageDesign().getStorageObjectSetForType(this.getOldObjectTypeName());
                }
                if (set != null) {
                    StorageDesign sd = this.getStorageDesign();
                    this.clearChildren();
                    set.remove(this);
                    sd.setDirty(true);
                }
                if ((pac = this.getPAC_Element()) != null) {
                    pac.setDirty(true);
                }
                this.remove();
            }
        }
    }

    @Override
    public void remove() {
        if (this.isWriteable() && this.getStorageDesign() != null) {
            RepositoryObject pac;
            StorageObjectSet set = (StorageObjectSet)this.getObjectSet();
            if (set == null && (set = this.getStorageDesign().getStorageObjectSetForType(this.getObjectTypeName())) == null) {
                set = this.getStorageDesign().getStorageObjectSetForType(this.getOldObjectTypeName());
            }
            this.clearChildren();
            if (set != null) {
                StorageDesign sd = this.getStorageDesign();
                set.remove(this);
                sd.setDirty(true);
            }
            if ((pac = this.getPAC_Element()) != null) {
                pac.setDirty(true);
            }
        }
    }

    @Override
    public void setObjectID(String id) {
        if (this.storageDesign != null) {
            this.getStorageDesign().unregisterModelIDObject(this);
            this.id = id;
            this.getStorageDesign().registerModelIDObject(this);
        } else {
            this.id = id;
        }
    }

    public void setLongName(String value) {
    }

    @Override
    public abstract void showPropertyDialog();

    public boolean canDeleteInGUI() {
        return true;
    }

    public boolean hasPropertyDialog() {
        return true;
    }

    public String getNameSubstitutionType() {
        return NAME_SUBSTITUTION_TYPE;
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        return super.allowName(name, isLongName);
    }

    @Override
    public boolean setName(String name) {
        if (name != null && !this.isNameFixed()) {
            if (this.name.equals(name)) {
                return true;
            }
            if (this.getStorageDesign() != null) {
                this.getStorageDesign().setObjectListChanged(true);
            }
            if (this.isTopLevelObject()) {
                if ("".equals(this.name) && this.getStorageDesign() != null && (this.getStorageDesign().isLoading() || this.getStorageDesign().getAppView().isImporting())) {
                    this.name = name;
                    return true;
                }
                boolean result = super.setName(name);
                if (result && this.getStorageDesign() != null && !this.getStorageDesign().isLoading() && ApplicationView.canLogging) {
                    this.sortObjectSet();
                }
                return result;
            }
            this.name = name;
            return true;
        }
        return false;
    }

    protected void sortObjectSet() {
        StorageObjectSet set = (StorageObjectSet)this.getObjectSet();
        if (set != null) {
            set.sort();
        }
    }

    @Override
    public String getName() {
        String name = super.getName();
        name = this.applyNameSubstitution(name);
        return name;
    }

    protected String applyNameSubstitution(String myname) {
        SubstitutionPattern substPattern;
        if (this.getDesign().isApplyNameSubstitution() && !this.getNameSubstitutionType().equals(NAME_SUBSTITUTION_TYPE) && this.getStorageDesign().isNameSubstitutionTypeSelected(this.getNameSubstitutionType()) && (substPattern = this.getsSubstitutionPatterns(myname)) != null) {
            String name = myname;
            if (name == null) {
                return "";
            }
            if ((name = this.replaceWord(name, substPattern)).indexOf(46) == 0) {
                name = name.substring(1);
            }
            return name;
        }
        return myname;
    }

    private SubstitutionPattern getsSubstitutionPatterns(String name) {
        DesignLevelSettings settings = this.getDesign().getDesignLevelSettings();
        for (SubstitutionPattern substPattern : settings.getSubstitutionList()) {
            if (!substPattern.isSelected() || !this.hasString(name, substPattern)) continue;
            return substPattern;
        }
        return null;
    }

    private boolean hasString(String name, SubstitutionPattern substPattern) {
        String sourceString = substPattern.getSourceString();
        if (!substPattern.isCaseSensitive()) {
            sourceString = sourceString.toUpperCase();
            name = name.toUpperCase();
        }
        return name.indexOf(sourceString) > -1;
    }

    private String replaceWord(String name, SubstitutionPattern substPattern) {
        String sourceString = substPattern.getSourceString();
        int index = -1;
        if (!substPattern.isCaseSensitive()) {
            String mysourceString = sourceString.toUpperCase();
            String myname = name.toUpperCase();
            index = myname.indexOf(mysourceString);
        } else {
            index = name.indexOf(sourceString);
        }
        if (index > -1) {
            String partBefore = name.substring(0, index);
            String partAfter = name.substring(index + substPattern.getSourceString().length());
            name = partBefore + substPattern.getReplacementString() + partAfter;
        }
        return name;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void copy(StorageDesign stDesign) {
    }

    public boolean isRawObject() {
        return this.rawObject;
    }

    public void setRawObject(boolean rawObject) {
        this.rawObject = rawObject;
    }

    public boolean isTopLevelObject() {
        return true;
    }

    public void clearNoneMergableStructure() {
    }

    public void clearMergableStructure(Map reverseMap) {
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        if (id == null) {
            return null;
        }
        Object result = this.storageDesign.getStorageObject(id);
        if ("schemaObject".equals(propertyName)) {
            Object obj;
            Map map = this.storageDesign.getCorrespondenceMap();
            if (map != null && (obj = map.get(id)) instanceof SchemaObject) {
                result = obj;
            }
        } else if ("implementedDomain".equals(propertyName)) {
            Object obj;
            Map map = this.storageDesign.getCorrespondenceMap();
            if (map != null && (obj = map.get(id)) instanceof Domain) {
                result = obj;
            }
        } else if (result == null) {
            ModelIDObject obj;
            String newID = null;
            Map map = this.storageDesign.getCorrespondenceMap();
            if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
                newID = obj.getObjectID();
                result = this.storageDesign.getStorageObject(newID);
            }
        }
        if (result != null) {
            return result;
        }
        if ("schemaObject".equals(propertyName) || "implementedDomain".equals(propertyName)) {
            result = super.translateIdToObject(propertyName, id);
        }
        return result;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getStorageDesign().getStoragePath(), this.getObjectTypeName() + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public void setNameChanged(boolean nameChanged) {
        this.nameChanged = nameChanged;
    }

    @Override
    public String getDirectorySegmentName() {
        StorageObjectSet set;
        if ("".equals(this.directorySegmentName) && (set = (StorageObjectSet)this.getObjectSet()) != null) {
            this.directorySegmentName = set.getSegmentName(this);
        }
        return this.directorySegmentName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getSegmentedStorageName() {
        StorageObjectSet set = (StorageObjectSet)this.getObjectSet();
        if (this.segmentedStorageName != null) return this.segmentedStorageName;
        if (set == null) return super.getSegmentedStorageName();
        String sname = set.getSegmentName(this);
        if ("".equals(sname)) return super.getSegmentedStorageName();
        String sn = this.getStorageName();
        if (sn == null || "".equals(sn)) return this.segmentedStorageName;
        File file = new File(sn);
        String fname = file.getName();
        this.segmentedStorageName = file.getParent() + File.separatorChar + sname + File.separatorChar + fname;
        return this.segmentedStorageName;
    }

    @Override
    public void setDirectorySegmentName(String directorySegmentName) {
        this.setDirectorySegmentName(directorySegmentName, true);
    }

    @Override
    public void setDirectorySegmentName(String directorySegmentName, boolean clear) {
        StorageObjectSet set;
        if (directorySegmentName != null && !"".equals(directorySegmentName) && (set = (StorageObjectSet)this.getObjectSet()) != null) {
            set.addSegmentEntry(directorySegmentName, this.getObjectID(), clear);
        }
        this.directorySegmentName = directorySegmentName;
    }

    public boolean isStorableNullInstance() {
        return this.storableNullInstance;
    }

    public void setStorableNullInstance(boolean storableNullInstance) {
        this.storableNullInstance = storableNullInstance;
    }

    @Override
    public String replaceIDsInValue(String value) {
        if (value != null && !"".equals(value)) {
            String res = "";
            Map map = this.getStorageDesign().getCorrespondenceMap();
            if (map != null) {
                String separator = null;
                if (value.indexOf(44) > 0) {
                    separator = ",";
                } else if (value.indexOf(124) > 0) {
                    separator = "|";
                } else if (value.trim().indexOf(32) > 0) {
                    value = value.trim();
                    separator = " ";
                }
                if (separator != null) {
                    StringTokenizer st = new StringTokenizer(value, separator);
                    boolean first = true;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        String id = token.trim();
                        ModelIDObject obj = (ModelIDObject)map.get(id);
                        if (obj != null && obj.getObjectID() != id) {
                            token = obj.getObjectID();
                        }
                        if (first) {
                            res = token;
                            first = false;
                            continue;
                        }
                        res = res + separator + token;
                    }
                    return res;
                }
                ModelIDObject obj = (ModelIDObject)map.get(value);
                if (obj != null) {
                    String newID = obj.getObjectID();
                    return newID;
                }
            }
        }
        return value;
    }

    @Override
    public ElementSet getSet() {
        return this.getObjectSet();
    }

    @Override
    public String getModelID() {
        return this.getStorageDesign().getObjectID();
    }

    @Override
    public DesignObject getGenerator() {
        return null;
    }

    public StorageObject getStObGenerator() {
        return this.getStorageDesign().getStorageObject(this.getGeneratorID());
    }
}

