/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.io.File;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;
import oracle.dbtools.crest.util.logging.Logger;

public class RelationalObjectProxy
extends StorageObject
implements UpdateSubject,
ObjectListener {
    private DesignObject object = null;
    private String id = null;
    private String longName = null;
    private boolean nameChanged = false;
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    private UpdateSubjectImpl updateDelegate = new UpdateSubjectImpl();
    private RelationalObjectProxySet proxySet;
    private static final Logger LOGGER = new Logger(RelationalObjectProxy.class);

    public RelationalObjectProxy(DesignObject object, StorageDesign storageDesign) {
        this.object = object;
        this.setStorageDesign(storageDesign);
        this.setObjectID(object.getObjectID());
        this.id = object.getObjectID();
        this.longName = object.getLongName();
        this.setDesign(object.getDesign());
        this.setName(object.getName());
        this.setNameChanged(false);
        object.addObjectListener(this);
    }

    public RelationalObjectProxy(Design design, String id, String longName, StorageDesign storageDesign) {
        this.id = id;
        this.longName = longName;
        this.setDesign(design);
        this.setStorageDesign(storageDesign);
    }

    public DesignObject getObject() {
        if (this.object == null) {
            this.loadDesignObject();
        }
        return this.object;
    }

    public void setObject(DesignObject object) {
        this.object = object;
    }

    public boolean loadDesignObject() {
        if (this.getStorageDesign().isClosing()) {
            return false;
        }
        if (this.object == null && this.getDesign() != null) {
            this.object = this.getDesign().getDesignObject(this.id);
            if (this.object == null) {
                try {
                    this.object = (DesignObject)this.getDesign().getAppView().getPersistenceManager().read((Object)this.getObjectID(), this.getDesign(), true);
                    this.object.addObjectListener(this);
                    this.longName = this.object.getLongName();
                    this.fireUpdate();
                }
                catch (Exception e) {
                    LOGGER.error("PhysicalObjectProxy can not load object: " + this.getObjectID(), e);
                }
            }
            if (this.isLoaded()) {
                this.setName(this.object.getName());
            }
        }
        return this.isLoaded();
    }

    public boolean isLoaded() {
        return this.object != null;
    }

    @Override
    public String getObjectID() {
        return this.id;
    }

    @Override
    public void setObjectID(String id) {
        this.id = id;
    }

    @Override
    public String getLongName() {
        if (this.isLoaded()) {
            this.longName = this.getObject().isContainedObject() ? this.getObject().getLongName() : super.getLongName();
        } else if (this.longName == null) {
            this.longName = this.getObjectID();
        }
        return this.longName;
    }

    @Override
    public String getLongNameDDL() {
        if (this.getStorageDesign().getAppView().getSettings().isIncludeSchemaInDDL()) {
            return this.getLongName();
        }
        return this.getName();
    }

    @Override
    public String toString() {
        return this.getLongName();
    }

    public boolean isTable() {
        return false;
    }

    @Override
    public void addUpdateListener(UpdateListener listener) {
        this.updateDelegate.addUpdateListener(listener);
    }

    @Override
    public void removeUpdateListener(UpdateListener listener) {
        this.updateDelegate.removeUpdateListener(listener);
    }

    @Override
    protected void fireUpdate() {
        this.updateDelegate.fireChange();
    }

    @Override
    public String getIDPrefix() {
        return "PROXY";
    }

    @Override
    public String getObjectTypeName() {
        return "PROXY";
    }

    @Override
    public final boolean isPhysicalObjectProxy() {
        return true;
    }

    @Override
    public String getName() {
        if (this.isNameChanged() && !"".equals(super.getName())) {
            return super.getName();
        }
        String name = this.getObject().getName();
        name = this.applyNameSubstitution(name);
        return name;
    }

    @Override
    public boolean setName(String name) {
        if (!this.isNameFixed()) {
            boolean result = true;
            if (!this.getName().equals(name) && (result = super.setName(this.applyNameRules(name)))) {
                this.setNameChanged(true);
                this.setDirty(true);
            }
            if (this.getObject() != null && this.isNameChanged() && this.getName().equals(this.getObject().getName())) {
                this.setNameChanged(false);
                this.setDirty(true);
            }
            return result;
        }
        return false;
    }

    protected String applyNameRules(String name) {
        return name;
    }

    public void copyCommentInRDBMS() {
        if (this.isLoaded()) {
            this.setCommentInRDBMS(this.getObject().getCommentInRDBMS());
        }
    }

    protected ColumnProxy[] getColumnProxies() {
        ContainedObject[] columns = ((ContainerObject)this.getObject()).getElements();
        ColumnProxy[] array = new ColumnProxy[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            array[i] = this.getColumnProxy(columns[i].getObjectID());
        }
        return array;
    }

    protected ColumnProxy getColumnProxy(String colID) {
        return (ColumnProxy)this.getStorageDesign().getColumnProxySet().getProxy(colID);
    }

    @Override
    public void changed(DesignObject obj, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.NAME_CHANGED)) {
            ElementSet set;
            if (!this.isNameChanged()) {
                this.setName(obj.getName());
            }
            if (this.isTopLevelObject() && (set = this.getSet()) != null && set.canSort()) {
                set.sort();
            }
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.OBJECT_ID_CHANED)) {
            String old = this.getObjectID();
            String id = obj.getObjectID();
            if (old != null && !old.equals(id)) {
                this.getStorageDesign().unregisterModelIDObject(this);
                if (this.proxySet != null) {
                    this.proxySet.updateProxyID(old, id);
                }
                this.setObjectID(id);
                this.getStorageDesign().registerModelIDObject(this);
            }
        }
    }

    @Override
    public void showPropertyDialog() {
    }

    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    public void setCommentChanged(boolean commentChanged) {
        this.commentChanged = commentChanged;
    }

    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    public void setCommentInRDBMSChanged(boolean commentInRDBMSChanged) {
        this.commentInRDBMSChanged = commentInRDBMSChanged;
    }

    @Override
    public boolean isNameChanged() {
        return this.nameChanged;
    }

    @Override
    public void setNameChanged(boolean nameChanged) {
        this.nameChanged = nameChanged;
    }

    @Override
    public boolean isMarkedGenerate() {
        if (this.getStorageDesign().isOpen() && this.isLoadedCompletely()) {
            return super.isMarkedGenerate();
        }
        return this.getObject().isMarkedGenerate();
    }

    @Override
    public void setMarkedGenerate(boolean value) {
        super.setMarkedGenerate(value);
        if (!this.getStorageDesign().isOpen() && !this.getStorageDesign().isLoading() || this.getStorageDesign().isOpen() && !this.getStorageDesign().isLoading() && !this.isLoadedCompletely()) {
            this.getObject().setMarkedGenerate(value);
        }
    }

    @Override
    public void setDropEnabled(boolean dropEnabled) {
        super.setDropEnabled(dropEnabled);
        this.getObject().setDropEnabled(dropEnabled);
    }

    @Override
    public boolean isDropEnabled() {
        if (this.getStorageDesign().isOpen()) {
            if (!Design.DROP_GENERATED_OBJECTS_ONLY) {
                return super.isDropEnabled();
            }
            return this.isMarkedGenerate() && super.isDropEnabled();
        }
        if (!Design.DROP_GENERATED_OBJECTS_ONLY) {
            return this.getObject().isDropEnabled();
        }
        return this.isMarkedGenerate() && this.getObject().isDropEnabled();
    }

    @Override
    public void remove() {
        if (this.object != null) {
            this.object.removeObjectListener(this);
        }
        super.remove();
    }

    public RelationalObjectProxySet getProxySet() {
        return this.proxySet;
    }

    public void setProxySet(RelationalObjectProxySet proxySet) {
        this.proxySet = proxySet;
    }

    public void reloadExistingData() {
        ReadRequest readRequest = this.getStorageDesign().getReadRequestFor(this.getObjectID());
        AbstractXMLReader sdReader = this.getDesign().getAppView().getPersistenceManager().getReaderFor(this.getStorageDesign());
        if (sdReader != null) {
            readRequest.setObjectSet(this.getProxySet());
            readRequest.setStorageObject(this);
            sdReader.recreateObject((Object)readRequest, this.getDesign(), true);
        }
    }

    @Override
    public String getDirectorySegmentName() {
        RelationalObjectProxySet set;
        if ("".equals(this.directorySegmentName) && (set = this.getProxySet()) != null) {
            this.directorySegmentName = set.getSegmentName(this);
        }
        return this.directorySegmentName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getSegmentedStorageName() {
        RelationalObjectProxySet set = this.getProxySet();
        if (this.segmentedStorageName != null) return this.segmentedStorageName;
        if (set == null) return super.getSegmentedStorageName();
        String sname = set.getSegmentName(this);
        if ("".equals(sname)) return super.getSegmentedStorageName();
        String sn = this.getStorageName();
        if (sn == null || "".equals(sn)) return this.segmentedStorageName;
        File file = new File(sn);
        String fname = file.getName();
        this.segmentedStorageName = file.getParent() + File.separatorChar + sname + File.separatorChar + fname;
        return this.segmentedStorageName;
    }

    @Override
    public void setDirectorySegmentName(String directorySegmentName, boolean clear) {
        RelationalObjectProxySet set;
        if (directorySegmentName != null && !"".equals(directorySegmentName) && (set = this.getProxySet()) != null) {
            set.addSegmentEntry(directorySegmentName, this.getObjectID(), clear);
        }
        this.directorySegmentName = directorySegmentName;
    }

    @Override
    public void setDirectorySegmentName(String directorySegmentName) {
        this.setDirectorySegmentName(directorySegmentName, true);
    }

    @Override
    protected void sortObjectSet() {
        RelationalObjectProxySet objectSet = this.getProxySet();
        if (objectSet != null) {
            objectSet.sort();
        }
    }

    @Override
    public ElementSet getSet() {
        return this.getProxySet();
    }

    @Override
    public boolean getNameHasQuotes() {
        DesignObject obj = this.getObject();
        if (obj != null) {
            return obj.getNameHasQuotes();
        }
        return super.getNameHasQuotes();
    }

    @Override
    public SchemaObject getSchemaObject() {
        DesignObject obj = this.getObject();
        if (obj != null && obj instanceof ContainerObject) {
            return ((ContainerObject)obj).getSchemaObject();
        }
        return super.getSchemaObject();
    }
}

