/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ErrorDescriptor;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.GlobalCandidateKeySet;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.model.design.undo.relational.memento.Memento;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.editor.relational.IndexPropertiesDialogEx;

public class Index
extends KeyObject {
    public static final String VALUE_ASCENDING = "ASC";
    public static final String VALUE_DESCENDING = "DESC";
    private static final String[] SORT_ORDER_CHOICES = new String[]{"ASC", "DESC"};
    private static String SORT_ORDER = "sortOrder";
    private static String COLUMN_ID = "columnID";
    private String indexState = "Plain Index";
    private static Set indexStateSet = null;
    private Map sortMap = new TreeMap();
    private String indexExpression = "";
    private boolean isSpatialIndex = false;
    public static final String POINT = "POINT";
    public static final String LINE = "LINE";
    public static final String POLYGON = "POLYGON";
    public static final String COLLECTION = "COLLECTION";
    public static final String MULTIPOINT = "MULTIPOINT";
    public static final String MULTILINE = "MULTILINE";
    public static final String MULTIPOLYGON = "MULTIPOLYGON";
    private static final String[] CONSTRAIN_LAYER_TYPES = new String[]{"", "POINT", "LINE", "POLYGON", "COLLECTION", "MULTIPOINT", "MULTILINE", "MULTIPOLYGON"};
    private String layerType;
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private String geodetic = YES_NO_STATES[0];
    private int dimensionsNumber = 2;
    private SpatialColumnDefObject spatialColumnDefiniton = null;
    private String idOfRecoveredIntegrityIndex;
    private IndexMemento memento;
    private boolean isSurrogateKey = false;
    private String relationGeneratorID = "";
    private Index supportingIndex;
    private Index supportedConstraint;
    private String supportingIndexID = null;
    private String supportedConstraintID = null;
    public static String INDEX_IS_RENAMED_IN_LOADING = "index_is_renamed_during_loading";
    public static final String TYPE_NAME = "Index";

    public Index(DesignPart designPart) {
        super(designPart);
    }

    public Index(DesignPart designPart, FKIndexAssociation fk) {
        this(designPart);
        this.indexState = "Foreign Key";
        this.name = fk.getName();
        this.setFKAssociation(fk);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("index id prefix");
    }

    @Override
    public int getByteSize(String rdbmsName) {
        return super.getByteSize(rdbmsName);
    }

    public ColumnSet getColumnSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getColumnSet();
    }

    @Override
    public void add(ContainedObject object) {
        super.add(object);
        if (object.getObjectID() != null) {
            this.sortMap.put(object.getObjectID(), VALUE_ASCENDING);
        }
    }

    @Override
    public void remove(ContainedObject object) {
        super.remove(object);
        this.sortMap.remove(object.getObjectID());
    }

    @Override
    public void setColumnSortOrder(Object column, String sortOrder) {
        if (((ContainedObject)column).getObjectID() != null) {
            this.sortMap.put(((ContainedObject)column).getObjectID(), sortOrder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getColumnSortOrder(Object column) {
        String sortOrder = null;
        if (column instanceof Column) {
            if (((ContainedObject)column).getObjectID() == null) return VALUE_ASCENDING;
            sortOrder = (String)this.sortMap.get(((ContainedObject)column).getObjectID());
            if (sortOrder == null) {
                return " ";
            }
            if (!"".equals(sortOrder.trim())) return sortOrder;
            return VALUE_ASCENDING;
        }
        if (!(column instanceof ColumnProxy)) return " ";
        if (((ColumnProxy)column).getObjectID() == null) return VALUE_ASCENDING;
        sortOrder = (String)this.sortMap.get(((ColumnProxy)column).getObjectID());
        if (sortOrder == null) {
            return " ";
        }
        if (!"".equals(sortOrder.trim())) return sortOrder;
        return VALUE_ASCENDING;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (event.isType(ObjectChangeEvent.NAME_CHANGED)) {
            if (this.isOidKey() && object == this.getContainerObject() && object instanceof Table) {
                this.setName(ApplyNamingStandards.createPK_Name(object.getName(), object.getDesign().getDesignLevelSettings().getNamingStandardRule(), object.getDesignPart().getName(), ((Table)object).getAbbreviation()));
            }
            this.sharedEvent.setElement(object);
            this.sharedEvent.setType(8);
            this.fireChange(this.sharedEvent);
        }
    }

    public boolean isSortOrderColumnsAscending() {
        return this.getSortOrderColumnsString().equalsIgnoreCase(VALUE_ASCENDING);
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getContainerWithKeyObject().isDropEnabled() || this.getContainerWithKeyObject().shouldBeDroppedIndirectly();
        }
        return false;
    }

    public static final String[] getSortOrderColumnsChoices() {
        return SORT_ORDER_CHOICES;
    }

    public String getSortOrderColumnsString() {
        return "Edit";
    }

    @Override
    public int getMaxNameLength() {
        if (this.isPK()) {
            return 8;
        }
        return super.getMaxNameLength();
    }

    private boolean checkIndexStateValue(String value) {
        if (indexStateSet == null) {
            indexStateSet = new HashSet();
            indexStateSet.addAll(Arrays.asList(INDEX_STATES));
        }
        return indexStateSet.contains(value);
    }

    public boolean hasFKAssociations() {
        Iterator it = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (!fk.getRemoteIndex().getObjectID().equals(this.getObjectID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setIndexState(String indexState) {
        if (this.checkIndexStateValue(indexState)) {
            String oldState = this.getIndexState();
            this.indexState = indexState;
            if ("Primary Constraint".equalsIgnoreCase(indexState)) {
                Index oldPK;
                if (!this.isPK() && (oldPK = (Index)this.getContainerWithKeyObject().getPK()) != null) {
                    oldPK.setIndexState("Unique Constraint");
                }
                this.setPK(true);
                this.makeValidPKIfNotEmpty();
            } else if ("Unique Constraint".equalsIgnoreCase(indexState)) {
                if (this.isPK()) {
                    this.setPK(false);
                }
                if (!this.isUnique()) {
                    this.setUnique(true);
                }
            } else if ((this.isPK() || this.isUnique()) && this.hasFKAssociations()) {
                this.indexState = oldState;
            } else {
                if (this.isPK()) {
                    this.setPK(false);
                }
                if (this.isUnique()) {
                    this.setUnique(false);
                }
            }
        }
    }

    @Override
    public void setPK(boolean value) {
        if (this.getDesignObjectSet() != null && this.getDesignObjectSet().getNameSpaceController() != null) {
            NameSpaceController nsc = this.getDesignObjectSet().getNameSpaceController();
            HashMap<String, Boolean> status = new HashMap<String, Boolean>();
            boolean wasPK = this.isBackup() ? false : this.isPK();
            status.put("Primary Constraint", wasPK);
            status.put("Unique Constraint", this.isUnique());
            super.setPK(value);
            nsc.objectStatusChanged(status, this);
        } else {
            super.setPK(value);
        }
    }

    @Override
    public void setUnique(boolean value) {
        if (this.getDesignObjectSet() != null && this.getDesignObjectSet().getNameSpaceController() != null) {
            NameSpaceController nsc = this.getDesignObjectSet().getNameSpaceController();
            HashMap<String, Boolean> status = new HashMap<String, Boolean>();
            boolean wasPK = this.isBackup() ? false : this.isPK();
            status.put("Primary Constraint", wasPK);
            status.put("Unique Constraint", this.isUnique());
            super.setUnique(value);
            nsc.objectStatusChanged(status, this);
        } else {
            super.setUnique(value);
        }
    }

    @Override
    public void setMarkedGenerate(boolean markedGenerate) {
        super.setMarkedGenerate(markedGenerate);
        if (this.getFKAssociation() != null) {
            this.getFKAssociation().synchronizeMarkedGenerate(markedGenerate);
        }
    }

    @Override
    public void setDropEnabled(boolean dropEnabled) {
        super.setDropEnabled(dropEnabled);
        if (this.getFKAssociation() != null) {
            this.getFKAssociation().setDropEnabled(dropEnabled);
        }
    }

    @Override
    public String getIndexState() {
        if (this.isPK()) {
            return "Primary Constraint";
        }
        if (this.isUnique()) {
            return "Unique Constraint";
        }
        if (this.isFK()) {
            return "Foreign Key";
        }
        if (!this.isPK() && "Primary Constraint".equalsIgnoreCase(this.indexState)) {
            return "Plain Index";
        }
        return this.indexState;
    }

    public CandidateKey getEngCandidateKey(Entity entity) {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                CandidateKey key = (CandidateKey)mapping.getObjectMappedTo(this);
                if (key == null || key.getContainerWithKeyObject() != entity) continue;
                return key;
            }
        }
        return null;
    }

    public XtdMapping getMappingFor(Entity entity) {
        List list;
        if (entity != null && (list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                CandidateKey key = (CandidateKey)mapping.getObjectMappedTo(this);
                if (key == null || key.getContainerWithKeyObject() != entity) continue;
                return mapping;
            }
        }
        return null;
    }

    public List getMappingsFor(Entity entity) {
        List list;
        ArrayList<XtdMapping> temp = new ArrayList<XtdMapping>();
        if (entity != null && (list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                CandidateKey key = (CandidateKey)mapping.getObjectMappedTo(this);
                if (key == null || key.getContainerWithKeyObject() != entity) continue;
                temp.add(mapping);
            }
        }
        return temp;
    }

    public List getMappingsToKeys() {
        ArrayList<XtdMapping> temp = new ArrayList<XtdMapping>();
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                DesignObject key = mapping.getObjectMappedTo(this);
                if (key == null || !(key instanceof CandidateKey)) continue;
                temp.add(mapping);
            }
        }
        return temp;
    }

    public CandidateKey getEngCandidateKey() {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            CandidateKey key = (CandidateKey)mapping.getObjectMappedTo(this);
            return key;
        }
        return null;
    }

    @Override
    public boolean hasAliveGenerator() {
        ModelIDObject obj;
        GlobalCandidateKeySet set = this.getDesign().getLogicalDesign().getGlobalCandidateKeySet();
        return this.isFK() || "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            Table table = this.getTable();
            ArrayList<Column> columnsList = new ArrayList<Column>(table.getElementsCollection());
            columnsList.addAll(table.getNestedElements());
            IndexPropertiesDialogEx dialog = new IndexPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.setColumnsList(columnsList);
            IndexMemento mem = (IndexMemento)this.getIndexMemento(true);
            dialog.initProperties(mem);
            try {
                dialog.show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isDropEnabled() {
        if (this.isFK()) {
            return this.getFKAssociation().isDropEnabled();
        }
        return super.isDropEnabled();
    }

    @Override
    protected void clearStructure() {
    }

    @Override
    protected void updateStructure() {
    }

    public String getIndexExpression() {
        return this.indexExpression;
    }

    public void setIndexExpression(String indexExpression) {
        this.indexExpression = indexExpression;
    }

    public boolean hasIndexExpression() {
        return !this.getIndexExpression().equals("");
    }

    public boolean isSpatialIndex() {
        return this.isSpatialIndex;
    }

    public void setSpatialIndex(boolean isSpatialIndex) {
        this.isSpatialIndex = isSpatialIndex;
    }

    public static final String[] getConstrainLayerTypeChoices() {
        return CONSTRAIN_LAYER_TYPES;
    }

    public int getDimensionsNumber() {
        return this.dimensionsNumber;
    }

    public void setDimensionsNumber(int dimensionsNumber) {
        this.dimensionsNumber = dimensionsNumber;
    }

    public String getGeodetic() {
        return this.geodetic;
    }

    public void setGeodetic(String geodetic) {
        if (Arrays.asList(YES_NO_STATES).contains(geodetic)) {
            this.geodetic = geodetic;
        }
    }

    public String getLayerType() {
        return this.layerType;
    }

    public void setLayerType(String layerType) {
        if (Arrays.asList(CONSTRAIN_LAYER_TYPES).contains(layerType)) {
            this.layerType = layerType;
        }
    }

    public static String[] getGeodeticChoices() {
        return YES_NO_STATES;
    }

    public SpatialColumnDefObject getSpatialColumnDefiniton() {
        return this.spatialColumnDefiniton;
    }

    public void setSpatialColumnDefiniton(SpatialColumnDefObject spatialColumnDefiniton) {
        this.spatialColumnDefiniton = spatialColumnDefiniton;
    }

    public Table getTable() {
        return (Table)this.getContainerWithKeyObject();
    }

    @Override
    public void synchronizeMarkedGenerate(boolean markedGenerate) {
        super.setMarkedGenerate(markedGenerate);
    }

    public boolean shouldBeEngineered(XtdMapping entityMapping) {
        return !entityMapping.getIndexes().contains(this.getObjectID());
    }

    public boolean hasColumnInOptionalFK() {
        for (Column column : this.getElementsCollection()) {
            if (!column.isInOptionalFK()) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumnInFKinArc() {
        for (Column column : this.getElementsCollection()) {
            if (!column.isInFKinArc()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        Index index = (Index)desObject;
        index.setIndexState(this.getIndexState());
        index.setIndexExpression(this.getIndexExpression());
        index.setSpatialIndex(this.isSpatialIndex());
        index.setLayerType(this.getLayerType());
        index.setSupportedConstraintID(this.getSupportedConstraintID());
        index.setSupportingIndexID(this.getSupportingIndexID());
        index.setDimensionsNumber(this.getDimensionsNumber());
        index.setGeodetic(this.getGeodetic());
        index.setSurrogateKey(this.isSurrogateKey());
        Table table = (Table)index.getContainerWithKeyObject();
        for (Column column : this.getElementsCollection()) {
            String sorder = this.getColumnSortOrder(column);
            Column newColumn = (Column)table.getElementByID(column.getObjectID());
            if (newColumn == null) {
                newColumn = (Column)table.getElementByName(column.getName());
            }
            if (newColumn == null) continue;
            index.setColumnSortOrder(newColumn, sorder);
        }
        index.setName(this.getName());
    }

    @Override
    public Memento getIndexMemento() {
        return this.getIndexMemento(false);
    }

    public Memento getIndexMemento(boolean recreate) {
        if (recreate || this.memento == null) {
            this.memento = new IndexMemento(this);
        }
        return this.memento;
    }

    public void restoreFromMemento(IndexMemento mem) {
        this.setSchemaObject(mem.schemaObject);
        this.setIndexState(mem.index_state);
        this.setName(mem.name);
        this.setObjectID(mem.id);
        this.setComment(mem.comments);
        this.setCommentInRDBMS(mem.comments_in_rdbms);
        this.setNotes(mem.notes);
        this.setMarkedGenerate(mem.generate_in_DDL);
        this.setShouldEngineer(mem.engineer);
        this.setDeprecated(mem.deprecated);
        this.setIndexExpression(mem.expression);
        this.setSpatialIndex(mem.spatial);
        this.setGeodetic(mem.is_geodetic);
        this.setLayerType(mem.layer_type);
        this.setSupportingIndexID(mem.supportingIndexID);
        this.setSupportedConstraintID(mem.supportedConstraintID);
        this.setDimensionsNumber(mem.dimensionsNumber);
        this.setOidKey(mem.isOidKey);
        this.setSurrogateKey(mem.isSurrogateKey);
        ContainedObject[] cos = this.getElements();
        ArrayList<Column> list = new ArrayList<Column>();
        Table table = (Table)this.getContainerWithKeyObject();
        for (IndexMemento.ColWr wr : mem.columns) {
            Column col;
            Column column = (Column)table.getElementByID(wr.col_id);
            if (column != null) {
                list.add(column);
                continue;
            }
            if (!table.isBST() || (col = (Column)table.getOidElement()) == null) continue;
            list.add(col);
        }
        for (int i = 0; i < cos.length; ++i) {
            Column col = (Column)cos[i];
            if (list.contains(col)) continue;
            this.remove(col);
        }
        List elems = (List)this.getElementsCollection();
        int k = 0;
        for (Column col : list) {
            int ind = elems.indexOf(col);
            if (ind < 0) {
                this.add(col);
                this.moveToIndex(col, k);
            } else {
                this.moveToIndex(col, k);
            }
            ++k;
        }
        for (IndexMemento.ColWr wr : mem.columns) {
            Column column = (Column)table.getElementByID(wr.col_id);
            if (column == null) continue;
            this.setColumnSortOrder(column, wr.sort_order);
        }
        this.setIndexState(mem.index_state);
    }

    public String getIdOfRecoveredIntegrityIndex() {
        return this.idOfRecoveredIntegrityIndex;
    }

    public void setIdOfRecoveredIntegrityIndex(String idOfRecoveredIntegrityIndex) {
        this.idOfRecoveredIntegrityIndex = idOfRecoveredIntegrityIndex;
    }

    public IndexColumnUsage createIndexColumnUsage() {
        return new IndexColumnUsage();
    }

    public List getIndexColumnUsageList() {
        ArrayList list = new ArrayList();
        for (Column col : this.getElementsCollection()) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put(COLUMN_ID, col.getObjectID());
            String sort = this.getColumnSortOrder(col);
            if (VALUE_DESCENDING.equals(sort)) {
                map.put(SORT_ORDER, sort);
            }
            list.add(map);
        }
        return list;
    }

    public void applyIndexColumnUsageList(List list) {
        int i;
        ArrayList<Column> tempCols = new ArrayList<Column>();
        ArrayList<String> tempSorts = new ArrayList<String>();
        for (Object obj : list) {
            Column col;
            Map map;
            String colID;
            if (!(obj instanceof Map) || (colID = (String)(map = (Map)obj).get(COLUMN_ID)) == null || (col = (Column)this.getTable().getElementByID(colID)) == null) continue;
            tempCols.add(col);
            String sort = (String)map.get(SORT_ORDER);
            if (sort != null && VALUE_DESCENDING.equals(sort)) {
                tempSorts.add(VALUE_DESCENDING);
                continue;
            }
            tempSorts.add(VALUE_ASCENDING);
        }
        ContainedObject[] cols = this.getElements();
        for (i = 0; i < cols.length; ++i) {
            if (tempCols.contains(cols[i])) continue;
            this.remove(cols[i]);
        }
        for (i = 0; i < tempCols.size(); ++i) {
            Column col = (Column)tempCols.get(i);
            if (!this.contains(col)) {
                this.add(col);
            }
            this.moveToIndex(col, i);
            this.setColumnSortOrder(col, (String)tempSorts.get(i));
        }
    }

    @Override
    public void setFKAssociation(FKIndexAssociation fkassociation) {
        super.setFKAssociation(fkassociation);
        this.indexState = "Foreign Key";
    }

    public void addIndexColumnUsage(IndexColumnUsage usage) {
        Column col;
        if (usage.getColumnID() != null && (col = (Column)this.getTable().getElementByID(usage.getColumnID())) != null) {
            if (!this.contains(col)) {
                this.add(col);
            }
            if (usage.getSortOrder() != null && VALUE_DESCENDING.equals(usage.getSortOrder())) {
                this.setColumnSortOrder(col, VALUE_DESCENDING);
            } else {
                this.setColumnSortOrder(col, VALUE_ASCENDING);
            }
        }
    }

    public boolean isIndexForColumns(Column[] cols) {
        ContainedObject[] icols = this.getElements();
        if (cols.length != icols.length) {
            return false;
        }
        for (int i = 0; i < icols.length; ++i) {
            if (icols[i] == cols[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isUniquePlainIndex() {
        return "Unique Plain Index".equalsIgnoreCase(this.getIndexState());
    }

    @Override
    public ContainedObject[] getColumns() {
        return this.getElementsCollection().toArray(new Column[0]);
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    @Override
    public String getVeryLongName() {
        ContainerWithKeyObject container = this.getContainerWithKeyObject();
        if (container != null) {
            SchemaObject so = container.getSchemaObject();
            if (so != null) {
                StringBuffer buffer = new StringBuffer(so.getName());
                buffer.append(".").append(container.getName()).append(".").append(this.getName());
                return buffer.toString();
            }
            StringBuffer buffer = new StringBuffer(container.getName());
            buffer.append(".").append(this.getName());
            return buffer.toString();
        }
        return this.getName();
    }

    @Override
    public boolean isSurrogateKey() {
        return this.isSurrogateKey;
    }

    public void setSurrogateKey(boolean isSurrogateKey) {
        this.isSurrogateKey = isSurrogateKey;
    }

    public String getRelationGeneratorID() {
        return this.relationGeneratorID;
    }

    public void setRelationGeneratorID(String relationGeneratorID) {
        this.relationGeneratorID = relationGeneratorID;
    }

    @Override
    public boolean isPK() {
        if (this.isBackup() && "Primary Constraint".equals(this.indexState)) {
            return true;
        }
        return super.isPK();
    }

    public List getUsedColumns() {
        if (this.getElementsCollection().size() > 0) {
            return new ArrayList(this.getElementsCollection());
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasSurrogateDelegateColumn() {
        for (Column col : this.getElementsCollection()) {
            FKElement cref = col.getReferencedColumn();
            if (cref == null || !cref.isSurrogateColumn()) continue;
            return true;
        }
        return false;
    }

    public Index getSupportingIndex() {
        if (this.supportingIndex == null || this.supportingIndex.isRemoved()) {
            this.supportingIndex = (Index)this.getTable().getKeySet().getObjectByID(this.supportingIndexID);
        }
        return this.supportingIndex;
    }

    public void setSupportingIndex(Index supportingIndex) {
        this.supportingIndex = supportingIndex;
        if (supportingIndex != null) {
            this.supportingIndexID = supportingIndex.getObjectID();
        }
    }

    public String getSupportingIndexID() {
        return this.supportingIndexID;
    }

    public void setSupportingIndexID(String supportingIndexID) {
        this.supportingIndexID = supportingIndexID;
    }

    public Index getSupportedConstraint() {
        if (this.supportedConstraint == null || this.supportedConstraint.isRemoved()) {
            this.supportedConstraint = (Index)this.getTable().getKeySet().getObjectByID(this.supportedConstraintID);
        }
        return this.supportedConstraint;
    }

    public void setSupportedConstraint(Index supportedConstraint) {
        this.supportedConstraint = supportedConstraint;
        if (supportedConstraint != null) {
            this.supportedConstraintID = supportedConstraint.getObjectID();
        }
    }

    public String getSupportedConstraintID() {
        return this.supportedConstraintID;
    }

    public void setSupportedConstraintID(String supportedConstraintID) {
        this.supportedConstraintID = supportedConstraintID;
    }

    @Override
    public String getLongName() {
        SchemaObject so = this.getSchemaObject();
        if (this.isPK() || this.isUnique() || so == null) {
            if (this.getTable() != null && (so = this.getTable().getSchemaObject()) != null) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
            return this.getName();
        }
        if (so != null && !"".equals(so.getLongName())) {
            return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
        }
        return this.getName();
    }

    @Override
    public boolean setName(String name) {
        boolean res = super.setName(name);
        if (this.name != null && !this.name.equals(name) && this.getDesign().isLoading()) {
            ErrorDescriptor err = new ErrorDescriptor();
            err.error = INDEX_IS_RENAMED_IN_LOADING;
            err.object = this;
            err.newName = name;
            this.getDesignPart().getErrorDescriptionList().add(err);
        }
        return res;
    }

    @Override
    public String toString() {
        this.nameBuffer.setLength(0);
        if (this.getContainerObject() != null) {
            this.nameBuffer.append(this.getContainerObject().getName());
            this.nameBuffer.append('.');
        }
        this.nameBuffer.append(this.getName());
        return this.nameBuffer.toString();
    }

    public boolean canSupportConstraint(Index constr, boolean ascending) {
        return this.canSupportConstraint(this, constr, true);
    }

    public boolean canSupportConstraint(Index ind, Index constr, boolean ascending) {
        ContainedObject[] icols;
        if (ind.getTable() != constr.getTable()) {
            return false;
        }
        ContainedObject[] cols = constr.getElements();
        if (cols.length > (icols = ind.getElements()).length) {
            return false;
        }
        boolean brflag = false;
        for (int j = 0; j < cols.length; ++j) {
            ContainedObject col = null;
            for (int k = 0; k < cols.length; ++k) {
                if (cols[j] != icols[k]) continue;
                col = icols[k];
                break;
            }
            if (col != null) {
                String so;
                if (!ascending || VALUE_ASCENDING.equalsIgnoreCase(so = ind.getColumnSortOrder(col).trim()) || "".equalsIgnoreCase(so)) continue;
                brflag = true;
                break;
            }
            brflag = true;
            break;
        }
        return !brflag;
    }

    public Index getsupportedConstraint(List constraints) {
        Index sc = this.getSupportedConstraint();
        if (sc != null && constraints.contains(sc)) {
            return sc;
        }
        for (Index constr : constraints) {
            if (constr == this || !constr.isPK() && !constr.isUnique() || this.getTable() != constr.getTable() || !this.isHasSameColumns(constr)) continue;
            return constr;
        }
        return null;
    }

    public boolean isHasSameColumns(Index constr) {
        ContainedObject[] icols;
        ContainedObject[] cols = constr.getElements();
        if (cols.length != (icols = this.getElements()).length) {
            return false;
        }
        for (int j = 0; j < cols.length; ++j) {
            if (cols[j] == icols[j]) continue;
            return false;
        }
        return true;
    }

    public Index getSupportingIndexForConstraint() {
        if (this.isPK() || this.isUnique()) {
            Index ind = this.getSupportingIndex();
            if (ind != null) {
                return ind;
            }
            Iterator it = this.getTable().getKeySet().iterator();
            while (it.hasNext()) {
                ind = (Index)it.next();
                if (ind.isPK() || ind.isUnique() || ind.isFK() || ind.getSupportedConstraint() != this) continue;
                return ind;
            }
            it = this.getTable().getKeySet().iterator();
            while (it.hasNext()) {
                ind = (Index)it.next();
                if (ind.isPK() || ind.isUnique() || ind.isFK() || !ind.isHasSameColumns(this)) continue;
                return ind;
            }
            it = this.getTable().getKeySet().iterator();
            while (it.hasNext()) {
                ind = (Index)it.next();
                if (ind.isPK() || ind.isUnique() || ind.isFK() || !ind.canSupportConstraint(this, true)) continue;
                return ind;
            }
        }
        return null;
    }

    public static class IndexColumnUsage {
        String columnID;
        String sortOrder;

        public String getColumnID() {
            return this.columnID;
        }

        public void setColumnID(String columnID) {
            this.columnID = columnID;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }

        public void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }
    }
}

