/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.glossary;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;

public class WordPropertiesComparator
implements GeneralPropertiesComparator {
    public static String NAME = Messages.getString("WordPropertiesComparator.Name");
    public static String PLURAL = Messages.getString("WordPropertiesComparator.Plural");
    public static String ABBREVIATION = Messages.getString("WordPropertiesComparator.Abbreviation");
    public static String ALT_ABBREVIATION = Messages.getString("WordPropertiesComparator.AlternateAbbreviation");
    public static String PRIMARY_WORD = Messages.getString("WordPropertiesComparator.PrimaryWord");
    public static String CLASS_WORD = Messages.getString("WordPropertiesComparator.ClassWord");
    public static String MODIFIER = Messages.getString("WordPropertiesComparator.Modifier");
    public static String QUALIFIER = Messages.getString("WordPropertiesComparator.Qualifier");
    public static String DESCRIPTION = Messages.getString("WordPropertiesComparator.Description");
    public static String COMMENT = Messages.getString("WordPropertiesComparator.Comment");
    public static String NOTES = Messages.getString("WordPropertiesComparator.Notes");
    private GlossaryWord left_word;
    private GlossaryWord right_word;
    protected List propertiesList = new ArrayList();

    public WordPropertiesComparator(GlossaryWord left_word, GlossaryWord right_word) {
        this.left_word = left_word;
        this.right_word = right_word;
        this.initPropertiesList();
    }

    @Override
    public List getPropertiesList() {
        return this.propertiesList;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
    }

    @Override
    public String getLeftName() {
        if (this.left_word != null) {
            return this.left_word.getName();
        }
        return "";
    }

    @Override
    public String getRightName() {
        if (this.right_word != null) {
            return this.right_word.getName();
        }
        return "";
    }

    protected void initNameProperty() {
        EngPropertyHolder ph = new EngPropertyHolder(NAME);
        ph.setLeftValue(this.left_word != null ? this.left_word.getName() : "");
        ph.setRightValue(this.right_word != null ? this.right_word.getName() : "");
        if (this.left_word != null && this.right_word != null && !this.left_word.getName().equals(this.right_word.getName())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    protected void initCommentsAndNotes() {
    }

    protected void copyPropertiesFromLeftToRight() {
        if (this.left_word != null && this.right_word != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(NAME)) {
                    this.right_word.setName(this.left_word.getName());
                    continue;
                }
                if (ph.getName().equals(PLURAL)) {
                    this.right_word.setPlural(this.left_word.getPlural());
                    continue;
                }
                if (ph.getName().equals(ABBREVIATION)) {
                    this.right_word.setAbbreviation(this.left_word.getAbbreviation());
                    continue;
                }
                if (ph.getName().equals(ALT_ABBREVIATION)) {
                    this.right_word.setAltAbbrevation(this.left_word.getAltAbbrevation());
                    continue;
                }
                if (ph.getName().equals(PRIMARY_WORD)) {
                    this.right_word.setPrimaryWord(this.left_word.isPrimaryWord());
                    continue;
                }
                if (ph.getName().equals(CLASS_WORD)) {
                    this.right_word.setClassWord(this.left_word.isClassWord());
                    continue;
                }
                if (ph.getName().equals(MODIFIER)) {
                    this.right_word.setModifier(this.left_word.isModifier());
                    continue;
                }
                if (ph.getName().equals(QUALIFIER)) {
                    this.right_word.setQualifier(this.left_word.isQualifier());
                    continue;
                }
                if (!ph.getName().equals(DESCRIPTION)) continue;
                this.right_word.setShortDescription(this.left_word.getShortDescription());
            }
        }
        if (this.isDirty()) {
            this.right_word.setDirty(true);
        }
    }

    @Override
    public boolean isModified() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.getName().equals(NAME) && ph.isModified()) {
                return true;
            }
            if (!ph.getName().equals(NAME) || !ph.isModified() || !ph.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        if (this.left_word != null && this.right_word != null) {
            return this.left_word.getId() + this.right_word.getId();
        }
        if (this.left_word != null) {
            return this.left_word.getId();
        }
        if (this.right_word != null) {
            return this.right_word.getId();
        }
        return "null";
    }

    protected boolean isDirty() {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.isModified() || !ph.isSelected()) continue;
            return true;
        }
        return false;
    }

    public EngPropertyHolder getPropertyHolderByName(String name) {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.getName().equals(name)) continue;
            return ph;
        }
        return null;
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        EngPropertyHolder ph = new EngPropertyHolder(PLURAL);
        ph.setLeftValue(this.left_word != null ? this.left_word.getPlural() : "");
        ph.setRightValue(this.right_word != null ? this.right_word.getPlural() : "");
        if (this.left_word != null && this.right_word != null && !this.left_word.getPlural().equals(this.right_word.getPlural())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ABBREVIATION);
        ph.setLeftValue(this.left_word != null ? this.left_word.getAbbreviation() : "");
        ph.setRightValue(this.right_word != null ? this.right_word.getAbbreviation() : "");
        if (this.left_word != null && this.right_word != null && !this.left_word.getAbbreviation().equals(this.right_word.getAbbreviation())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ALT_ABBREVIATION);
        ph.setLeftValue(this.left_word != null ? this.left_word.getAltAbbrevation() : "");
        ph.setRightValue(this.right_word != null ? this.right_word.getAltAbbrevation() : "");
        if (this.left_word != null && this.right_word != null && !this.left_word.getAltAbbrevation().equals(this.right_word.getAltAbbrevation())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(PRIMARY_WORD);
        ph.setLeftValue(this.left_word != null ? String.valueOf(this.left_word.isPrimaryWord()) : "");
        ph.setRightValue(this.right_word != null ? String.valueOf(this.right_word.isPrimaryWord()) : "");
        if (this.left_word != null && this.right_word != null && this.left_word.isPrimaryWord() != this.right_word.isPrimaryWord()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(CLASS_WORD);
        ph.setLeftValue(this.left_word != null ? String.valueOf(this.left_word.isClassWord()) : "");
        ph.setRightValue(this.right_word != null ? String.valueOf(this.right_word.isClassWord()) : "");
        if (this.left_word != null && this.right_word != null && this.left_word.isClassWord() != this.right_word.isClassWord()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(MODIFIER);
        ph.setLeftValue(this.left_word != null ? String.valueOf(this.left_word.isModifier()) : "");
        ph.setRightValue(this.right_word != null ? String.valueOf(this.right_word.isModifier()) : "");
        if (this.left_word != null && this.right_word != null && this.left_word.isModifier() != this.right_word.isModifier()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(QUALIFIER);
        ph.setLeftValue(this.left_word != null ? String.valueOf(this.left_word.isQualifier()) : "");
        ph.setRightValue(this.right_word != null ? String.valueOf(this.right_word.isQualifier()) : "");
        if (this.left_word != null && this.right_word != null && this.left_word.isQualifier() != this.right_word.isQualifier()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }
}

