/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;

public class RelationFKComparator
extends EngPropertiesComparator {
    private Relation rel;
    private FKIndexAssociation fk;
    private boolean mandatoryDefined = false;

    public RelationFKComparator(Relation rel, FKIndexAssociation fk) {
        super(rel, fk);
        this.rel = rel;
        this.fk = fk;
        this.initPropertiesList();
    }

    public RelationFKComparator(Relation rel, FKIndexAssociation fk, List filters) {
        this(rel, fk);
        this.applyCompareFilter(filters, rel.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            if (this.isMandatoryDefined() && this.rel != null && this.fk != null) {
                for (EngPropertyHolder ph : this.propertiesList) {
                    if (!ph.isSelected()) continue;
                    if (ph.getName().equals(MANDATORY)) {
                        String leftv = ph.getLeftValue();
                        try {
                            this.fk.setMandatory(Boolean.valueOf(leftv));
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (!ph.getName().equals(DELETE_RULE)) continue;
                    this.fk.setDeleteRule(ph.getLeftValue());
                }
            }
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization()) {
            this.initNameTranslationProperty();
        }
        this.initMandatory();
        this.initDeleteRule();
        this.initCommentsAndNotes();
    }

    @Override
    protected void initNameProperty() {
        EngPropertyHolder ph = new EngPropertyHolder(NAME);
        ph.setLeftValue(this.rel != null ? this.rel.getName() : "");
        ph.setRightValue(this.fk != null ? this.fk.getName() : "");
        if (this.rel != null && this.fk != null && !this.rel.getName().equals(this.fk.getName())) {
            if (this.getDesign().isApplyNameStandardization()) {
                String tr_name = "";
                tr_name = this.rel.getDesignPart() instanceof LogicalDesign ? this.getDesign().transformNameFromLogicalToRelational(this.rel, this.fk, null) : this.getDesign().transformNameFromRelationalToLogical(this.rel);
                this.translated_name = tr_name;
                if (!tr_name.equals(this.fk.getName())) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            } else {
                ph.setModified(true);
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
    }

    private void initMandatory() {
        int[] pkends;
        String rightv = "";
        if (this.fk != null) {
            rightv = String.valueOf(this.fk.isMandatory());
        }
        String leftv = "";
        if (this.rel != null && (pkends = this.rel.getPKProviderEndPoint()).length == 1) {
            int endp = pkends[0];
            int other = this.rel.getOtherEndPoint(endp);
            leftv = String.valueOf(!this.rel.isOptional(other));
            this.mandatoryDefined = true;
        }
        if (this.mandatoryDefined) {
            PropertyHolder ph = new PropertyHolder(MANDATORY);
            ph.setLeftValue(leftv);
            ph.setRightValue(rightv);
            if (!leftv.equalsIgnoreCase(rightv)) {
                if ("true".equals(leftv) && "false".equals(rightv) && this.rel.inArc()) {
                    ph.setModified(true);
                    ph.setSelected(false);
                    ph.setEditable(false);
                    ph.setFiltered(true);
                } else {
                    ph.setModified(true);
                    ph.setSelected(true);
                    ph.setEditable(true);
                }
            }
            this.propertiesList.add(ph);
        }
    }

    public boolean isMandatoryDefined() {
        return this.mandatoryDefined;
    }

    private void initDeleteRule() {
        PropertyHolder ph = new PropertyHolder(DELETE_RULE);
        String rightv = "";
        if (this.fk != null) {
            rightv = this.fk.getDeleteRule();
        }
        boolean optional = false;
        String leftv = "";
        if (this.rel != null) {
            leftv = this.rel.getDeleteRule();
        }
        ph.setLeftValue(leftv);
        ph.setRightValue(rightv);
        if (!leftv.equalsIgnoreCase(rightv)) {
            ph.setModified(optional);
            ph.setSelected(optional);
            ph.setEditable(optional);
        }
        this.propertiesList.add(ph);
    }
}

