/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FEEntityHierarchy;
import oracle.dbtools.crest.model.design.engineering.FE_LogicalToRelational;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class FWDEngineering
extends AbstractEngineering {
    private RelationalDesign pdes;
    private FEEntityHierarchy feEntityHierarchy;
    private List newEngineeredEntities = new ArrayList();
    private List newEngineeredEntityViews = new ArrayList();
    private boolean notForNewObjects = false;
    private String typeName = "";
    private List properties = new ArrayList();
    public Map newTables = new HashMap();
    private static final Logger LOGGER = new Logger(FWDEngineering.class);

    public FWDEngineering(Design design) {
        super(design);
    }

    @Override
    public void execute(Map comparatorsMap) {
        this.execute(null, comparatorsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DesignPartView dpv, Map comparatorsMap) {
        this.comparatorsMap = comparatorsMap;
        this.newTables.clear();
        this.newEngineeredEntities.clear();
        this.newEngineeredEntityViews.clear();
        this.properties.clear();
        AbstractEngineering.useSameOptionForAll = false;
        this.processedDPV = dpv;
        this.pdes = this.design.getRelationalDesign();
        this.pdes.getUndoManager().setLocked(true);
        this.targetDesPartID = this.pdes.getObjectID();
        this.design.setPropagatePKChahges(false);
        int deleteFKcolumns = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        try {
            Table table;
            this.getDesign().getAppView().getSettings().setDeleteFKColumnStrategy(1);
            this.newEngineeredEntities.clear();
            this.newTables.clear();
            this.newEngineeredEntityViews.clear();
            this.feEntityHierarchy = new FEEntityHierarchy(this, this.design, this.pdes);
            this.feEntityHierarchy.setComparatorsMap(comparatorsMap);
            this.notForNewObjects = this.design.getNotForNewObjects();
            this.checkFKAttributesByRelation(this.pdes);
            this.processEntities();
            this.processRelations();
            this.synchronizeKeysWithRelations();
            this.fixColumnOrder(this.design);
            this.fixColumnOrderHierarchicalEntity(this.design);
            this.processEntityViews();
            this.processTypeSubstitutions();
            if (dpv == dpv.getDesignPart().getMainView()) {
                this.engineerAllSubviews(this.design);
            } else {
                this.engineerSubviewElementsToMainView(this.design, dpv);
                if (this.design.isEngineerAsSubView()) {
                    this.engineerSubviewElementsToSubView(this.design, dpv);
                }
            }
            this.pdes.showFkeysInSubviews();
            this.processArcs();
            this.processSQLNames();
            if (this.pdes.isUseTemplateTable() && (table = this.pdes.getTemplateTable()) != null) {
                DesignObject[] entities = this.getProcessedObjects(this.design.getLogicalDesign().getEntitySet());
                for (int i = 0; i < entities.length; ++i) {
                    Entity entity = (Entity)entities[i];
                    Table tab = entity.getEngTable(this.pdes);
                    if (tab == null || !this.isNewTable(tab)) continue;
                    this.pdes.copyTemplateTable(table, tab);
                }
            }
            Iterator it = this.pdes.getFKIndexAssociationSet().iterator();
            while (it.hasNext()) {
                FKIndexAssociation fk = (FKIndexAssociation)it.next();
                fk.resetEdgeParams();
            }
            this.showArcsInSubviews(this.pdes);
            this.pdes.sortCollections();
            this.pdes.getAppView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(this.pdes);
        }
        catch (RuntimeException e) {
            LOGGER.error("FWDEngineering.execute()", e);
            e.printStackTrace();
        }
        finally {
            this.getDesign().getAppView().getSettings().setDeleteFKColumnStrategy(deleteFKcolumns);
            this.design.setPropagatePKChahges(true);
            this.pdes.getUndoManager().setLocked(false);
        }
    }

    private void synchronizeKeysWithRelations() {
        DesignObject[] entities = this.getProcessedObjects(this.design.getLogicalDesign().getEntitySet());
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = (Entity)entities[i];
            if (!entity.shouldBeEngineered()) continue;
            Iterator it = entity.getKeySet().iterator();
            while (it.hasNext()) {
                Table tab;
                Index ind;
                CandidateKey key = (CandidateKey)it.next();
                if (!key.shouldBeEngineered() || !key.hasRelations() || (ind = key.getEngIndex(this.pdes)) == null || !key.hasRelations(this.pdes, tab = ind.getTable())) continue;
                FWDEngineering.synchronizeColumnsForKeyAndIndex(key, ind);
            }
        }
    }

    private void processEntities() {
        DesignObject[] entities = this.getProcessedObjects(this.design.getLogicalDesign().getEntitySet());
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = (Entity)entities[i];
            if (entity.isHierarchicalEntityType() || entity.isRemoteObject()) continue;
            this.processEntity(entity);
        }
        List roots = this.getRoots(entities);
        for (Entity root : roots) {
            this.feEntityHierarchy.processInhEntityNew(root);
        }
        List allEntInh = this.getEntitiesInHiearatchies(roots);
        this.feEntityHierarchy.inheritancePostProcessingNew(allEntInh.toArray());
    }

    private List getEntitiesInHiearatchies(List roots) {
        ArrayList list = new ArrayList();
        for (Entity entity : roots) {
            this.addEntity(entity, list);
        }
        return list;
    }

    private void processEntityViews() {
        DesignObject[] entityViews = this.getProcessedObjects(this.design.getLogicalDesign().getEntityViewSet());
        for (int i = 0; i < entityViews.length; ++i) {
            EntityView entityView = (EntityView)entityViews[i];
            if (entityView.isRemoteObject()) continue;
            this.processEntityView(entityView);
        }
    }

    boolean shouldDelete(DesignObject desObject) {
        return true;
    }

    private void processRelations() {
        DesignObject[] relations = this.getProcessedObjects(this.design.getLogicalDesign().getRelationSet());
        for (int i = 0; i < relations.length; ++i) {
            Relation relation = (Relation)relations[i];
            if (!relation.shouldBeEngineered()) continue;
            this.feEntityHierarchy.processRelationNew(relation);
            this.processRelationAttributes(relation);
        }
    }

    private void processRelationAttributes(Relation relation) {
        if (relation.hasAttributes()) {
            ArrayList<DesignObject> tables = new ArrayList<DesignObject>();
            FKIndexAssociation fk = null;
            Table table = null;
            List list = this.xmap.getMappingsForDesignPart(relation, this.pdes.getObjectID());
            for (XtdMapping mapping : list) {
                DesignObject dobj = mapping.getObjectMappedTo(relation);
                if (dobj != null && dobj instanceof Table) {
                    tables.add(dobj);
                    table = (Table)dobj;
                } else if (dobj != null && dobj instanceof FKIndexAssociation) {
                    fk = (FKIndexAssociation)dobj;
                    table = (Table)fk.getTable();
                }
                if (table == null) continue;
                if (relation.isManyToMany()) {
                    // empty if block
                }
                for (Attribute attr : relation.getAttributesCollection()) {
                    if (!attr.shouldBeEngineered()) continue;
                    Column col = attr.getEngColumn(this.pdes, table);
                    if (col == null) {
                        col = this.createColumn(attr, table, mapping);
                    } else {
                        col.setName(FWDEngineering.getColumnName(attr));
                    }
                    EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(attr.getObjectID() + col.getObjectID());
                    if (comp != null) {
                        comp.copySelectedProperties();
                    } else {
                        this.copyPropertiesFromAttributeToColumn(attr, col, mapping.getInheritanceType());
                    }
                    col.setDependOnForeignKey(fk);
                    col.setDependOnFK_AsMandatory(attr.isMandatory());
                    col.setRelationshipColumn(true);
                    if (fk == null || fk.isMandatory() || !col.isMandatory()) continue;
                    col.setMandatory(false);
                }
            }
        }
    }

    private void checkFKAttributesByRelation(RelationalDesign reld) {
        DesignObject[] relations = this.getProcessedObjects(this.design.getLogicalDesign().getRelationSet());
        for (int i = 0; i < relations.length; ++i) {
            Attribute attr;
            int k;
            Table tab;
            DesignObject obj;
            List mappings;
            Relation relation = (Relation)relations[i];
            if (!relation.shouldBeEngineered()) continue;
            ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
            Entity ent = relation.getSourceEntity();
            ContainedObject[] objs = ent.getAllElementsGeneratedBy(relation.getObjectID());
            if (objs.length > 0) {
                for (int k2 = 0; k2 < objs.length; ++k2) {
                    list.add(objs[k2]);
                }
                mappings = ent.getEngTables(reld);
                for (XtdMapping mapping : mappings) {
                    obj = mapping.getObjectMappedTo(ent);
                    if (obj == null || !(obj instanceof Table)) continue;
                    tab = (Table)obj;
                    for (k = 0; k < objs.length; ++k) {
                        attr = (Attribute)objs[k];
                        if (FE_LogicalToRelational.isRefKeyChanged(attr, tab)) continue;
                        mapping.getAttributes().remove(attr.getObjectID());
                    }
                }
            }
            if ((objs = (ent = relation.getTargetEntity()).getAllElementsGeneratedBy(relation.getObjectID())).length > 0) {
                for (int k3 = 0; k3 < objs.length; ++k3) {
                    list.add(objs[k3]);
                }
                mappings = ent.getEngTables(reld);
                for (XtdMapping mapping : mappings) {
                    obj = mapping.getObjectMappedTo(ent);
                    if (obj == null || !(obj instanceof Table)) continue;
                    tab = (Table)obj;
                    for (k = 0; k < objs.length; ++k) {
                        attr = (Attribute)objs[k];
                        if (FE_LogicalToRelational.isRefKeyChanged(attr, tab)) continue;
                        mapping.getAttributes().remove(attr.getObjectID());
                    }
                }
            }
            for (DesignObject designObject : list) {
                designObject.setShouldEngineer(true);
                designObject.setEngineerTo(reld.getObjectID(), true);
            }
        }
    }

    void synchronizeDeleteRule(Relation relation, FKIndexAssociation fkAssociation, int endPoint) {
        EngPropertyHolder holder = Design.getEngPropertyHolder(relation.getDesign().getRelFKPropertyList(), PropertyNames.DELETE_RULE);
        boolean process = true;
        if (holder != null && !holder.isSelected()) {
            process = false;
        }
        if (process) {
            String drule = relation.getDeleteRule();
            if (fkAssociation.isMandatory() && "SET NULL".equalsIgnoreCase(drule)) {
                drule = "NO ACTION";
            }
            fkAssociation.setDeleteRule(this.pdes.getStorageDesign().getValidFKRule(drule));
        }
    }

    public static String getDeleteRule(Relation relation, FKIndexAssociation fkAssociation, int endPoint) {
        return relation.getDeleteRule();
    }

    void copyPropertiesFromRelationToFK(Relation relation, FKIndexAssociation fkAssociation) {
        if (!this.notForNewObjects) {
            this.typeName = Design.RELATION_FK;
            this.properties = this.design.getRelFKPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                fkAssociation.setComment(relation.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                fkAssociation.setNotes(relation.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                fkAssociation.setCommentInRDBMS(relation.getCommentInRDBMS());
            }
        } else {
            fkAssociation.setComment(relation.getComment());
            fkAssociation.setNotes(relation.getNotes());
            fkAssociation.setCommentInRDBMS(relation.getCommentInRDBMS());
        }
        if (relation.isOneToOne()) {
            Index index;
            Table table = (Table)fkAssociation.getTable();
            Column[] cols = (Column[])fkAssociation.getColumns();
            if (cols.length > 0 && (index = table.getUniqueIndex_PK_UK(cols)) == null) {
                index = table.getIndex(cols);
                if (index == null) {
                    index = table.createIndex();
                    index.setRelationGeneratorID(relation.getObjectID());
                    for (int i = 0; i < cols.length; ++i) {
                        index.add(cols[i]);
                    }
                }
                index.setIndexState("Unique Plain Index");
            }
        }
    }

    private void processEntity(Entity entity) {
        List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
        if (list.size() == 0) {
            if (entity.shouldBeEngineered()) {
                String newName = entity.getDesign().transformNameFromLogicalToRelational(entity);
                Table table = this.pdes.createTable(newName);
                this.newTables.put(table.getObjectID(), table);
                XtdMapping tableMapping = this.xmap.createMapping(entity, table);
                tableMapping.initializeContained();
                this.copyPropertiesFromEntityToTable(entity, table);
                if (this.design.isEngineerCoordinates()) {
                    this.setGraphicalPropertiesOnNewObject(entity, table);
                }
                this.newEngineeredEntities.add(entity);
                XtdMapping del_mapping = entity.getDeletedMapping(table.getDesignPartId());
                if (del_mapping != null) {
                    entity.updateDeletedMappings(del_mapping.getDeletedID(), table.getObjectID(), table.getDesignPartId());
                    this.xmap.removeMapping(del_mapping);
                }
                if (entity.getBasedOnStructuredType() == null && !entity.isHierarchicalEntityType()) {
                    this.processAttributes(entity, table, tableMapping);
                } else {
                    this.processAttributesBST(entity, table, tableMapping);
                }
                this.processKeys(entity, table, tableMapping);
            }
        } else {
            for (XtdMapping mapping : list) {
                if (!mapping.isFwEngineer()) continue;
                Table table = (Table)mapping.getObjectMappedTo(entity);
                if (table != null) {
                    EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(entity.getObjectID() + table.getObjectID());
                    if (comp != null) {
                        comp.copySelectedProperties();
                        if (this.design.isEngineerCoordinates()) {
                            this.setGraphicalPropertiesOnNewObject(entity, table);
                        }
                    }
                    if (entity.getBasedOnStructuredType() == null) {
                        this.processAttributes(entity, table, mapping);
                    } else {
                        this.processAttributesBST(entity, table, mapping);
                    }
                    this.processKeys(entity, table, mapping);
                    continue;
                }
                System.out.println("Table mapped to entity is null - entity " + entity.getName() + "  - id " + entity.getObjectID());
            }
        }
    }

    private void copyPropertiesFromEntityToTable(Entity entity, Table table) {
        table.setGeneratorID(entity.getObjectID());
        table.setBasedOnStructuredType(entity.getBasedOnStructuredType());
        if (!this.notForNewObjects) {
            this.typeName = Design.ENTITY_TABLE;
            this.properties = this.design.getEntTablePropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                table.setComment(entity.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                table.setNotes(entity.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                table.setCommentInRDBMS(entity.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.TABLE_TYPE)) {
                table.setTypeID(entity.getTypeID());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SCOPE)) {
                table.setScope(entity.getScope());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.MIN_VOLUMES)) {
                table.setMinVolumes(entity.getMinVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.EXPECTED_VOLUMES)) {
                table.setExpectedVolumes(entity.getExpectedVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.MAX_VOLUMES)) {
                table.setMaxVolumes(entity.getMaxVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.GROWTH_PERCENT)) {
                table.setGrowthPercent(entity.getGrowthPercent());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.GROWTH_TYPE)) {
                table.setGrowthType(entity.getGrowthType());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NORMAL_FORM)) {
                table.setNormalForm(entity.getNormalForm());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.ADEQUATELY_NORMALIZED)) {
                table.setAdequatelyNormalized(entity.getAdequatelyNormalized());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SHORT_NAME_ABBR)) {
                table.setAbbreviation(entity.getShortName());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.ALLOW_TYPE_SUBSTITUTION)) {
                table.setAllowTypeSubstitution(entity.isAllowTypeSubstitution());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.DEPRECATED)) {
                table.setDeprecated(entity.isDeprecated());
            }
        } else {
            table.setComment(entity.getComment());
            table.setNotes(entity.getNotes());
            table.setCommentInRDBMS(entity.getCommentInRDBMS());
            table.setTypeID(entity.getTypeID());
            table.getAdditionalClassificationTypes().clear();
            table.getAdditionalClassificationTypes().addAll(entity.getAdditionalClassificationTypes());
            table.setScope(entity.getScope());
            table.setMinVolumes(entity.getMinVolumes());
            table.setExpectedVolumes(entity.getExpectedVolumes());
            table.setMaxVolumes(entity.getMaxVolumes());
            table.setGrowthPercent(entity.getGrowthPercent());
            table.setGrowthType(entity.getGrowthType());
            table.setNormalForm(entity.getNormalForm());
            table.setAdequatelyNormalized(entity.getAdequatelyNormalized());
            table.setAbbreviation(entity.getShortName());
            table.setAllowTypeSubstitution(entity.isAllowTypeSubstitution());
            table.setDeprecated(entity.isDeprecated());
        }
    }

    private XtdMapping getColumnMappingForTable(Attribute attr, List mappings, Table table) {
        for (XtdMapping mapping : mappings) {
            DesignObject obj = mapping.getObjectMappedTo(attr);
            if (obj == null || !(obj instanceof Column) || ((Column)obj).getContainer() != table) continue;
            return mapping;
        }
        return null;
    }

    void processAttributesBST(Entity ent, Table table, XtdMapping tableMapping) {
        if (table != null) {
            RelationalDesign phdes = (RelationalDesign)table.getDesignPart();
            for (Attribute attribute : ent.getAttributes()) {
                String id;
                Column column;
                List list = attribute.getMappingsFor(phdes, table);
                if (list.size() != 0 || (column = (Column)table.getElementByStructAttributeID(id = attribute.getStructAttributeID())) == null) continue;
                this.xmap.createMapping(attribute, column);
                this.copyPropertiesFromAttributeToColumn(attribute, column, 0);
            }
        }
    }

    void processAttributes(Entity ent, Table table, XtdMapping tableMapping) {
        if (table != null) {
            List overlappingEnt = ((LogicalDesign)ent.getDesignPart()).getEntitiesWuthOverlappingKeys(false);
            LogicalDesign.EntHolder entHolder = this.getHolderForEnt(ent, overlappingEnt);
            RelationalDesign phdes = (RelationalDesign)table.getDesignPart();
            ArrayList<Attribute> list1 = new ArrayList<Attribute>();
            ArrayList list2 = new ArrayList();
            for (Attribute attribute : ent.getElementsCollection()) {
                list1.add(attribute);
            }
            list1.addAll(list2);
            for (Attribute attribute : list1) {
                List list;
                LogicalDesign.AttrHolder holder = null;
                if (entHolder != null) {
                    holder = this.getFoldedAttr2Holder(entHolder, attribute);
                }
                if ((list = attribute.getMappingsFor(phdes, table)).size() == 0) {
                    XtdMapping del_mapping;
                    boolean eng;
                    boolean bl = eng = attribute.shouldBeEngineered(tableMapping) || ent.isHierarchicalEntityType();
                    if (!eng && tableMapping.getInheritanceType() == 1 && ent.isHierarchicalEntityType() && !ent.isHierarchicalRoot()) {
                        eng = true;
                    }
                    if (!eng) continue;
                    Column column = null;
                    column = holder == null || holder != null && !holder.overlap ? this.createColumn(attribute, table, tableMapping) : holder.attr1.getEngColumn(phdes, table);
                    if (column == null || (del_mapping = attribute.getDeletedMapping(table)) == null) continue;
                    this.xmap.removeMapping(del_mapping);
                    continue;
                }
                for (XtdMapping mapping : list) {
                    Column column1;
                    Column column;
                    if (!mapping.isFwEngineer() || (column = (Column)mapping.getObjectMappedTo(attribute)) == null || column.getContainerWithKeyObject() != table) continue;
                    if (holder == null || holder != null && !holder.overlap) {
                        Column column12;
                        boolean recreated = false;
                        if (holder != null && (column12 = holder.attr1.getEngColumn(phdes, table)) != null && column == column12) {
                            recreated = true;
                            this.xmap.removeMapping(mapping);
                            Column col = this.createColumn(attribute, table, tableMapping);
                            if (ent.getPK() != null && ent.getPK().contains(attribute) && table.getPK() != null) {
                                table.getPK().add(col);
                                table.getPK().moveToIndex(col, ent.getPK().getIndexOf(attribute));
                            }
                            this.replaceFKColumn(attribute, column12, col, phdes, table);
                            this.xmap.createMapping(attribute, col);
                        }
                        if (recreated) continue;
                        this.synchronyzeAttr(attribute, column, mapping);
                        continue;
                    }
                    if (holder == null || !holder.overlap || (column1 = holder.attr1.getEngColumn(phdes, table)) == null || column == column1) continue;
                    this.xmap.removeMapping(mapping);
                    mapping = this.xmap.createMapping(attribute, column1);
                    mapping.setInheritanceType(tableMapping.getInheritanceType());
                    this.replaceFKColumn(attribute, column, column1, phdes, table);
                    column.remove();
                }
            }
        }
    }

    void processAttributesOldNew(Entity ent, Table table, XtdMapping tableMapping, int engType) {
        if (table != null) {
            List overlappingEnt = ((LogicalDesign)ent.getDesignPart()).getEntitiesWuthOverlappingKeys(false);
            LogicalDesign.EntHolder entHolder = this.getHolderForEnt(ent, overlappingEnt);
            RelationalDesign phdes = (RelationalDesign)table.getDesignPart();
            ArrayList<Attribute> list1 = new ArrayList<Attribute>();
            ArrayList list2 = new ArrayList();
            for (Attribute attribute : ent.getAttributes()) {
                list1.add(attribute);
            }
            list1.addAll(list2);
            for (Attribute attribute : list1) {
                XtdMapping mapping2;
                List list;
                LogicalDesign.AttrHolder holder = null;
                if (entHolder != null) {
                    holder = this.getFoldedAttr2Holder(entHolder, attribute);
                }
                if ((list = attribute.getMappingsFor(phdes, table)).size() == 0) {
                    boolean eng;
                    boolean bl = eng = attribute.shouldBeEngineered(tableMapping) || ent.isHierarchicalEntityType();
                    if (!eng && tableMapping.getInheritanceType() == 1 && ent.isHierarchicalEntityType() && !ent.isHierarchicalRoot()) {
                        eng = true;
                    }
                    if (!eng) continue;
                    if (holder == null || holder != null && !holder.overlap) {
                        this.createColumn(attribute, table, tableMapping);
                        continue;
                    }
                    Column column = holder.attr1.getEngColumn(phdes, table);
                    if (column == null) continue;
                    this.xmap.createMapping(attribute, column);
                    XtdMapping del_mapping = attribute.getDeletedMapping(table);
                    if (del_mapping == null) continue;
                    this.xmap.removeMapping(del_mapping);
                    continue;
                }
                for (XtdMapping mapping2 : list) {
                    Column column1;
                    Column column;
                    if (!mapping2.isFwEngineer() || (column = (Column)mapping2.getObjectMappedTo(attribute)) == null || column.getContainerWithKeyObject() != table) continue;
                    if (holder == null || holder != null && !holder.overlap) {
                        Column column12;
                        boolean recreated = false;
                        if (holder != null && (column12 = holder.attr1.getEngColumn(phdes, table)) != null && column == column12) {
                            recreated = true;
                            this.xmap.removeMapping(mapping2);
                            Column col = this.createColumn(attribute, table, tableMapping);
                            if (ent.getPK() != null && ent.getPK().contains(attribute) && table.getPK() != null) {
                                table.getPK().add(col);
                                table.getPK().moveToIndex(col, ent.getPK().getIndexOf(attribute));
                            }
                            this.replaceFKColumn(attribute, column12, col, phdes, table);
                            this.xmap.createMapping(attribute, col);
                        }
                        if (recreated) continue;
                        this.synchronyzeAttr(attribute, column, mapping2);
                        continue;
                    }
                    if (holder == null || !holder.overlap || (column1 = holder.attr1.getEngColumn(phdes, table)) == null || column == column1) continue;
                    this.xmap.removeMapping(mapping2);
                    this.xmap.createMapping(attribute, column1);
                    this.replaceFKColumn(attribute, column, column1, phdes, table);
                    column.remove();
                }
                if (!"Table per child".equals(ent.getFwdEngineeringStrategyName()) || (mapping2 = this.getColumnMappingForTable(attribute, list, table)) != null || !attribute.shouldBeEngineered(mapping2)) continue;
                String name = attribute.getName().trim();
                int dotind = name.lastIndexOf(46);
                if (dotind > -1 && dotind < name.length()) {
                    name = name.substring(dotind + 1);
                }
                String newName = attribute.getDesign().transformNameFromLogicalToRelational(attribute);
                Column column = table.createColumn(newName);
                this.xmap.createMapping(attribute, column);
                this.copyPropertiesFromAttributeToColumn(attribute, column, tableMapping.getInheritanceType());
            }
        }
    }

    void processPKAttributesw(Entity ent, Table table, XtdMapping tableMapping, int engType) {
        if (table != null) {
            RelationalDesign phdes = (RelationalDesign)table.getDesignPart();
            KeyObject pkey = ent.getPK();
            if (pkey != null) {
                for (Attribute attribute : pkey.getElementsCollection()) {
                    List list = attribute.getMappingsFor(phdes, table);
                    if (list.size() == 0) {
                        Column column = this.createColumn(attribute, table, tableMapping);
                        this.xmap.createMapping(attribute, column);
                        XtdMapping del_mapping = attribute.getDeletedMapping(table);
                        if (del_mapping == null) continue;
                        this.xmap.removeMapping(del_mapping);
                        continue;
                    }
                    for (XtdMapping mapping : list) {
                        Column column;
                        if (!mapping.isFwEngineer() || (column = (Column)mapping.getObjectMappedTo(attribute)) == null || column.getContainerWithKeyObject() != table) continue;
                        this.synchronyzeAttr(attribute, column, mapping);
                    }
                }
            }
        }
    }

    private void replaceFKColumn(Attribute attribute, Column oldColumn, Column newColumn, RelationalDesign phdes, Table table) {
        Column delegate;
        Index ind;
        int k;
        FKIndexAssociation fk;
        Relation rel;
        if (attribute.isFKAttribute() && (rel = attribute.getRelation()) != null && (fk = rel.getEngFK(phdes, table)) != null && (k = (ind = (Index)fk.getLocalFKIndex()).getIndexOf(oldColumn)) > -1 && (delegate = (Column)fk.getRemoteIndex().getElement(k)) != null) {
            oldColumn.removeFKAssociation(fk.getObjectID());
            newColumn.addFKAssociation(delegate, fk);
            ind.remove(oldColumn);
            ind.add(newColumn);
            ind.moveToIndex(newColumn, k);
        }
    }

    private Column createColumn(Attribute attribute, Table table, XtdMapping tableMapping) {
        String newName = FWDEngineering.getColumnName(attribute);
        Column column = table.createColumn(newName);
        XtdMapping mapping = this.xmap.createMapping(attribute, column);
        mapping.setInheritanceType(tableMapping.getInheritanceType());
        tableMapping.getAttributes().remove(attribute.getObjectID());
        this.copyPropertiesFromAttributeToColumn(attribute, column, tableMapping.getInheritanceType());
        column.setPreviousColumn(!attribute.isFKAttribute());
        XtdMapping del_mapping = attribute.getDeletedMapping(table);
        if (del_mapping != null) {
            this.xmap.removeMapping(del_mapping);
        }
        return column;
    }

    public String getShortName_Abbrev_Name(Entity ent) {
        String res = ent.getShortName();
        if (res == null || "".equalsIgnoreCase(res)) {
            res = ent.getPreferredAbbreviation();
        }
        if (res == null || "".equalsIgnoreCase(res)) {
            res = ent.getDesign().transformNameFromLogicalToRelational(ent);
        }
        return res;
    }

    public static String getColumnName(Attribute attribute) {
        String newName = attribute.getDesign().transformNameFromLogicalToRelational(attribute);
        int dotind = newName.lastIndexOf(46);
        if (dotind > -1 && dotind < newName.length()) {
            newName = newName.substring(0, dotind) + "_" + newName.substring(dotind + 1);
        }
        return newName;
    }

    private void synchronyzeAttr(Attribute attribute, Column column, XtdMapping mapping) {
        EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(attribute.getObjectID() + column.getObjectID());
        if (comp != null) {
            comp.copySelectedProperties();
        } else if (this.isModified(mapping)) {
            DesignObject target = mapping.getTargetObject();
            if (attribute == target) {
                target = mapping.getOwnerObject();
            }
            if (target != null) {
                this.copyPropertiesFromAttributeToColumn(attribute, (Column)target, mapping.getInheritanceType());
            }
            mapping.setCreationTime(System.currentTimeMillis());
        }
    }

    public void copyPropertiesFromAttributeToColumn(Attribute attribute, Column column, int inheritanceType) {
        column.setTemporaryWriteable(true);
        column.setGeneratorID(attribute.getObjectID());
        column.setDomain(attribute.getDomain());
        column.setUse(attribute.getUse());
        column.setLogicalDatatype(attribute.getLogicalDatatype());
        if (!attribute.isFKAttribute()) {
            column.copyParametersFrom(attribute);
        }
        column.setReference(attribute.isReference());
        column.setStructuredType(attribute.getStructuredType());
        column.setDistinctType(attribute.getDistinctType());
        column.setCollectionType(attribute.getCollectionType());
        column.setDeprecated(attribute.isDeprecated());
        if (attribute.getStructuredType() != null && !attribute.isReference() && attribute.getUse() == 3) {
            Entity entity = (Entity)attribute.getContainer();
            Table table = (Table)column.getContainer();
            Iterator typeElemIt = attribute.getStructuredType().getAllElements().iterator();
            while (typeElemIt.hasNext()) {
                String typeElId = ((TypeElement)typeElemIt.next()).getObjectID();
                Attribute nestedAtt = (Attribute)entity.getElementByStructAttributeID(typeElId, attribute);
                Column nestedCol = (Column)table.getElementByStructAttributeID(typeElId, column);
                if (nestedCol == null || nestedAtt == null) continue;
                this.xmap.createMapping(nestedAtt, nestedCol);
                this.copyPropertiesFromAttributeToColumn(nestedAtt, nestedCol, inheritanceType);
            }
        }
        if (attribute.getScope() != null) {
            Table engtab = ((Entity)attribute.getScope()).getEngTable((RelationalDesign)column.getDesignPart());
            if (engtab != null) {
                column.setScopeId(engtab.getObjectID());
            } else {
                column.setScopeId(null);
            }
        } else {
            column.setScopeId(null);
        }
        column.setAllowSubtypeSubstitution(attribute.isAllowSubtypeSubstitution());
        column.setRestrictedTypeSubstitution(attribute.isRestrictedTypeSubstitution());
        List list = column.getPermittedSubTypes();
        list.clear();
        list.addAll(attribute.getPermittedSubTypes());
        if (1 == inheritanceType) {
            Entity ent = (Entity)attribute.getContainerWithKeyObject();
            if (ent.isHierarchicalEntityType() && !ent.isHierarchicalRoot()) {
                column.setNullsAllowed(true);
            } else {
                column.setNullsAllowed(attribute.getNullsAllowed());
            }
        } else {
            column.setNullsAllowed(attribute.getNullsAllowed());
        }
        column.setUseDomainConstraints(attribute.getUseDomainConstraints());
        if (!attribute.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(attribute, column);
            EngCOPropertiesComparator.copyRangeConstraint(attribute, column);
            EngCOPropertiesComparator.copyLOVConstraint(attribute, column);
        }
        if (!this.notForNewObjects) {
            this.typeName = Design.ATTRIBUTE_COLUMN;
            this.properties = this.design.getAttrColPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                column.setConstraintName(attribute.getConstraintName());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.DEFAULT_VALUE)) {
                column.setDefaultValue(attribute.getDefaultValue());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.USES_DEFUALT_VALUE)) {
                column.setUsesDefaultValue(attribute.getUsesDefaultValue());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                column.setCommentInRDBMS(attribute.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                column.setComment(attribute.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                column.setNotes(attribute.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SOURCE_TYPE)) {
                column.setSourceType(attribute.getSourceType());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.FORMULA_DESC)) {
                column.setFormulaDesc(attribute.getFormulaDesc());
            }
        } else {
            column.setConstraintName(attribute.getConstraintName());
            column.setDefaultValue(attribute.getDefaultValue());
            column.setUsesDefaultValue(attribute.getUsesDefaultValue());
            column.setCommentInRDBMS(attribute.getCommentInRDBMS());
            column.setComment(attribute.getComment());
            column.setNotes(attribute.getNotes());
            column.setSourceType(attribute.getSourceType());
            column.setFormulaDesc(attribute.getFormulaDesc());
            if (column.getFormulaDesc().length() > 0) {
                column.setComputed(true);
            }
        }
        column.setTemporaryWriteable(false);
    }

    public boolean isInherited(Attribute attribute, Column column) {
        DesignObject entityGenerator = column.getContainer().getGenerator();
        if (entityGenerator != null && entityGenerator instanceof Entity) {
            Entity mainEntity = (Entity)entityGenerator;
            Entity targetEntity = (Entity)attribute.getContainer();
            boolean result = !mainEntity.equals(targetEntity);
            return result;
        }
        return false;
    }

    void processKeys(Entity ent, Table table, XtdMapping tableMapping) {
        if (table != null) {
            KeyObject[] keys = ent.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                CandidateKey key = (CandidateKey)keys[i];
                List list = key.getMappingsFor(table);
                if (list.size() == 0) {
                    boolean eng;
                    boolean bl = eng = key.shouldBeEngineered(tableMapping) || ent.isHierarchicalEntityType();
                    if (!eng) continue;
                    Index index = null;
                    if (key.isOidKey() && (index = (Index)table.getOidKey()) != null) {
                        index.clearElements();
                    }
                    if (index == null) {
                        index = table.createIndex();
                    }
                    if (key.isOidKey() && index != null) {
                        index.setOidKey(true);
                    }
                    XtdMapping mapping = this.xmap.createMapping(key, index);
                    mapping.setInheritanceType(tableMapping.getInheritanceType());
                    tableMapping.getKeys().remove(key.getObjectID());
                    this.copyPropertiesFromKeyToIndex(key, index);
                    String newName = this.getDesign().transformNameFromLogicalToRelational(key, index, table);
                    index.setName(newName);
                    XtdMapping del_mapping = key.getDeletedMapping(table);
                    if (del_mapping == null) continue;
                    this.xmap.removeMapping(del_mapping);
                    continue;
                }
                for (XtdMapping mapping : list) {
                    EngPropertiesComparator comp;
                    Index index;
                    if (!mapping.isFwEngineer() || (index = (Index)mapping.getObjectMappedTo(key)) == null || index.getContainerWithKeyObject() != table || (comp = (EngPropertiesComparator)this.comparatorsMap.get(key.getObjectID() + index.getObjectID())) == null) continue;
                    comp.copySelectedProperties();
                }
            }
            if (ent.isCreateSurrogateKey()) {
                Index pk = (Index)table.getPK();
                if (pk != null && !pk.isSurrogateKey()) {
                    pk.setUnique(true);
                    pk = table.getSurrogateKey();
                }
                if (pk == null) {
                    this.feEntityHierarchy.createSurrogatePKandColumn(table, null, table.getSurrogateColumn());
                }
            }
        }
    }

    void processPrKey(Entity hierRoot, Table table, XtdMapping tableMapping, Entity entity) {
        CandidateKey key;
        if (table != null && (key = (CandidateKey)hierRoot.getPK()) != null) {
            List list = key.getMappingsFor(table);
            if (list.size() == 0) {
                XtdMapping del_mapping;
                Index index = null;
                if (key.isOidKey() && (index = (Index)table.getOidKey()) != null) {
                    index.clearElements();
                }
                if (index == null) {
                    index = table.createIndex();
                }
                if (key.isOidKey() && index != null) {
                    index.setOidKey(true);
                }
                String newName = this.getDesign().transformNameFromLogicalToRelational(key);
                index.setName(newName);
                XtdMapping mapping = this.xmap.createMapping(key, index);
                mapping.setInheritanceType(tableMapping.getInheritanceType());
                tableMapping.getKeys().remove(key.getObjectID());
                this.copyPropertiesFromKeyToIndex(key, index);
                if (hierRoot != entity) {
                    String pkname;
                    NamingStandardRule nsr = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
                    if (index.isPK()) {
                        pkname = ApplyNamingStandards.createPK_Name(table.getName(), table.getDesign().getDesignLevelSettings().getNamingStandardRule(), table.getDesignPart().getName(), table.getAbbreviation());
                    } else {
                        int ind = table.getUniqueKeysList().indexOf(index);
                        pkname = ApplyNamingStandards.createUK_Name(index, ind, nsr, table.getDesignPart().getName(), table.getName(), table.getAbbreviation());
                    }
                    index.setName(pkname);
                }
                if ((del_mapping = key.getDeletedMapping(table)) != null) {
                    this.xmap.removeMapping(del_mapping);
                }
            } else {
                for (XtdMapping mapping : list) {
                    EngPropertiesComparator comp;
                    Index index;
                    if (!mapping.isFwEngineer() || (index = (Index)mapping.getObjectMappedTo(key)) == null || index.getContainerWithKeyObject() != table || (comp = (EngPropertiesComparator)this.comparatorsMap.get(key.getObjectID() + index.getObjectID())) == null) continue;
                    comp.copySelectedProperties();
                }
            }
        }
    }

    private void copyPropertiesFromKeyToIndex(KeyObject key, Index index) {
        index.setGeneratorID(key.getObjectID());
        if (!this.notForNewObjects) {
            this.typeName = Design.KEY_INDEX;
            this.properties = this.design.getKeyIdxPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                index.setCommentInRDBMS(key.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                index.setComment(key.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                index.setNotes(key.getNotes());
            }
        } else {
            index.setCommentInRDBMS(key.getCommentInRDBMS());
            index.setComment(key.getComment());
            index.setNotes(key.getNotes());
        }
        ContainedObject[] attributes = key.getElements();
        for (int j = 0; j < attributes.length; ++j) {
            ContainedObject attribute = attributes[j];
            List columns = this.xmap.getMappingsForDesignPart(attribute, this.targetDesPartID);
            if (columns.size() <= 0) continue;
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)((XtdMapping)it.next()).getObjectMappedTo(attribute);
                if (column == null || column.getContainer() != index.getContainerObject()) continue;
                index.add(column);
            }
        }
        Entity ent = (Entity)key.getContainerWithKeyObject();
        Table table = index.getTable();
        Index pk = (Index)table.getPK();
        boolean hasSurrogateKey = false;
        if (pk != null && pk.isSurrogateKey()) {
            hasSurrogateKey = true;
        }
        KeyObject hpk = null;
        if (ent.isHierarchicalEntityType() && !ent.isHierarchicalRoot()) {
            hpk = ent.getHierarchicalRoot().getPK();
        }
        if (!(!key.isPK() || ent.isHierarchicalEntityType() && !ent.isHierarchicalRoot() && hpk != null || ent.isCreateSurrogateKey() || hasSurrogateKey)) {
            index.makePK();
        } else {
            index.setIndexState("Unique Constraint");
        }
    }

    public static void synchronizeColumnsFromKeyToIndex(KeyObject key, Index index) {
        int i;
        ExtendedMap xtmap = key.getDesign().getExtendedMap();
        String targetDesID = index.getDesignPart().getObjectID();
        ContainedObject[] attributes = key.getElements();
        ArrayList<Column> list = new ArrayList<Column>();
        for (int j = 0; j < attributes.length; ++j) {
            ContainedObject attribute = attributes[j];
            List columns = xtmap.getMappingsForDesignPart(attribute, targetDesID);
            if (columns.size() <= 0) continue;
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)((XtdMapping)it.next()).getObjectMappedTo(attribute);
                if (column == null || column.getContainer() != index.getContainerObject()) continue;
                if (!index.contains(column)) {
                    index.add(column);
                }
                list.add(column);
            }
        }
        ContainedObject[] cols = index.getElements();
        for (i = 0; i < cols.length; ++i) {
            if (list.contains(cols[i])) continue;
            index.remove(cols[i]);
        }
        for (i = 0; i < list.size(); ++i) {
            index.moveToIndex((ContainedObject)list.get(i), i);
        }
    }

    public static void synchronizeColumnsForKeyAndIndex(CandidateKey key, Index ind) {
        if (ind != null) {
            int i;
            Table tab = ind.getTable();
            ArrayList<FKElement> list = new ArrayList<FKElement>();
            for (DesignObject obj : key.getNewElementsCollection()) {
                Index rind;
                if (obj instanceof Attribute) {
                    Attribute attr = (Attribute)obj;
                    Column col = attr.getEngColumn((RelationalDesign)ind.getDesignPart(), tab);
                    if (col == null) continue;
                    ind.add(col);
                    if (list.contains(col)) continue;
                    list.add(col);
                    continue;
                }
                if (!(obj instanceof Relation)) continue;
                Relation rel = (Relation)obj;
                ContainedObject[] attrs = key.getEntity().getAllElementsGeneratedBy(rel);
                if (attrs.length > 0) {
                    for (int i2 = 0; i2 < attrs.length; ++i2) {
                        Attribute attr = (Attribute)attrs[i2];
                        Column col = attr.getEngColumn((RelationalDesign)ind.getDesignPart(), tab);
                        if (col == null) continue;
                        ind.add(col);
                        if (list.contains(col)) continue;
                        list.add(col);
                    }
                    continue;
                }
                FKIndexAssociation fk = rel.getEngFK((RelationalDesign)ind.getDesignPart(), tab);
                if (fk == null || (rind = (Index)fk.getRemoteIndex()) == null) continue;
                ContainedObject[] cols = rind.getColumns();
                for (int k = 0; k < cols.length; ++k) {
                    FKElement fcol = tab.getColumnForDelegate(fk, (Column)cols[k]);
                    if (fcol == null) continue;
                    ind.add(fcol);
                    if (list.contains(fcol)) continue;
                    list.add(fcol);
                }
            }
            ContainedObject[] cols = ind.getElements();
            for (i = 0; i < cols.length; ++i) {
                if (list.contains(cols[i])) continue;
                ind.remove(cols[i]);
            }
            for (i = 0; i < list.size(); ++i) {
                ind.moveToIndex((ContainedObject)list.get(i), i);
            }
        }
    }

    public static boolean isColumnsChangedForKeyAndIndex(CandidateKey key, Index ind) {
        if (ind != null) {
            int i;
            Table tab = ind.getTable();
            ArrayList<Column> list = new ArrayList<Column>();
            for (DesignObject obj : key.getNewElementsCollection()) {
                Index rind;
                if (obj instanceof Attribute) {
                    Attribute attr = (Attribute)obj;
                    Column col = attr.getEngColumn((RelationalDesign)ind.getDesignPart(), tab);
                    if (col != null) {
                        if (list.contains(col)) continue;
                        list.add(col);
                        continue;
                    }
                    return true;
                }
                if (!(obj instanceof Relation)) continue;
                Relation rel = (Relation)obj;
                ContainedObject[] attrs = key.getEntity().getAllElementsGeneratedBy(rel);
                if (attrs.length > 0) {
                    for (int i2 = 0; i2 < attrs.length; ++i2) {
                        Attribute attr = (Attribute)attrs[i2];
                        Column col = attr.getEngColumn((RelationalDesign)ind.getDesignPart(), tab);
                        if (col != null) {
                            if (list.contains(col)) continue;
                            list.add(col);
                            continue;
                        }
                        return true;
                    }
                    continue;
                }
                FKIndexAssociation fk = rel.getEngFK((RelationalDesign)ind.getDesignPart(), tab);
                if (fk == null || (rind = (Index)fk.getRemoteIndex()) == null) continue;
                ContainedObject[] cols = rind.getColumns();
                for (int k = 0; k < cols.length; ++k) {
                    Column fcol = (Column)tab.getColumnForDelegate(fk, (Column)cols[k]);
                    if (fcol != null) {
                        if (!ind.contains(fcol)) {
                            return true;
                        }
                        if (list.contains(fcol)) continue;
                        list.add(fcol);
                        continue;
                    }
                    return true;
                }
            }
            ContainedObject[] cols = ind.getElements();
            if (cols.length != list.size()) {
                return true;
            }
            for (i = 0; i < cols.length; ++i) {
                if (list.contains(cols[i])) continue;
                return true;
            }
            for (i = 0; i < list.size(); ++i) {
                if (ind.getIndexOf((ContainedObject)list.get(i)) == i) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean haveIdenticalColumns(KeyObject key, Index index) {
        if (key.getElementsCollection().size() != index.getElementsCollection().size()) {
            return false;
        }
        ContainedObject[] attributes = key.getElements();
        Table indexTable = (Table)index.getContainerWithKeyObject();
        RelationalDesign physdes = (RelationalDesign)index.getDesignPart();
        for (int j = 0; j < attributes.length; ++j) {
            Attribute attribute = (Attribute)attributes[j];
            Column column = null;
            try {
                column = attribute.getEngColumn(physdes, indexTable);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (column == null) {
                return false;
            }
            if (j == index.getIndexOf(column)) continue;
            return false;
        }
        return true;
    }

    private void engineerAllSubviews(Design design) {
        Iterator it = design.getLogicalDesign().getLogicalDesignSubviews().iterator();
        RelationalDesign physdes = design.getRelationalDesign();
        while (it.hasNext()) {
            DPVRelational physDPV;
            DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it.next();
            DPVLogicalSubView logDPV = (DPVLogicalSubView)dpvph.getDesignPartView();
            if (!dpvph.shouldBeEngineered() || (physDPV = (DPVRelational)physdes.getSubViewGeneratedByDPV(logDPV.getDPVId())) != null && (physDPV == null || !(physDPV instanceof DPVRelationalSubView))) continue;
            if (physDPV == null) {
                if (logDPV.getGeneratorId() != null && !"".equalsIgnoreCase(logDPV.getGeneratorId())) {
                    physDPV = (DPVRelationalSubView)physdes.getSubViewByID(logDPV.getGeneratorId());
                }
                if (physDPV == null) {
                    physDPV = (DPVRelationalSubView)physdes.createDesignPartSubView();
                    physDPV.setName("From_LM_" + logDPV.getName());
                    physDPV.setGeneratorId(logDPV.getDPVId());
                    this.copyPropertiesFromSubViewToSubView((DPVLogicalSubView)dpvph.getDesignPartView(), physDPV);
                    this.xmap.createMapping(logDPV.getPlaceHolder(), physDPV.getPlaceHolder());
                }
            }
            for (ContainerView tv : logDPV.getTVEntities()) {
                this.engineerEntitySynonyms((TVEntity)tv, physDPV, design);
            }
            for (ContainerView tv : ((DPVLogical)logDPV).getTVEntityViews()) {
                this.engineerEntityViewSynonyms((TVEntityView)tv, physDPV, design);
            }
            physDPV.setVisible(logDPV.isVisible());
        }
    }

    private void engineerEntitySynonyms(TVEntity tv, DesignPartView physDPV, Design design) {
        block5: {
            List list;
            Entity ent;
            block4: {
                String pdesID = physDPV.getDesignPart().getObjectID();
                ent = (Entity)tv.getModel();
                list = design.getExtendedMap().getMappingsForDesignPart(ent, pdesID);
                if (list != null) break block4;
                Table table = ent.getEngTable(this.pdes);
                if (table == null) break block5;
                TVTable topv = (TVTable)table.getTopView().createViewSynonim(physDPV);
                topv.setGeneratorID(tv.getViewID());
                topv.addTVFKRelations(physDPV);
                if (!ent.getDesign().isEngineerCoordinates()) break block5;
                physDPV.getApplicationView().setGraphicalPropsFor(topv, physDPV.getApplicationView().getGraphicalPropsFor(tv));
                break block5;
            }
            for (XtdMapping mapping : list) {
                MultiShapedDesignObject table = null;
                DesignObject obj = mapping.getObjectMappedTo(ent);
                if (obj != null && obj instanceof Table) {
                    table = (Table)mapping.getObjectMappedTo(ent);
                }
                if (table == null) continue;
                TVTable topv = (TVTable)table.getTopViewByGeneratorID(physDPV, tv.getViewID());
                if (topv == null) {
                    topv = (TVTable)table.getTopViewByID(physDPV, tv.getGeneratorID());
                }
                if (topv == null || topv.getDesignPartView() != physDPV) {
                    topv = (TVTable)table.getTopView().createViewSynonim(physDPV);
                    topv.setGeneratorID(tv.getViewID());
                    topv.addTVFKRelations(physDPV);
                }
                if (!ent.getDesign().isEngineerCoordinates()) continue;
                physDPV.getApplicationView().setGraphicalPropsFor(topv, physDPV.getApplicationView().getGraphicalPropsFor(tv));
            }
        }
    }

    private void engineerEntitySynonymsToMV(TVEntity tv, DesignPartView physDPV, Design design) {
        block7: {
            List list;
            Entity ent;
            block6: {
                String pdesID = physDPV.getDesignPart().getObjectID();
                ent = (Entity)tv.getModel();
                list = design.getExtendedMap().getMappingsForDesignPart(ent, pdesID);
                if (list != null) break block6;
                Table table = ent.getEngTable(this.pdes);
                if (table == null) break block7;
                TVTable topv = (TVTable)table.getTopView().createViewSynonim(physDPV);
                topv.setGeneratorID(tv.getViewID());
                topv.addTVFKRelations(physDPV);
                if (!ent.getDesign().isEngineerCoordinates()) break block7;
                physDPV.getApplicationView().setGraphicalPropsFor(topv, physDPV.getApplicationView().getGraphicalPropsFor(tv));
                break block7;
            }
            for (XtdMapping mapping : list) {
                Table table = (Table)mapping.getObjectMappedTo(ent);
                if (table == null) continue;
                TVTable topv = (TVTable)table.getTopViewByGeneratorID(physDPV, tv.getViewID());
                if (topv == null) {
                    topv = (TVTable)table.getTopView();
                    if (topv.getGeneratorID() == null && (tv.getGeneratorID() == null || tv.getGeneratorID() != null && tv.getGeneratorID().equalsIgnoreCase(topv.getViewID()))) {
                        topv.setGeneratorID(tv.getViewID());
                    } else {
                        topv = null;
                    }
                }
                if (topv == null) {
                    topv = (TVTable)table.getTopViewByID(physDPV, tv.getGeneratorID());
                }
                if (topv == null || topv.getDesignPartView() != physDPV) {
                    topv = (TVTable)table.getTopView().createViewSynonim(physDPV);
                    topv.setGeneratorID(tv.getViewID());
                    topv.addTVFKRelations(physDPV);
                }
                if (!ent.getDesign().isEngineerCoordinates()) continue;
                physDPV.getApplicationView().setGraphicalPropsFor(topv, physDPV.getApplicationView().getGraphicalPropsFor(tv));
            }
        }
    }

    private void engineerSubviewElementsToMainView(Design design, DesignPartView dpv) {
        DPVLogicalSubView logDPV = (DPVLogicalSubView)dpv;
        DesignPartView physDPV = this.pdes.getMainView();
        for (TVEntity tv : logDPV.getTVEnities()) {
            if (!this.includeEntity((Entity)tv.getModel())) continue;
            this.engineerEntitySynonymsToMV(tv, physDPV, design);
        }
        for (TVEntityView entityView : logDPV.getTVEntityViews()) {
            this.engineerEntityViewSynonymsToMV(entityView, physDPV, design);
        }
    }

    private boolean includeEntity(Entity ent) {
        if (ent.isHierarchicalEntityType()) {
            return ent.shouldBeEngineered();
        }
        return true;
    }

    private void engineerSubviewElementsToSubView(Design design, DesignPartView dpv) {
        DPVLogicalSubView logDPV = (DPVLogicalSubView)dpv;
        DesignPartView physDPV = this.pdes.getSubViewGeneratedByDPV(logDPV.getDPVId());
        if (physDPV == null || physDPV != null && physDPV instanceof DPVRelationalSubView) {
            if (physDPV == null) {
                if (logDPV.getGeneratorId() != null && !"".equalsIgnoreCase(logDPV.getGeneratorId())) {
                    physDPV = this.pdes.getSubViewByID(logDPV.getGeneratorId());
                }
                if (physDPV == null) {
                    physDPV = this.pdes.createDesignPartSubView();
                    physDPV.setName("From_LM_" + logDPV.getName());
                    physDPV.setGeneratorId(logDPV.getDPVId());
                    this.copyPropertiesFromSubViewToSubView(logDPV, (DPVRelational)physDPV);
                    this.xmap.createMapping(logDPV.getPlaceHolder(), physDPV.getPlaceHolder());
                }
            }
            for (TVEntity tv : logDPV.getTVEnities()) {
                this.engineerEntitySynonyms(tv, physDPV, design);
            }
            for (TVEntityView tvView : logDPV.getTVEntityViews()) {
                this.engineerEntityViewSynonyms(tvView, physDPV, design);
            }
        }
    }

    private void fixColumnOrder(Design design) {
        List overlappingEnt = design.getLogicalDesign().getEntitiesWuthOverlappingKeys(false);
        DesignObject[] entities = this.getProcessedObjects(design.getLogicalDesign().getEntitySet());
        RelationalDesign pdes = design.getRelationalDesign();
        for (int k = 0; k < entities.length; ++k) {
            ArrayList rlist;
            Entity ent = (Entity)entities[k];
            if (!ent.shouldBeEngineered() || ent.isHierarchicalEntityType()) continue;
            LogicalDesign.EntHolder entHolder = this.getHolderForEnt(ent, overlappingEnt);
            Table tab = ent.getEngTable(pdes);
            if (tab == null || !tab.isAllowColumnReorder() && !this.isNewTable(tab)) continue;
            ArrayList slist = new ArrayList(tab.getElementsCollection());
            Iterator ita = ent.getElementsCollection().iterator();
            int i = 0;
            while (ita.hasNext()) {
                Attribute attr = (Attribute)ita.next();
                LogicalDesign.AttrHolder holder = null;
                if (entHolder != null) {
                    holder = this.getFoldedAttr2Holder(entHolder, attr);
                }
                if (holder != null && holder.overlap) continue;
                Column col = attr.getEngColumn(pdes, tab);
                if (col != null) {
                    tab.moveToIndex(col, i);
                }
                ++i;
            }
            if (this.isNewTable(tab) || FWDEngineering.equalOrder(slist, rlist = new ArrayList(tab.getElementsCollection()))) continue;
            tab.setDirty(true);
        }
    }

    public static boolean equalOrder(List list1, List list2) {
        if (list1.size() == list2.size()) {
            for (int i = 0; i < list1.size(); ++i) {
                if (list1.get(i) == list2.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List getRoots(DesignObject[] entities) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = (Entity)entities[i];
            if (!entity.isHierarchicalRoot()) continue;
            list.add(entity);
        }
        return list;
    }

    private void addEntity(Entity entity, List list) {
        if (entity.shouldBeEngineered()) {
            list.add(entity);
        }
        int count = entity.getHierarchicalChildrenCount();
        for (int i = 0; i < count; ++i) {
            Entity ch_ent = entity.getHierarchicalChild(i);
            this.addEntity(ch_ent, list);
        }
    }

    private void processEntityView(EntityView entityView) {
        block4: {
            List list;
            block3: {
                list = this.xmap.getMappingsForDesignPart(entityView, this.targetDesPartID);
                if (list.size() != 0) break block3;
                if (!entityView.shouldBeEngineered()) break block4;
                String newName = this.getDesign().transformNameFromLogicalToRelational(entityView);
                TableView tableView = this.pdes.createTableView(newName);
                this.xmap.createMapping(entityView, tableView);
                this.copyPropertiesFromEntityViewToTableView(entityView, tableView);
                if (this.design.isEngineerCoordinates()) {
                    this.setGraphicalPropertiesOnNewObject(entityView, tableView);
                }
                this.newEngineeredEntityViews.add(entityView);
                XtdMapping del_mapping = entityView.getDeletedMapping(tableView.getDesignPartId());
                if (del_mapping == null) break block4;
                entityView.updateDeletedMappings(del_mapping.getDeletedID(), tableView.getObjectID(), tableView.getDesignPartId());
                this.xmap.removeMapping(del_mapping);
                break block4;
            }
            for (XtdMapping mapping : list) {
                TableView tableView;
                if (!mapping.isFwEngineer() || (tableView = (TableView)mapping.getObjectMappedTo(entityView)) == null) continue;
                EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(entityView.getObjectID() + tableView.getObjectID());
                if (comp != null) {
                    comp.copySelectedProperties();
                }
                if (!this.design.isEngineerCoordinates()) continue;
                tableView = (TableView)mapping.getObjectMappedTo(entityView);
                this.setGraphicalPropertiesOnNewObject(entityView, tableView);
            }
        }
    }

    private void copyPropertiesFromEntityViewToTableView(EntityView entityView, TableView tableView) {
        AbstractViewElement col;
        tableView.setGeneratorID(entityView.getObjectID());
        tableView.setWhere(entityView.getWhere());
        tableView.setGroupBy(entityView.getGroupBy());
        tableView.setHaving(entityView.getHaving());
        tableView.setUserDefined(entityView.getUserDefined());
        tableView.setUserDefinedSQL(entityView.getUserDefinedSQL());
        tableView.setLayoutSQL(entityView.getLayoutSQL());
        tableView.setBasedOnStructuredType(entityView.getBasedOnStructuredType());
        tableView.setParsed(entityView.isParsed());
        tableView.setIncorrectSQL(entityView.isIncorrectSQL());
        tableView.setValidSQL(entityView.isValidSQL());
        if (!this.notForNewObjects) {
            this.typeName = Design.ENTVIEW_TBLVIEW;
            this.properties = this.design.getViewPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                tableView.setComment(entityView.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                tableView.setNotes(entityView.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                tableView.setCommentInRDBMS(entityView.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.DEPRECATED)) {
                tableView.setDeprecated(entityView.isDeprecated());
            }
        } else {
            tableView.setComment(entityView.getComment());
            tableView.setNotes(entityView.getNotes());
            tableView.setCommentInRDBMS(entityView.getCommentInRDBMS());
            tableView.setDeprecated(entityView.isDeprecated());
        }
        for (AbstractView.ContainerHolder ch : entityView.getUsedContainers()) {
            Table table;
            String alias = ch.getAlias();
            String cID = ch.getContainer().getObjectID();
            Entity entity = (Entity)this.design.getLogicalDesign().getEntitySet().getObjectByID(cID);
            if (entity == null || (table = entity.getEngTable(this.pdes)) == null) continue;
            tableView.addToContainers(table, alias);
        }
        for (String id : entityView.getOrderByMap().keySet()) {
            AttributeView attribute = (AttributeView)entityView.getObjectByID(entityView.getOrderByList(), id);
            if (attribute != null) {
                col = new ColumnView(tableView.getDesignPart());
                col.setDesign(tableView.getDesign());
                this.copyAttributeToColumn(attribute, (ColumnView)col);
                col.setView(tableView);
                tableView.addToOrderBy(col, (String)entityView.getOrderByMap().get(id));
                continue;
            }
            System.out.println("FWDEngineering.copyPropertiesFromEntityViewToTableView: Unable to find AttributeView: " + id);
        }
        if (!entityView.isBST()) {
            for (int i = 0; i < entityView.getElements().length; ++i) {
                ColumnView col2;
                Entity entity = ((AttributeView)entityView.getElements()[i]).getEntity();
                if (entity != null && entity.getEngTable(this.pdes) != null) {
                    col2 = new ColumnView(tableView.getDesignPart());
                    col2.setDesign(tableView.getDesign());
                    this.copyAttributeToColumn((AttributeView)entityView.getElements()[i], col2);
                    col2.setView(tableView);
                    col2.setContainer(tableView);
                    tableView.add(col2);
                    continue;
                }
                col2 = new ColumnView(tableView.getDesignPart());
                col2.setDesign(tableView.getDesign());
                this.copyAttributeToColumn((AttributeView)entityView.getElements()[i], col2);
                col2.setView(tableView);
                col2.setContainer(tableView);
                tableView.add(col2);
            }
        }
        for (int i = 0; i < entityView.getGroupByList().size(); ++i) {
            ColumnView newcol;
            col = (AttributeView)entityView.getGroupByList().get(i);
            if (col == null || (newcol = (ColumnView)tableView.getElementGeneratedBy(col.getObjectID())) == null) continue;
            tableView.addGroupByList(newcol);
        }
    }

    public void copyAttributeToColumn(AttributeView attributeView, ColumnView columnView) {
        columnView.setGeneratorID(attributeView.getObjectID());
        attributeView.copyDefaults(columnView);
        columnView.setTableAlias(attributeView.getTableAlias());
        columnView.setAlias(attributeView.getAlias());
        columnView.setExpression(attributeView.getExpression());
        columnView.setDataType(attributeView.getDataTypeString());
        if (attributeView.getReferencedColumn() != null) {
            Column col = (Column)((Attribute)attributeView.getReferencedColumn()).getEngColumn(this.pdes);
            columnView.setReferencedColumn(col);
        }
        if (attributeView.getEntity() != null) {
            Table table = attributeView.getEntity().getEngTable(this.pdes);
            columnView.setTable(table);
        }
        columnView.setReference(attributeView.isReference());
        columnView.setStructuredType(attributeView.getStructuredType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTypeSubstitution(ContainerObject entity) {
        List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
        if (list.size() > 0) {
            for (XtdMapping mapping : list) {
                TVTypeSubstitution tvc_s;
                DesignPartView physdpv;
                DesignPartView ldpv;
                ContainerObject table;
                if (!mapping.isFwEngineer() || (table = (ContainerObject)mapping.getObjectMappedTo(entity)) == null) continue;
                EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(entity.getObjectID() + table.getObjectID());
                if (comp == null) {
                    comp = (EngPropertiesComparator)this.comparatorsMap.get(entity.getObjectID());
                }
                if (comp == null) continue;
                EngPropertyHolder ph = comp.getPropertyHolderByName(EngPropertiesComparator.ENT_TABLE_TYPE_SUBSTITUTION);
                if (ph != null && ph.isSelected()) {
                    ldpv = this.getDesign().getLogicalDesign().getMainView();
                    physdpv = this.getDesign().getRelationalDesign().getMainView();
                    if (entity.getTypeSubstitution() != null) {
                        tvc_s = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(ldpv);
                        ContainerObject ent = entity.getTypeSubstitution().getParentContainerObject();
                        ContainerObject tab = null;
                        if (table.getTypeSubstitution() != null) {
                            tab = table.getTypeSubstitution().getParentContainerObject();
                            ContainerObject engtab = this.getEngEntityOrEntityView(ent, (RelationalDesign)table.getDesignPart());
                            if (engtab == null) continue;
                            table.getTypeSubstitution().setParentCV((ContainerView)engtab.getFirstViewForDPV(physdpv));
                            TVTypeSubstitution tvc_t = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(physdpv);
                            if (!this.design.isEngineerCoordinates()) continue;
                            ApplicationView.loading = true;
                            try {
                                this.copyConnectionPoints(tvc_s, tvc_t);
                                continue;
                            }
                            finally {
                                ApplicationView.loading = false;
                                continue;
                            }
                        }
                        tab = this.getEngEntityOrEntityView(ent, (RelationalDesign)table.getDesignPart());
                        if (tab == null) continue;
                        ApplicationView.loading = false;
                        try {
                            TypeSubstitution ts = this.getDesign().getRelationalDesign().createTypeSubstitution();
                            ContainerView childTV = (ContainerView)table.getFirstViewForDPV(physdpv);
                            ContainerView parentTV = (ContainerView)tab.getFirstViewForDPV(physdpv);
                            ts.setChildCV(childTV);
                            ts.setParentCV(parentTV);
                            ts.addToAllDPVs();
                            TVTypeSubstitution tvc_t = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(physdpv);
                            if (!this.design.isEngineerCoordinates()) continue;
                            this.copyConnectionPoints(tvc_s, tvc_t);
                            continue;
                        }
                        finally {
                            ApplicationView.loading = false;
                            continue;
                        }
                    }
                    if (table == null || table.getTypeSubstitution() == null) continue;
                    table.getTypeSubstitution().remove();
                    continue;
                }
                if (!this.design.isEngineerCoordinates() || entity.getTypeSubstitution() == null || table.getTypeSubstitution() == null) continue;
                ldpv = this.getDesign().getLogicalDesign().getMainView();
                physdpv = this.getDesign().getRelationalDesign().getMainView();
                tvc_s = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(ldpv);
                TVTypeSubstitution tvc_t = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(physdpv);
                if (tvc_t == null || tvc_s == null) continue;
                this.copyConnectionPoints(tvc_s, tvc_t);
            }
        }
    }

    private ContainerObject getEngEntityOrEntityView(ContainerObject entityOrEntityView, RelationalDesign relDesign) {
        if (entityOrEntityView instanceof Entity) {
            return ((Entity)entityOrEntityView).getEngTable(relDesign);
        }
        if (entityOrEntityView instanceof EntityView) {
            return ((EntityView)entityOrEntityView).getEngTableView(relDesign);
        }
        return null;
    }

    private void processTypeSubstitutions() {
        DesignObject[] entities = this.getProcessedObjects(this.design.getLogicalDesign().getEntitySet());
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = (Entity)entities[i];
            if (entity.isHierarchicalEntityType() || !entity.isBST()) continue;
            this.processTypeSubstitution(entity);
        }
        DesignObject[] entityViews = this.getProcessedObjects(this.design.getLogicalDesign().getEntityViewSet());
        for (int i = 0; i < entityViews.length; ++i) {
            EntityView entityView = (EntityView)entityViews[i];
            if (!entityView.isBST()) continue;
            this.processTypeSubstitution(entityView);
        }
    }

    private void copyConnectionPoints(TVConnector tvc_s, TVConnector tvc_t) {
        if (tvc_t != null && tvc_s != null && !tvc_t.getDesignPartView().isAutoRoute()) {
            tvc_t.removeConnection();
            EdgeView ev = null;
            if (tvc_s.getEdge() != null) {
                ev = (EdgeView)tvc_s.getEdge().getCellView();
            }
            if (ev != null) {
                if (tvc_t.getEdge() == null) {
                    tvc_t.getDesignPartView().add(tvc_t);
                }
                List s_edgePoints = ev.getPoints();
                List t_edgePoints = tvc_t.getEdgePoints();
                t_edgePoints.clear();
                for (int i = 1; i < s_edgePoints.size() - 1; ++i) {
                    Point2D point = ev.getPoint(i);
                    t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                }
                if (s_edgePoints.size() == 2 && tvc_t.getEdge() != null) {
                    tvc_t.getEdge().straightLine();
                }
            } else {
                List s_edgePoints = tvc_s.getEdgePoints();
                List t_edgePoints = tvc_t.getEdgePoints();
                t_edgePoints.clear();
                for (int i = 0; i < s_edgePoints.size(); ++i) {
                    Point2D point = (Point2D)s_edgePoints.get(i);
                    t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                }
            }
        }
    }

    private LogicalDesign.EntHolder getHolderForEnt(Entity ent, List list) {
        for (LogicalDesign.EntHolder holder : list) {
            if (holder.ent != ent) continue;
            return holder;
        }
        return null;
    }

    private LogicalDesign.AttrHolder getFoldedAttr2Holder(LogicalDesign.EntHolder entholder, Attribute attribute) {
        for (LogicalDesign.AttrHolder holder : entholder.attrHolders) {
            if (!holder.overlap || holder.attr2 != attribute) continue;
            return holder;
        }
        for (LogicalDesign.AttrHolder holder : entholder.attrHolders) {
            if (holder.attr2 != attribute || !holder.overlapped) continue;
            return holder;
        }
        return null;
    }

    private void engineerEntityViewSynonyms(TVEntityView tv, DesignPartView physDPV, Design design) {
        block4: {
            List list;
            EntityView entView;
            block3: {
                String pdesID = physDPV.getDesignPart().getObjectID();
                entView = (EntityView)tv.getModel();
                list = this.xmap.getMappingsForDesignPart(entView, pdesID);
                if (list != null) break block3;
                TableView tableView = entView.getEngTableView(this.pdes);
                if (tableView == null) break block4;
                TVView topv = (TVView)tableView.getTopView().createViewSynonim(physDPV);
                this.xmap.createMapping(entView, tableView);
                topv.setGeneratorID(tv.getViewID());
                if (!entView.getDesign().isEngineerCoordinates()) break block4;
                physDPV.getApplicationView().setGraphicalPropsFor(topv, physDPV.getApplicationView().getGraphicalPropsFor(tv));
                break block4;
            }
            for (XtdMapping mapping : list) {
                TableView tableView = (TableView)mapping.getObjectMappedTo(entView);
                if (tableView == null) continue;
                TVView topv = (TVView)tableView.getTopViewByGeneratorID(physDPV, tv.getViewID());
                if (topv == null) {
                    topv = (TVView)tableView.getTopViewByID(physDPV, tv.getGeneratorID());
                }
                if (topv == null || topv.getDesignPartView() != physDPV) {
                    topv = (TVView)tableView.getTopView().createViewSynonim(physDPV);
                    topv.setGeneratorID(tv.getViewID());
                }
                if (!entView.getDesign().isEngineerCoordinates()) continue;
                physDPV.getApplicationView().setGraphicalPropsFor(topv, physDPV.getApplicationView().getGraphicalPropsFor(tv));
            }
        }
    }

    private void engineerEntityViewSynonymsToMV(TVEntityView tv, DesignPartView physDPV, Design design) {
        block7: {
            List list;
            EntityView entityView;
            block6: {
                String pdesID = physDPV.getDesignPart().getObjectID();
                entityView = (EntityView)tv.getModel();
                list = this.xmap.getMappingsForDesignPart(entityView, pdesID);
                if (list != null) break block6;
                TableView tableView = entityView.getEngTableView(this.pdes);
                if (tableView == null) break block7;
                TVView topv = (TVView)tableView.getTopView().createViewSynonim(physDPV);
                this.xmap.createMapping(entityView, tableView);
                topv.setGeneratorID(tv.getViewID());
                if (!entityView.getDesign().isEngineerCoordinates()) break block7;
                physDPV.getApplicationView().setGraphicalPropsFor(topv, physDPV.getApplicationView().getGraphicalPropsFor(tv));
                break block7;
            }
            for (XtdMapping mapping : list) {
                TableView tableView = (TableView)mapping.getObjectMappedTo(entityView);
                if (tableView == null) continue;
                TVView topView = (TVView)tableView.getTopViewByGeneratorID(physDPV, tv.getViewID());
                if (topView == null) {
                    topView = (TVView)tableView.getTopView();
                    if (topView.getGeneratorID() == null && (tv.getGeneratorID() == null || tv.getGeneratorID() != null && tv.getGeneratorID().equalsIgnoreCase(topView.getViewID()))) {
                        topView.setGeneratorID(tv.getViewID());
                    } else {
                        topView = null;
                    }
                }
                if (topView == null) {
                    topView = (TVView)tableView.getTopViewByID(physDPV, tv.getGeneratorID());
                }
                if (topView == null || topView.getDesignPartView() != physDPV) {
                    topView = (TVView)tableView.getTopView().createViewSynonim(physDPV);
                    topView.setGeneratorID(tv.getViewID());
                }
                if (!entityView.getDesign().isEngineerCoordinates()) continue;
                physDPV.getApplicationView().setGraphicalPropsFor(topView, physDPV.getApplicationView().getGraphicalPropsFor(tv));
            }
        }
    }

    private void copyPropertiesFromSubViewToSubView(DPVLogicalSubView source, DPVRelational target) {
        target.getPlaceHolder().setComment(source.getPlaceHolder().getComment());
        target.getPlaceHolder().setNotes(source.getPlaceHolder().getNotes());
    }

    private boolean checkIfSelected(String name, List props, String propName) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!name.equalsIgnoreCase(Design.ENTITY_TABLE)) break block5;
                            for (EngPropertyHolder h : props) {
                                if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                                return true;
                            }
                            break block6;
                        }
                        if (!name.equalsIgnoreCase(Design.ATTRIBUTE_COLUMN)) break block7;
                        for (EngPropertyHolder h : props) {
                            if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!name.equalsIgnoreCase(Design.ENTVIEW_TBLVIEW)) break block8;
                    for (EngPropertyHolder h : props) {
                        if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                        return true;
                    }
                    break block6;
                }
                if (!name.equalsIgnoreCase(Design.KEY_INDEX)) break block9;
                for (EngPropertyHolder h : props) {
                    if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                    return true;
                }
                break block6;
            }
            if (!name.equalsIgnoreCase(Design.RELATION_FK)) break block6;
            for (EngPropertyHolder h : props) {
                if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    private void processArcs() {
        LogicalDesign ldes = this.design.getLogicalDesign();
        Iterator it = ldes.getArcSet().iterator();
        while (it.hasNext()) {
            Arc arc = (Arc)it.next();
            List list = this.xmap.getMappingsForDesignPart(arc, this.pdes.getObjectID());
            if (list.size() == 0) {
                this.createNewArc(arc);
                continue;
            }
            this.synchronizeArc(arc, list);
        }
    }

    private void showArcsInSubviews(RelationalDesign pdes) {
        LogicalDesign ldes = this.design.getLogicalDesign();
        Iterator it = ldes.getArcSet().iterator();
        while (it.hasNext()) {
            Arc arc = (Arc)it.next();
            List list = this.xmap.getMappingsForDesignPart(arc, pdes.getObjectID());
            Iterator itm = list.iterator();
            FKArc fa = null;
            while (itm.hasNext()) {
                XtdMapping mapping = (XtdMapping)itm.next();
                DesignObject obj = mapping.getObjectMappedTo(arc);
                if (obj == null || !(obj instanceof FKArc)) continue;
                fa = (FKArc)obj;
                fa.addToAllDPVs();
            }
        }
    }

    private void createNewArc(Arc arc) {
        Table table;
        Entity ent = arc.getEntity();
        boolean mandatory = false;
        boolean reverse = false;
        if (ent != null && (table = ent.getEngTable(this.pdes)) != null) {
            HashMap<String, FKIndexAssociation> map = new HashMap<String, FKIndexAssociation>();
            ArrayList<FKIndexAssociation> fkeys = new ArrayList<FKIndexAssociation>();
            for (Relation rel : arc.getRelations()) {
                Table tab;
                Entity child;
                FKIndexAssociation fk = rel.getEngFK(this.pdes, table);
                if (fk == null && (child = rel.getOtherEntity(ent)) != null && (tab = child.getEngTable(this.pdes)) != null && (fk = rel.getEngFK(this.pdes, tab)) != null) {
                    reverse = true;
                }
                if (fk == null) continue;
                if (!reverse && !fk.canBeOptional()) {
                    return;
                }
                map.put(rel.getObjectID(), fk);
            }
            for (Relation rel : arc.getRelations()) {
                int i = rel.getEndPointFor(ent);
                boolean opt = rel.isOptional(i);
                FKIndexAssociation fk = (FKIndexAssociation)map.get(rel.getObjectID());
                if (fk == null) continue;
                fkeys.add(fk);
                if (!reverse) {
                    fk.setMandatory(false);
                }
                if (opt) continue;
                mandatory = true;
            }
            if (fkeys.size() > 1) {
                FKArc fk_arc = this.pdes.createArc(fkeys.toArray());
                fk_arc.setName(arc.getName());
                fk_arc.setMandatory(mandatory);
                this.xmap.createMapping(arc, fk_arc);
            }
        }
    }

    private void synchronizeArc(Arc arc, List mappings) {
        Table table;
        Entity ent = arc.getEntity();
        boolean mandatory = false;
        boolean reverse = false;
        if (ent != null && (table = ent.getEngTable(this.pdes)) != null) {
            ArrayList<FKIndexAssociation> fkeys = new ArrayList<FKIndexAssociation>();
            HashMap<String, FKIndexAssociation> map = new HashMap<String, FKIndexAssociation>();
            Iterator itm = mappings.iterator();
            FKArc fa = null;
            while (itm.hasNext()) {
                XtdMapping mapping = (XtdMapping)itm.next();
                DesignObject obj = mapping.getObjectMappedTo(arc);
                if (obj == null || !(obj instanceof FKArc)) continue;
                fa = (FKArc)obj;
                for (Relation rel : arc.getRelations()) {
                    Table tab;
                    Entity child;
                    FKIndexAssociation fk = rel.getEngFK(this.pdes, table);
                    if (fk == null && (child = rel.getOtherEntity(ent)) != null && (tab = child.getEngTable(this.pdes)) != null && (fk = rel.getEngFK(this.pdes, tab)) != null) {
                        reverse = true;
                    }
                    if (fk == null) continue;
                    if (!reverse && !fk.canBeOptional()) {
                        return;
                    }
                    map.put(rel.getObjectID(), fk);
                }
                for (Relation rel : arc.getRelations()) {
                    int i = rel.getEndPointFor(ent);
                    boolean opt = rel.isOptional(i);
                    FKIndexAssociation fk = (FKIndexAssociation)map.get(rel.getObjectID());
                    if (fk == null) continue;
                    fkeys.add(fk);
                    if (!reverse) {
                        fk.setMandatory(false);
                    }
                    if (opt) continue;
                    mandatory = true;
                }
            }
            if (fa != null) {
                if (fkeys.size() > 1) {
                    fa.setMandatory(mandatory);
                    ArrayList list = new ArrayList(fa.getFkeys());
                    for (FKIndexAssociation fk : fkeys) {
                        fa.addFkey(fk);
                    }
                    for (FKIndexAssociation fk : list) {
                        if (fkeys.contains(fk)) continue;
                        fa.removeFkey(fk);
                    }
                } else {
                    fa.remove();
                }
            }
        }
    }

    private void orderLeaf(Entity ent, Table tab) {
        if (tab != null) {
            Iterator ita = ent.getElementsCollection().iterator();
            int i = 0;
            while (ita.hasNext()) {
                Attribute attr = (Attribute)ita.next();
                Column col = attr.getEngColumn(this.pdes, tab);
                if (col != null) {
                    tab.moveToIndex(col, i);
                }
                ++i;
            }
            Entity par = ent.getHierarchicalParent();
            if (par != null) {
                this.orderLeaf(par, tab);
            }
        }
    }

    private int orderSingle(Entity ent, Table tab, int inpos) {
        int pos = inpos;
        if (tab != null) {
            Iterator ita = ent.getElementsCollection().iterator();
            int i = inpos;
            while (ita.hasNext()) {
                Attribute attr = (Attribute)ita.next();
                Column col = attr.getEngColumn(this.pdes, tab);
                if (col == null) continue;
                tab.moveToIndex(col, i);
                ++i;
            }
            pos = i;
            int k = ent.getHierarchicalChildrenCount();
            for (int p = 0; p < k; ++p) {
                Entity chent = ent.getHierarchicalChild(p);
                pos += this.orderSingle(chent, tab, pos);
            }
        }
        return pos - inpos;
    }

    private void orderHierarchicalEnt(Entity ent, Table tab) {
        this.orderSingle(ent, tab, 0);
        Entity par = ent.getHierarchicalParent();
        if (par != null) {
            this.orderLeaf(par, tab);
        }
    }

    private void fixColumnOrderHierarchicalEntity(Design design) {
        DesignObject[] entities = this.getProcessedObjects(design.getLogicalDesign().getEntitySet());
        RelationalDesign pdes = design.getRelationalDesign();
        for (int k = 0; k < entities.length; ++k) {
            ArrayList rlist;
            Table tab;
            Entity ent = (Entity)entities[k];
            if (!ent.shouldBeEngineered() || !ent.isHierarchicalEntityType() || (tab = ent.getEngTable(pdes, 3)) == null || !tab.isAllowColumnReorder() && !this.isNewTable(tab)) continue;
            ArrayList slist = new ArrayList(tab.getElementsCollection());
            this.orderHierarchicalEnt(ent, tab);
            Index key = tab.getSurrogateKey();
            if (key != null && key.getElementsCollection().size() == 1) {
                Column col = (Column)key.getElement(0);
                tab.moveToIndex(col, 0);
            }
            if (this.isNewTable(tab) || FWDEngineering.equalOrder(slist, rlist = new ArrayList(tab.getElementsCollection()))) continue;
            tab.setDirty(true);
        }
    }

    private void processSQLNames() {
        Iterator it = this.design.getLogicalDesign().getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView entityView = (EntityView)it.next();
            this.processSQLNamesForView(entityView);
        }
    }

    private boolean isNewTable(Table table) {
        return this.newTables.get(table.getObjectID()) != null;
    }

    private void processSQLNamesForView(EntityView view) {
        List list = this.xmap.getMappingsForDesignPart(view, this.targetDesPartID);
        for (XtdMapping mapping : list) {
            TableView tableView;
            if (!mapping.isFwEngineer() || (tableView = (TableView)mapping.getObjectMappedTo(view)) == null) continue;
            tableView.getSQLNames().clear();
            tableView.setValidSQL(false);
            for (SQLNameHelper helper : view.getSQLNames()) {
                DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
                if (desObj != null) {
                    SQLNameHelper newHelper;
                    if (desObj instanceof Entity) {
                        Entity entity = (Entity)desObj;
                        Table table = entity.getEngTable(this.pdes);
                        if (table != null) {
                            newHelper = new SQLNameHelper(true, false);
                            newHelper.setID(table.getObjectID());
                            newHelper.setTableName(entity.getName());
                            tableView.getSQLNames().add(newHelper);
                            table.addObjectListener(tableView);
                            continue;
                        }
                        tableView.setIncorrectSQL(true);
                        continue;
                    }
                    if (desObj instanceof EntityView) {
                        EntityView enView = (EntityView)desObj;
                        TableView tbView = enView.getEngTableView(this.pdes);
                        if (tbView != null) {
                            newHelper = new SQLNameHelper(true, true);
                            newHelper.setID(tbView.getObjectID());
                            newHelper.setTableName(enView.getName());
                            tableView.getSQLNames().add(newHelper);
                            tbView.addObjectListener(tableView);
                            continue;
                        }
                        tableView.setIncorrectSQL(true);
                        continue;
                    }
                    if (desObj instanceof Attribute) {
                        Attribute attribute = (Attribute)desObj;
                        Column column = (Column)attribute.getEngColumn(this.pdes);
                        if (column != null) {
                            newHelper = new SQLNameHelper(false, false);
                            newHelper.setID(column.getObjectID());
                            newHelper.setTableName(attribute.getContainer().getName());
                            newHelper.setColumnName(attribute.getName());
                            tableView.getSQLNames().add(newHelper);
                            column.addObjectListener(tableView);
                            continue;
                        }
                        tableView.setIncorrectSQL(true);
                        continue;
                    }
                    if (!(desObj instanceof AttributeView)) continue;
                    AttributeView attributeView = (AttributeView)desObj;
                    EntityView enView = (EntityView)attributeView.getContainer();
                    ContainedObject colView = enView.getElementByName(attributeView.getName());
                    if (colView != null) {
                        SQLNameHelper newHelper2 = new SQLNameHelper(false, false);
                        newHelper2.setID(attributeView.getObjectID());
                        newHelper2.setTableName(attributeView.getContainer().getName());
                        newHelper2.setColumnName(attributeView.getName());
                        tableView.getSQLNames().add(newHelper2);
                        colView.addObjectListener(tableView);
                        continue;
                    }
                    tableView.setIncorrectSQL(true);
                    continue;
                }
                SQLNameHelper newHelper = helper.clone();
                tableView.getSQLNames().add(newHelper);
            }
        }
    }
}

