/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.awt.Dimension;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.datatypes.TVDTReference;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;

public class DTReference
extends DTRelation {
    public static final String OBJECT_TYPE_NAME = "DTReference";
    private TypeElement typeElement;

    public DTReference(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public void remove() {
        if (this.typeElement != null) {
            this.typeElement.setReferenceRelation(null);
            this.typeElement.remove();
            this.typeElement = null;
        }
        super.remove();
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public void setTypeElement(TypeElement typeElement) {
        this.typeElement = typeElement;
    }

    public void updatePresentation() {
        for (TVDTRelation tv : this.getAllViews()) {
            tv.resetEdgeParams();
            tv.displayLabels();
        }
    }

    public void createDefaultSelfReferencePoints() {
        ((TVDTReference)this.getTopView()).createDefaultSelfReferencePoints();
    }

    @Override
    public void addTVDTRelation(DTRelation.DpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TVDTReference tv = new TVDTReference(this.getDesign().getAppView(), dpi.dpv);
            tv.setModel(this);
            tv.setSize(new Dimension(100, 100));
            this.addObjectListener(tv);
            dpi.dpv.registerForTreemodel(tv);
            if (dpi.dpv.isVisible() && !ApplicationView.loading) {
                tv.addConnection();
            }
        } else if (dpi.tv != null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null && ((TVDTRelation)dpi.tv).getEdge() == null && !ApplicationView.loading) {
            ((TVDTRelation)dpi.tv).addConnection();
        }
    }

    @Override
    public void showPropertyDialog() {
        TypeElement te = this.getTypeElement();
        if (te != null) {
            te.showPropertyDialog();
        }
    }
}

