/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBIndexOraclev11g;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBCreateTableOraclev11g
extends CSSBCreateTableOraclev10g {
    private CSSBIndexOraclev11g cssbIndex = null;

    @Override
    protected void appendDatatype(StringBuffer buffer, String datatype, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (datatype.equalsIgnoreCase("unknown") && columnProxy.isVirtual()) {
            return;
        }
        super.appendDatatype(buffer, datatype, columnProxy, prettyPrint);
    }

    @Override
    protected void appendColumnOptions(StringBuffer buffer, TableProxyOraclev10g tableProxy, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (columnProxy.isVirtual()) {
            this.appendVirtualColumnDefinition(buffer, tableProxy, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
            this.appendInvisible(buffer, columnProxy);
        } else {
            this.appendInvisible(buffer, columnProxy);
            this.appendWithDefaultDefinition(buffer, columnProxy);
        }
        this.appendEncrypt(buffer, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateTableOraclev11g.appendString(buffer, ' ');
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "NULL");
        }
    }

    private void appendVirtualColumnDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, ColumnProxyOraclev11g columnProxy, boolean prettyPrint) {
        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "AS");
        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, columnProxy.getColumnExpression());
        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "VIRTUAL");
        if (tableProxy.getOrganization().equalsIgnoreCase("INDEX")) {
            this.appendError(buffer, "--  ERROR: Virtual columns not supported for Organization INDEX", prettyPrint);
        }
        if (tableProxy.getCluster() != null) {
            this.appendError(buffer, "--  ERROR: Virtual columns not supported for Cluster Tables", prettyPrint);
        }
        if ("YES".equalsIgnoreCase(tableProxy.getTemporary())) {
            this.appendError(buffer, "--  ERROR: Virtual columns not supported for Temporary Tables", prettyPrint);
        }
    }

    @Override
    protected void appendRefPartitionFK(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        FKProxyOracle fkproxy;
        PartitionListOracle partitionList = tableProxy.getPartitionList();
        if (partitionList != null && partitionList.getPartitionType().equals("REFERENCE") && (fkproxy = ((PartitionListOraclev11g)partitionList).getRefConstraint()) != null && fkproxy.getFKTable() != null) {
            this.appendComma(buffer);
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            if (!fkproxy.getName().startsWith("SYS_")) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy));
            }
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "FOREIGN KEY");
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 0);
            String columnList = fkproxy.getColumns(this.storageDesign);
            if (columnList.length() > 0) {
                CSSBCreateTableOraclev11g.appendString(buffer, columnList);
            }
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
            this.appendReferences(buffer, fkproxy);
            this.appendOnDelete(buffer, fkproxy, prettyPrint);
            this.appendConstraintState(buffer, fkproxy);
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxyOracle fk) {
        CSSBCreateTableOraclev11g.appendNewLine(buffer, true, 1);
        FKContainer refTable = fk.getFKTable();
        if (refTable != null) {
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "REFERENCES");
            ModelIDObject refTableObject = this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObject == null) {
                refTableObject = refTable;
            }
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObject));
            boolean refStructType = false;
            if (refTable.isBST()) {
                ColumnProxy[] columnProxies = fk.getColumnProxies();
                for (int i = 0; i < columnProxies.length; ++i) {
                    Column column = columnProxies[i].getColumn();
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
            if (!refStructType) {
                CSSBCreateTableOraclev11g.appendNewLine(buffer, true, 1);
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev11g.appendNewLine(buffer, true, 0);
                CSSBCreateTableOraclev11g.appendString(buffer, fk.getReferenceColumns(this.storageDesign));
                CSSBCreateTableOraclev11g.appendNewLine(buffer, true, 1);
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendOnDelete(StringBuffer buffer, FKProxyOracle fk, boolean prettyPrint) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        String onDelete = fkass.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = fkass.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            CSSBCreateTableOraclev11g.appendNewLine(buffer, true, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "ON");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "DELETE");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, onDelete);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            // empty if block
        }
    }

    private void appendConstraintState(StringBuffer buffer, FKProxyOracle fk) {
        if (this.storageDesign.isOpen()) {
            CSSBCreateTableOraclev11g.appendNewLine(buffer, true, 1);
            if ("NO".equalsIgnoreCase(fk.getDeferrable())) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "NOT");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "DEFERRABLE");
            } else {
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(fk.getInitially())) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(fk.getEnable())) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(fk.getValidate())) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(fk.getEnable())) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(fk.getValidate())) {
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(fk.getValidate())) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            if (fk.getExceptionsTable() != null) {
                buffer.append(NEWLINE);
                buffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
            }
        }
    }

    @Override
    public void appendPartitionList(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        PartitionListOraclev11g partitionList = (PartitionListOraclev11g)tableProxy.getPartitionList();
        if (partitionList != null) {
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev11g)tableProxy.getStorageDesign();
            }
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                String intervalExpression = partitionList.getIntervalExpression().trim();
                if (intervalExpression.length() > 0) {
                    CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "INTERVAL");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, intervalExpression);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                    if (partitionList.getIntervalTablespaces().length() > 0) {
                        CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIntervalTablespaces()));
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                }
                this.appendSubPartitionDefinition(buffer, tableProxy, partitionList, prettyPrint);
                boolean composite = !subpartitionType.equalsIgnoreCase("");
                this.appendPartitions(buffer, partitionList, true, composite, prettyPrint);
            } else if (partitionType.startsWith("HASH")) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "HASH");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, tableProxy, partitionList, prettyPrint);
                if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                    CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    this.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                    if (!"".equals(partitionList.getHashPTableSpaces())) {
                        CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                    if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                        CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "OVERFLOW");
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else {
                    this.appendHashPartitions(buffer, tableProxy, prettyPrint);
                }
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "LIST");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, tableProxy, partitionList, prettyPrint);
                this.appendListPartitions(buffer, tableProxy, partitionList, prettyPrint);
            } else if ("REFERENCE".equalsIgnoreCase(partitionType)) {
                FKContainer remoteTable;
                FKProxyOracle refConstraint = partitionList.getRefConstraint();
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "REFERENCE");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                FKContainer fKContainer = remoteTable = refConstraint == null ? null : refConstraint.getFKTable();
                if (remoteTable != null) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(refConstraint));
                }
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
            } else if ("SYSTEM".equalsIgnoreCase(partitionType)) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SYSTEM");
                int systemPartitions = partitionList.getSystemPartitions();
                if (systemPartitions > 1) {
                    CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    this.appendStringWithSpace(buffer, systemPartitions);
                } else {
                    this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
                }
            }
        }
    }

    private void appendSubPartitionDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, PartitionListOraclev11g partitionList, boolean prettyPrint) {
        String subpartitionType = partitionList.getSubpartitionType();
        if (subpartitionType.equalsIgnoreCase("HASH")) {
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "BY");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
            if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
                if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                    CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    this.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                    if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "1");
                }
            } else {
                this.appendHashSubPartitionTemplates(buffer, tableProxy, prettyPrint);
            }
        } else if (subpartitionType.equalsIgnoreCase("LIST")) {
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "BY");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "LIST");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
            this.appendListSubPartitionTemplates(buffer, tableProxy, prettyPrint);
        } else if (subpartitionType.equalsIgnoreCase("RANGE")) {
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "BY");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
            this.appendRangeSubPartitionTemplates(buffer, tableProxy, prettyPrint);
        }
    }

    private void appendRangeSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        StorageObjectCollection templates = tableProxy.getListStorageTemplates();
        if (templates.size() > 0) {
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "TEMPLATE");
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < templates.size(); ++i) {
                PartitionOraclev11g temp = (PartitionOraclev11g)templates.getElement(i);
                if (i > 0) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!temp.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(temp));
                }
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, temp.getValueList());
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, temp, prettyPrint);
            }
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    protected void appendSubPartitions(StringBuffer buffer, AbstractStorageObjectOracle partition, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        if (partitionList.getSubpartitionType().equalsIgnoreCase("HASH")) {
            StorageObjectCollection subpartitions = null;
            int subPartitionsQuantity = 0;
            String subPartitionsTableSpaceIDs = "";
            if (partition instanceof PartitionOraclev11g) {
                PartitionOraclev11g rangePartition = (PartitionOraclev11g)partition;
                subpartitions = rangePartition.getPartitions();
                subPartitionsQuantity = rangePartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = rangePartition.getSubPartitionsTableSpaces();
            } else if (partition instanceof ListPartitionOraclev11g) {
                ListPartitionOraclev11g listPartition = (ListPartitionOraclev11g)partition;
                subpartitions = listPartition.getHashSubpartitions();
                subPartitionsQuantity = listPartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = listPartition.getSubPartitionsTableSpaces();
            }
            if (!this.appendHashSubPartitions(buffer, subpartitions, partitionList, prettyPrint) && subPartitionsQuantity > 0) {
                CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                this.appendStringWithSpace(buffer, subPartitionsQuantity);
                if (!"".equalsIgnoreCase(subPartitionsTableSpaceIDs)) {
                    CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionsTableSpaceIDs));
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                }
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("LIST")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((PartitionOraclev11g)partition).getListPartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getListSubpartitions(), prettyPrint);
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("RANGE")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((PartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            }
        }
    }

    private void appendRangeSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, boolean prettyPrint) {
        if (subpartitions.size() > 0) {
            Object[] subpartitionsList = subpartitions.toArray();
            Arrays.sort(subpartitionsList, new PositionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < subpartitionsList.length; ++i) {
                sortedList.add(subpartitionsList[i]);
            }
            Iterator rangeSubpartitions = sortedList.iterator();
            boolean firstPart = true;
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
            while (rangeSubpartitions.hasNext()) {
                PartitionOraclev11g rangeSubpartition = (PartitionOraclev11g)rangeSubpartitions.next();
                if (!firstPart) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ',');
                } else {
                    firstPart = false;
                }
                CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!rangeSubpartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(rangeSubpartition));
                }
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, rangeSubpartition.getValueList());
                CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, rangeSubpartition, prettyPrint);
            }
            CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendError(StringBuffer buffer, String errorText, boolean prettyPrint) {
        CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 0);
        CSSBCreateTableOraclev11g.appendStringWithSpace(buffer, errorText);
        CSSBCreateTableOraclev11g.appendNewLine(buffer, prettyPrint, 5);
        CDDLFileMaker.incrementErrors();
    }

    @Override
    protected CSSBIndexOraclev11g getCSSBIndex() {
        if (this.cssbIndex == null) {
            this.cssbIndex = new CSSBIndexOraclev11g();
            this.cssbIndex.setStorageDesign((StorageDesignOraclev11g)this.storageDesign);
        }
        return this.cssbIndex;
    }

    static class PositionComparator
    implements Comparator {
        PositionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

