/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g;

import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterColumnOraclev10g;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBAlterColumnOraclev11g
extends CSSBAlterColumnOraclev10g {
    @Override
    protected void appendDatatype(StringBuffer buffer, String datatype, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (datatype.equalsIgnoreCase("unknown") && columnProxy.isVirtual()) {
            return;
        }
        super.appendDatatype(buffer, datatype, columnProxy, prettyPrint);
    }

    @Override
    protected void appendColumnOptions(StringBuffer buffer, TableProxyOraclev10g tableProxy, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (columnProxy.isVirtual()) {
            this.appendVirtualColumnDefinition(buffer, tableProxy, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
            this.appendInvisible(buffer, columnProxy);
        } else {
            this.appendInvisible(buffer, columnProxy);
            this.appendWithDefaultDefinition(buffer, columnProxy);
        }
        this.appendEncrypt(buffer, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBAlterColumnOraclev11g.appendString(buffer, ' ');
            CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, "NULL");
        }
    }

    @Override
    protected void appendVirtualColumnDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, ColumnProxyOraclev11g columnProxy, boolean prettyPrint) {
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, "AS");
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, '(');
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, columnProxy.getColumnExpression());
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, ')');
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, "VIRTUAL");
        if (tableProxy.getOrganization().equalsIgnoreCase("INDEX")) {
            this.appendError(buffer, "--  ERROR: Virtual columns not supported for Organization INDEX", prettyPrint);
        }
        if (tableProxy.getCluster() != null) {
            this.appendError(buffer, "--  ERROR: Virtual columns not supported for Cluster Tables", prettyPrint);
        }
        if ("YES".equalsIgnoreCase(tableProxy.getTemporary())) {
            this.appendError(buffer, "--  ERROR: Virtual columns not supported for Temporary Tables", prettyPrint);
        }
    }

    private void appendError(StringBuffer buffer, String errorText, boolean prettyPrint) {
        CSSBAlterColumnOraclev11g.appendNewLine(buffer, prettyPrint, 0);
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, errorText);
        CSSBAlterColumnOraclev11g.appendNewLine(buffer, prettyPrint, 5);
        CDDLFileMaker.incrementErrors();
    }
}

