/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBListPartitionOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.AbstractCSSBOraclev10g;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;

public class CSSBAlterTableOraclev10g
extends AbstractCSSBOraclev10g {
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection listPartitionsNode;
        int listPartitionsIndex;
        CompareObjectSelection sourceObj = (CompareObjectSelection)object;
        Table table = (Table)sourceObj.getObject();
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        boolean createProp = false;
        if (sourceObj.isModified()) {
            for (EngPropertyHolder ph : sourceObj.getPropertiesComparator().getPropertiesList()) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(PropertiesComparator.COMMENT_IN_RDBMS) && table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendCommentOn(oldbuffer, tableProxy, prettyPrint);
                    continue;
                }
                if (!ph.getName().equals(PropertiesComparator.SPATIAL_TABLE) || !Boolean.parseBoolean(ph.getLeftValue())) continue;
                for (SpatialColumnDefObject spObjects : table.getSpatialDefinitions()) {
                    if (spObjects.getSpatialColumn() == null && !spObjects.isFunction()) continue;
                    this.appendRegisterSpatialTable(oldbuffer, table, spObjects, prettyPrint);
                }
            }
            ArrayList<String> propList = new ArrayList<String>();
            boolean alterProp = false;
            Settings settings = sourceObj.getObject().getAppView().getSettings();
            for (EngPropertyHolder ph : sourceObj.getPropertiesComparator().getStoragePropertiesList()) {
                if (!ph.isSelected()) continue;
                String propName = ph.getName();
                if (settings.isIncludeStorageInDDL()) {
                    if (propName.equalsIgnoreCase(PropertyNames.PCT_FREE) && settings.isIncludePctFreeInDDL()) {
                        propList.add("PCTFREE");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.PCT_USED) && settings.isIncludePctUsedInDDL()) {
                        propList.add("PCTUSED");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.INIT_TRANS) && settings.isIncludeInitransInDDL()) {
                        propList.add("INITRANS");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.SC_BUFFER_POOL) && settings.isIncludeBufferPoolInDDL()) {
                        propList.add("BUFFER_POOL");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.SC_INITIAL_EXTENT) && settings.isIncludeInitialExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_NEXT_EXTENT) && settings.isIncludeNextExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_MIN_EXTENTS) && settings.isIncludeMinExtentsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_MAX_EXTENTS) && settings.isIncludeMaxExtentsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_PCT_INCREASE) && settings.isIncludePctIncreaseInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS) && settings.isIncludeFreeListsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS_GRPS) && settings.isIncludeFreeListGroupsInDDL()) {
                        createProp = true;
                    }
                }
                if (!propName.equalsIgnoreCase(PropertyNames.TABLESPACE) || !settings.isIncludeTablespaceInDDL()) continue;
                createProp = true;
            }
            if (alterProp) {
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLE");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, this.getFormattedTableName(sourceObj, this.storageDesign));
                this.appendSegment(oldbuffer, tableProxy.getSegment(), prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging(), propList);
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendLineFinisher(oldbuffer, prettyPrint);
                this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                CDDLFileMaker.incrementAlterTable();
            }
            if (createProp) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "-- Table " + table.getName() + " some storage properties are not modified");
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            }
        }
        if ((listPartitionsIndex = sourceObj.getChildIndex(CompareModelToModel.LIST_PARTITIONS)) > -1 && !createProp && (listPartitionsNode = (CompareObjectSelection)sourceObj.getChild(listPartitionsIndex)).hasChildsWithChangeStatus()) {
            CSSBListPartitionOracle cssbListPartitionOracle = new CSSBListPartitionOracle();
            cssbListPartitionOracle.updateListPartitions(oldbuffer, sourceObj, listPartitionsNode, this.storageDesign, prettyPrint);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Table;
    }
}

