/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBIndexOraclev10g;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBAlterIndexOraclev10g
extends AbstractCSSBOracle {
    CSSBDropIndex dropIndex;
    private CSSBIndexOraclev10g cssbIndex = null;
    Map fkMap;
    private PKProxyOraclev10g pk = null;
    protected StorageDesignOraclev10g storageDesign;
    private CompareObjectSelection tableObj;
    public static String CREATED = "created_";

    public CSSBAlterIndexOraclev10g(Map fkMap) {
        this.fkMap = fkMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        HashMap map = new HashMap();
        this.tableObj = (CompareObjectSelection)((CompareObjectSelection)obj.getParent()).getParent();
        CompareObjectSelection ttableObj = this.tableObj.getCorrespondentNode();
        FKContainer table = (FKContainer)this.tableObj.getObject();
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
        ModelIDObject mobj = obj.getObject();
        FKContainer ttable = (FKContainer)ttableObj.getObject();
        ModelIDObject sobj = obj.getObject();
        String sobjCreatedID = CREATED + sobj.getObjectID();
        if (!obj.canBeCreate()) {
            boolean dropAndRecreate = false;
            String formattedNewName = null;
            String formattedOldName = null;
            for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
                if (!ph.isSelected()) continue;
                String propertyName = ph.getName();
                if (propertyName.equals(PropertiesComparator.NAME)) {
                    formattedNewName = this.storageDesign.getFormatedName(obj.getObject());
                    formattedOldName = this.storageDesign.getFormatedName(obj.getCorrespondentNode().getObject());
                    continue;
                }
                if (!propertyName.equals(PropertiesComparator.COLUMNS) && !propertyName.equals(PropertiesComparator.INDEX_FUNCTION_EXPRESSION) && !propertyName.equals(PropertiesComparator.INDEX_STATUS)) continue;
                dropAndRecreate = true;
            }
            if (!dropAndRecreate) {
                for (EngPropertyHolder ph : obj.getPropertiesComparator().getStoragePropertiesList()) {
                    if (!ph.isSelected()) continue;
                    dropAndRecreate = true;
                    break;
                }
            }
            if (dropAndRecreate) {
                KeyObject mdObject = (KeyObject)((CompareObjectSelection)object).getCorrespondentNode().getObject();
                if (mdObject != null) {
                    Index supConstr = null;
                    Index supIndex = null;
                    boolean isPK_UK = false;
                    this.dropIndex = new CSSBDropIndex(this.fkMap);
                    List list = null;
                    if (!this.fkMap.containsKey(mdObject.getObjectID()) && ttable instanceof Table && mdObject instanceof Index) {
                        if (!mdObject.isPK() && !mdObject.isUnique()) {
                            list = ((Table)ttable).getConstraintsSupprtedByIndex((Index)mdObject);
                        } else {
                            isPK_UK = true;
                            supIndex = ((Index)mdObject).getSupportingIndexForConstraint();
                            if (supIndex != null && mdObject.getName().equals(supIndex.getName())) {
                                list = ((Table)ttable).getConstraintsSupprtedByIndex(supIndex);
                                supConstr = supIndex.getsupportedConstraint(list);
                            }
                        }
                    }
                    if (list == null || list.size() == 0) {
                        this.dropIndex.doAppend(oldbuffer, obj, prettyPrint);
                    } else if (ttable instanceof Table && mdObject instanceof Index) {
                        boolean removed;
                        Index ind = (Index)mdObject;
                        if (supConstr == null) {
                            supConstr = ind.getsupportedConstraint(list);
                        }
                        if (supConstr != null && (removed = list.remove(supConstr))) {
                            list.add(supConstr);
                        }
                        ArrayList<CompareObjectSelection> nodes = new ArrayList<CompareObjectSelection>();
                        CompareObjectSelection supConstrNode = null;
                        for (Index tind : list) {
                            CompareObjectSelection node = this.getPK_UK_NodeForObject(ttableObj, tind);
                            if (node == null) continue;
                            nodes.add(node);
                            if (supConstr == tind || list.size() == 1 && supIndex == null) {
                                supConstrNode = node;
                                this.dropIndex.doAppend(oldbuffer, node.getCorrespondentNode(), prettyPrint, true);
                                continue;
                            }
                            this.dropIndex.doAppend(oldbuffer, node.getCorrespondentNode(), prettyPrint, false);
                        }
                        if (nodes.size() > 1 && supConstrNode != null) {
                            nodes.remove(supConstrNode);
                            nodes.add(0, supConstrNode);
                        }
                        if (!this.fkMap.containsKey(sobjCreatedID)) {
                            this.fkMap.put(sobjCreatedID, sobj);
                            this.appendAddIndex(oldbuffer, obj, prettyPrint);
                        }
                        for (CompareObjectSelection node : nodes) {
                            ModelIDObject newK = node.getObject();
                            boolean nmerge = false;
                            boolean omerge = false;
                            if (newK != null) {
                                nmerge = newK.shouldBeMerge();
                                newK.setShouldMerge(true);
                            }
                            CompareObjectSelection source = node.getCorrespondentNode();
                            ModelIDObject oldK = source.getObject();
                            String sobCrID = null;
                            if (oldK != null) {
                                sobCrID = CREATED + oldK.getObjectID();
                                omerge = oldK.shouldBeMerge();
                                oldK.setShouldMerge(true);
                            }
                            if (sobCrID != null && !this.fkMap.containsKey(sobCrID)) {
                                this.fkMap.put(sobCrID, oldK);
                                this.appendAddIndex(oldbuffer, source, prettyPrint);
                            }
                            if (newK != null) {
                                newK.setShouldMerge(nmerge);
                            }
                            if (oldK == null) continue;
                            oldK.setShouldMerge(omerge);
                        }
                        return;
                    }
                }
            } else {
                if (formattedNewName != null) {
                    Index oldIndex = (Index)obj.getCorrespondentNode().getObject();
                    if (oldIndex.isPK() || oldIndex.isUnique()) {
                        this.renameConstraint(oldbuffer, formattedOldName, formattedNewName, prettyPrint);
                    } else {
                        this.renameIndex(oldbuffer, oldIndex, formattedNewName, prettyPrint);
                    }
                }
                return;
            }
        }
        if (!this.fkMap.containsKey(sobjCreatedID)) {
            this.fkMap.put(sobjCreatedID, sobj);
            this.appendAddIndex(oldbuffer, obj, prettyPrint);
        }
    }

    private void renameIndex(StringBuffer oldbuffer, Index oldIndex, String formattedNewName, boolean prettyPrint) {
        RDBMSSite site;
        Table oldTable = oldIndex.getTable();
        Design design = oldTable.getDesign();
        StorageDesign targetStorageDesign = design.getStorageDesign(site = oldTable.getSelectedRDBMSSite(), oldTable);
        IndexProxyOracle indexProxy = (IndexProxyOracle)targetStorageDesign.getIndexProxySet().getProxy(oldIndex.getObjectID());
        if (indexProxy != null) {
            StringBuffer buffer = new StringBuffer();
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "INDEX");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(indexProxy));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "RENAME");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "TO");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, formattedNewName);
            String advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterIndex();
        }
    }

    private void renameConstraint(StringBuffer oldbuffer, String formattedOldName, String formattedNewName, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.getFormattedTableName(this.tableObj, this.storageDesign));
        String advancedComment = buffer.toString() + "RENAME" + ' ' + "CONSTRAINT" + ' ' + formattedOldName;
        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "RENAME");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, formattedOldName);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "TO");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, formattedNewName);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendLineFinisher(buffer, prettyPrint);
        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendAddIndex(StringBuffer oldbuffer, CompareObjectSelection obj, boolean prettyPrint) {
        Table table = (Table)this.tableObj.getObject();
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null) {
            this.appendIndexDefinition(oldbuffer, obj, prettyPrint);
            this.appendPKDefinition(oldbuffer, tableProxy, obj, prettyPrint);
            this.appendUniqueDefinition(oldbuffer, tableProxy, obj, prettyPrint);
        }
    }

    private void appendIndexDefinition(StringBuffer oldbuffer, CompareObjectSelection indexObj, boolean prettyPrint) {
        CSSBIndexOraclev10g cssbIndex = this.getCSSBIndex();
        if (cssbIndex.canHandle(indexObj.getObject())) {
            StringBuffer columnList = this.getColumnsForRestore(indexObj, prettyPrint, true);
            cssbIndex.setRestoredColumns(columnList);
            cssbIndex.setRestoredExpression(indexObj.getChoosedPropertyValue(PropertiesComparator.INDEX_FUNCTION_EXPRESSION));
            cssbIndex.setTableName(this.getFormattedTableName(this.tableObj, this.storageDesign));
            cssbIndex.doAppend(oldbuffer, indexObj.getObject(), prettyPrint);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Index;
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableProxyOraclev10g tableProxy, CompareObjectSelection indexObj, boolean prettyPrint) {
        if (tableProxy != null) {
            Index pkInd = (Index)indexObj.getObject();
            this.pk = (PKProxyOraclev10g)this.storageDesign.getPKProxySet().getProxy(pkInd.getObjectID());
            if (this.pk != null && pkInd.shouldBeMerge()) {
                if (!"".equalsIgnoreCase(this.pk.getColumns())) {
                    StringBuffer columnList = this.getColumnsForRestore(indexObj, prettyPrint, false);
                    if (this.isNotEmpty(columnList.toString())) {
                        if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                            this.appendComment(oldbuffer, this.pk);
                        } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                            this.appendComment(oldbuffer, this.pk.getObject());
                        }
                        StringBuffer buffer = new StringBuffer();
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.getFormattedTableName(this.tableObj, this.storageDesign));
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "ADD");
                        if (!this.pk.getName().startsWith("SYS_")) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.pk));
                        }
                        String advancedComment = buffer.toString();
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        this.appendStringWithSpace(buffer, columnList);
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
                        if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                            if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                            }
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOT");
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                        }
                        if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                            this.appendUsingIndex(buffer, this.pk, tableProxy, prettyPrint);
                        }
                        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            if ("YES".equalsIgnoreCase(this.pk.getEnable())) {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                            } else {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                            }
                            if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                            } else {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                            }
                        } else {
                            if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                                if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                                }
                            }
                            if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                            }
                        }
                        this.appendToBuffer(oldbuffer, buffer, advancedComment);
                        this.appendLineFinisher(buffer, prettyPrint);
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, advancedComment);
                        CDDLFileMaker.incrementAlterTable();
                    }
                } else {
                    this.appendError(oldbuffer, prettyPrint, "Index " + this.pk.getLongNameDDL() + " without columns");
                }
            }
        }
    }

    private void appendUsingIndex(StringBuffer buffer, PKProxyOraclev10g pkProxy, TableProxyOracle tableProxy, boolean prettyPrint) {
        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = pkProxy.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(pkProxy.getUsingIndex()) && exIndex != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(pkProxy.getIndex(), true)) {
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pkProxy.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pkProxy.getUsingIndex())) {
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, pkProxy.getCreateIndexStatement());
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                    this.getCSSBIndex().appendPartitionList(buffer, pkProxy, tableProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                    this.appendGlobalIndex(buffer, pkProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                    this.appendGlobalIndexByHashQuantity(buffer, pkProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                    this.appendGlobalIndexByHashList(buffer, pkProxy, prettyPrint);
                }
                if (pkProxy.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)pkProxy.getIndexSegment(), prettyPrint, pkProxy.getTableSpace(), pkProxy.getLogging());
                } else {
                    if (pkProxy.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy.getTableSpace()));
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (pkProxy.getIndexSort().equalsIgnoreCase("NO")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOSORT");
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (pkProxy.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "SORT");
                    }
                    buffer.append("REVERSE");
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "SORT");
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (pkProxy.getComputeStatistics().equalsIgnoreCase("YES")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (this.storageDesign instanceof StorageDesignOraclev11g) {
                    if (pkProxy.getCompress() > 0) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        this.appendStringWithSpace(buffer, pkProxy.getCompress());
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                }
            }
        }
    }

    private void appendGlobalIndex(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "RANGE");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, pkProxy, prettyPrint);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g partList = (IndexGlobalPartitionsListOraclev10g)pkProxy.getIndexGlobalPL();
            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partList.getGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
            this.appendStringWithSpace(buffer, partList.getHashPQuantity());
            if (!"".equals(partList.getHashPTableSpaces())) {
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getHashPTableSpaces()));
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
            if (!"".equals(partList.getIOTOverflowHashPTS())) {
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getIOTOverflowHashPTS()));
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendHashPartitions(buffer, pkProxy, prettyPrint);
        }
    }

    private void appendHashPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, boolean prettyPrint) {
        this.getCSSBIndex().appendGlobalHashPartitions(buffer, indexProxy, prettyPrint);
    }

    private void appendGlobalPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, boolean prettyPrint) {
        this.getCSSBIndex().appendGlobalRangePartitions(buffer, indexProxy, prettyPrint);
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev10g segment, boolean prettyPrint, TableSpaceOracle tableSpace, String logging) {
        if (segment != null) {
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                    this.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                    if (segment.getInitrans() > 1) {
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                        this.appendStringWithSpace(buffer, segment.getInitrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "1");
                    }
                    if (!(this.storageDesign instanceof StorageDesignOraclev11g)) {
                        if (segment.getMaxTrans() > 1) {
                            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                            this.appendStringWithSpace(buffer, segment.getMaxTrans());
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "255");
                        }
                    }
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (tableSpace != null) {
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
                } else if (segment.getTableSpace() != null) {
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment.getTableSpace()));
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && !"".equals(logging)) {
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                if (logging.equalsIgnoreCase("NO")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                boolean props = false;
                if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, segment.getSCNextExtent());
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, segment.getSCMinExtents());
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, segment.getSCFreeLists());
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    props = true;
                }
                if (props) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableProxyOraclev10g tableProxy, CompareObjectSelection indexObj, boolean prettyPrint) {
        UniqueOraclev10g unique = (UniqueOraclev10g)this.storageDesign.getUniqueSet().getProxy(indexObj.getObject().getObjectID());
        if (unique != null && unique.shouldBeMerge()) {
            StringBuffer columnList = this.getColumnsForRestore(indexObj, prettyPrint, false);
            if (this.isNotEmpty(columnList.toString())) {
                if (unique.isCommentChanged() && !"".equalsIgnoreCase(unique.getComment())) {
                    this.appendComment(oldbuffer, unique);
                } else if (!"".equalsIgnoreCase(unique.getObject().getComment())) {
                    this.appendComment(oldbuffer, unique.getObject());
                }
                StringBuffer buffer = new StringBuffer();
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.getFormattedTableName(this.tableObj, this.storageDesign));
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "ADD");
                if (!unique.getName().startsWith("SYS_")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
                }
                String advancedComment = buffer.toString();
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                this.appendString(buffer, columnList);
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
                if (!"NO".equalsIgnoreCase(unique.getDeferrable())) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(unique.getInitially())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOT");
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                }
                if (!"NO".equalsIgnoreCase(unique.getUsingIndex())) {
                    this.appendUniqueUsingIndex(buffer, unique, tableProxy, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if ("YES".equalsIgnoreCase(unique.getEnable())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                    } else {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    }
                    if ("YES".equalsIgnoreCase(unique.getValidate())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    } else {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                } else {
                    if (!"YES".equalsIgnoreCase(unique.getEnable())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                        if ("YES".equalsIgnoreCase(unique.getValidate())) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(unique.getValidate())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.appendLineFinisher(buffer, prettyPrint);
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
            } else {
                this.appendError(oldbuffer, prettyPrint, "Index " + unique.getLongNameDDL() + " without columns");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer buffer, UniqueOraclev10g unique, TableProxyOracle tableProxy, boolean prettyPrint) {
        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = unique.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(unique.getUsingIndex()) && exIndex != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(unique.getIndex(), true)) {
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(unique.getUsingIndex())) {
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, unique.getCreateIndexStatement());
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL".equalsIgnoreCase(unique.getUsingIndex())) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                    this.getCSSBIndex().appendPartitionList(buffer, unique, tableProxy, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                    this.appendUniqueGlobalIndex(buffer, unique, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                    this.appendGlobalIndexByHashQuantity(buffer, unique, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                    this.appendGlobalIndexByHashList(buffer, unique, prettyPrint);
                }
                if (unique.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)unique.getIndexSegment(), prettyPrint, unique.getTableSpace(), unique.getLogging());
                } else {
                    if (unique.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique.getTableSpace()));
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(unique.getLogging())) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(unique.getLogging())) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (unique.getIndexSort().equalsIgnoreCase("NO")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOSORT");
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (unique.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "SORT");
                    }
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "REVERSE");
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "SORT");
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (unique.getComputeStatistics().equalsIgnoreCase("YES")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
                    CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (this.storageDesign instanceof StorageDesignOraclev11g) {
                    if (unique.getCompress() > 0) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        this.appendStringWithSpace(buffer, unique.getCompress());
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                        CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                }
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "RANGE");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, unique, prettyPrint);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g partList = (IndexGlobalPartitionsListOraclev10g)unique.getUsingIndexGlobalPL();
            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partList.getGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
            this.appendStringWithSpace(buffer, partList.getHashPQuantity());
            if (!"".equals(partList.getHashPTableSpaces())) {
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getHashPTableSpaces()));
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
            if (!"".equals(partList.getIOTOverflowHashPTS())) {
                CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getIOTOverflowHashPTS()));
                CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            CSSBAlterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendHashPartitions(buffer, unique, prettyPrint);
        }
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection indexObj, boolean prettyPrint, boolean getColumnSortOrder) {
        Index index = (Index)indexObj.getObject();
        CompareObjectSelection tableObj = (CompareObjectSelection)((CompareObjectSelection)indexObj.getParent()).getParent();
        StringBuffer columnList = new StringBuffer();
        boolean notFirst = false;
        List sourceColumns = tableObj.getChildObjects(0);
        block0: for (Column indexCol : index.getElementsCollection()) {
            for (CompareObjectSelection tableCol : sourceColumns) {
                ModelIDObject column = tableCol.getObject();
                if (column == null || !column.equals(indexCol)) continue;
                if (tableCol.canBeCreate() && !tableCol.isSelected() || tableCol.canBeDrop() && tableCol.getCorrespondentNode().isSelected()) continue block0;
                if (notFirst) {
                    columnList.append(',');
                    CSSBAlterIndexOraclev10g.appendNewLine(columnList, prettyPrint, 1);
                    columnList.append(' ');
                }
                String formattedColumnName = tableCol.isSelected() ? CSSBAlterIndexOraclev10g.getFormattedSelectedName(tableCol, this.storageDesign) : this.storageDesign.getFormatedName(tableCol.getCorrespondentNode().getObject());
                CSSBAlterIndexOraclev10g.appendStringWithSpace(columnList, formattedColumnName);
                if (getColumnSortOrder) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(columnList, index.getColumnSortOrder(tableCol.getObject()));
                }
                notFirst = true;
                continue block0;
            }
        }
        return columnList;
    }

    private void appendError(StringBuffer oldbuffer, boolean prettyPrint, String errorMsg) {
        CSSBAlterIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: ");
        CSSBAlterIndexOraclev10g.appendString(oldbuffer, errorMsg);
        CSSBAlterIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CDDLFileMaker.incrementErrors();
    }

    protected CSSBIndexOraclev10g getCSSBIndex() {
        if (this.cssbIndex == null) {
            this.cssbIndex = new CSSBIndexOraclev10g();
            this.cssbIndex.setStorageDesign(this.storageDesign);
        }
        return this.cssbIndex;
    }

    CompareObjectSelection getPK_UK_NodeForObject(CompareObjectSelection tableObj, Object obj) {
        List chIndexes = tableObj.getChildObjects(2);
        for (CompareObjectSelection node : chIndexes) {
            if (obj != node.getObject()) continue;
            return node;
        }
        return null;
    }
}

