/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBDropArcConstraint
extends AbstractCSSBOracle {
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection sourceTypeSel = (CompareObjectSelection)object;
        FKArc fkArc = (FKArc)sourceTypeSel.getCorrespondentNode().getObject();
        Design design = fkArc.getDesign();
        RDBMSSite site = fkArc.getSelectedRDBMSSite();
        StorageDesign storageDesign = design.getStorageDesign(site);
        CompareObjectSelection tableObj = sourceTypeSel.getTableNode();
        if (tableObj != null && storageDesign != null && design.getAppView().getSettings().isGenerateFKArcTriggers() && !fkArc.isReverse()) {
            CSSBDropArcConstraint.appendNewLine(oldbuffer, prettyPrint, 0);
            StringBuffer buffer = new StringBuffer();
            CSSBDropArcConstraint.appendStringWithSpace(buffer, "ALTER");
            CSSBDropArcConstraint.appendStringWithSpace(buffer, "TABLE");
            CSSBDropArcConstraint.appendStringWithSpace(buffer, this.getFormattedTableName(tableObj, storageDesign));
            CSSBDropArcConstraint.appendNewLine(buffer, prettyPrint, 1);
            CSSBDropArcConstraint.appendStringWithSpace(buffer, "DROP");
            CSSBDropArcConstraint.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBDropArcConstraint.appendStringWithSpace(buffer, storageDesign.getFormatedName(fkArc));
            String advancedComments = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CSSBDropArcConstraint.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CDDLFileMaker.incrementAlterTable();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof FKArc;
    }
}

