/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.compare.AbstractMerging;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.AttributeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.DesignHandler;
import oracle.dbtools.crest.model.design.compare.cwddesign.MethodComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.StructuredTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.TypeElementComparator;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.Logger;

public class MergingCWDDesigns {
    private static final Logger LOGGER = new Logger(MergingCWDDesigns.class);
    protected Map comparatorsMap;
    protected Map objectsMap = null;
    private List fkeys = new ArrayList();
    double shift = 0.0;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private int maxTablePerRow;
    private boolean notEmpty = false;
    private List newContained = new ArrayList();
    private Map newTables = new HashMap();
    Map dtMap = new TreeMap();
    Map stMap = new TreeMap();
    Map ctMap = new TreeMap();
    List dtList = new ArrayList();
    List ctList = new ArrayList();
    List stList = new ArrayList();
    List types = new ArrayList();
    Map incompleteTypes = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DesignHandler designHandler, Map comparatorsMap, Map objectsMap, ProgressDialog monitor) {
        this.comparatorsMap = comparatorsMap;
        this.objectsMap = objectsMap;
        AbstractMerging.setObjectsMap(objectsMap);
        designHandler.getSourceDesign().setPropagatePKChahges(false);
        try {
            DesignPartView t_mainView;
            DesignPartView s_mainView;
            designHandler.getSourceDesign().loadDesignLevelSettings(false);
            Design.DesignStorageDesc desc = designHandler.getSourceDesign().getDesignStorageDesc(designHandler.getSourceDesign().getObjectID());
            if (desc == null) {
                designHandler.getSourceDesign().addDesignStorageDesc(designHandler.getSourceDesign());
            }
            designHandler.getSourceDesign().copyDesignStorageDescriptors(designHandler.getTargetDesign());
            this.resetAllObjects();
            if (designHandler.getSourceDataTypesDesign() != null) {
                this.resetAllObjects();
                s_mainView = designHandler.getSourceDataTypesDesign().getMainView();
                t_mainView = designHandler.getTargetDataTypesDesign().getMainView();
                DesignPartView.copyDisplayDrawingProperties(s_mainView, t_mainView);
                this.scanForUsedTypes(designHandler, designHandler.getSourceDesign());
                this.createIncompleteTypes(designHandler.getTargetDataTypesDesign());
                this.processDistinctTypes(designHandler.getSourceDataTypesDesign(), designHandler.getTargetDataTypesDesign());
                Rectangle2D rec = designHandler.getTargetDataTypesDesign().getMainView().getWorkSpace().getDiagramBounds();
                if (rec != null) {
                    this.top = (int)rec.getHeight();
                }
                this.processStructuredTypes(designHandler.getSourceDataTypesDesign(), designHandler.getTargetDataTypesDesign());
                this.processCollectionTypes(designHandler.getSourceDataTypesDesign(), designHandler.getTargetDataTypesDesign());
                this.processNotes(designHandler.getSourceDataTypesDesign(), designHandler.getTargetDataTypesDesign());
                if (!this.notEmpty) {
                    MergingCWDDesigns.copyDisplayTopViews(s_mainView, t_mainView, objectsMap);
                }
            }
            monitor.setNote(Messages.getString("MergingCWDDesigns.ProcessingLogicalModel"));
            monitor.setProgress(10);
            if (designHandler.isLogicalIsSelected()) {
                MergingModels.createUsedClassificationypes(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.newContained.clear();
                this.newTables.clear();
                this.resetAllObjects();
                s_mainView = designHandler.getSourceLogicalDesign().getMainView();
                t_mainView = designHandler.getTargetLogicalDesign().getMainView();
                DesignPartView.copyDisplayDrawingProperties(s_mainView, t_mainView);
                this.processModel(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processEntities(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processRelations(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processInheritances(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                MergingCWDDesigns.processArcs(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign(), objectsMap, comparatorsMap);
                this.processEntityViews(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processNotes(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processTypeSubstitutionsL(designHandler.getSourceLogicalDesign());
                this.copyScope(this.newContained);
                this.newContained.clear();
                this.newTables.clear();
                MergingCWDDesigns.copyDisplayTopViews(s_mainView, t_mainView, objectsMap);
                for (DesignPartView sdpv : s_mainView.getSubordinateViews()) {
                    DesignPartView tdpv = this.getCorrespondingSubordinateView(t_mainView, sdpv.getDPVId());
                    if (tdpv != null) continue;
                    tdpv = t_mainView.addSubordinateView();
                    tdpv.setImportedId(sdpv.getDPVId());
                    this.copyPropertiesFromSubViewToSubView(sdpv, tdpv);
                    DesignPartView.copyDisplayDrawingProperties(sdpv, tdpv);
                    MergingCWDDesigns.copyDisplayTopViews(sdpv, tdpv, objectsMap);
                }
                this.processLogSubViews(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
            }
            double step = 10.0;
            int size = designHandler.getSourceRelationalModels().size();
            Iterator it = designHandler.getSourceRelationalModels().iterator();
            while (it.hasNext()) {
                monitor.setNote(Messages.getString("MergingCWDDesigns.ProcessingRelationalModels"));
                monitor.setProgress((int)(step += 40.0 / (double)size));
                String sourceDesID = (String)it.next();
                String targetID = designHandler.getTargetRelationalModelID(sourceDesID);
                RelationalDesign sourceDes = (RelationalDesign)designHandler.getSourceDesign().getRelationalDesigns().getById(sourceDesID);
                RelationalDesign targetDes = (RelationalDesign)designHandler.getTargetDesign().getRelationalDesigns().getById(targetID);
                if (sourceDes == null || targetDes == null) continue;
                this.newContained.clear();
                this.newTables.clear();
                MergingModels.createUsedClassificationypes(sourceDes, targetDes);
                objectsMap.put(sourceDes.getObjectID(), targetDes);
                this.resetAllObjects();
                DesignPartView s_mainView2 = sourceDes.getMainView();
                DesignPartView t_mainView2 = targetDes.getMainView();
                DesignPartView.copyDisplayDrawingProperties(s_mainView2, t_mainView2);
                this.processModel(sourceDes, targetDes);
                this.processSchemaObjects(sourceDes, targetDes);
                this.fkeys.clear();
                sourceDes.getFKIndexAssociationSet().addAllElementsTo(this.fkeys);
                this.processTables(sourceDes, targetDes);
                this.processTableViews(sourceDes, targetDes);
                this.processForeignKeys();
                MergingCWDDesigns.processFKArcs(sourceDes, targetDes, this.objectsMap, this.comparatorsMap);
                this.processNotes(sourceDes, targetDes);
                this.processTypeSubstitutionsR(sourceDes);
                this.copyScope(this.newContained);
                this.newContained.clear();
                this.newTables.clear();
                MergingCWDDesigns.copyDisplayTopViews(s_mainView2, t_mainView2, objectsMap);
                for (DesignPartView sdpv : s_mainView2.getSubordinateViews()) {
                    DesignPartView tdpv = this.getCorrespondingSubordinateView(t_mainView2, sdpv.getDPVId());
                    if (tdpv == null) {
                        tdpv = t_mainView2.addSubordinateView();
                        tdpv.setImportedId(sdpv.getDPVId());
                    }
                    this.copyPropertiesFromSubViewToSubView(sdpv, tdpv);
                    DesignPartView.copyDisplayDrawingProperties(sdpv, tdpv);
                    MergingCWDDesigns.copyDisplayTopViews(sdpv, tdpv, objectsMap);
                }
                this.processRelSubViews(sourceDes, targetDes);
                targetDes.setDirty(true);
            }
            ExtendedMap targetMap = designHandler.getTargetDesign().getExtendedMap();
            this.importMappings(designHandler.getSourceLogicalDesign(), targetMap);
        }
        catch (RuntimeException e) {
            LOGGER.error("MergingCWDDesigns.execute()", e);
        }
        finally {
            designHandler.getSourceDesign().setPropagatePKChahges(true);
            AbstractMerging.setObjectsMap(null);
        }
    }

    private void resetAllObjects() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.notEmpty = false;
        this.count = 0;
    }

    private void processModel(DesignPart sourceDes, DesignPart targetDes) {
        PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceDes.getObjectID() + targetDes.getObjectID());
        if (prop != null) {
            prop.copySelectedProperties();
        }
    }

    private void processSchemaObjects(RelationalDesign sourceDesignPart, RelationalDesign targetDesignPart) {
        if (targetDesignPart.getSchemaObjectSet().size() > 0 && this.count == 0) {
            this.notEmpty = true;
        }
        Iterator it = sourceDesignPart.getSchemaObjectSet().iterator();
        while (it.hasNext()) {
            SchemaObject sourceSchemaObject = (SchemaObject)it.next();
            this.processSchemaObject(targetDesignPart, sourceSchemaObject);
        }
    }

    private void processSchemaObject(RelationalDesign targetDesignPart, SchemaObject sourceSchemaObject) {
        SchemaObject targetSchemaObject = (SchemaObject)this.objectsMap.get(sourceSchemaObject.getObjectID());
        if (targetSchemaObject == null) {
            targetSchemaObject = (SchemaObject)targetDesignPart.getSchemaObjectSet().getByName(sourceSchemaObject.getName());
            if (targetSchemaObject == null) {
                targetSchemaObject = targetDesignPart.createSchemaObject(sourceSchemaObject.getName());
                targetSchemaObject.setNameHasQuotes(sourceSchemaObject.getNameHasQuotes());
            }
            targetSchemaObject.setComment(sourceSchemaObject.getComment());
            targetSchemaObject.setCommentInRDBMS(sourceSchemaObject.getCommentInRDBMS());
            targetSchemaObject.setNotes(sourceSchemaObject.getNotes());
            targetSchemaObject.setORDSDropSchema(sourceSchemaObject.isORDSDropSchema());
            targetSchemaObject.setORDSEnable(sourceSchemaObject.isORDSEnable());
            targetSchemaObject.setORDSAuth(sourceSchemaObject.isORDSAuth());
            targetSchemaObject.setORDSAlias(sourceSchemaObject.getORDSAlias());
            sourceSchemaObject.copyDynamicProperties(targetSchemaObject);
            targetSchemaObject.setImportedId(sourceSchemaObject.getObjectID());
            this.objectsMap.put(sourceSchemaObject.getObjectID(), targetSchemaObject);
        }
    }

    private void processNotes(DesignPart sourceDesignPart, DesignPart targetDesignPart) {
        if (sourceDesignPart.getNoteSet() != null && targetDesignPart.getNoteSet() != null) {
            Iterator it = sourceDesignPart.getNoteSet().iterator();
            while (it.hasNext()) {
                Note sourceNote = (Note)it.next();
                if (!sourceNote.shouldBeMerge()) continue;
                Note targetNote = (Note)this.objectsMap.get(sourceNote.getObjectID());
                if (targetNote == null) {
                    targetNote = targetDesignPart.getNoteSet().createNote(null);
                    targetNote.setImportedId(sourceNote.getObjectID());
                    targetNote.setText(sourceNote.getText());
                    this.objectsMap.put(sourceNote.getObjectID(), targetNote);
                    continue;
                }
                PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceNote.getObjectID() + targetNote.getObjectID());
                if (prop == null) continue;
                prop.copySelectedProperties();
            }
        }
    }

    private void processEntities(LogicalDesign sourceDesignPart, LogicalDesign targetDesignPart) {
        Entity sourceEntity;
        Iterator it = sourceDesignPart.getEntitySet().iterator();
        while (it.hasNext()) {
            sourceEntity = (Entity)it.next();
            if (!sourceEntity.shouldBeMerge()) continue;
            this.createNewEntity(sourceEntity, sourceDesignPart, targetDesignPart);
        }
        it = sourceDesignPart.getEntitySet().iterator();
        while (it.hasNext()) {
            sourceEntity = (Entity)it.next();
            if (!sourceEntity.shouldBeMerge()) continue;
            this.processEntity(sourceEntity, sourceDesignPart, targetDesignPart);
            this.processAttributes(sourceEntity);
            if (sourceEntity.getBasedOnStructuredType() != null) {
                this.processST_Columns(sourceEntity);
            }
            this.processKeys(sourceEntity);
        }
        this.processAttributeProps(sourceDesignPart, targetDesignPart);
    }

    private void processAttributeProps(LogicalDesign sourceDesignPart, LogicalDesign targetDesignPart) {
        Iterator it = sourceDesignPart.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity sourceEntity = (Entity)it.next();
            if (!sourceEntity.shouldBeMerge()) continue;
            ContainedObject[] elems = sourceEntity.getElements();
            for (int i = 0; i < elems.length; ++i) {
                Attribute refTarget;
                Attribute attr = (Attribute)elems[i];
                String refID = attr.getReferedAttribute();
                if (refID == null) continue;
                Attribute target = (Attribute)this.objectsMap.get(attr.getObjectID());
                if (target == null) {
                    target = (Attribute)targetDesignPart.getDesign().getDesignObject(attr.getObjectID());
                }
                if (target == null || (refTarget = (Attribute)this.objectsMap.get(refID)) == null) continue;
                target.setReferedAttribute(refTarget.getObjectID());
            }
        }
    }

    public DesignPartView getCorrespondingSubordinateView(DesignPartView masterDPV, String id) {
        for (DesignPartView dpv : masterDPV.getSubordinateViews()) {
            if (!id.equals(dpv.getDPVId()) && !id.equals(dpv.getImportedId())) continue;
            return dpv;
        }
        return null;
    }

    private void moveGraphical(LogicalDesign logical, LogicalDesign newLogical, DesignObject newEntity, DesignObject entity) {
        float square = (float)Math.sqrt(logical.getEntitySet().size());
        this.maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        Rectangle2D rec = newLogical.getMainView().getWorkSpace().getDiagramBounds();
        TopView topView = newEntity.getTopView();
        if (topView.getCellView() != null) {
            Dimension dim = entity.getTopView().getSize();
            if (this.count == 0) {
                this.top = (int)((double)((int)rec.getHeight()) + dim.getHeight());
                this.left = 20;
            }
            ++this.count;
            this.width = (int)dim.getWidth();
            this.height = (int)Math.max(dim.getHeight(), (double)this.height);
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), entity.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    private void processEntity(Entity sourceEntity, LogicalDesign sourceDesignPart, LogicalDesign targetDesignPart) {
        Entity targetEntity = (Entity)this.objectsMap.get(sourceEntity.getObjectID());
        if (targetEntity == null) {
            if (targetDesignPart.getEntitySet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            targetEntity = targetDesignPart.createEntity(sourceEntity.getName());
            targetEntity.setImportedId(sourceEntity.getObjectID());
            this.objectsMap.put(sourceEntity.getObjectID(), targetEntity);
            this.copyPropertiesFromEntityToEntity(sourceEntity, targetEntity, targetDesignPart);
            if (this.notEmpty) {
                this.moveGraphical(sourceDesignPart, targetDesignPart, (DesignObject)targetEntity, (DesignObject)sourceEntity);
            } else {
                ++this.count;
                this.setObjectBounds(sourceEntity, targetEntity);
            }
        } else if (this.newTables.containsKey(targetEntity)) {
            if (this.notEmpty) {
                this.moveGraphical(sourceDesignPart, targetDesignPart, (DesignObject)targetEntity, (DesignObject)sourceEntity);
            } else {
                ++this.count;
                this.setObjectBounds(sourceEntity, targetEntity);
            }
        } else {
            PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceEntity.getObjectID() + targetEntity.getObjectID());
            if (prop != null) {
                prop.copySelectedProperties();
            }
        }
    }

    private void createNewEntity(Entity sourceEntity, LogicalDesign sourceDesignPart, LogicalDesign targetDesignPart) {
        Entity targetEntity = (Entity)this.objectsMap.get(sourceEntity.getObjectID());
        if (targetEntity == null) {
            if (targetDesignPart.getEntitySet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            targetEntity = targetDesignPart.createEntity(sourceEntity.getName());
            targetEntity.setImportedId(sourceEntity.getObjectID());
            this.objectsMap.put(sourceEntity.getObjectID(), targetEntity);
            this.copyPropertiesFromEntityToEntity(sourceEntity, targetEntity, targetDesignPart);
            this.newTables.put(targetEntity, targetEntity);
        }
    }

    public static void processArcs(LogicalDesign sourceDesignPart, LogicalDesign targetDesignPart, Map objectsMap, Map comparatorsMap) {
        Iterator it = sourceDesignPart.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity sourceTable = (Entity)it.next();
            Object[] arcs = sourceTable.getArcs().toArray();
            for (int i = 0; i < arcs.length; ++i) {
                Arc sarc = (Arc)arcs[i];
                Arc tarc = (Arc)objectsMap.get(sarc.getObjectID());
                if (!sarc.shouldBeMerge()) continue;
                if (tarc == null) {
                    tarc = MergingCWDDesigns.processArc(sarc, objectsMap);
                    if (tarc == null) continue;
                    tarc.setImportedId(sarc.getObjectID());
                    continue;
                }
                PropertiesComparator comp = (PropertiesComparator)comparatorsMap.get(sarc.getObjectID() + tarc.getObjectID());
                if (comp == null) continue;
                comp.copySelectedProperties();
            }
        }
    }

    public static Arc processArc(Arc arc, Map objectsMap) {
        Entity sourceTable = arc.getEntity();
        Entity targetTable = (Entity)objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            Arc tarc = ((LogicalDesign)targetTable.getDesignPart()).createArc();
            tarc.setEntity(targetTable);
            arc.copy(tarc, objectsMap, false);
            if (tarc.getRelations().size() > 1) {
                targetTable.addArc(tarc);
                objectsMap.put(arc.getObjectID(), tarc);
                return tarc;
            }
            tarc.remove();
        }
        return null;
    }

    private void processTables(RelationalDesign sourceDesignPart, RelationalDesign targetDesignPart) {
        Table sourceTable;
        Iterator it = sourceDesignPart.getTableSet().iterator();
        while (it.hasNext()) {
            sourceTable = (Table)it.next();
            if (!sourceTable.shouldBeMerge()) continue;
            this.createNewTable(sourceTable, sourceDesignPart, targetDesignPart);
        }
        it = sourceDesignPart.getTableSet().iterator();
        while (it.hasNext()) {
            Table targetTable;
            sourceTable = (Table)it.next();
            if (sourceTable.shouldBeMerge()) {
                targetTable = this.processTable(sourceTable, sourceDesignPart, targetDesignPart);
                MergingCWDDesigns.copySourceStamp(sourceTable, targetTable);
                this.processColumns(sourceTable, targetTable);
                if (sourceTable.getBasedOnStructuredType() != null) {
                    this.processST_Columns(sourceTable);
                }
                this.processIndexes(sourceTable);
                this.processConstraints(sourceTable);
                this.processTimeDimensions(sourceTable);
                targetTable.setSpatialTable(sourceTable.isSpatialTable());
                targetTable.getSpatialDefinitions().clear();
                for (SpatialColumnDefObject spCol : sourceTable.getSpatialDefinitions()) {
                    SpatialColumnDefObject t_spCol = new SpatialColumnDefObject(targetTable);
                    spCol.copyTo(t_spCol, this.objectsMap);
                    targetTable.addSpatialDefinition(t_spCol);
                }
                targetTable.setBeforeDrop(sourceTable.getBeforeDrop());
                targetTable.setBeforeCreate(sourceTable.getBeforeCreate());
                targetTable.setAfterCreate(sourceTable.getAfterCreate());
                targetTable.setEndOfScript(sourceTable.getEndOfScript());
                targetTable.setShouldGenerateScript(sourceTable.getShouldGenerateScript());
                targetTable.getColumnGroupsSet().clear();
                for (Table.ColumnGroup cgOld : sourceTable.getColumnGroupsSet()) {
                    Table.ColumnGroup cgNew = targetTable.createColumnGroup(cgOld.getName(), null);
                    targetTable.getColumnGroupsSet().add(cgNew);
                    cgOld.copy(cgNew, this.objectsMap);
                }
                targetTable.setOidIsPK(sourceTable.isOidIsPK());
                targetTable.setRedactionPolicyName(sourceTable.getRedactionPolicyName());
                targetTable.setRedactionPolicyDefaultExpression(sourceTable.getRedactionPolicyDefaultExpression());
                targetTable.setRedactionPolicyEnabled(sourceTable.isRedactionPolicyEnabled());
                targetTable.setRedactionPolicyGenerateInDDL(sourceTable.isRedactionPolicyGenerateInDDL());
                targetTable.setExistDependencyConstraintName(sourceTable.getExistDependencyConstraintName());
                targetTable.setExistDependencyGenerateInDDl(sourceTable.isExistDependencyGenerateInDDl());
                targetTable.setExistDependencyGenerationLevel(sourceTable.getExistDependencyGenerationLevel());
                targetTable.setShouldMerge(true);
                continue;
            }
            targetTable = (Table)this.objectsMap.get(sourceTable.getObjectID());
            if (targetTable == null) continue;
            targetTable.setShouldMerge(false);
        }
    }

    private void processST_Columns(ContainerObject sourceTable) {
        ContainerObject targetTable = (ContainerObject)this.objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            for (ContainedObject column : sourceTable.getElementsCollectionImmutable()) {
                String te_id = column.getStructAttributeID();
                if (te_id == null) continue;
                ModelIDObject obj = (ModelIDObject)this.objectsMap.get(te_id);
                String id = te_id;
                if (obj != null) {
                    id = obj.getObjectID();
                }
                if (id == null) continue;
                ContainedObject targetCol = targetTable.getElementByStructAttributeID(te_id);
                if (targetCol == null) {
                    targetCol = targetTable.getElementByStructAttributeID(id);
                } else {
                    targetCol.setStructAttributeID(id);
                }
                if (targetCol == null) continue;
                this.objectsMap.put(column.getObjectID(), targetCol);
            }
        }
    }

    private void processIndexes(Table sourceTable) {
        Table targetTable = (Table)this.objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            KeyObject[] sourceKeys = sourceTable.getKeys();
            for (int i = 0; i < sourceKeys.length; ++i) {
                KeyObject sourceKey = sourceKeys[i];
                if (sourceKey.isFK() || !sourceKey.shouldBeMerge()) continue;
                Index index = (Index)this.objectsMap.get(sourceKey.getObjectID());
                if (index == null) {
                    SchemaObject tsho;
                    index = targetTable.createIndex();
                    index.setImportedId(sourceKey.getObjectID());
                    SchemaObject sho = sourceKey.getSchemaObject();
                    if (sho != null && (tsho = (SchemaObject)this.objectsMap.get(sho.getObjectID())) != null) {
                        index.setSchemaObject(tsho);
                    }
                    this.objectsMap.put(sourceKey.getObjectID(), index);
                    this.copyPropertiesFromIndexToIndex((Index)sourceKey, index);
                    index.setName(sourceKey.getName());
                    MergingCWDDesigns.copySourceStamp(sourceKey, index);
                    continue;
                }
                PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceKey.getObjectID() + index.getObjectID());
                if (comp == null) continue;
                comp.copySelectedProperties();
            }
        }
    }

    private void processKeys(Entity sourceEntity) {
        Entity targetEntity = (Entity)this.objectsMap.get(sourceEntity.getObjectID());
        if (targetEntity != null) {
            KeyObject[] sourceKeys = sourceEntity.getKeys();
            for (int i = 0; i < sourceKeys.length; ++i) {
                KeyObject sourceKey = sourceKeys[i];
                if (sourceKey.isFK() || !sourceKey.shouldBeMerge()) continue;
                CandidateKey key = (CandidateKey)this.objectsMap.get(sourceKey.getObjectID());
                if (key == null) {
                    key = targetEntity.createCandidateKey();
                    key.setImportedId(sourceKey.getObjectID());
                    key.setName(sourceKey.getName());
                    this.objectsMap.put(sourceKey.getObjectID(), key);
                    this.copyPropertiesFromKeyToKey((CandidateKey)sourceKey, key);
                    continue;
                }
                PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceKey.getObjectID() + key.getObjectID());
                if (comp == null) continue;
                comp.copySelectedProperties();
            }
        }
    }

    private void copyPropertiesFromKeyToKey(CandidateKey sourceKey, CandidateKey targetKey) {
        DesignObject dobj;
        if (sourceKey.getGeneratorID() != null && !"User generated".equals(sourceKey.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceKey.getGeneratorID())) != null && dobj instanceof Index) {
            targetKey.setGeneratorID(dobj.getObjectID());
        }
        targetKey.setComment(targetKey.getComment());
        targetKey.setNotes(targetKey.getNotes());
        sourceKey.copyDynamicProperties(targetKey);
        ContainedObject[] sourceAttributes = sourceKey.getElements();
        for (int j = 0; j < sourceAttributes.length; ++j) {
            ContainedObject sourceAttribute = sourceAttributes[j];
            Attribute targetAttribute = (Attribute)this.objectsMap.get(sourceAttribute.getObjectID());
            if (targetAttribute == null || targetAttribute.getContainer() != targetKey.getContainerObject()) continue;
            targetKey.add(targetAttribute);
        }
        if (sourceKey.isPK()) {
            targetKey.makePK();
        }
    }

    private void copyPropertiesFromIndexToIndex(Index sourceIndex, Index targetIndex) {
        DesignObject dobj;
        if (sourceIndex.getGeneratorID() != null && !"User generated".equals(sourceIndex.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceIndex.getGeneratorID())) != null && dobj instanceof CandidateKey) {
            targetIndex.setGeneratorID(dobj.getObjectID());
        }
        targetIndex.setNameHasQuotes(sourceIndex.getNameHasQuotes());
        targetIndex.setCommentInRDBMS(sourceIndex.getCommentInRDBMS());
        targetIndex.setComment(sourceIndex.getComment());
        targetIndex.setNotes(sourceIndex.getNotes());
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        for (int j = 0; j < sourceColumns.length; ++j) {
            ContainedObject sourceColumn = sourceColumns[j];
            Column targetColumn = (Column)this.objectsMap.get(sourceColumn.getObjectID());
            if (targetColumn == null || targetColumn.getContainer() != targetIndex.getContainerObject()) continue;
            String sorder = sourceIndex.getColumnSortOrder(sourceColumn);
            targetIndex.add(targetColumn);
            targetIndex.setColumnSortOrder(targetColumn, sorder);
        }
        targetIndex.setIndexState(sourceIndex.getIndexState());
        targetIndex.setIndexExpression(sourceIndex.getIndexExpression());
        targetIndex.setSpatialIndex(sourceIndex.isSpatialIndex());
        targetIndex.setLayerType(sourceIndex.getLayerType());
        targetIndex.setDimensionsNumber(sourceIndex.getDimensionsNumber());
        targetIndex.setGeodetic(sourceIndex.getGeodetic());
        sourceIndex.copyAllRemoteObjectIDsAndPath(targetIndex);
        sourceIndex.copyDynamicProperties(targetIndex);
    }

    private void processColumns(Table sourceTable, Table targetTable) {
        ContainedObject[] sourceColumns = sourceTable.getElements();
        for (int i = 0; i < sourceColumns.length; ++i) {
            ColumnComparator comp;
            Column sourceColumn = (Column)sourceColumns[i];
            if (!sourceColumn.shouldBeMerge()) continue;
            Column targetColumn = (Column)this.objectsMap.get(sourceColumn.getObjectID());
            if (targetColumn == null && targetTable != null) {
                targetColumn = targetTable.createColumn(sourceColumn.getName());
                targetColumn.setImportedId(sourceColumn.getObjectID());
                targetColumn.moveToIndex(sourceColumn.getIndex());
                this.objectsMap.put(sourceColumn.getObjectID(), targetColumn);
                MergingModels.copyPropertiesFromColumnToColumn(sourceColumn, targetColumn, this.objectsMap);
                targetColumn.setStructAttributeID(sourceColumn.getStructAttributeID());
                MergingCWDDesigns.copySourceStamp(sourceColumn, targetColumn);
                this.newContained.add(sourceColumn);
                continue;
            }
            if (targetColumn == null || (comp = (ColumnComparator)this.comparatorsMap.get(sourceColumn.getObjectID() + targetColumn.getObjectID())) == null) continue;
            comp.copySelectedProperties();
            targetColumn.moveToIndex(sourceColumn.getIndex());
        }
        for (Column sourceNestedCol : sourceTable.getNestedElements()) {
            Column targetNestedCol = (Column)this.getCorrespondingNestedColumn(targetTable, sourceNestedCol);
            if (targetNestedCol == null) continue;
            this.objectsMap.put(sourceNestedCol.getObjectID(), targetNestedCol);
            boolean shouldMerge = sourceNestedCol.getParentObject().shouldBeMerge();
            sourceNestedCol.setShouldMerge(shouldMerge);
            if (!shouldMerge) continue;
            MergingModels.copyPropertiesFromColumnToColumn(sourceNestedCol, targetNestedCol, this.objectsMap);
        }
        for (int i = 0; i < sourceColumns.length; ++i) {
            Column targetColumn;
            Column sourceColumn = (Column)sourceColumns[i];
            if (!sourceColumn.shouldBeMerge() || (targetColumn = (Column)this.objectsMap.get(sourceColumn.getObjectID())) == null || targetTable == null) continue;
            sourceColumn.copyDepenDendentColumnDescriptors(targetColumn, true, this.objectsMap);
        }
    }

    private ContainedObject getCorrespondingNestedColumn(ContainerObject targetTable, ContainedObject sourceColumn) {
        TypeElement targetStructAtt;
        ContainedObject targetParentColumn;
        ContainedObject sourceParentColumn = sourceColumn.getParentObject();
        if (sourceParentColumn != null && (targetParentColumn = (ContainedObject)this.objectsMap.get(sourceParentColumn.getObjectID())) != null && (targetStructAtt = (TypeElement)this.objectsMap.get(sourceColumn.getStructAttributeID())) != null) {
            String targetStructAttID = targetStructAtt.getObjectID();
            String targetParentColumnID = targetParentColumn.getObjectID();
            for (ContainedObject targetCol : targetTable.getNestedElements()) {
                ContainedObject parentCol;
                if (!targetCol.getStructAttributeID().equals(targetStructAttID) || (parentCol = targetCol.getParentObject()) == null || !parentCol.getObjectID().equals(targetParentColumnID)) continue;
                return targetCol;
            }
        }
        return null;
    }

    private void processConstraints(Table sourceTable) {
        Table targetTable = (Table)this.objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            for (TableLevelConstraint sourceConstraint : sourceTable.getCheckConstraints()) {
                if (!sourceConstraint.shouldBeMerge()) continue;
                TableLevelConstraint targetConstraint = (TableLevelConstraint)this.objectsMap.get(sourceConstraint.getObjectID());
                if (targetConstraint == null) {
                    targetConstraint = targetTable.createCheckConstraint(sourceConstraint.getName(), sourceConstraint.getRule());
                    targetConstraint.setNameHasQuotes(sourceConstraint.getNameHasQuotes());
                    targetConstraint.setGenerateInDDL(sourceConstraint.getGenerateInDDL());
                    targetConstraint.setImportedId(sourceConstraint.getObjectID());
                    targetTable.addCheckConstraint(targetConstraint);
                    this.objectsMap.put(sourceConstraint.getObjectID(), targetConstraint);
                    MergingCWDDesigns.copySourceStamp(sourceConstraint, targetConstraint);
                    continue;
                }
                PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceConstraint.getObjectID() + targetConstraint.getObjectID());
                if (comp == null) continue;
                comp.copySelectedProperties();
            }
        }
    }

    private void processTimeDimensions(Table sourceTable) {
        Table targetTable = (Table)this.objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            for (ValidTimeDimension sourceTimeDim : sourceTable.getValidTimeDimensions()) {
                ValidTimeDimension targetTimeDim = (ValidTimeDimension)this.objectsMap.get(sourceTimeDim.getObjectID());
                if (sourceTimeDim.shouldBeMerge()) {
                    if (targetTimeDim == null) {
                        Column sourceEndColumn;
                        targetTimeDim = targetTable.createValidTimeDimension();
                        targetTimeDim.setName(sourceTimeDim.getName());
                        targetTimeDim.setNameHasQuotes(sourceTimeDim.getNameHasQuotes());
                        Column sourceStartColumn = sourceTimeDim.getStartTimeColumn();
                        if (sourceStartColumn != null) {
                            Column targetStartColumn = (Column)this.objectsMap.get(sourceStartColumn.getObjectID());
                            targetTimeDim.setStartTimeColumn(targetStartColumn);
                        }
                        if ((sourceEndColumn = sourceTimeDim.getEndTimeColumn()) != null) {
                            Column targetEndColumn = (Column)this.objectsMap.get(sourceEndColumn.getObjectID());
                            targetTimeDim.setEndTimeColumn(targetEndColumn);
                        }
                        targetTimeDim.setImportedId(sourceTimeDim.getObjectID());
                        this.objectsMap.put(sourceTimeDim.getObjectID(), targetTimeDim);
                        MergingCWDDesigns.copySourceStamp(sourceTimeDim, targetTimeDim);
                    } else {
                        PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceTimeDim.getObjectID() + targetTimeDim.getObjectID());
                        if (comp != null) {
                            comp.copySelectedProperties();
                        }
                    }
                    targetTimeDim.setShouldMerge(true);
                    continue;
                }
                if (targetTimeDim == null) continue;
                targetTimeDim.setShouldMerge(false);
            }
        }
    }

    private void processAttributes(Entity sourceEntity) {
        Entity targetEntity = (Entity)this.objectsMap.get(sourceEntity.getObjectID());
        ContainedObject[] sourceAttributes = sourceEntity.getElements();
        for (int i = 0; i < sourceAttributes.length; ++i) {
            Attribute targetAttribute;
            Attribute sourceAttribute = (Attribute)sourceAttributes[i];
            if (sourceAttribute.shouldBeMerge()) {
                AttributeComparator comp;
                targetAttribute = (Attribute)this.objectsMap.get(sourceAttribute.getObjectID());
                if (targetAttribute == null && targetEntity != null) {
                    targetAttribute = targetEntity.createAttribute(sourceAttribute.getName());
                    targetAttribute.setImportedId(sourceAttribute.getObjectID());
                    targetAttribute.moveToIndex(sourceAttribute.getIndex());
                    this.objectsMap.put(sourceAttribute.getObjectID(), targetAttribute);
                    this.copyPropertiesFromAttributeToAttribute(sourceAttribute, targetAttribute);
                    if (sourceAttribute.getScope() == null) continue;
                    this.newContained.add(sourceAttribute);
                    continue;
                }
                if (targetAttribute == null || (comp = (AttributeComparator)this.comparatorsMap.get(sourceAttribute.getObjectID() + targetAttribute.getObjectID())) == null) continue;
                comp.copySelectedProperties();
                targetAttribute.moveToIndex(sourceAttribute.getIndex());
                continue;
            }
            if (!sourceEntity.shouldBeMerge() || (targetAttribute = (Attribute)this.objectsMap.get(sourceAttribute.getObjectID())) == null) continue;
            targetAttribute.moveToIndex(sourceAttribute.getIndex());
        }
        for (Attribute sourceNestedAtt : sourceEntity.getNestedElements()) {
            Attribute targetNestedAtt = (Attribute)this.getCorrespondingNestedColumn(targetEntity, sourceNestedAtt);
            if (targetNestedAtt == null) continue;
            this.objectsMap.put(sourceNestedAtt.getObjectID(), targetNestedAtt);
            boolean shouldMerge = sourceNestedAtt.getParentObject().shouldBeMerge();
            sourceNestedAtt.setShouldMerge(shouldMerge);
            if (!shouldMerge) continue;
            this.copyPropertiesFromAttributeToAttribute(sourceNestedAtt, targetNestedAtt);
        }
    }

    private void copyPropertiesFromAttributeToAttribute(Attribute sourceAttribute, Attribute targetAttribute) {
        DesignObject dobj;
        targetAttribute.setTemporaryWriteable(true);
        if (sourceAttribute.getGeneratorID() != null && !"User generated".equals(sourceAttribute.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceAttribute.getGeneratorID())) != null && (dobj instanceof Column || dobj instanceof Relation)) {
            targetAttribute.setGeneratorID(dobj.getObjectID());
        }
        targetAttribute.setStructAttributeID(sourceAttribute.getStructAttributeID());
        MergingCWDDesigns.copyPropertiesFromAttributeToAttribute(sourceAttribute, targetAttribute, this.objectsMap);
        targetAttribute.setTemporaryWriteable(false);
    }

    public static void copyPropertiesFromAttributeToAttribute(Attribute sourceAttribute, Attribute targetAttribute, Map objectsMap) {
        MergingModels.copyPropertiesFromCOWD_To_COWD(sourceAttribute, targetAttribute, objectsMap);
        targetAttribute.setSource(sourceAttribute.getSource());
        targetAttribute.setSynonym(sourceAttribute.getSynonym());
        targetAttribute.setPreferredAbbreviation(sourceAttribute.getPreferredAbbreviation());
        targetAttribute.setImportedId(sourceAttribute.getObjectID());
    }

    private Table processTable(Table sourceTable, RelationalDesign sourceDesignPart, RelationalDesign targetDesignPart) {
        Table targetTable = (Table)this.objectsMap.get(sourceTable.getObjectID());
        if (targetTable == null) {
            SchemaObject tsho;
            if (targetDesignPart.getTableSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            targetTable = targetDesignPart.createTable();
            targetTable.setImportedId(sourceTable.getObjectID());
            SchemaObject sho = sourceTable.getSchemaObject();
            if (sho != null && (tsho = (SchemaObject)this.objectsMap.get(sho.getObjectID())) != null) {
                targetTable.setSchemaObject(tsho);
            }
            targetTable.setName(sourceTable.getName());
            this.objectsMap.put(sourceTable.getObjectID(), targetTable);
            this.copyPropertiesFromTableToTable(sourceTable, targetTable);
            if (this.notEmpty) {
                this.moveGraphical(sourceDesignPart, targetDesignPart, (DesignObject)targetTable, (DesignObject)sourceTable);
            } else {
                ++this.count;
                this.setObjectBounds(sourceTable, targetTable);
            }
        } else if (this.newTables.containsKey(targetTable)) {
            if (this.notEmpty) {
                this.moveGraphical(sourceDesignPart, targetDesignPart, (DesignObject)targetTable, (DesignObject)sourceTable);
            } else {
                ++this.count;
                this.setObjectBounds(sourceTable, targetTable);
            }
        } else {
            PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceTable.getObjectID() + targetTable.getObjectID());
            if (prop != null) {
                prop.copySelectedProperties();
            }
        }
        return targetTable;
    }

    private void createNewTable(Table sourceTable, RelationalDesign sourceDesignPart, RelationalDesign targetDesignPart) {
        Table targetTable = (Table)this.objectsMap.get(sourceTable.getObjectID());
        if (targetTable == null) {
            SchemaObject tsho;
            if (targetDesignPart.getTableSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            targetTable = targetDesignPart.createTable();
            targetTable.setImportedId(sourceTable.getObjectID());
            SchemaObject sho = sourceTable.getSchemaObject();
            if (sho != null && (tsho = (SchemaObject)this.objectsMap.get(sho.getObjectID())) != null) {
                targetTable.setSchemaObject(tsho);
            }
            targetTable.setName(sourceTable.getName());
            this.objectsMap.put(sourceTable.getObjectID(), targetTable);
            this.newTables.put(targetTable, targetTable);
            this.copyPropertiesFromTableToTable(sourceTable, targetTable);
        }
    }

    private void setObjectBounds(DesignObject sourceTable, DesignObject targetTable) {
        if (targetTable.getTopView().getCellView() != null && sourceTable.getTopView().getBounds() != null) {
            targetTable.getTopView().getCellView().setNewBounds(sourceTable.getTopView().getBounds());
        }
    }

    private void moveGraphical(RelationalDesign physical, RelationalDesign newPhysical, DesignObject newTable, DesignObject table) {
        float square = (float)Math.sqrt(physical.getTableSet().size());
        this.maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        Rectangle2D rec = newPhysical.getMainView().getWorkSpace().getDiagramBounds();
        TopView topView = newTable.getTopView();
        if (topView.getCellView() != null) {
            Dimension dim = table.getTopView().getSize();
            if (this.count == 0) {
                this.top = (int)((double)((int)rec.getHeight()) + dim.getHeight());
                this.left = 20;
            }
            ++this.count;
            this.width = (int)dim.getWidth();
            this.height = (int)Math.max(dim.getHeight(), (double)this.height);
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), table.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPropertiesFromTableToTable(Table sourceTable, Table targetTable) {
        DesignObject dobj;
        if (sourceTable.getGeneratorID() != null && !"User generated".equals(sourceTable.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceTable.getGeneratorID())) != null && dobj instanceof Entity) {
            targetTable.setGeneratorID(dobj.getObjectID());
        }
        targetTable.setNameHasQuotes(sourceTable.getNameHasQuotes());
        targetTable.setMinVolumes(sourceTable.getMinVolumes());
        targetTable.setExpectedVolumes(sourceTable.getExpectedVolumes());
        targetTable.setMaxVolumes(sourceTable.getMaxVolumes());
        targetTable.setGrowthPercent(sourceTable.getGrowthPercent());
        targetTable.setGrowthType(sourceTable.getGrowthType());
        targetTable.setNormalForm(sourceTable.getNormalForm());
        targetTable.setAdequatelyNormalized(sourceTable.getAdequatelyNormalized());
        targetTable.setTypeID(sourceTable.getTypeID());
        targetTable.getAdditionalClassificationTypes().clear();
        targetTable.getAdditionalClassificationTypes().addAll(sourceTable.getAdditionalClassificationTypes());
        targetTable.setScope(sourceTable.getScope());
        StructuredType st = sourceTable.getBasedOnStructuredType();
        if (st != null) {
            StructuredType targ_st = (StructuredType)CompareModelToModel.getCorrespondingObject(targetTable.getDesign().getDataTypesDesign().getStructuredTypeSet(), st);
            if (targ_st != null) {
                ApplicationView.loading = true;
                try {
                    targetTable.setBasedOnStructuredType(targ_st);
                }
                finally {
                    ApplicationView.loading = false;
                }
            }
        } else {
            targetTable.setBasedOnStructuredType(null);
        }
        targetTable.setAllowTypeSubstitution(sourceTable.isAllowTypeSubstitution());
        targetTable.setComment(sourceTable.getComment());
        targetTable.setCommentInRDBMS(sourceTable.getCommentInRDBMS());
        targetTable.setNotes(sourceTable.getNotes());
        targetTable.setAbbreviation(sourceTable.getAbbreviation());
        sourceTable.copyAllRemoteObjectIDsAndPath(targetTable);
        targetTable.setEngineerToRelation(sourceTable.isEngineerToRelation());
        targetTable.setAllowColumnReorder(sourceTable.isAllowColumnReorder());
        targetTable.setShouldEngineer(sourceTable.getShouldEngineer());
        targetTable.setDeprecated(sourceTable.isDeprecated());
        targetTable.setUseDDLTransformationScript(sourceTable.isUseDDLTransformationScript());
        targetTable.setOnPrebuiltTable(sourceTable.isOnPrebuiltTable());
        targetTable.setMaterializedQueryTable(sourceTable.isMaterializedQueryTable());
        targetTable.setUserDefinedSQL(sourceTable.getUserDefinedSQL());
        targetTable.setIncludeSchemaNameInQuery(sourceTable.includeSchemaNameInQuery());
        targetTable.setSyntaxProvider(sourceTable.getSyntaxProvider());
        targetTable.setIncorrectSQL(sourceTable.isIncorrectSQL());
        targetTable.setORDSEnable(sourceTable.isORDSEnable());
        targetTable.setORDSAuth(sourceTable.isORDSAuth());
        targetTable.setORDSAlias(sourceTable.getORDSAlias());
        sourceTable.copyDynamicProperties(targetTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPropertiesFromEntityToEntity(Entity sourceEntity, Entity targetEntity, LogicalDesign targetDesignPart) {
        Attribute tattr;
        DesignObject dobj;
        if (sourceEntity.getGeneratorID() != null && !"User generated".equals(sourceEntity.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceEntity.getGeneratorID())) != null && dobj instanceof Table) {
            targetEntity.setGeneratorID(dobj.getObjectID());
        }
        targetEntity.setOwner(sourceEntity.getOwner());
        targetEntity.setFwdEngineeringStrategyName(sourceEntity.getFwdEngineeringStrategyName());
        targetEntity.setSource(sourceEntity.getSource());
        targetEntity.setTypeID(sourceEntity.getTypeID());
        targetEntity.getAdditionalClassificationTypes().clear();
        targetEntity.getAdditionalClassificationTypes().addAll(sourceEntity.getAdditionalClassificationTypes());
        targetEntity.setScope(sourceEntity.getScope());
        StructuredType st = sourceEntity.getBasedOnStructuredType();
        if (st != null) {
            StructuredType targ_st = (StructuredType)CompareModelToModel.getCorrespondingObject(targetEntity.getDesign().getDataTypesDesign().getStructuredTypeSet(), st);
            if (targ_st != null) {
                ApplicationView.loading = true;
                try {
                    targetEntity.setBasedOnStructuredType(targ_st);
                }
                finally {
                    ApplicationView.loading = false;
                }
            }
        } else {
            targetEntity.setBasedOnStructuredType(null);
        }
        targetEntity.setAllowTypeSubstitution(sourceEntity.isAllowTypeSubstitution());
        targetEntity.setMinVolumes(sourceEntity.getMinVolumes());
        targetEntity.setExpectedVolumes(sourceEntity.getExpectedVolumes());
        targetEntity.setMaxVolumes(sourceEntity.getMaxVolumes());
        targetEntity.setGrowthPercent(sourceEntity.getGrowthPercent());
        targetEntity.setGrowthType(sourceEntity.getGrowthType());
        targetEntity.setNormalForm(sourceEntity.getNormalForm());
        targetEntity.setAdequatelyNormalized(sourceEntity.getAdequatelyNormalized());
        targetEntity.setComment(sourceEntity.getComment());
        targetEntity.setCommentInRDBMS(sourceEntity.getCommentInRDBMS());
        targetEntity.setNotes(sourceEntity.getNotes());
        targetEntity.setSynonym(sourceEntity.getSynonym());
        targetEntity.setSynonymToDisplay(sourceEntity.getSynonymToDisplay());
        targetEntity.setPreferredAbbreviation(sourceEntity.getPreferredAbbreviation());
        targetEntity.setImportedId(sourceEntity.getObjectID());
        targetEntity.setShortName(sourceEntity.getShortName());
        targetEntity.setDeprecated(sourceEntity.isDeprecated());
        targetEntity.setSubtypesRefType(sourceEntity.getSubtypesRefType());
        targetEntity.setCreateSurrogateKey(sourceEntity.isCreateSurrogateKey());
        targetEntity.setAttributeInherType(sourceEntity.getAttributeInherType());
        targetEntity.setGenerateDiscriminatorColumn(sourceEntity.isGenerateDiscriminatorColumn());
        sourceEntity.copyDynamicProperties(targetEntity);
        Attribute attr = sourceEntity.getDiscriminatorAttribute();
        if (attr != null && (tattr = (Attribute)this.objectsMap.get(attr.getObjectID())) != null) {
            targetEntity.setDiscriminatorAttribute(tattr);
        }
        targetEntity.setDiscriminatorColumnName(sourceEntity.getDiscriminatorColumnName());
        targetEntity.setDiscriminatorValue(sourceEntity.getDiscriminatorValue());
        targetEntity.setCompleteSubtypes(sourceEntity.isCompleteSubtypes());
    }

    public static Relation copyRelationShiptoNew(Relation sourceRelation, LogicalDesign targetDesignPart, Map objectsMap) {
        Relation targetRelation = null;
        if (targetRelation == null) {
            Entity sourceEntity = (Entity)objectsMap.get(sourceRelation.getSourceEntity().getObjectID());
            Entity targetEntity = (Entity)objectsMap.get(sourceRelation.getTargetEntity().getObjectID());
            if (sourceEntity != null && targetEntity != null) {
                CandidateKey tkey;
                CandidateKey key;
                DesignObject dobj;
                Entity ent;
                Attribute refAttr;
                Attribute refOldAttr;
                String oldId;
                Attribute at;
                Attribute oldAt;
                int b;
                DesignObject dobj2;
                targetRelation = targetDesignPart.createRelation(sourceRelation.getName());
                targetRelation.setTargetEntity(targetEntity);
                targetRelation.setSourceEntity(sourceEntity);
                targetRelation.setSourceTV((TVEntity)sourceEntity.getTopView());
                targetRelation.setTargetTV((TVEntity)targetEntity.getTopView());
                objectsMap.put(sourceRelation.getObjectID(), targetRelation);
                if (sourceRelation.getGeneratorID() != null && !"User generated".equals(sourceRelation.getGeneratorID()) && (dobj2 = (DesignObject)objectsMap.get(sourceRelation.getGeneratorID())) != null && (dobj2 instanceof FKIndexAssociation || dobj2 instanceof Table)) {
                    targetRelation.setGeneratorID(dobj2.getObjectID());
                }
                ContainedObject[] attributes = sourceRelation.getTargetEntity().getAllElementsGeneratedBy(sourceRelation);
                for (b = 0; b < attributes.length; ++b) {
                    oldAt = (Attribute)attributes[b];
                    at = (Attribute)objectsMap.get(oldAt.getObjectID());
                    if (at == null) continue;
                    oldId = oldAt.getReferedAttribute();
                    refOldAttr = (Attribute)sourceRelation.getSourceEntity().getElementByID(oldId);
                    if (refOldAttr != null && (refAttr = (Attribute)objectsMap.get(refOldAttr.getObjectID())) != null) {
                        at.setReferedAttribute(refAttr.getObjectID());
                    }
                    at.setGeneratorID(targetRelation.getObjectID());
                }
                attributes = sourceRelation.getSourceEntity().getAllElementsGeneratedBy(sourceRelation);
                for (b = 0; b < attributes.length; ++b) {
                    oldAt = (Attribute)attributes[b];
                    at = (Attribute)objectsMap.get(oldAt.getObjectID());
                    if (at == null) continue;
                    oldId = oldAt.getReferedAttribute();
                    refOldAttr = (Attribute)sourceRelation.getTargetEntity().getElementByID(oldId);
                    if (refOldAttr != null && (refAttr = (Attribute)objectsMap.get(refOldAttr.getObjectID())) != null) {
                        at.setReferedAttribute(refAttr.getObjectID());
                    }
                    at.setGeneratorID(targetRelation.getObjectID());
                }
                targetRelation.setFireCardinalityChange(false);
                if (sourceRelation.isIdentifying()) {
                    targetRelation.setIdentifying(sourceRelation.isIdentifying());
                }
                if ((ent = sourceRelation.getDominantRole()) != null && ent != sourceRelation.getNONEEntity() && (dobj = (DesignObject)objectsMap.get(ent.getObjectID())) != null && dobj instanceof Entity) {
                    targetRelation.setDominantRole((Entity)dobj);
                }
                if ((key = sourceRelation.getSourcePk()) != null && (tkey = (CandidateKey)objectsMap.get(key.getObjectID())) != null) {
                    targetRelation.setSourcePk(tkey);
                }
                if ((key = sourceRelation.getTargetPk()) != null && (tkey = (CandidateKey)objectsMap.get(key.getObjectID())) != null) {
                    targetRelation.setTargetPk(tkey);
                }
                targetRelation.setDeleteRule(sourceRelation.getDeleteRule());
                targetRelation.setNameOnSource(sourceRelation.getNameOnSource());
                targetRelation.setNameOnTarget(sourceRelation.getNameOnTarget());
                targetRelation.setUseSurrogateKey(sourceRelation.isUseSurrogateKey());
                targetRelation.setOptionalSource(sourceRelation.isOptionalSource());
                targetRelation.setOptionalTarget(sourceRelation.isOptionalTarget());
                targetRelation.setSourceCardinality(sourceRelation.getSourceCardinality());
                targetRelation.setSourceTransferable(sourceRelation.isSourceTransferable());
                targetRelation.setTargetTransferable(sourceRelation.isTargetTransferable());
                targetRelation.setFireCardinalityChange(true);
                targetRelation.setTargetCardinality(sourceRelation.getTargetCardinality());
                targetRelation.setBelongsToSourcePK(sourceRelation.belongsToSourcePK());
                targetRelation.setBelongsToTargetPK(sourceRelation.belongsToTargetPK());
            }
        }
        return targetRelation;
    }

    private void processRelations(LogicalDesign sourceDesignPart, LogicalDesign targetDesignPart) {
        Iterator it = sourceDesignPart.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation sourceRelation = (Relation)it.next();
            Relation targetRelation = (Relation)this.objectsMap.get(sourceRelation.getObjectID());
            if (!sourceRelation.shouldBeMerge()) continue;
            if (targetRelation == null) {
                targetRelation = MergingCWDDesigns.copyRelationShiptoNew(sourceRelation, targetDesignPart, this.objectsMap);
                if (targetRelation != null) {
                    targetRelation.setImportedId(sourceRelation.getObjectID());
                }
            } else {
                PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceRelation.getObjectID() + targetRelation.getObjectID());
                if (comp != null) {
                    comp.copySelectedProperties();
                }
            }
            if (targetRelation == null) continue;
            ContainedObject[] sourceAttributes = sourceRelation.getOwnedEntity().getElements();
            for (int i = 0; i < sourceAttributes.length; ++i) {
                AttributeComparator comp;
                Attribute sourceAttribute = (Attribute)sourceAttributes[i];
                if (!sourceAttribute.shouldBeMerge()) continue;
                Attribute targetAttribute = (Attribute)this.objectsMap.get(sourceAttribute.getObjectID());
                if (targetAttribute == null) {
                    targetAttribute = targetRelation.createAttribute(sourceAttribute.getName());
                    targetAttribute.setImportedId(sourceAttribute.getObjectID());
                    targetAttribute.moveToIndex(sourceAttribute.getIndex());
                    this.objectsMap.put(sourceAttribute.getObjectID(), targetAttribute);
                    this.copyPropertiesFromAttributeToAttribute(sourceAttribute, targetAttribute);
                    continue;
                }
                if (targetAttribute == null || (comp = (AttributeComparator)this.comparatorsMap.get(sourceAttribute.getObjectID() + targetAttribute.getObjectID())) == null) continue;
                comp.copySelectedProperties();
                targetAttribute.moveToIndex(sourceAttribute.getIndex());
            }
            for (TVRelation tv : targetRelation.getAllTVRelations()) {
                tv.resetEdgeParams();
            }
        }
    }

    private void processInheritances(LogicalDesign sourceDesignPart, LogicalDesign targetDesignPart) {
        Iterator it = sourceDesignPart.getInheritanceRelationSet().iterator();
        while (it.hasNext()) {
            InheritanceRelation ir = (InheritanceRelation)it.next();
            if (!ir.shouldBeMerge()) continue;
            InheritanceRelation target_ir = (InheritanceRelation)this.objectsMap.get(ir.getObjectID());
            if (target_ir == null) {
                Entity sourcePar = ir.getSourceEntity();
                Entity sourceChild = ir.getTargetEntity();
                if (sourcePar == null || sourceChild == null) continue;
                Entity targetPar = (Entity)this.objectsMap.get(sourcePar.getObjectID());
                Entity targetChild = (Entity)this.objectsMap.get(sourceChild.getObjectID());
                if (targetPar == null || targetChild == null) continue;
                targetChild.setHierarchicalParent(targetPar);
                InheritanceRelation t_ir = (InheritanceRelation)targetChild.getInheritanceRelation();
                if (t_ir == null) continue;
                t_ir.setName(ir.getName());
                t_ir.setImportedId(ir.getObjectID());
                t_ir.setComment(ir.getComment());
                t_ir.setCommentInRDBMS(ir.getCommentInRDBMS());
                t_ir.setNotes(ir.getNotes());
                this.objectsMap.put(ir.getObjectID(), t_ir);
                continue;
            }
            PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(ir.getObjectID() + target_ir.getObjectID());
            if (comp == null) continue;
            comp.copySelectedProperties();
        }
    }

    private void processForeignKeys() {
        for (int i = 0; i < this.fkeys.size(); ++i) {
            FKIndexAssociation fk = (FKIndexAssociation)this.fkeys.get(i);
            FKIndexAssociation targetfk = (FKIndexAssociation)this.objectsMap.get(fk.getObjectID());
            if (!fk.shouldBeMerge()) continue;
            if (targetfk == null) {
                if (!fk.getLocalFKIndex().shouldBeMerge()) continue;
                this.processFK(fk);
                continue;
            }
            PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(fk.getObjectID() + targetfk.getObjectID());
            if (comp == null) continue;
            comp.copySelectedProperties();
            this.synchronizeFKColumns(fk, targetfk);
        }
    }

    public static void processFKArcs(RelationalDesign sourceDesignPart, RelationalDesign targetDesignPart, Map objectsMap, Map comparatorsMap) {
        Iterator it = sourceDesignPart.getTableSet().iterator();
        while (it.hasNext()) {
            Table sourceTable = (Table)it.next();
            Object[] arcs = sourceTable.getArcs().toArray();
            for (int i = 0; i < arcs.length; ++i) {
                FKArc sarc = (FKArc)arcs[i];
                FKArc tarc = (FKArc)objectsMap.get(sarc.getObjectID());
                if (!sarc.shouldBeMerge()) continue;
                if (tarc == null) {
                    MergingCWDDesigns.processFKArc(sarc, objectsMap);
                    continue;
                }
                PropertiesComparator comp = (PropertiesComparator)comparatorsMap.get(sarc.getObjectID() + tarc.getObjectID());
                if (comp == null) continue;
                comp.copySelectedProperties();
            }
        }
    }

    public void processFK(FKIndexAssociation sourcefkAssociation) {
        KeyObject remoteIndex;
        KeyObject newRemoteIndex;
        FKContainer sourceTable = sourcefkAssociation.getRemoteTable();
        FKContainer targetTable = (FKContainer)sourcefkAssociation.getContainerWithKeyObject();
        FKContainer newsourceTable = (FKContainer)this.objectsMap.get(sourceTable.getObjectID());
        FKContainer newtargetTable = (FKContainer)this.objectsMap.get(targetTable.getObjectID());
        if (newsourceTable != null && newtargetTable != null && (newRemoteIndex = (KeyObject)this.objectsMap.get((remoteIndex = sourcefkAssociation.getRemoteIndex()).getObjectID())) != null) {
            FKElement tcol;
            DesignObject dobj;
            FKIndexAssociation targetfkAssociation = newtargetTable.addFK(newRemoteIndex);
            targetfkAssociation.setImportedId(sourceTable.getObjectID());
            sourcefkAssociation.copy(targetfkAssociation);
            targetfkAssociation.setName(sourcefkAssociation.getName());
            this.objectsMap.put(sourcefkAssociation.getObjectID(), targetfkAssociation);
            if (sourcefkAssociation.getGeneratorID() != null && !"User generated".equals(sourcefkAssociation.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourcefkAssociation.getGeneratorID())) != null && dobj instanceof Table) {
                targetfkAssociation.setGeneratorID(dobj.getObjectID());
            }
            MergingCWDDesigns.copySourceStamp(sourcefkAssociation, targetfkAssociation);
            this.synchronizeFKColumns(sourcefkAssociation, targetfkAssociation);
            targetfkAssociation.setDeleteRule(sourcefkAssociation.getDeleteRule());
            targetfkAssociation.setComment(sourcefkAssociation.getComment());
            targetfkAssociation.setCommentInRDBMS(sourcefkAssociation.getCommentInRDBMS());
            targetfkAssociation.setNotes(sourcefkAssociation.getNotes());
            targetfkAssociation.setMandatory(sourcefkAssociation.isMandatory());
            targetfkAssociation.setTransferable(sourcefkAssociation.isTransferable());
            targetfkAssociation.setRely(sourcefkAssociation.isRely());
            FKArc targetArc = null;
            FKArc sourceArc = sourcefkAssociation.getArc();
            if (sourceArc != null) {
                targetArc = (FKArc)this.objectsMap.get(sourceArc.getObjectID());
            }
            targetfkAssociation.setArc(targetArc);
            sourcefkAssociation.copyAllRemoteObjectIDsAndPath(targetfkAssociation);
            FKElement col = sourcefkAssociation.getDiscriminatorColumn();
            if (col != null && (tcol = (FKElement)this.objectsMap.get(col.getObjectID())) != null) {
                targetfkAssociation.setDiscriminatorColumn(tcol);
            }
            targetfkAssociation.setDiscriminatorValue(sourcefkAssociation.getDiscriminatorValue());
            targetfkAssociation.getLocalFKIndex().setNameHasQuotes(sourcefkAssociation.getLocalFKIndex().getNameHasQuotes());
            targetfkAssociation.resetEdgeParams();
        }
    }

    private static void processFKArc(FKArc arc, Map objectsMap) {
        FKContainer sourceTable = arc.getTable();
        FKContainer targetTable = (FKContainer)objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            FKArc tarc = targetTable.getRelationalModel().createArc();
            tarc.setTable(targetTable);
            arc.copy(tarc, objectsMap);
            arc.copyAllRemoteObjectIDsAndPath(tarc);
            if (tarc.getFkeys().size() > 1) {
                targetTable.addArc(tarc);
                objectsMap.put(arc.getObjectID(), tarc);
                tarc.setImportedId(arc.getObjectID());
            } else {
                tarc.remove();
            }
        }
    }

    public void synchronizeFKColumns(FKIndexAssociation sourcefkass, FKIndexAssociation targetfkass) {
        KeyObject sourceKeyObject = sourcefkass.getKeyObject();
        if (sourceKeyObject != null) {
            int i;
            FKElement[] sourcePKCols = (FKElement[])sourceKeyObject.getElements();
            FKContainer sourceTable = (FKContainer)sourcefkass.getContainerWithKeyObject();
            FKContainer targetTable = (FKContainer)targetfkass.getContainerWithKeyObject();
            ArrayList<FKElement> list = new ArrayList<FKElement>();
            for (i = 0; i < sourcePKCols.length; ++i) {
                FKElement sourceFKcol = sourceTable.getFKColumn(sourcefkass, sourcePKCols[i]);
                if (sourceFKcol == null) continue;
                FKElement targetFKcol = (FKElement)this.objectsMap.get(sourceFKcol.getObjectID());
                FKElement targetPKcol = null;
                if (targetFKcol != null) {
                    targetPKcol = (FKElement)this.objectsMap.get(sourcePKCols[i].getObjectID());
                    if (targetPKcol == null) continue;
                    targetFKcol.addFKAssociation(targetPKcol, targetfkass);
                    targetfkass.getLocalFKIndex().add(targetFKcol);
                    list.add(targetFKcol);
                    continue;
                }
                targetPKcol = (FKElement)this.objectsMap.get(sourcePKCols[i].getObjectID());
                if (targetPKcol == null) continue;
                targetFKcol = targetTable.createColumnFK(targetPKcol, targetfkass);
                targetFKcol.setName(sourceFKcol.getName());
                MergingModels.copyPropertiesFromColumnToColumn(sourceFKcol, targetFKcol, this.objectsMap);
                MergingCWDDesigns.copySourceStamp(sourceFKcol, targetFKcol);
                targetFKcol.moveToIndex(sourceFKcol.getIndex());
                targetfkass.getLocalFKIndex().add(targetFKcol);
                list.add(targetFKcol);
                this.objectsMap.put(sourceFKcol.getObjectID(), targetFKcol);
            }
            for (i = 0; i < list.size(); ++i) {
                targetfkass.getLocalFKIndex().moveToIndex((ContainedObject)list.get(i), i);
            }
        }
    }

    private void processTableViews(RelationalDesign sourceDesignPart, RelationalDesign targetDesignPart) {
        Iterator it = sourceDesignPart.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView sourceTableView = (TableView)it.next();
            if (!sourceTableView.shouldBeMerge()) continue;
            TableView targetTableView = this.processTableView(sourceTableView, sourceDesignPart, targetDesignPart);
            MergingCWDDesigns.copySourceStamp(sourceTableView, targetTableView);
            this.processViewIndexes(sourceTableView);
        }
    }

    private TableView processTableView(TableView sourceTableView, RelationalDesign sourceDesignPart, RelationalDesign targetDesignPart) {
        TableView targetTableView = (TableView)this.objectsMap.get(sourceTableView.getObjectID());
        if (targetTableView == null) {
            SchemaObject tsho;
            if (targetDesignPart.getTableViewSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            targetTableView = targetDesignPart.createTableView(sourceTableView.getName());
            targetTableView.setImportedId(sourceTableView.getObjectID());
            this.objectsMap.put(sourceTableView.getObjectID(), targetTableView);
            SchemaObject sho = sourceTableView.getSchemaObject();
            if (sho != null && (tsho = (SchemaObject)this.objectsMap.get(sho.getObjectID())) != null) {
                targetTableView.setSchemaObject(tsho);
            }
            this.copyPropertiesFromTableViewToTableView(sourceTableView, targetTableView, sourceDesignPart);
            if (this.notEmpty) {
                this.moveGraphical(sourceDesignPart, targetDesignPart, (DesignObject)targetTableView, (DesignObject)sourceTableView);
            } else {
                ++this.count;
                this.setObjectBounds(sourceTableView, targetTableView);
            }
        } else {
            PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceTableView.getObjectID() + targetTableView.getObjectID());
            if (prop != null) {
                prop.copySelectedProperties();
            }
        }
        return targetTableView;
    }

    private void processViewIndexes(TableView sourceView) {
        TableView targetView = (TableView)this.objectsMap.get(sourceView.getObjectID());
        if (targetView != null) {
            KeyObject[] sourceKeys = sourceView.getKeys();
            for (int i = 0; i < sourceKeys.length; ++i) {
                KeyObject sourceKey = sourceKeys[i];
                if (sourceKey.isFK()) continue;
                ViewIndex index = (ViewIndex)this.objectsMap.get(sourceKey.getObjectID());
                if (sourceKey.shouldBeMerge()) {
                    if (index == null) {
                        SchemaObject tsho;
                        index = targetView.createIndex();
                        index.setImportedId(sourceKey.getObjectID());
                        SchemaObject sho = sourceKey.getSchemaObject();
                        if (sho != null && (tsho = (SchemaObject)this.objectsMap.get(sho.getObjectID())) != null) {
                            index.setSchemaObject(tsho);
                        }
                        this.objectsMap.put(sourceKey.getObjectID(), index);
                        this.copyPropertiesFromViewIndexToViewIndex((ViewIndex)sourceKey, index);
                        index.setName(sourceKey.getName());
                        MergingCWDDesigns.copySourceStamp(sourceKey, index);
                    } else {
                        PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceKey.getObjectID() + index.getObjectID());
                        if (comp != null) {
                            comp.copySelectedProperties();
                        }
                    }
                    index.setShouldMerge(true);
                    continue;
                }
                if (index == null) continue;
                index.setShouldMerge(false);
            }
        }
    }

    private void copyPropertiesFromViewIndexToViewIndex(ViewIndex sourceIndex, ViewIndex targetIndex) {
        DesignObject dobj;
        if (sourceIndex.getGeneratorID() != null && !"User generated".equals(sourceIndex.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceIndex.getGeneratorID())) != null && dobj instanceof CandidateKey) {
            targetIndex.setGeneratorID(dobj.getObjectID());
        }
        targetIndex.setNameHasQuotes(sourceIndex.getNameHasQuotes());
        targetIndex.setCommentInRDBMS(sourceIndex.getCommentInRDBMS());
        targetIndex.setComment(sourceIndex.getComment());
        targetIndex.setNotes(sourceIndex.getNotes());
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        for (int j = 0; j < sourceColumns.length; ++j) {
            ContainedObject sourceColumn = sourceColumns[j];
            ContainedObject targetColumn = (ContainedObject)this.objectsMap.get(sourceColumn.getObjectID());
            if (targetColumn == null || targetColumn.getContainer() != targetIndex.getContainerObject()) continue;
            String sorder = sourceIndex.getColumnSortOrder(sourceColumn);
            targetIndex.add(targetColumn);
            targetIndex.setColumnSortOrder(targetColumn, sorder);
        }
        targetIndex.setIndexState(sourceIndex.getIndexState());
        targetIndex.setIndexExpression(sourceIndex.getIndexExpression());
        sourceIndex.copyAllRemoteObjectIDsAndPath(targetIndex);
    }

    private void copyPropertiesFromTableViewToTableView(TableView sourceTableView, TableView targetTableView, RelationalDesign sourceDesignPart) {
        ColumnView col;
        DesignObject dobj;
        if (sourceTableView.getGeneratorID() != null && !"User generated".equals(sourceTableView.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceTableView.getGeneratorID())) != null && dobj instanceof EntityView) {
            targetTableView.setGeneratorID(dobj.getObjectID());
        }
        targetTableView.setNameHasQuotes(sourceTableView.getNameHasQuotes());
        targetTableView.setComment(sourceTableView.getComment());
        targetTableView.setCommentInRDBMS(sourceTableView.getCommentInRDBMS());
        targetTableView.setNotes(sourceTableView.getNotes());
        targetTableView.setDeprecated(sourceTableView.isDeprecated());
        targetTableView.setIncludeSchemaNameInQuery(sourceTableView.includeSchemaNameInQuery());
        targetTableView.setSyntaxProvider(sourceTableView.getSyntaxProvider());
        targetTableView.setWhere(sourceTableView.getWhere());
        targetTableView.setGroupBy(sourceTableView.getGroupBy());
        targetTableView.setHaving(sourceTableView.getHaving());
        targetTableView.setUserDefined(sourceTableView.getUserDefined());
        targetTableView.setUserDefinedSQL(sourceTableView.getUserDefinedSQL());
        targetTableView.setOptimizerHints(sourceTableView.getOptimizerHints());
        targetTableView.setOidText(sourceTableView.getOidText());
        targetTableView.setAllowTypeSubstitution(sourceTableView.isAllowTypeSubstitution());
        targetTableView.setBeforeDrop(sourceTableView.getBeforeDrop());
        targetTableView.setBeforeCreate(sourceTableView.getBeforeCreate());
        targetTableView.setAfterCreate(sourceTableView.getAfterCreate());
        targetTableView.setEndOfScript(sourceTableView.getEndOfScript());
        targetTableView.setShouldGenerateScript(sourceTableView.getShouldGenerateScript());
        targetTableView.setORDSEnable(sourceTableView.isORDSEnable());
        targetTableView.setORDSAuth(sourceTableView.isORDSAuth());
        targetTableView.setORDSAlias(sourceTableView.getORDSAlias());
        sourceTableView.copyDynamicProperties(targetTableView);
        StructuredType st = sourceTableView.getBasedOnStructuredType();
        if (st != null) {
            StructuredType targetST = (StructuredType)this.objectsMap.get(st.getObjectID());
            if (targetST != null) {
                targetTableView.setBasedOnStructuredType(targetST);
            }
        } else {
            targetTableView.setBasedOnStructuredType(null);
        }
        for (String alias : sourceTableView.getContainerMap().keySet()) {
            Table targetTable;
            String cID = sourceTableView.getContainerID(alias);
            Table table = (Table)sourceDesignPart.getTableSet().getObjectByID(cID);
            if (table == null || (targetTable = (Table)this.objectsMap.get(table.getObjectID())) == null) continue;
            targetTableView.addToContainers(targetTable, alias);
        }
        for (String id : sourceTableView.getOrderByMap().keySet()) {
            ColumnView key = (ColumnView)sourceTableView.getObjectByID(sourceTableView.getOrderByList(), id);
            if (key != null) {
                col = new ColumnView(targetTableView.getDesignPart());
                col.setDesign(targetTableView.getDesign());
                this.copyColumnToColumn(key, col);
                col.setView(targetTableView);
                targetTableView.addToOrderBy(col, (String)sourceTableView.getOrderByMap().get(id));
                this.objectsMap.put(key.getObjectID(), col);
                continue;
            }
            System.out.println("MergingCWDDesigns.copyPropertiesFromTableViewToTableView: Unable to find ColumnView: " + id);
        }
        if (!sourceTableView.isBST()) {
            for (int i = 0; i < sourceTableView.getElements().length; ++i) {
                ColumnView scol = (ColumnView)sourceTableView.getElements()[i];
                ColumnView col2 = new ColumnView(targetTableView.getDesignPart());
                col2.setDesign(targetTableView.getDesign());
                this.copyColumnToColumn(scol, col2);
                col2.setView(targetTableView);
                col2.setContainer(targetTableView);
                targetTableView.add(col2);
                this.objectsMap.put(scol.getObjectID(), col2);
            }
        }
        for (int i = 0; i < sourceTableView.getGroupByList().size(); ++i) {
            col = (ColumnView)sourceTableView.getGroupByList().get(i);
            ColumnView tcol = (ColumnView)this.objectsMap.get(col.getObjectID());
            if (tcol == null) continue;
            targetTableView.addGroupByList(tcol);
        }
        sourceTableView.copyAllRemoteObjectIDsAndPath(targetTableView);
    }

    public void copyColumnToColumn(ColumnView sourceColumnView, ColumnView targetColumnView) {
        DesignObject dobj;
        if (sourceColumnView.getGeneratorID() != null && !"User generated".equals(sourceColumnView.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceColumnView.getGeneratorID())) != null && dobj instanceof AttributeView) {
            targetColumnView.setGeneratorID(dobj.getObjectID());
        }
        sourceColumnView.copyDefaults(targetColumnView);
        targetColumnView.setNameHasQuotes(sourceColumnView.getNameHasQuotes());
        targetColumnView.setTableAlias(sourceColumnView.getTableAlias());
        targetColumnView.setAlias(sourceColumnView.getAlias());
        targetColumnView.setHeaderAlias(sourceColumnView.getHeaderAlias());
        targetColumnView.setExpression(sourceColumnView.getExpression());
        targetColumnView.setDataType(sourceColumnView.getDataTypeString());
        if (sourceColumnView.getReferencedColumn() != null) {
            FKElement col = (FKElement)this.objectsMap.get(sourceColumnView.getReferencedColumn().getObjectID());
            targetColumnView.setReferencedColumn(col);
        }
        if (sourceColumnView.getTable() != null) {
            Table tTable = (Table)this.objectsMap.get(sourceColumnView.getTable().getObjectID());
            targetColumnView.setTable(tTable);
        }
        targetColumnView.setReference(sourceColumnView.isReference());
        targetColumnView.setStructuredType(sourceColumnView.getStructuredType());
    }

    private void processEntityViews(LogicalDesign sourceDesignPart, LogicalDesign targetDesignPart) {
        Iterator it = sourceDesignPart.getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView sourceView = (EntityView)it.next();
            if (!sourceView.shouldBeMerge()) continue;
            this.processEntityView(sourceView, sourceDesignPart, targetDesignPart);
        }
    }

    private void processEntityView(EntityView sourceView, LogicalDesign sourceDesignPart, LogicalDesign targetDesignPart) {
        EntityView targetView = (EntityView)this.objectsMap.get(sourceView.getObjectID());
        if (targetView == null) {
            if (targetDesignPart.getEntityViewSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            targetView = targetDesignPart.createEntityView(sourceView.getName());
            targetView.setImportedId(sourceView.getObjectID());
            this.objectsMap.put(sourceView.getObjectID(), targetView);
            this.copyPropertiesFromEntityViewToEntityView(sourceView, targetView, sourceDesignPart);
            if (this.notEmpty) {
                this.moveGraphical(sourceDesignPart, targetDesignPart, (DesignObject)targetView, (DesignObject)sourceView);
            } else {
                ++this.count;
                this.setObjectBounds(sourceView, targetView);
            }
        } else {
            PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceView.getObjectID() + targetView.getObjectID());
            if (prop != null) {
                prop.copySelectedProperties();
            }
        }
    }

    private void copyPropertiesFromEntityViewToEntityView(EntityView sourceView, EntityView targetView, LogicalDesign sourceDesignPart) {
        AttributeView col;
        DesignObject dobj;
        if (sourceView.getGeneratorID() != null && !"User generated".equals(sourceView.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceView.getGeneratorID())) != null && dobj instanceof TableView) {
            targetView.setGeneratorID(dobj.getObjectID());
        }
        targetView.setComment(sourceView.getComment());
        targetView.setCommentInRDBMS(sourceView.getCommentInRDBMS());
        targetView.setNotes(sourceView.getNotes());
        targetView.setWhere(sourceView.getWhere());
        targetView.setGroupBy(sourceView.getGroupBy());
        targetView.setHaving(sourceView.getHaving());
        targetView.setUserDefined(sourceView.getUserDefined());
        targetView.setUserDefinedSQL(sourceView.getUserDefinedSQL());
        targetView.setBasedOnStructuredType(sourceView.getBasedOnStructuredType());
        sourceView.copyDynamicProperties(targetView);
        for (String alias : sourceView.getContainerMap().keySet()) {
            Entity targetEntity;
            String cID = sourceView.getContainerID(alias);
            Entity entity = (Entity)sourceDesignPart.getEntitySet().getObjectByID(cID);
            if (entity == null || (targetEntity = (Entity)this.objectsMap.get(entity.getObjectID())) == null) continue;
            targetView.addToContainers(targetEntity, alias);
        }
        for (String id : sourceView.getOrderByMap().keySet()) {
            AttributeView key = (AttributeView)sourceView.getObjectByID(sourceView.getOrderByList(), id);
            if (key != null) {
                col = new AttributeView(targetView.getDesignPart());
                col.setDesign(targetView.getDesign());
                this.copyAttributeToAttribute(key, col);
                col.setView(targetView);
                targetView.addToOrderBy(col, (String)sourceView.getOrderByMap().get(id));
                this.objectsMap.put(key.getObjectID(), col);
                continue;
            }
            System.out.println("MergingCWDDesigns.copyPropertiesFromTableViewToTableView: Unable to find ColumnView: " + id);
        }
        if (!sourceView.isBST()) {
            for (int i = 0; i < sourceView.getElements().length; ++i) {
                AttributeView scol = (AttributeView)sourceView.getElements()[i];
                AttributeView col2 = new AttributeView(targetView.getDesignPart());
                col2.setDesign(targetView.getDesign());
                this.copyAttributeToAttribute(scol, col2);
                col2.setView(targetView);
                col2.setContainer(targetView);
                targetView.add(col2);
                this.objectsMap.put(scol.getObjectID(), col2);
            }
        }
        for (int i = 0; i < sourceView.getGroupByList().size(); ++i) {
            col = (AttributeView)sourceView.getGroupByList().get(i);
            AttributeView tcol = (AttributeView)this.objectsMap.get(col.getObjectID());
            if (tcol == null) continue;
            targetView.addGroupByList(tcol);
        }
    }

    public void copyAttributeToAttribute(AttributeView sourceAttributeView, AttributeView targetAttributeView) {
        DesignObject dobj;
        if (sourceAttributeView.getGeneratorID() != null && !"User generated".equals(sourceAttributeView.getGeneratorID()) && (dobj = (DesignObject)this.objectsMap.get(sourceAttributeView.getGeneratorID())) != null && dobj instanceof ColumnView) {
            targetAttributeView.setGeneratorID(dobj.getObjectID());
        }
        sourceAttributeView.copyDefaults(targetAttributeView);
        targetAttributeView.setTableAlias(sourceAttributeView.getTableAlias());
        targetAttributeView.setAlias(sourceAttributeView.getAlias());
        targetAttributeView.setExpression(sourceAttributeView.getExpression());
        targetAttributeView.setDataType(sourceAttributeView.getDataTypeString());
        if (sourceAttributeView.getReferencedColumn() != null) {
            Attribute col = (Attribute)this.objectsMap.get(sourceAttributeView.getReferencedAttribute().getObjectID());
            targetAttributeView.setReferencedAttribute(col);
        }
        if (sourceAttributeView.getEntity() != null) {
            Entity tEntity = (Entity)this.objectsMap.get(sourceAttributeView.getEntity().getObjectID());
            targetAttributeView.setEntity(tEntity);
        }
        targetAttributeView.setReference(sourceAttributeView.isReference());
        targetAttributeView.setStructuredType(sourceAttributeView.getStructuredType());
    }

    private void processLogSubViews(LogicalDesign sourceDesign, LogicalDesign targetDesign) {
        Iterator it = sourceDesign.getLogicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder sSubView = (DesignPartViewPlaceHolder)it.next();
            if (!sSubView.shouldBeMerge()) continue;
            this.processLogicalSubView(sSubView.getDesignPartView(), sourceDesign, targetDesign);
        }
    }

    private void processLogicalSubView(DesignPartView sourceDPV, LogicalDesign sDesign, LogicalDesign tDesign) {
        DesignPartView targetDPV = (DesignPartView)this.objectsMap.get(sourceDPV.getDPVId());
        if (targetDPV == null) {
            targetDPV = tDesign.createDesignPartSubView();
            targetDPV.setImportedId(sourceDPV.getDPVId());
            this.objectsMap.put(sourceDPV.getDPVId(), targetDPV);
            this.copyPropertiesFromSubViewToSubView(sourceDPV, targetDPV);
            DesignPartView.copyDisplayDrawingProperties(sourceDPV, targetDPV);
            MergingCWDDesigns.copyDisplayTopViews(sourceDPV, targetDPV, this.objectsMap);
            for (DesignPartView sdpv : sourceDPV.getSubordinateViews()) {
                DesignPartView tdpv = this.getCorrespondingSubordinateView(targetDPV, sdpv.getDPVId());
                if (tdpv != null) continue;
                tdpv = targetDPV.addSubordinateView();
                tdpv.setImportedId(sdpv.getDPVId());
                this.copyPropertiesFromSubViewToSubView(sdpv, tdpv);
                DesignPartView.copyDisplayDrawingProperties(sdpv, tdpv);
                MergingCWDDesigns.copyDisplayTopViews(sdpv, tdpv, this.objectsMap);
            }
            ++this.count;
        } else {
            PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceDPV.getPlaceHolder().getObjectID());
            if (prop != null) {
                prop.copySelectedProperties();
            }
        }
    }

    public static void copyDisplayTopViews(DesignPartView sourceDPV, DesignPartView targetDPV, Map objectsMap) {
        DesignObject target;
        DesignObject dobj;
        ApplicationView view = sourceDPV.getApplicationView();
        TreeMap<String, TopView> objMap = new TreeMap<String, TopView>();
        for (TopView tv : sourceDPV.getTopviewsList()) {
            if (tv.isConnection()) continue;
            dobj = tv.getModel();
            if (dobj instanceof Note) {
                // empty if block
            }
            if ((target = (DesignObject)objectsMap.get(dobj.getObjectID())) == null) continue;
            TopView ttv = target.getFirstViewForDPV(targetDPV);
            if (ttv == null) {
                ttv = targetDPV.createTopViewFor(target);
            } else if (sourceDPV.isMainDiagram()) {
                TopView stv = dobj.getFirstViewForDPV(sourceDPV);
                if (stv != tv) {
                    ttv = targetDPV.createTopViewFor(target);
                }
            } else {
                TopView temp = (TopView)objMap.get(tv.getViewID());
                if (temp == null) {
                    ttv = ttv.createViewSynonim(targetDPV);
                }
            }
            view.setGraphicalPropsFor(ttv, view.getGraphicalPropsFor(tv));
            objMap.put(tv.getViewID(), ttv);
        }
        for (TopView tv : sourceDPV.getTopviewsList()) {
            if (!tv.isConnection() || !(tv instanceof TVConnector) || (target = (DesignObject)objectsMap.get((dobj = tv.getModel()).getObjectID())) == null || !(target instanceof ConnectionInterface)) continue;
            ConnectionInterface ci = (ConnectionInterface)((Object)target);
            TopView sv_s = ((ConnectionInterface)((Object)dobj)).getSourceTopView(sourceDPV);
            TopView tv_s = ((ConnectionInterface)((Object)dobj)).getTargetTopView(sourceDPV);
            if (sv_s == null || tv_s == null) continue;
            TopView sv_t = (TopView)objMap.get(sv_s.getViewID());
            TopView tv_t = (TopView)objMap.get(tv_s.getViewID());
            if (sv_t == null || tv_t == null) continue;
            ci.setSourceTopView(sv_t);
            ci.setTargetTopView(tv_t);
            if (sourceDPV.isAutoRoute()) continue;
            TVConnector connTV = (TVConnector)ci.getViewFor(targetDPV);
            DesignPartView.copyConnectionPoints((TVConnector)tv, connTV);
        }
    }

    private void processRelSubViews(RelationalDesign sDesign, RelationalDesign tDesign) {
        Iterator it = sDesign.getPhysicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpv = (DesignPartViewPlaceHolder)it.next();
            if (!dpv.shouldBeMerge()) continue;
            this.processRelationalSubView(dpv.getDesignPartView(), sDesign, tDesign);
        }
    }

    private void processRelationalSubView(DesignPartView sourceView, RelationalDesign sDesign, RelationalDesign tDesign) {
        DesignPartView targetView = (DesignPartView)this.objectsMap.get(sourceView.getDPVId());
        if (targetView == null) {
            targetView = tDesign.createDesignPartSubView();
            targetView.setImportedId(sourceView.getDPVId());
            this.objectsMap.put(sourceView.getDPVId(), targetView);
            this.copyPropertiesFromSubViewToSubView(sourceView, targetView);
            DesignPartView.copyDisplayDrawingProperties(sourceView, targetView);
            MergingCWDDesigns.copyDisplayTopViews(sourceView, targetView, this.objectsMap);
            for (DesignPartView sdpv : sourceView.getSubordinateViews()) {
                DesignPartView tdpv = this.getCorrespondingSubordinateView(targetView, sdpv.getDPVId());
                if (tdpv != null) continue;
                tdpv = targetView.addSubordinateView();
                tdpv.setImportedId(sdpv.getDPVId());
                this.copyPropertiesFromSubViewToSubView(sdpv, tdpv);
                DesignPartView.copyDisplayDrawingProperties(sdpv, tdpv);
                MergingCWDDesigns.copyDisplayTopViews(sdpv, tdpv, this.objectsMap);
            }
            ++this.count;
        } else {
            PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceView.getPlaceHolder().getObjectID());
            if (prop != null) {
                prop.copySelectedProperties();
            }
        }
    }

    private void copyPropertiesFromSubViewToSubView(DesignPartView sView, DesignPartView tView) {
        tView.setGeneratorId(sView.getPlaceHolder().getObjectID());
        tView.setName(sView.getName());
        tView.setMustBeVisible(sView.mustBeVisible());
        tView.getPlaceHolder().setComment(sView.getPlaceHolder().getComment());
    }

    private void processDistinctTypes(DataTypesDesign sourceDesign, DataTypesDesign targetDesign) {
        for (DistinctType sourceType : this.dtList) {
            this.processDistinctType(sourceType, sourceDesign, targetDesign);
        }
    }

    private void processDistinctType(DistinctType sourceType, DataTypesDesign sourceDesign, DataTypesDesign targetDesign) {
        DistinctType targetType = (DistinctType)this.incompleteTypes.get(sourceType.getObjectID());
        if (targetType != null) {
            this.copyPropertiesFromDistTypeToDistType(sourceType, targetType);
            ++this.count;
        } else {
            targetType = (DistinctType)this.objectsMap.get(sourceType.getObjectID());
            if (targetType == null) {
                targetType = targetDesign.createDistinctType();
                targetType.setImportedId(sourceType.getObjectID());
                this.objectsMap.put(sourceType.getObjectID(), targetType);
                this.copyPropertiesFromDistTypeToDistType(sourceType, targetType);
                ++this.count;
            } else {
                PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceType.getObjectID() + targetType.getObjectID());
                if (prop != null) {
                    prop.copySelectedProperties();
                }
            }
        }
    }

    private void copyPropertiesFromDistTypeToDistType(DistinctType sourceType, DistinctType targetType) {
        targetType.setGeneratorID(sourceType.getObjectID());
        targetType.setName(sourceType.getName());
        targetType.setNameHasQuotes(sourceType.getNameHasQuotes());
        LogicalDatatype tlType = (LogicalDatatype)targetType.getDesign().getLogicalDatatypeSet().getByName(sourceType.getLogicalDataType().getName());
        targetType.setLogicalDataType(tlType);
        targetType.setSize(sourceType.getSize());
        targetType.setPrecision(sourceType.getPrecision());
        targetType.setScale(sourceType.getScale());
        targetType.setComment(sourceType.getComment());
        targetType.setCommentInRDBMS(sourceType.getCommentInRDBMS());
        targetType.setNotes(sourceType.getNotes());
    }

    private void processStructuredTypes(DataTypesDesign sourceDesign, DataTypesDesign targetDesign) {
        for (StructuredType sourceType : this.stList) {
            if (!sourceType.shouldBeMerge()) continue;
            this.processStructuredType(sourceType, sourceDesign, targetDesign);
            this.processElementTypes(sourceType);
            this.processMethods(sourceType);
        }
    }

    private void processStructuredType(StructuredType sourceType, DataTypesDesign sourceDesign, DataTypesDesign targetDesign) {
        StructuredType targetType = (StructuredType)this.incompleteTypes.get(sourceType.getObjectID());
        if (targetType != null) {
            this.copyPropertiesFromStrTypeToStrType(sourceType, targetType);
            if (this.notEmpty && sourceType != null) {
                this.moveGraphical(sourceDesign, targetDesign, (DesignObject)targetType, (DesignObject)sourceType);
            } else {
                ++this.count;
            }
        } else {
            targetType = (StructuredType)this.objectsMap.get(sourceType.getObjectID());
            if (targetType == null) {
                targetType = targetDesign.createStructuredType();
                targetType.setImportedId(sourceType.getObjectID());
                this.objectsMap.put(sourceType.getObjectID(), targetType);
                this.copyPropertiesFromStrTypeToStrType(sourceType, targetType);
                if (this.notEmpty) {
                    this.moveGraphical(sourceDesign, targetDesign, (DesignObject)targetType, (DesignObject)sourceType);
                } else {
                    ++this.count;
                }
            } else {
                PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceType.getObjectID() + targetType.getObjectID());
                if (prop instanceof StructuredTypeComparator) {
                    ((StructuredTypeComparator)prop).copySelectedProperties(this.objectsMap);
                }
            }
        }
    }

    private void copyPropertiesFromStrTypeToStrType(StructuredType sourceType, StructuredType targetType) {
        targetType.setName(sourceType.getName());
        targetType.setNameHasQuotes(sourceType.getNameHasQuotes());
        MergingCWDDesigns.copySourceStamp(sourceType, targetType);
        StructuredType s_parent = sourceType.getParentType();
        if (s_parent != null) {
            DTInheritance sinh;
            StructuredType superType = (StructuredType)this.objectsMap.get(s_parent.getObjectID());
            targetType.setParentType(superType, false);
            DTInheritance inh = targetType.getInheritanceRelation();
            if (inh != null && (sinh = sourceType.getInheritanceRelation()) != null) {
                this.objectsMap.put(sinh.getObjectID(), inh);
            }
        }
        targetType.setPredefined(sourceType.isPredefined());
        targetType.setFinal(sourceType.isFinal());
        targetType.setInstantiable(sourceType.isInstantiable());
        targetType.setHiveType(sourceType.getHiveType());
        targetType.setComment(sourceType.getComment());
        targetType.setNotes(sourceType.getNotes());
        sourceType.copyDynamicProperties(targetType);
    }

    private static void copySourceStamp(ModelObject source, ModelObject target) {
        if (source != null && target != null) {
            if (!"".equals(source.getSourceConnName()) && "".equals(target.getSourceConnName()) && MergingCWDDesigns.validTargetStamp(source, target)) {
                MergingCWDDesigns.setTargetDesignStamp(source, target);
                target.setSourceConnName(source.getSourceConnName());
                target.setSourceObjName(source.getSourceObjName());
                target.setSourceObjSchema(source.getSourceObjSchema());
            }
            if (!"".equals(source.getSourceDDLFile()) && "".equals(target.getSourceDDLFile())) {
                target.setSourceDDLFile(source.getSourceDDLFile());
            }
        }
    }

    private static boolean validTargetStamp(ModelObject source, ModelObject target) {
        if (source instanceof DesignObject && target instanceof DesignObject ? ((DesignObject)source).getDesignPart().equals(((DesignObject)target).getDesignPart()) : source instanceof StorageObject && target instanceof StorageObject && ((StorageObject)source).getStorageDesign().getPhysicalDesign().equals(((StorageObject)target).getStorageDesign().getPhysicalDesign())) {
            return false;
        }
        Class<?> srcClass = source.getClass();
        String srcIndexState = "";
        if (source instanceof Index) {
            srcIndexState = ((Index)source).getIndexState();
        }
        String srcConnName = source.getSourceConnName();
        String srcObjName = source.getSourceObjName();
        String srcObjSchema = source.getSourceObjSchema();
        RelationalDesign tgtDes = null;
        if (target instanceof DesignObject) {
            if (!(((DesignObject)target).getDesignPart() instanceof RelationalDesign)) {
                return true;
            }
            tgtDes = (RelationalDesign)((DesignObject)target).getDesignPart();
        } else if (target instanceof StorageObject) {
            tgtDes = ((StorageObject)target).getStorageDesign().getPhysicalDesign();
        }
        if (tgtDes != null) {
            List tgtObjs = tgtDes.getAllImportedObjects();
            for (int i = 0; i < tgtObjs.size(); ++i) {
                ModelObject tgtObj = (ModelObject)tgtObjs.get(i);
                if (!(source instanceof Index && tgtObj instanceof Index ? ((Index)tgtObj).getIndexState().equalsIgnoreCase(srcIndexState) && tgtObj.getSourceConnName().equalsIgnoreCase(srcConnName) && tgtObj.getSourceObjName().equalsIgnoreCase(srcObjName) && tgtObj.getSourceObjSchema().equalsIgnoreCase(srcObjSchema) : tgtObj.getClass().equals(srcClass) && tgtObj.getSourceConnName().equalsIgnoreCase(srcConnName) && tgtObj.getSourceObjName().equalsIgnoreCase(srcObjName) && tgtObj.getSourceObjSchema().equalsIgnoreCase(srcObjSchema))) continue;
                return false;
            }
        }
        return true;
    }

    private static void setTargetDesignStamp(ModelObject source, ModelObject target) {
        String srcConnName = source.getSourceConnName();
        RelationalDesign srcDes = null;
        RelationalDesign tgtDes = null;
        if (((DesignObject)source).getDesignPart() != null && ((DesignObject)source).getDesignPart() instanceof RelationalDesign) {
            if (source instanceof DesignObject && target instanceof DesignObject) {
                srcDes = (RelationalDesign)((DesignObject)source).getDesignPart();
                tgtDes = (RelationalDesign)((DesignObject)target).getDesignPart();
            } else if (source instanceof StorageObject && target instanceof StorageObject) {
                srcDes = ((StorageObject)source).getStorageDesign().getPhysicalDesign();
                tgtDes = ((StorageObject)target).getStorageDesign().getPhysicalDesign();
            }
            DBConnectionStamp stamp = srcDes.getImportConnectionStamp(srcDes.findImportConnectionStamp(srcConnName));
            if (stamp != null) {
                tgtDes.addImportConnectionStamp(stamp);
            }
        }
    }

    private void processElementTypes(StructuredType sourceType) {
        TypeElement[] sourceTypes = sourceType.getElements();
        for (int i = 0; i < sourceTypes.length; ++i) {
            TypeElementComparator comp;
            TypeElement sourceElem = sourceTypes[i];
            if (!sourceElem.shouldBeMerge()) continue;
            TypeElement targetElem = (TypeElement)this.objectsMap.get(sourceElem.getObjectID());
            StructuredType targetType = (StructuredType)this.objectsMap.get(sourceType.getObjectID());
            if (targetElem == null && targetType != null) {
                targetElem = targetType.createTypeElement(sourceElem.getName());
                targetElem.setImportedId(sourceElem.getObjectID());
                this.objectsMap.put(sourceElem.getObjectID(), targetElem);
                this.copyPropertiesFromTypeElemToTypeElem(sourceElem, targetElem);
                continue;
            }
            if (targetElem == null || (comp = (TypeElementComparator)this.comparatorsMap.get(sourceElem.getObjectID() + targetElem.getObjectID())) == null) continue;
            comp.copySelectedProperties();
        }
    }

    private void copyPropertiesFromTypeElemToTypeElem(TypeElement sourceElem, TypeElement targetElem) {
        DTReference srel;
        targetElem.setGeneratorID(sourceElem.getObjectID());
        targetElem.setName(sourceElem.getName());
        targetElem.setNameHasQuotes(sourceElem.getNameHasQuotes());
        MergingCWDDesigns.copyDataTypeFromDTO_To_DTO(sourceElem, targetElem);
        DTReference rel = targetElem.getReferenceRelation();
        if (rel != null && (srel = sourceElem.getReferenceRelation()) != null) {
            this.objectsMap.put(srel.getObjectID(), rel);
        }
        targetElem.setMandatory(sourceElem.isMandatory());
        targetElem.setComment(sourceElem.getComment());
        targetElem.setNotes(sourceElem.getNotes());
        sourceElem.copyDynamicProperties(targetElem);
    }

    public static void copyDataTypeFromDTO_To_DTO(DataTypeObject sourceElem, DataTypeObject targetElem) {
        Design targetDesign = targetElem.getDesign();
        DesignObject targetDT = null;
        DesignObject sourceDT = sourceElem.getType();
        if (sourceDT instanceof Domain) {
            boolean idUsed = false;
            targetDT = targetDesign.getDesignObject(sourceDT.getObjectID());
            if (targetDT != null) {
                idUsed = true;
                if (!(targetDT instanceof Domain)) {
                    targetDT = null;
                }
            }
            if (targetDT == null) {
                targetDT = CompareModelToModel.getCorrespondingObject(targetDesign.getDomainSet(), sourceDT);
            }
            if (targetDT == null) {
                LogicalDatatype ldt;
                Domain sourceDomain = (Domain)sourceDT;
                Domain targetDomain = targetDesign.getDomainSet().createDomain();
                targetDomain.setDesign(targetDesign);
                targetDomain.setOwnerDesign(targetDesign);
                sourceDomain.copyTo(targetDomain);
                if (!idUsed) {
                    targetDomain.setObjectID(sourceDomain.getObjectID());
                }
                if ((ldt = (LogicalDatatype)CompareModelToModel.getCorrespondingObject(targetDesign.getLogicalDatatypeSet(), sourceDomain.getLogicalDatatype())) != null) {
                    targetDomain.setLogicalDatatype(ldt);
                }
                targetDomain.setFileName(sourceDomain.getFileName());
                targetDomain.setDirty(true);
                targetDT = targetDomain;
            }
        } else if (sourceDT instanceof LogicalDatatype) {
            targetDT = targetDesign.getLogicalDatatypeSet().getByName(sourceDT.getName());
        } else if (sourceDT instanceof DistinctType) {
            targetDT = CompareModelToModel.getCorrespondingObject(targetDesign.getDataTypesDesign().getDistinctTypeSet(), sourceDT);
        } else if (sourceDT instanceof CollectionType) {
            targetDT = CompareModelToModel.getCorrespondingObject(targetDesign.getDataTypesDesign().getCollectionTypeSet(), sourceDT);
        } else if (sourceDT instanceof StructuredType) {
            targetDT = CompareModelToModel.getCorrespondingObject(targetDesign.getDataTypesDesign().getStructuredTypeSet(), sourceDT);
        }
        targetElem.setType(targetDT);
        targetElem.setSize(sourceElem.getSize());
        targetElem.setPrecision(sourceElem.getPrecision());
        targetElem.setScale(sourceElem.getScale());
        targetElem.setReference(sourceElem.isReference());
        if (targetElem instanceof TypeElement) {
            ((TypeElement)targetElem).updateReferenceNew();
        }
        MergingCWDDesigns.copySourceStamp((ModelObject)((Object)sourceElem), (ModelObject)((Object)targetElem));
    }

    private void processMethods(StructuredType sourceType) {
        StructuredType targetType = (StructuredType)this.objectsMap.get(sourceType.getObjectID());
        if (targetType != null) {
            Method[] sourceMethods = sourceType.getMethods();
            for (int i = 0; i < sourceMethods.length; ++i) {
                Method sourceMethod = sourceMethods[i];
                if (!sourceMethod.shouldBeMerge()) continue;
                Method targetMethod = (Method)this.objectsMap.get(sourceMethod.getObjectID());
                if (targetMethod == null) {
                    targetMethod = targetType.createMethod(sourceMethod.getName());
                    targetMethod.setImportedId(sourceMethod.getObjectID());
                    this.objectsMap.put(sourceMethod.getObjectID(), targetMethod);
                    this.processMethodParams(sourceMethod, targetMethod);
                    this.copyPropertiesFromMethodToMethod(sourceMethod, targetMethod);
                    continue;
                }
                this.processMethodParams(sourceMethod, targetMethod);
                PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceMethod.getObjectID() + targetMethod.getObjectID());
                if (!(comp instanceof MethodComparator)) continue;
                ((MethodComparator)comp).copySelectedProperties(this.objectsMap);
            }
        }
    }

    private void copyPropertiesFromMethodToMethod(Method sourceMethod, Method targetMethod) {
        targetMethod.setGeneratorID(sourceMethod.getObjectID());
        targetMethod.setName(sourceMethod.getName());
        targetMethod.setNameHasQuotes(sourceMethod.getNameHasQuotes());
        targetMethod.setConstructor(sourceMethod.isConstructor());
        targetMethod.setOverriding(sourceMethod.isOverriding());
        if (sourceMethod.getOverridedMethod() != null) {
            Method method = (Method)targetMethod.getDesign().getDataTypesDesign().getMethodSet().getByName(sourceMethod.getOverridedMethod().getName());
            targetMethod.setOverridedMethod(method);
        }
        if (sourceMethod.getReturnValue() != null) {
            MethodParam rv = new MethodParam(targetMethod.getDesignPart());
            sourceMethod.getReturnValue().copyDataType(rv);
            targetMethod.setReturnValue(rv);
        }
        targetMethod.setBody(sourceMethod.getBody());
        targetMethod.setComment(sourceMethod.getComment());
        targetMethod.setNotes(sourceMethod.getNotes());
        MergingCWDDesigns.copySourceStamp(sourceMethod, targetMethod);
    }

    private void processMethodParams(Method sourceMethod, Method targetMethod) {
        for (MethodParam sourceParam : sourceMethod.getParameters()) {
            if (!sourceParam.shouldBeMerge()) continue;
            MethodParam targetParam = (MethodParam)this.objectsMap.get(sourceParam.getObjectID());
            if (targetParam == null) {
                targetParam = targetMethod.createParameter(sourceParam.getName());
                targetParam.setImportedId(sourceParam.getObjectID());
                this.objectsMap.put(sourceParam.getObjectID(), targetParam);
                this.copyPropertiesFromMethodParamToMethodParam(sourceParam, targetParam);
                continue;
            }
            PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceParam.getObjectID() + targetParam.getObjectID());
            if (comp == null) continue;
            comp.copySelectedProperties();
        }
    }

    private void copyPropertiesFromMethodParamToMethodParam(MethodParam sourceParam, MethodParam targetParam) {
        targetParam.setGeneratorID(sourceParam.getObjectID());
        targetParam.setName(sourceParam.getName());
        targetParam.setNameHasQuotes(sourceParam.getNameHasQuotes());
        MergingCWDDesigns.copyDataTypeFromDTO_To_DTO(sourceParam, targetParam);
        targetParam.setDefaultValue(sourceParam.getDefaultValue());
        targetParam.setComment(sourceParam.getComment());
        targetParam.setNotes(sourceParam.getNotes());
        MergingCWDDesigns.copySourceStamp(sourceParam, targetParam);
    }

    private void processCollectionTypes(DataTypesDesign sourceDesign, DataTypesDesign targetDesign) {
        for (CollectionType sourceType : this.ctList) {
            this.processCollectionType(sourceType, sourceDesign, targetDesign);
        }
    }

    private void processCollectionType(CollectionType sourceType, DataTypesDesign sourceDesign, DataTypesDesign targetDesign) {
        CollectionType targetType = (CollectionType)this.incompleteTypes.get(sourceType.getObjectID());
        if (targetType != null) {
            this.copyPropertiesFromCollTypeToCollType(sourceType, targetType);
            ++this.count;
        } else {
            targetType = (CollectionType)this.objectsMap.get(sourceType.getObjectID());
            if (targetType == null) {
                targetType = targetDesign.createCollectionType();
                targetType.setImportedId(sourceType.getObjectID());
                this.objectsMap.put(sourceType.getObjectID(), targetType);
                this.copyPropertiesFromCollTypeToCollType(sourceType, targetType);
                ++this.count;
            } else {
                PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceType.getObjectID() + targetType.getObjectID());
                if (prop != null) {
                    prop.copySelectedProperties();
                }
            }
        }
    }

    private void copyPropertiesFromCollTypeToCollType(CollectionType sourceType, CollectionType targetType) {
        targetType.setGeneratorID(sourceType.getObjectID());
        targetType.setName(sourceType.getName());
        targetType.setNameHasQuotes(sourceType.getNameHasQuotes());
        targetType.setType(sourceType.getType());
        targetType.setMaxElement(sourceType.getMaxElement());
        sourceType.getElementType().copyDataType(targetType.getElementType());
        DesignObject stype = sourceType.getDataType();
        if (stype != null && stype instanceof Domain) {
            Domain sourceDomain = sourceType.getElementType().getDomain();
            Domain targetDomain = (Domain)CompareModelToModel.getCorrespondingObject(targetType.getDesign().getDomainSet(), sourceDomain);
            if (targetDomain != null) {
                targetType.getElementType().setType(targetDomain);
            } else {
                targetDomain = targetType.getDesign().getDomainSet().createDomain();
                targetDomain.setDesign(targetType.getDesign());
                targetDomain.setOwnerDesign(targetType.getDesign());
                sourceDomain.copyTo(targetDomain);
                LogicalDatatype ldt = (LogicalDatatype)CompareModelToModel.getCorrespondingObject(targetType.getDesign().getLogicalDatatypeSet(), sourceDomain.getLogicalDatatype());
                if (ldt != null) {
                    targetDomain.setLogicalDatatype(ldt);
                }
                targetDomain.setFileName(sourceDomain.getFileName());
                targetDomain.setDirty(true);
                targetType.getElementType().setType(targetDomain);
            }
        } else if (stype != null && !(stype instanceof LogicalDatatype)) {
            DesignObject ttype = (DesignObject)this.objectsMap.get(stype.getObjectID());
            targetType.getElementType().setType(ttype);
        }
        targetType.setComment(sourceType.getComment());
        targetType.setNotes(sourceType.getNotes());
        sourceType.copyDynamicProperties(targetType);
    }

    private void moveGraphical(DataTypesDesign dataTypes, DataTypesDesign newDataTypes, DesignObject newType, DesignObject type) {
        float square = (float)Math.sqrt(dataTypes.getStructuredTypeSet().size());
        this.maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        TopView topView = newType.getTopView();
        if (topView.getCellView() != null && type.getTopView() != null) {
            Dimension dim = type.getTopView().getSize();
            if (this.count == 0) {
                this.top += (int)dim.getHeight();
                this.left = 20;
            }
            ++this.count;
            this.width = (int)dim.getWidth();
            this.height = (int)Math.max(dim.getHeight(), (double)this.height);
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), type.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    private void importMappings(LogicalDesign ldesSource, ExtendedMap targetMap) {
        ExtendedMap extMap = ldesSource.getDesign().getExtendedMap();
        Iterator it = ldesSource.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity ent = (Entity)it.next();
            if (!ent.shouldBeMerge() || !this.importMapping(ent, extMap, targetMap)) continue;
            for (DesignObject dobj : ent.getElementsCollection()) {
                this.importMapping(dobj, extMap, targetMap);
            }
            KeyObject[] keys = ent.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                this.importMapping(keys[i], extMap, targetMap);
            }
        }
        it = ldesSource.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            if (!rel.shouldBeMerge()) continue;
            this.importMapping(rel, extMap, targetMap);
        }
        it = ldesSource.getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView view = (EntityView)it.next();
            if (!view.shouldBeMerge()) continue;
            this.importMapping(view, extMap, targetMap);
        }
    }

    private boolean importMapping(DesignObject dobj, ExtendedMap sourceMap, ExtendedMap targetMap) {
        boolean result = false;
        String sid = dobj.getObjectID();
        DesignObject target = (DesignObject)this.objectsMap.get(sid);
        if (dobj instanceof Attribute) {
            if (((Attribute)dobj).isFKAttribute()) {
                DesignObject newTarget;
                target = newTarget = targetMap.getDesign().getDesignObject(target.getObjectID());
            }
            if (target instanceof Attribute && ((Attribute)target).getContainer() == null) {
                target = null;
            }
        }
        if (target != null) {
            MappingCollector mc = sourceMap.getOrCreateCollector(dobj);
            for (XtdMapping mapping : mc.getAllMappings()) {
                if (mapping.isDeleted()) continue;
                if (mapping.isOwnerDesignPartLoaded() && mapping.isTargetDesignPartLoaded()) {
                    String id = mapping.getOtherID(sid);
                    DesignObject dobj2 = mapping.getObjectMappedTo(dobj);
                    DesignObject otherTarget = (DesignObject)this.objectsMap.get(id);
                    if (otherTarget == null && dobj2 != null && dobj2 instanceof Attribute && ((Attribute)dobj2).isFKAttribute()) {
                        otherTarget = targetMap.getDesign().getDesignObject(id);
                    }
                    if (otherTarget == null) continue;
                    XtdMapping tmapping = targetMap.getMapping(target, otherTarget);
                    result = true;
                    if (tmapping != null) continue;
                    targetMap.createMapping(target, otherTarget);
                    continue;
                }
                return false;
            }
        }
        return result;
    }

    private void scanForUsedTypes(DesignHandler designHandler, Design sourceDesign) {
        this.dtMap.clear();
        this.ctMap.clear();
        this.stMap.clear();
        this.dtList.clear();
        this.ctList.clear();
        this.stList.clear();
        this.types.clear();
        if (designHandler.isLogicalIsSelected()) {
            this.scanLogicalDesign(sourceDesign.getLogicalDesign());
        }
        for (String sourceDesID : designHandler.getSourceRelationalModels()) {
            RelationalDesign sourceDes = (RelationalDesign)designHandler.getSourceDesign().getRelationalDesigns().getById(sourceDesID);
            this.scanRelationalModel(sourceDes);
        }
        this.scanDataTypesModel(sourceDesign.getDataTypesDesign());
        this.types.addAll(this.ctList);
        this.types.addAll(this.stList);
        for (int step = 0; step < this.types.size(); ++step) {
            DesignObject dobj = (DesignObject)this.types.get(step);
            if (dobj instanceof CollectionType) {
                this.scanCollectionType((CollectionType)dobj);
                continue;
            }
            if (!(dobj instanceof StructuredType)) continue;
            this.scanStructuredType((StructuredType)dobj);
        }
    }

    private void scanForUsedTypes(RelationalDesign sourceRel, Design sourceDesign) {
        this.dtMap.clear();
        this.ctMap.clear();
        this.stMap.clear();
        this.dtList.clear();
        this.ctList.clear();
        this.stList.clear();
        this.types.clear();
        this.scanRelationalModel(sourceRel);
        this.scanDataTypesModel(sourceDesign.getDataTypesDesign());
        this.types.addAll(this.ctList);
        this.types.addAll(this.stList);
        for (int step = 0; step < this.types.size(); ++step) {
            DesignObject dobj = (DesignObject)this.types.get(step);
            if (dobj instanceof CollectionType) {
                this.scanCollectionType((CollectionType)dobj);
                continue;
            }
            if (!(dobj instanceof StructuredType)) continue;
            this.scanStructuredType((StructuredType)dobj);
        }
    }

    private void createIncompleteTypes(DataTypesDesign targetDesign) {
        DesignObject target;
        if (targetDesign.getStructuredTypeSet().size() > 1) {
            this.notEmpty = true;
        }
        this.incompleteTypes.clear();
        for (AbstractDTObject dt : this.dtList) {
            target = (DesignObject)this.objectsMap.get(dt.getObjectID());
            if (target != null) continue;
            target = targetDesign.createDistinctType();
            target.setImportedId(dt.getObjectID());
            this.objectsMap.put(dt.getObjectID(), target);
            this.incompleteTypes.put(dt.getObjectID(), target);
        }
        for (AbstractDTObject dt : this.ctList) {
            target = (DesignObject)this.objectsMap.get(dt.getObjectID());
            if (target != null) continue;
            target = targetDesign.createCollectionType();
            target.setImportedId(dt.getObjectID());
            this.objectsMap.put(dt.getObjectID(), target);
            this.incompleteTypes.put(dt.getObjectID(), target);
        }
        for (AbstractDTObject dt : this.stList) {
            target = null;
            String stName = dt.getName();
            if (stName.equalsIgnoreCase("SDO_GEOMETRY") || stName.equalsIgnoreCase("XMLTYPE")) {
                target = targetDesign.getStructuredTypeSet().getByName(stName.toUpperCase());
                if (target != null) {
                    this.objectsMap.put(dt.getObjectID(), target);
                    this.incompleteTypes.put(dt.getObjectID(), target);
                }
            } else {
                target = (DesignObject)this.objectsMap.get(dt.getObjectID());
            }
            if (target != null) continue;
            target = targetDesign.createStructuredType();
            target.setImportedId(dt.getObjectID());
            this.objectsMap.put(dt.getObjectID(), target);
            this.incompleteTypes.put(dt.getObjectID(), target);
        }
    }

    private void scanCollectionType(CollectionType ct) {
        DesignObject dataType = ct.getElementType().getType();
        this.processDataType(dataType);
    }

    private void scanStructuredType(StructuredType st) {
        StructuredType super_t = st.getParentType();
        if (super_t != null && !this.stMap.containsKey(super_t.getObjectID())) {
            this.stMap.put(super_t.getObjectID(), super_t);
            this.stList.add(super_t);
            this.types.add(super_t);
        }
        this.scanST_Attributes(st);
        this.scanST_Methods(st);
    }

    private void processDataType(DesignObject dataType) {
        if (dataType instanceof CollectionType) {
            if (!this.ctMap.containsKey(dataType.getObjectID())) {
                this.ctMap.put(dataType.getObjectID(), dataType);
                this.ctList.add(dataType);
                this.types.add(dataType);
            }
        } else if (dataType instanceof StructuredType && !this.stMap.containsKey(dataType.getObjectID())) {
            this.stMap.put(dataType.getObjectID(), dataType);
            this.stList.add(dataType);
            this.types.add(dataType);
        }
    }

    private void scanST_Attributes(StructuredType st) {
        TypeElement[] elems = st.getElements();
        for (int i = 0; i < elems.length; ++i) {
            DesignObject dataType = elems[i].getType();
            this.processDataType(dataType);
        }
    }

    private void scanST_Methods(StructuredType st) {
        Method[] methods = st.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            DesignObject dataType;
            for (MethodParam par : methods[i].getParameters()) {
                dataType = par.getType();
                this.processDataType(dataType);
            }
            MethodParam ret = methods[i].getReturnValue();
            if (ret == null) continue;
            dataType = ret.getType();
            this.processDataType(dataType);
        }
    }

    private void scanLogicalDesign(LogicalDesign ldes) {
        Iterator it = ldes.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            if (!entity.shouldBeMerge()) continue;
            if (entity.getBasedOnStructuredType() != null) {
                StructuredType st = entity.getBasedOnStructuredType();
                if (this.stMap.containsKey(entity.getObjectID())) continue;
                this.stMap.put(entity.getObjectID(), st);
                this.stList.add(st);
                continue;
            }
            this.scanContainedElements(entity);
        }
    }

    private void scanContainedElements(ContainerWithKeyObject container) {
        for (ContainedObjectWithDomain co : container.getElementsCollection()) {
            DistinctType dt;
            if (co.getUse() == 3) {
                StructuredType st = co.getStructuredType();
                if (st == null || this.stMap.containsKey(st.getObjectID())) continue;
                this.stMap.put(st.getObjectID(), st);
                this.stList.add(st);
                continue;
            }
            if (co.getUse() == 4) {
                CollectionType ct = co.getCollectionType();
                if (ct == null || this.ctMap.containsKey(ct.getObjectID())) continue;
                this.ctMap.put(ct.getObjectID(), ct);
                this.ctList.add(ct);
                continue;
            }
            if (co.getUse() != 2 || (dt = co.getDistinctType()) == null || this.dtMap.containsKey(dt.getObjectID())) continue;
            this.dtMap.put(dt.getObjectID(), dt);
            this.dtList.add(dt);
        }
    }

    private void scanRelationalModel(RelationalDesign pdes) {
        Iterator it = pdes.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            if (!table.shouldBeMerge()) continue;
            if (table.getBasedOnStructuredType() != null) {
                StructuredType st = table.getBasedOnStructuredType();
                if (st == null || this.stMap.containsKey(table.getObjectID())) continue;
                this.stMap.put(table.getObjectID(), st);
                this.stList.add(st);
                continue;
            }
            this.scanContainedElements(table);
        }
    }

    private void scanDataTypesModel(DataTypesDesign tdes) {
        Iterator it = tdes.getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType dt = (DistinctType)it.next();
            if (dt == null || !dt.shouldBeMerge() || this.dtMap.containsKey(dt.getObjectID())) continue;
            this.dtMap.put(dt.getObjectID(), dt);
            this.dtList.add(dt);
        }
        it = tdes.getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType ct = (CollectionType)it.next();
            if (ct == null || !ct.shouldBeMerge() || this.ctMap.containsKey(ct.getObjectID())) continue;
            this.ctMap.put(ct.getObjectID(), ct);
            this.ctList.add(ct);
            if (!(ct.getElementType().getType() instanceof StructuredType)) continue;
        }
        it = tdes.getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st == null || this.stMap.containsKey(st.getObjectID())) continue;
            this.stMap.put(st.getObjectID(), st);
            this.stList.add(st);
        }
    }

    public void processDataTypesDesign(RelationalDesign sourceRel, RelationalDesign targetRel, Map comparatorsMap, Map objectsMap) {
        this.comparatorsMap = comparatorsMap;
        this.objectsMap = objectsMap;
        this.resetAllObjects();
        Design sdes = sourceRel.getDesign();
        Design tdes = targetRel.getDesign();
        DataTypesDesign targetDTD = tdes.getDataTypesDesign();
        DataTypesDesign sourceDTD = sdes.getDataTypesDesign();
        boolean empty = targetDTD.getMainView().getTopViews().size() == 0;
        this.scanForUsedTypes(sourceRel, sourceRel.getDesign());
        this.createIncompleteTypes(tdes.getDataTypesDesign());
        this.processDistinctTypes(sdes.getDataTypesDesign(), tdes.getDataTypesDesign());
        Rectangle2D rec = targetDTD.getMainView().getWorkSpace().getDiagramBounds();
        if (rec != null) {
            this.top = (int)rec.getHeight();
        }
        this.processCollectionTypes(sourceDTD, targetDTD);
        this.processStructuredTypes(sourceDTD, targetDTD);
        this.processNotes(sourceDTD, targetDTD);
        DesignPartView s_mainView = sourceDTD.getMainView();
        DesignPartView t_mainView = targetDTD.getMainView();
        DesignPartView.copyDisplayDrawingProperties(s_mainView, t_mainView);
        if (empty) {
            MergingCWDDesigns.copyDisplayTopViews(s_mainView, t_mainView, objectsMap);
        }
    }

    private void processTypeSubstitutionsR(RelationalDesign sourceDesignPart) {
        Iterator it = sourceDesignPart.getTableSet().iterator();
        while (it.hasNext()) {
            Table sourceTable = (Table)it.next();
            this.processTypeSubstitution(sourceTable);
        }
        it = sourceDesignPart.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView sourceTableView = (TableView)it.next();
            this.processTypeSubstitution(sourceTableView);
        }
    }

    private void processTypeSubstitutionsL(LogicalDesign sourceDesignPart) {
        Iterator it = sourceDesignPart.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity sourceEntity = (Entity)it.next();
            this.processTypeSubstitution(sourceEntity);
        }
        it = sourceDesignPart.getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView sourceEntityView = (EntityView)it.next();
            this.processTypeSubstitution(sourceEntityView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTypeSubstitution(ContainerObject table) {
        ContainerObject target;
        TypeSubstitution sourceTS;
        if (table.shouldBeMerge() && (sourceTS = table.getTypeSubstitution()) != null && (target = (ContainerObject)this.objectsMap.get(table.getObjectID())) != null) {
            DesignPartView ldpv = target.getDesignPart().getMainView();
            ContainerObject tab = table.getTypeSubstitution().getParentContainerObject();
            ContainerObject ent = null;
            if (target.getTypeSubstitution() == null && (ent = (ContainerObject)this.objectsMap.get(tab.getObjectID())) != null) {
                boolean loading = ApplicationView.loading;
                try {
                    ApplicationView.loading = true;
                    TypeSubstitution ts = null;
                    DesignPart targetDesignPart = target.getDesignPart();
                    if (targetDesignPart instanceof RelationalDesign) {
                        ts = ((RelationalDesign)targetDesignPart).createTypeSubstitution();
                    } else if (targetDesignPart instanceof LogicalDesign) {
                        ts = ((LogicalDesign)targetDesignPart).createTypeSubstitution();
                    }
                    if (ts != null) {
                        this.objectsMap.put(sourceTS.getObjectID(), ts);
                        ContainerView childTV = (ContainerView)target.getFirstViewForDPV(ldpv);
                        ContainerView parentTV = (ContainerView)ent.getFirstViewForDPV(ldpv);
                        ts.setChildCV(childTV);
                        ts.setParentCV(parentTV);
                        ts.addToAllDPVs();
                    }
                }
                finally {
                    ApplicationView.loading = loading;
                }
            }
        }
    }

    private void copyScope(List list) {
        for (ContainedObject co : list) {
            this.setContainedScope(co);
        }
    }

    public void setContainedScope(ContainedObject sourceColumn) {
        ContainedObject targetColumn;
        ContainerObject tTable;
        ContainerObject sTable = sourceColumn.getScope();
        if (sTable != null && (tTable = (ContainerObject)this.objectsMap.get(sTable.getObjectID())) != null && (targetColumn = (ContainedObject)this.objectsMap.get(sourceColumn.getObjectID())) != null) {
            targetColumn.setScopeId(tTable.getObjectID());
        }
    }
}

