/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;

public abstract class COPropertiesComparator
extends PropertiesComparator {
    private ContainedObjectWithDomain left_co;
    private ContainedObjectWithDomain right_co;

    public COPropertiesComparator(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        super(left_co, right_co);
        this.left_co = left_co;
        this.right_co = right_co;
    }

    public static String decodeDataTypeKindToString(short use) {
        if (use == 0) {
            return Messages.getString("COPropertiesComparator.Domain");
        }
        if (use == 1) {
            return Messages.getString("COPropertiesComparator.LogicalType");
        }
        if (use == 2) {
            return Messages.getString("COPropertiesComparator.DistinctType");
        }
        if (use == 3) {
            return Messages.getString("COPropertiesComparator.StructuredType");
        }
        if (use == 4) {
            return Messages.getString("COPropertiesComparator.CollectionType");
        }
        return "";
    }

    public static String getType(ContainedObjectWithDomain co) {
        String type = co.getDesign().getDomainSet().getDefaultDomain().getDataType().toString();
        short use = co.getUse();
        if (use == 0 && co.getDomain() != null) {
            type = co.getDomain().getName();
        } else if (use == 1) {
            type = co.getLogicalDatatype().getName();
        } else if (use == 2) {
            if (co.getDistinctType() != null) {
                type = co.getDistinctType().getName();
            }
        } else if (use == 3) {
            if (co.getStructuredType() != null) {
                type = co.isReference() ? "REF " + co.getStructuredType().getName() : co.getStructuredType().getName();
            }
        } else if (use == 4 && co.getCollectionType() != null) {
            type = co.getCollectionType().getName();
        }
        return type;
    }

    @Override
    protected void initPropertiesList() {
        EngPropertyHolder cnPH;
        this.initNameProperty();
        EngCOPropertiesComparator.processDataTypeAndUse(this.propertiesList, this.left_co, this.right_co);
        PropertyHolder ph = new PropertyHolder(MANDATORY);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.left_co != null ? String.valueOf(!this.left_co.getNullsAllowed()) : "");
        ph.setRightValue(this.right_co != null ? String.valueOf(!this.right_co.getNullsAllowed()) : "");
        if (this.isExcludedFromComparison(MANDATORY)) {
            ph.setExcluded(true);
        } else if (this.left_co != null && this.right_co != null && this.left_co.getNullsAllowed() != this.right_co.getNullsAllowed()) {
            if (this.left_co.isFKElement() && this.right_co.isFKElement()) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setRightValue(ph.getRightValue() + "(FK)");
            } else {
                ph.setModified(true);
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
        if (this.left_co != null && this.left_co instanceof Column && this.right_co != null && this.right_co instanceof Column) {
            String rname;
            Column lcol = (Column)this.left_co;
            Column rcol = (Column)this.right_co;
            ph = new PropertyHolder(NNC_NAME);
            ph.setDDLHolder(true);
            String lname = lcol.getNotNullConstraintName();
            if (lname == null) {
                lname = "";
            }
            if ((rname = rcol.getNotNullConstraintName()) == null) {
                rname = "";
            }
            ph.setLeftValue(lname);
            ph.setRightValue(rname);
            if (this.isExcludedFromComparison(NNC_NAME)) {
                ph.setExcluded(true);
            } else if (!(lname.equalsIgnoreCase(rname) || "".equals(lname) && rname.startsWith("SYS_") || "".equals(rname) && lname.startsWith("SYS_"))) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(DEFAULT_VALUE);
        ph.setDDLHolder(true);
        String leftValue = this.left_co != null ? this.left_co.getDefaultValue().replaceAll("'", "") : "";
        String rightValue = this.right_co != null ? this.right_co.getDefaultValue().replaceAll("'", "") : "";
        ph.setLeftValue(leftValue);
        ph.setRightValue(rightValue);
        if (this.left_co != null && this.right_co != null && !leftValue.trim().equals(rightValue.trim())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        boolean usename = true;
        if (this.left_co != null && this.right_co != null && this.left_co.getUseDomainConstraints() && PropertiesComparator.DDL_ONLY) {
            usename = false;
        }
        if (this.isExcludedFromComparison((cnPH = EngCOPropertiesComparator.createCheckConstrNamePH(this.left_co, this.right_co)).getName())) {
            cnPH.setExcluded(true);
        }
        this.propertiesList.add(cnPH);
        if (!PropertiesComparator.DDL_ONLY) {
            ph = new PropertyHolder(EngPropertiesComparator.USE_DOMAIN_CONSTRAINT);
            ph.setLeftValue(this.left_co != null ? String.valueOf(this.left_co.getUseDomainConstraints()) : "");
            ph.setRightValue(this.right_co != null ? String.valueOf(this.right_co.getUseDomainConstraints()) : "");
            if (this.isExcludedFromComparison(USE_DOMAIN_CONSTRAINT)) {
                ph.setExcluded(true);
            } else if (this.left_co != null && this.right_co != null && this.left_co.getUseDomainConstraints() != this.right_co.getUseDomainConstraints()) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        if (this.left_co != null && !this.left_co.getUseDomainConstraints() || this.right_co != null && !this.right_co.getUseDomainConstraints()) {
            EngPropertyHolder ccPH = EngCOPropertiesComparator.createCheckConstrPH(this.left_co, this.right_co);
            EngPropertyHolder rcPH = EngCOPropertiesComparator.createRangeConstrPH(this.left_co, this.right_co);
            EngPropertyHolder vcPH = EngCOPropertiesComparator.createLOVConstraintPH(this.left_co, this.right_co);
            if ((ccPH.isModified() || rcPH.isModified() || vcPH.isModified()) && EngCOPropertiesComparator.isConstrCondConsistent(this.left_co, this.right_co)) {
                ccPH.setSelected(false);
                rcPH.setSelected(false);
                vcPH.setSelected(false);
            }
            if (this.isExcludedFromComparison(ccPH.getName())) {
                ccPH.setExcluded(true);
            }
            if (this.isExcludedFromComparison(rcPH.getName())) {
                rcPH.setExcluded(true);
            }
            if (this.isExcludedFromComparison(vcPH.getName())) {
                vcPH.setExcluded(true);
            }
            this.propertiesList.add(ccPH);
            this.propertiesList.add(rcPH);
            this.propertiesList.add(vcPH);
        }
        if (!PropertiesComparator.DDL_ONLY && this.left_co != null && this.left_co instanceof Column && this.right_co != null && this.right_co instanceof Column) {
            ph = new PropertyHolder(GEN_CHECK_CONSTRAINT_IN_DDL);
            ph.setDDLHolder(true);
            ph.setLeftValue(((Column)this.left_co).getGenerateConstraintInDDL());
            ph.setRightValue(((Column)this.right_co).getGenerateConstraintInDDL());
            if (this.isExcludedFromComparison(GEN_CHECK_CONSTRAINT_IN_DDL)) {
                ph.setExcluded(true);
            } else {
                ph.setModified(false);
                ph.setSelected(false);
            }
            this.propertiesList.add(ph);
        }
        this.initCommentsAndNotes();
        if (!PropertiesComparator.DDL_ONLY) {
            ph = new PropertyHolder(SOURCE_TYPE);
            ph.setLeftValue(this.left_co != null ? this.left_co.getSourceType() : "");
            ph.setRightValue(this.right_co != null ? this.right_co.getSourceType() : "");
            if (this.isExcludedFromComparison(SOURCE_TYPE)) {
                ph.setExcluded(true);
            } else if (this.left_co != null && this.right_co != null && !this.left_co.getSourceType().equals(this.right_co.getSourceType())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        if (this.left_co instanceof Column || this.right_co instanceof Column) {
            ph = new PropertyHolder(COMPUTED);
            ph.setLeftValue(this.left_co != null ? String.valueOf(((Column)this.left_co).isComputed()) : "");
            ph.setRightValue(this.right_co != null ? String.valueOf(((Column)this.right_co).isComputed()) : "");
            if (this.isExcludedFromComparison(COMPUTED)) {
                ph.setExcluded(true);
            } else if (this.left_co != null && this.right_co != null && !((Column)this.left_co).isComputed().equals(((Column)this.right_co).isComputed())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(FORMULA_DESC);
        ph.setLeftValue(this.left_co != null ? this.left_co.getFormulaDesc() : "");
        ph.setRightValue(this.right_co != null ? this.right_co.getFormulaDesc() : "");
        if (this.isExcludedFromComparison(FORMULA_DESC)) {
            ph.setExcluded(true);
        } else if (this.left_co != null && this.right_co != null && !this.left_co.getFormulaDesc().equals(this.right_co.getFormulaDesc())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TYPE_SUBSTITUTION);
        ph.setLeftValue(this.left_co != null ? String.valueOf(this.left_co.isAllowSubtypeSubstitution()) : "");
        ph.setRightValue(this.right_co != null ? String.valueOf(this.right_co.isAllowSubtypeSubstitution()) : "");
        if (this.isExcludedFromComparison(TYPE_SUBSTITUTION)) {
            ph.setExcluded(true);
        } else if (this.left_co != null && this.right_co != null && this.left_co.isAllowSubtypeSubstitution() != this.right_co.isAllowSubtypeSubstitution()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_co != null && this.right_co != null) {
            this.right_co.setTemporaryWriteable(true);
            super.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(DATA_TYPE) || ph.getName().equals(DATA_TYPE_KIND) || ph.getName().equals(NATIVE_DATA_TYPE)) {
                    MergingModels.copyDataTypeFromCOWD_To_COWD(this.left_co, this.right_co, true);
                    continue;
                }
                if (ph.getName().equals(TYPE_SUBSTITUTION)) {
                    this.right_co.setAllowSubtypeSubstitution(this.left_co.isAllowSubtypeSubstitution());
                    this.right_co.setRestrictedTypeSubstitution(this.left_co.isRestrictedTypeSubstitution());
                    continue;
                }
                if (ph.getName().equals(MANDATORY)) {
                    this.right_co.setNullsAllowed(this.left_co.getNullsAllowed());
                    continue;
                }
                if (ph.getName().equals(NNC_NAME) && this.right_co instanceof Column && this.left_co instanceof Column) {
                    ((Column)this.right_co).setNotNullConstraintName(((Column)this.left_co).getNotNullConstraintName());
                    continue;
                }
                if (ph.getName().equals(GEN_CHECK_CONSTRAINT_IN_DDL) && this.right_co instanceof Column && this.left_co instanceof Column) {
                    ((Column)this.right_co).setGenerateConstraintInDDL(((Column)this.left_co).getGenerateConstraintInDDL());
                    continue;
                }
                if (ph.getName().equals(DEFAULT_VALUE)) {
                    this.right_co.setDefaultValue(this.left_co.getDefaultValue());
                    continue;
                }
                if (ph.getName().equals(USES_DEFUALT_VALUE)) {
                    this.right_co.setUsesDefaultValue(this.left_co.getUsesDefaultValue());
                    continue;
                }
                if (ph.getName().equals(SOURCE_TYPE)) {
                    this.right_co.setSourceType(this.left_co.getSourceType());
                    continue;
                }
                if (ph.getName().equals(COMPUTED)) {
                    ((Column)this.right_co).setComputed(((Column)this.left_co).isComputed());
                    continue;
                }
                if (ph.getName().equals(FORMULA_DESC)) {
                    this.right_co.setFormulaDesc(this.left_co.getFormulaDesc());
                    continue;
                }
                if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                    this.right_co.setConstraintName(this.left_co.getConstraintName());
                    continue;
                }
                if (ph.getName().equals(EngPropertiesComparator.USE_DOMAIN_CONSTRAINT)) {
                    this.right_co.setUseDomainConstraints(this.left_co.getUseDomainConstraints());
                    continue;
                }
                if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT)) {
                    EngCOPropertiesComparator.copyCheckConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (ph.getName().equals(EngPropertiesComparator.RANGE_CONSTRAINT)) {
                    EngCOPropertiesComparator.copyRangeConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (!ph.getName().equals(EngPropertiesComparator.LOV_CONSTRAINT)) continue;
                EngCOPropertiesComparator.copyLOVConstraint(this.left_co, this.right_co);
            }
            this.copySelectedDynamicProperties();
            this.right_co.setTemporaryWriteable(false);
        }
    }
}

