/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.ApplyAttributesNamingStandards;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public abstract class ContainerWithKeyObject
extends ContainerObject {
    private KeyObject primaryKey = null;
    private KeyObjectSet keys;
    private String typeID = "";
    private List<String> additionalClassificationTypes;

    public ContainerWithKeyObject(DesignPart designPart) {
        super(designPart);
    }

    public abstract KeyObject createKeyObject(String var1);

    public KeyObject createKeyObject() {
        return this.createKeyObject(null);
    }

    public void add(KeyObject key) {
        boolean isPK = key.isPK();
        key.setContainerObject(this);
        this.getKeySet().add(key);
        key.setDesign(this.getDesign());
        this.assignLocalID(key);
        if (!this.isBackup()) {
            this.getDesign().addDesignObject(key);
        }
        if (!this.getDesign().isLoading()) {
            this.setDirty(true);
        }
        this.sharedEvent.setElement(key);
        this.sharedEvent.setType(5);
        this.fireChange(this.sharedEvent);
        if (isPK) {
            key.setPK(isPK);
        }
    }

    @Override
    public void remove() {
        StructuredType st = this.getBasedOnStructuredType();
        if (st != null) {
            st.removeObjectListener(this);
        }
        this.removeAllKeys();
        super.remove();
    }

    @Override
    public void clearAll() {
        this.removeAllKeys();
        super.clearAll();
    }

    public void removeAllKeys() {
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
    }

    public void remove(KeyObject key) {
        this.getKeySet().remove(key);
        this.getDesign().removeDesignObject(key);
        if (key == this.primaryKey) {
            this.primaryKey = null;
        }
        if (!key.isRemoved()) {
            key.remove();
        }
        key.setContainerObject(null);
        this.sharedEvent.setElement(key);
        this.sharedEvent.setType(4);
        this.fireChange(this.sharedEvent);
    }

    public KeyObject[] getKeysWith(ContainedObject[] contained) {
        return this.getKeysWith(Arrays.asList(contained));
    }

    public KeyObject[] getKeysWith(Collection containedObjects) {
        HashSet<KeyObject> set = new HashSet<KeyObject>();
        KeyObjectSet keys = this.getKeySet();
        Iterator it = keys.iterator();
        int size = containedObjects.size();
        if (size > 0) {
            while (it.hasNext()) {
                KeyObject key = (KeyObject)it.next();
                if (!key.containsAll(containedObjects)) continue;
                set.add(key);
            }
        }
        return (KeyObject[])set.toArray(keys.getProtoTypeArray());
    }

    public final KeyObjectSet getKeySet() {
        if (this.keys == null) {
            this.keys = this.createKeySet();
            this.keys.setDesign(this.getDesign());
            this.keys.setParentContainer(this);
        }
        return this.keys;
    }

    protected abstract KeyObjectSet createKeySet();

    public KeyObject[] getKeys() {
        return (KeyObject[])this.getKeySet().toArray();
    }

    public abstract KeyObject[] getKeyArrayPrototype();

    public void setPK(KeyObject key) {
        if (this.primaryKey != key) {
            this.primaryKey = key;
            ObjectChangeEvent event = ObjectChangeEvent.PK_CHANGED;
            event.setAffected(key);
            this.fireChange(event);
            event.setAffected(null);
        }
    }

    public KeyObject getPK() {
        return this.primaryKey;
    }

    public KeyObject getPKorUnique() {
        if (this.primaryKey != null) {
            return this.primaryKey;
        }
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isUnique()) continue;
            return keys[i];
        }
        return null;
    }

    public boolean hasPK() {
        return this.getPK() != null;
    }

    public boolean hasUnique() {
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isUnique()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPKorUK_Constraint() {
        return this.hasPK() || this.hasUnique();
    }

    public boolean isValid() {
        return this.size() > 0 && this.hasPK() && this.getPK().isValidPK();
    }

    public KeyObject getKeyGeneratedBy(DesignObject object) {
        return this.getKeyGeneratedBy(object.getObjectID());
    }

    public KeyObject getKeyGeneratedBy(String generatorID) {
        KeyObject[] keyArray = this.getKeys();
        for (int i = 0; i < keyArray.length; ++i) {
            if (!generatorID.equals(keyArray[i].getGeneratorID())) continue;
            return keyArray[i];
        }
        return null;
    }

    public int getNumberOfKeys() {
        return this.keys.size();
    }

    public int countRelationsWith(ContainerWithKeyObject other) {
        return 0;
    }

    public int countRelations() {
        return 0;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 1;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index < super.getNumberOfChildren()) {
            return super.getChild(index);
        }
        return this.getKeySet();
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.keys) {
            return this.getNumberOfChildren();
        }
        return super.getIndexForChild(child);
    }

    public KeyObject getKeyObject(String id) {
        return (KeyObject)this.getKeySet().getObjectByID(id);
    }

    public void setPKName(String pkName) {
    }

    public String getPKName() {
        KeyObject pk = this.getPK();
        if (pk != null) {
            return pk.getName();
        }
        return "";
    }

    public ContainedObjectWithDomain getExactRefToStructurtedType(StructuredType type, ContainerObject cont) {
        ArrayList<ContainedObjectWithDomain> list = new ArrayList<ContainedObjectWithDomain>();
        for (ContainedObjectWithDomain cod : this.getElementsAndNestedElementsCollection()) {
            ContainerWithKeyObject scope;
            if (cod.isOid() || !cod.isExactRefToStructuredType(type)) continue;
            if (cod.getScopeId() != null && (scope = (ContainerWithKeyObject)this.getDesign().getDesignObject(cod.getScopeId())) != null && scope.isBST() && scope.getBasedOnStructuredType() == type && scope == cont) {
                return cod;
            }
            list.add(cod);
        }
        for (ContainedObjectWithDomain cod : list) {
            if (cod.getScopeId() != null) continue;
            return cod;
        }
        if (list.size() > 0) {
            return (ContainedObjectWithDomain)list.get(0);
        }
        return null;
    }

    public ContainedObjectWithDomain getRefToStructurtedType(StructuredType type, ContainerObject cont) {
        ArrayList<ContainedObjectWithDomain> list = new ArrayList<ContainedObjectWithDomain>();
        for (ContainedObjectWithDomain cod : this.getElementsAndNestedElementsCollection()) {
            ContainerWithKeyObject scope;
            if (cod.isOid() || !cod.isRefToStructuredType(type)) continue;
            if (cod.getScopeId() != null && (scope = (ContainerWithKeyObject)this.getDesign().getDesignObject(cod.getScopeId())) != null && scope.isBST() && scope.getBasedOnStructuredType() == type && scope == cont) {
                return cod;
            }
            list.add(cod);
        }
        for (ContainedObjectWithDomain cod : list) {
            if (cod.getScopeId() != null) continue;
            return cod;
        }
        if (list.size() > 0) {
            return (ContainedObjectWithDomain)list.get(0);
        }
        return null;
    }

    public KeyObject getFirstFK() {
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isFK()) continue;
            return key;
        }
        return null;
    }

    public void updateDeletedMappings(String oldContainerID, String recreatedID, String designPartID) {
        XtdMapping mapping;
        for (DesignObject co : this.getElementsCollection()) {
            mapping = ((ContainedObject)co).getDeletedMapping(oldContainerID, designPartID);
            if (mapping == null) continue;
            mapping.setRecreatedContainerID(recreatedID);
        }
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            DesignObject co;
            co = (KeyObject)it.next();
            mapping = ((KeyObject)co).getDeletedMapping(oldContainerID, designPartID);
            if (mapping == null) continue;
            mapping.setRecreatedContainerID(recreatedID);
        }
    }

    @Override
    public void setTypeSubstitution(TypeSubstitution typeSubstitution) {
        TypeSubstitution old = this.getTypeSubstitution();
        super.setTypeSubstitution(typeSubstitution);
        if (typeSubstitution != null) {
            KeyObject pk = this.getPK();
            if (pk != null) {
                pk.remove();
            }
        } else if (old != null) {
            KeyObject key = this.createKeyObject();
            ContainedObject co = this.getOidElement();
            key.setPK(true);
            if (co != null) {
                key.add(co);
            }
            NamingStandardRule nsr = this.getDesign().getDesignLevelSettings().getNamingStandardRule();
            if (this instanceof Table) {
                key.setName(ApplyNamingStandards.createPK_Name(this.getName(), nsr, this.getDesignPart().getName(), ((Table)this).getAbbreviation()));
            } else if (this instanceof Entity) {
                key.setName(ApplyAttributesNamingStandards.createPrimaryIdentifierName(this.getName(), ((Entity)this).getShortName(), nsr));
            }
            key.setOidKey(true);
        }
    }

    public String getTypeID() {
        return this.typeID;
    }

    public void setTypeID(String id) {
        this.typeID = id;
    }

    public ClassificationType getClassificationType() {
        if (!"".equals(this.typeID)) {
            return this.getDesign().getDesignLevelSettings().getClassificationTypeByID(this.typeID);
        }
        return null;
    }

    public String getClassificationTypeName() {
        ClassificationType ct = this.getClassificationType();
        if (ct != null) {
            return ct.getTypeName();
        }
        return "";
    }

    public List<ClassificationType> getAllClassificationTypes() {
        if (!"".equals(this.getTypeID()) || this.getAdditionalClassificationTypes().size() > 0) {
            ClassificationType ct;
            ArrayList<ClassificationType> list = new ArrayList<ClassificationType>();
            if (!"".equals(this.getTypeID()) && (ct = this.getDesign().getDesignLevelSettings().getClassificationTypeByID(this.getTypeID())) != null) {
                list.add(ct);
            }
            for (String id : this.getAdditionalClassificationTypes()) {
                ClassificationType ct2 = this.getDesign().getDesignLevelSettings().getClassificationTypeByID(id);
                if (ct2 == null) continue;
                list.add(ct2);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List<ClassificationType> getAdd_ClassificationTypes() {
        if (this.getAdditionalClassificationTypes().size() > 0) {
            ArrayList<ClassificationType> list = new ArrayList<ClassificationType>();
            for (String id : this.getAdditionalClassificationTypes()) {
                ClassificationType ct = this.getDesign().getDesignLevelSettings().getClassificationTypeByID(id);
                if (ct == null) continue;
                list.add(ct);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List<String> getAdd_ClassificationTypeNames() {
        List<ClassificationType> list = this.getAdd_ClassificationTypes();
        if (list.size() > 0) {
            ArrayList<String> res = new ArrayList<String>();
            for (ClassificationType ct : list) {
                res.add(ct.getTypeName());
            }
            return res;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasKey(KeyObject key) {
        return this.getKeySet().contains(key);
    }

    public KeyObject getOidKey() {
        if (this.isBST()) {
            Iterator it = this.getKeySet().iterator();
            while (it.hasNext()) {
                KeyObject key = (KeyObject)it.next();
                if (!key.isOidKey()) continue;
                return key;
            }
        }
        return null;
    }

    public List<String> getAdditionalClassificationTypes() {
        if (this.additionalClassificationTypes == null) {
            this.additionalClassificationTypes = new ArrayList<String>();
        }
        return this.additionalClassificationTypes;
    }

    public void setAdditionalClassificationTypes(List<String> additionalClassificationTypes) {
        this.additionalClassificationTypes = additionalClassificationTypes;
    }

    public String getAdditionalClassificationTypesRefs() {
        if (this.getAdditionalClassificationTypes().size() > 0) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (String id : this.getAdditionalClassificationTypes()) {
                if (first) {
                    sb.append(id);
                    first = false;
                    continue;
                }
                sb.append(',').append(id);
            }
            return sb.toString();
        }
        return "";
    }

    public void setAdditionalClassificationTypesRefs(String refs) {
        if (refs != null) {
            this.getAdditionalClassificationTypes().clear();
            String[] ids = refs.split(",");
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                this.getAdditionalClassificationTypes().add(id);
            }
        }
    }

    public List getUniqueKeysList() {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isUnique()) continue;
            list.add(key);
        }
        return list;
    }
}

