/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIContactSet;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIDocumentSet;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BIEmailSet;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BILocationSet;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIPhoneSet;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocatorSet;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.businessinfo.BIResponsiblePartySet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.businessinfo.BusinessInfoModelPropertiesDialog;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;

public class BusinessInfoDesign
extends DesignPart {
    public static final String OBJECT_TYPE_NAME = "Business Information";
    public static final String DOCUMENT_SET_NAME = "Documents";
    public static final String RES_PARTY_SET_NAME = "Responsible Parties";
    public static final String CONTACT_SET_NAME = "Contacts";
    public static final String EMAIL_SET_NAME = "EMails";
    public static final String LOCATION_SET_NAME = "Locations";
    public static final String PHONE_SET_NAME = "Telephones";
    public static final String URL_SET_NAME = "Resource Locators";
    private BIDocumentSet docSet;
    private BIResponsiblePartySet resPartySet;
    private BIContactSet contactSet;
    private BIEmailSet emailSet;
    private BILocationSet locationSet;
    private BIPhoneSet phoneSet;
    private BIResourceLocatorSet urlSet;

    public BusinessInfoDesign(Design design) {
        this.setDesign(design);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        return collection;
    }

    @Override
    public void clearAll() {
        this.getDocumentSet().removeAll();
        this.getResPartySet().removeAll();
        this.getContactSet().removeAll();
        this.getEmailSet().removeAll();
        this.getLocationSet().removeAll();
        this.getPhoneSet().removeAll();
        this.getUrlSet().removeAll();
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getEmailSet());
        list.add(this.getLocationSet());
        list.add(this.getPhoneSet());
        list.add(this.getUrlSet());
        list.add(this.getContactSet());
        list.add(this.getResPartySet());
        list.add(this.getDocumentSet());
        return list;
    }

    @Override
    public void sortCollections() {
        this.getDocumentSet().sort();
        this.getResPartySet().sort();
        this.getContactSet().sort();
        this.getEmailSet().sort();
        this.getLocationSet().sort();
        this.getPhoneSet().sort();
        this.getUrlSet().sort();
    }

    @Override
    public void doAfterLoad() {
        int pers = this.getDesign().getLoadedModelPersistence();
        if (pers != Design.PERS_MODEL_IN_ONE_FILE) {
            this.createFilesMap();
        }
        this.setLoaded(true);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        XMLPersistenceManager pm = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader reader = pm.getDesignPartReader(this);
        if (reader != null) {
            reader.recreateDesign(this.getName(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        return null;
    }

    @Override
    public DesignPartView getMainView() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "BI";
    }

    public BIContactSet getContactSet() {
        if (this.contactSet == null) {
            this.contactSet = new BIContactSet(this);
            this.contactSet.setDesign(this.getDesign());
            this.contactSet.setName(Messages.getString("BusinessInfoDesign.Contacts"));
            this.contactSet.setParent(this);
            this.contactSet.addSetListener(this);
        }
        return this.contactSet;
    }

    public BIDocumentSet getDocumentSet() {
        if (this.docSet == null) {
            this.docSet = new BIDocumentSet(this);
            this.docSet.setDesign(this.getDesign());
            this.docSet.setName(Messages.getString("BusinessInfoDesign.Documents"));
            this.docSet.setParent(this);
            this.docSet.addSetListener(this);
        }
        return this.docSet;
    }

    public BIEmailSet getEmailSet() {
        if (this.emailSet == null) {
            this.emailSet = new BIEmailSet(this);
            this.emailSet.setDesign(this.getDesign());
            this.emailSet.setName(Messages.getString("BusinessInfoDesign.Emails"));
            this.emailSet.setParent(this);
            this.emailSet.addSetListener(this);
        }
        return this.emailSet;
    }

    public BILocationSet getLocationSet() {
        if (this.locationSet == null) {
            this.locationSet = new BILocationSet(this);
            this.locationSet.setDesign(this.getDesign());
            this.locationSet.setName(Messages.getString("BusinessInfoDesign.Locations"));
            this.locationSet.setParent(this);
            this.locationSet.addSetListener(this);
        }
        return this.locationSet;
    }

    public BIPhoneSet getPhoneSet() {
        if (this.phoneSet == null) {
            this.phoneSet = new BIPhoneSet(this);
            this.phoneSet.setDesign(this.getDesign());
            this.phoneSet.setName(Messages.getString("BusinessInfoDesign.Telephones"));
            this.phoneSet.setParent(this);
            this.phoneSet.addSetListener(this);
        }
        return this.phoneSet;
    }

    public BIResponsiblePartySet getResPartySet() {
        if (this.resPartySet == null) {
            this.resPartySet = new BIResponsiblePartySet(this);
            this.resPartySet.setDesign(this.getDesign());
            this.resPartySet.setName(Messages.getString("BusinessInfoDesign.ResponsibleParties"));
            this.resPartySet.setParent(this);
            this.resPartySet.addSetListener(this);
        }
        return this.resPartySet;
    }

    public BIResourceLocatorSet getUrlSet() {
        if (this.urlSet == null) {
            this.urlSet = new BIResourceLocatorSet(this);
            this.urlSet.setDesign(this.getDesign());
            this.urlSet.setName(Messages.getString("BusinessInfoDesign.ResourceLocators"));
            this.urlSet.setParent(this);
            this.urlSet.addSetListener(this);
        }
        return this.urlSet;
    }

    public BIDocument createDocument() {
        return this.getDocumentSet().createDocument(null);
    }

    public BIResponsibleParty createResParty() {
        return this.getResPartySet().createParty(null);
    }

    public BIContact createContact() {
        return this.getContactSet().createContact(null);
    }

    public BIEmail createEmail() {
        return this.getEmailSet().createEmail(null);
    }

    public BILocation createLocation() {
        return this.getLocationSet().createLocation(null);
    }

    public BIPhone createPhone() {
        return this.getPhoneSet().createPhone(null);
    }

    public BIResourceLocator createUrl() {
        return this.getUrlSet().createResLocator(null);
    }

    @Override
    public int getNumberOfChildren() {
        return 7;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.getDocumentSet();
            }
            case 1: {
                return this.getResPartySet();
            }
            case 2: {
                return this.getContactSet();
            }
            case 3: {
                return this.getEmailSet();
            }
            case 4: {
                return this.getLocationSet();
            }
            case 5: {
                return this.getPhoneSet();
            }
            case 6: {
                return this.getUrlSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.getDocumentSet()) {
            return 0;
        }
        if (child == this.getResPartySet()) {
            return 1;
        }
        if (child == this.getContactSet()) {
            return 2;
        }
        if (child == this.getEmailSet()) {
            return 3;
        }
        if (child == this.getLocationSet()) {
            return 4;
        }
        if (child == this.getPhoneSet()) {
            return 5;
        }
        if (child == this.getUrlSet()) {
            return 6;
        }
        return -1;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event == SetEvent.OBJECT_ADDED) {
            this.fireAdded(event.getAffected());
        } else if (event == SetEvent.OBJECT_REMOVED) {
            this.fireRemoved(event.getAffected());
        }
    }

    @Override
    public Note createNote() {
        return null;
    }

    @Override
    public ImageObject createImage() {
        return null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            BusinessInfoModelPropertiesDialog dialog = new BusinessInfoModelPropertiesDialog(this.getDesign().getAppView(), this, true);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Email");
        list.add("Location");
        list.add("Phone");
        list.add("ResLocator");
        list.add("Contact");
        list.add("ResponsibleParty");
        list.add("Document");
        return list;
    }

    @Override
    public boolean isNewModel() {
        return false;
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "businessinfo").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "businessinfo" + File.separatorChar + this.getName() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String toString() {
        return Messages.getString("Design.BusinessInformation");
    }

    @Override
    public boolean setName(String name) {
        return true;
    }

    @Override
    public StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("Email".equalsIgnoreCase(objectType)) {
            object = this.getEmailSet().createEmail(objectID);
        } else if ("Location".equalsIgnoreCase(objectType)) {
            object = this.getLocationSet().createLocation(objectID);
        } else if ("Phone".equalsIgnoreCase(objectType)) {
            object = this.getPhoneSet().createPhone(objectID);
        } else if ("ResLocator".equalsIgnoreCase(objectType)) {
            object = this.getUrlSet().createResLocator(objectID);
        } else if ("Contact".equalsIgnoreCase(objectType)) {
            object = this.getContactSet().createContact(objectID);
        } else if ("ResponsibleParty".equalsIgnoreCase(objectType)) {
            object = this.getResPartySet().createParty(objectID);
        } else if ("Document".equalsIgnoreCase(objectType)) {
            object = this.getDocumentSet().createDocument(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            object.setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("email", "Email");
            this.f2tMap.put("location", "Location");
            this.f2tMap.put("phone", "Phone");
            this.f2tMap.put("url", "ResLocator");
            this.f2tMap.put("contact", "Contact");
            this.f2tMap.put("party", "ResponsibleParty");
            this.f2tMap.put("document", "Document");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String path, StorableObjectStatusHelper sosHelper, String storableObjectID) {
        sosHelper.treePath.add(new TreePathHelper(OBJECT_TYPE_NAME, new File(design.getBusinessInfoDesign().getStorageName()), BusinessInfoDesign.class));
        if ("email".equalsIgnoreCase(path)) {
            sosHelper.objectClass = BIEmail.class;
            sosHelper.objectType = "Email";
            sosHelper.treePath.add(new TreePathHelper(EMAIL_SET_NAME, file.getParentFile(), BIEmailSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((BusinessInfoDesign)sosHelper.designPart).getEmailSet();
                sosHelper.storableObject = ((BusinessInfoDesign)sosHelper.designPart).getEmailSet().getObjectByID(storableObjectID);
            }
        } else if ("location".equalsIgnoreCase(path)) {
            sosHelper.objectClass = BILocation.class;
            sosHelper.objectType = "Location";
            sosHelper.treePath.add(new TreePathHelper(LOCATION_SET_NAME, file.getParentFile(), BILocationSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((BusinessInfoDesign)sosHelper.designPart).getLocationSet();
                sosHelper.storableObject = ((BusinessInfoDesign)sosHelper.designPart).getLocationSet().getObjectByID(storableObjectID);
            }
        } else if ("phone".equalsIgnoreCase(path)) {
            sosHelper.objectClass = BIPhone.class;
            sosHelper.objectType = "Phone";
            sosHelper.treePath.add(new TreePathHelper(PHONE_SET_NAME, file.getParentFile(), BIPhoneSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((BusinessInfoDesign)sosHelper.designPart).getPhoneSet();
                sosHelper.storableObject = ((BusinessInfoDesign)sosHelper.designPart).getPhoneSet().getObjectByID(storableObjectID);
            }
        } else if ("url".equalsIgnoreCase(path)) {
            sosHelper.objectClass = BIResourceLocator.class;
            sosHelper.objectType = "ResLocator";
            sosHelper.treePath.add(new TreePathHelper(URL_SET_NAME, file.getParentFile(), BIResourceLocatorSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((BusinessInfoDesign)sosHelper.designPart).getUrlSet();
                sosHelper.storableObject = ((BusinessInfoDesign)sosHelper.designPart).getUrlSet().getObjectByID(storableObjectID);
            }
        } else if ("contact".equalsIgnoreCase(path)) {
            sosHelper.objectClass = BIContact.class;
            sosHelper.objectType = "Contact";
            sosHelper.treePath.add(new TreePathHelper(CONTACT_SET_NAME, file.getParentFile(), BIContactSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((BusinessInfoDesign)sosHelper.designPart).getContactSet();
                sosHelper.storableObject = ((BusinessInfoDesign)sosHelper.designPart).getContactSet().getObjectByID(storableObjectID);
            }
        } else if ("party".equalsIgnoreCase(path)) {
            sosHelper.objectClass = BIResponsibleParty.class;
            sosHelper.objectType = "ResponsibleParty";
            sosHelper.treePath.add(new TreePathHelper(RES_PARTY_SET_NAME, file.getParentFile(), BIResponsiblePartySet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((BusinessInfoDesign)sosHelper.designPart).getResPartySet();
                sosHelper.storableObject = ((BusinessInfoDesign)sosHelper.designPart).getResPartySet().getObjectByID(storableObjectID);
            }
        } else if ("document".equalsIgnoreCase(path)) {
            sosHelper.objectClass = BIDocument.class;
            sosHelper.objectType = "Document";
            sosHelper.treePath.add(new TreePathHelper(DOCUMENT_SET_NAME, file.getParentFile(), BIDocumentSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((BusinessInfoDesign)sosHelper.designPart).getDocumentSet();
                sosHelper.storableObject = ((BusinessInfoDesign)sosHelper.designPart).getDocumentSet().getObjectByID(storableObjectID);
            }
        }
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        this.sortCollections();
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (BIDocument biDocument : this.getDocuments()) {
            if (biDocument.getMeasurements().size() <= 0) continue;
            objects.add(biDocument);
        }
        Iterator it = this.getResPartySet().iterator();
        while (it.hasNext()) {
            BIResponsibleParty biResponsibleParty = (BIResponsibleParty)it.next();
            if (biResponsibleParty.getMeasurements().size() <= 0) continue;
            objects.add(biResponsibleParty);
        }
        it = this.getContactSet().iterator();
        while (it.hasNext()) {
            BIContact biContact = (BIContact)it.next();
            if (biContact.getMeasurements().size() <= 0) continue;
            objects.add(biContact);
        }
        it = this.getEmailSet().iterator();
        while (it.hasNext()) {
            BIEmail biEmail = (BIEmail)it.next();
            if (biEmail.getMeasurements().size() <= 0) continue;
            objects.add(biEmail);
        }
        it = this.getLocationSet().iterator();
        while (it.hasNext()) {
            BILocation biLocation = (BILocation)it.next();
            if (biLocation.getMeasurements().size() <= 0) continue;
            objects.add(biLocation);
        }
        it = this.getPhoneSet().iterator();
        while (it.hasNext()) {
            BIPhone biPhone = (BIPhone)it.next();
            if (biPhone.getMeasurements().size() <= 0) continue;
            objects.add(biPhone);
        }
        return objects;
    }

    @Override
    public List getSearchableSets() {
        ArrayList<SearchSet> sets = new ArrayList<SearchSet>();
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(BIDocument.class), BIDocument.class, this, this.getDocumentSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(BIResponsibleParty.class), BIResponsibleParty.class, this, this.getResPartySet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(BIContact.class), BIContact.class, this, this.getContactSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(BIEmail.class), BIEmail.class, this, this.getEmailSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(BILocation.class), BILocation.class, this, this.getLocationSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(BIPhone.class), BIPhone.class, this, this.getPhoneSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(BIResourceLocator.class), BIResourceLocator.class, this, this.getUrlSet()));
        return sets;
    }
}

