/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHTableSpace
extends RowHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    public static final String OBJECT_TYPE_COOL = "TABLE_SPACES";
    private static final Logger LOGGER = new Logger(RHTableSpace.class);
    private Integer nactive = new Integer(46);
    private Integer max_rows = new Integer(58);
    private String CCSID_DEF_NUM = "4294967295";
    private Integer ccsid1 = new Integer(14);
    private Integer ccsid2 = new Integer(53);

    public RHTableSpace(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        list.add(OBJECT_TYPE_COOL);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createTableSpace(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createTableSpace(VarFileLine line) {
        String keyDatabase = this.getField(line, "TABLESPACE_DATABASES");
        DataBaseDB2 database = (DataBaseDB2)this.getCreatedObject(keyDatabase);
        String keyStorageGroup = this.getField(line, "TABLESPACE_STORAGE_GROUP");
        StorageGroupDB2 storageGroup = (StorageGroupDB2)this.getCreatedObject(keyStorageGroup);
        VCatDB2 vcat = (VCatDB2)this.getCreatedObject(this.getField(line, "TABLESPACE_VCAT"));
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        if (database == null) {
            database = (DataBaseDB2)storageDesign.getDataBaseSet().getByName("DSNDB04");
        }
        TableSpaceDB2 tableSpace = storageDesign.getTableSpaceSet().createTableSpace();
        StorageTemplateDB2 st = storageDesign.getStorageTemplateSet().createStorageTemplate();
        tableSpace.setName(this.getField(line, "TABLESPACE_TSPACE_NAME"));
        tableSpace.setComment(this.getComment(line));
        tableSpace.setStorageTemplate(st);
        if (storageGroup != null) {
            st.setStorageGroup(storageGroup);
        } else if (vcat != null) {
            st.setVCat(vcat);
        }
        this.fillBufferpool(line, tableSpace);
        this.fillLockSize(line, tableSpace);
        this.fillLockMax(line, tableSpace);
        this.fillGbpCache(line, st);
        this.fillSegSize(line, tableSpace);
        this.fillCloseRule(line, tableSpace);
        this.fillMaxRows(line, tableSpace);
        this.fillCCSID(line, tableSpace);
        this.fillEraseRule(line, st);
        this.fillFreePage(line, st);
        this.fillMaintInterval(line, tableSpace);
        this.fillNActive(line, tableSpace);
        this.fillPctFree(line, st);
        this.fillPriqty(line, st);
        this.fillSecqty(line, st);
        this.fillSpaceAlloc(line, tableSpace);
        this.fillCatSpace(line, tableSpace);
        this.fillObid(line, tableSpace);
        this.fillPsid(line, tableSpace);
        this.fillCreateBy(line, tableSpace);
        tableSpace.setDataBase(database);
        this.fillCompress(line, tableSpace);
        this.fillCompressRatio(line, tableSpace);
        this.fillPageSave(line, tableSpace);
        this.addCreatedObject(this.getField(line, "general_id"), tableSpace);
        this.removeSelectedLine(line);
        StorageTemplateDB2 realst = storageDesign.getStorageTemplateSet().removeIfExistEqual(tableSpace.getStorageTemplate());
        if (realst != tableSpace.getStorageTemplate()) {
            tableSpace.setStorageTemplate(realst);
        }
    }

    private void fillLockSize(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int lockSize = Integer.parseInt(this.getField(line, "TABLESPACE_LOCKSIZE"));
            String[] choisesLockSize = TableSpaceDB2.getLockSizeValues();
            switch (lockSize) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    tableSpace.setLockSize(choisesLockSize[lockSize - 1]);
                    break;
                }
                default: {
                    tableSpace.setLockSize(choisesLockSize[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillLockSize: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL LOCK SIZE format near " + line);
        }
    }

    private void fillLockMax(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int lockMax = Integer.parseInt(this.getField(line, "TABLESPACE_LOCKMAX"));
            tableSpace.setLockMax(lockMax);
        }
        catch (NumberFormatException e) {
            tableSpace.setLockMax(-1);
        }
    }

    private void fillGbpCache(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int gbCache = Integer.parseInt(this.getField(line, "TABLESPACE_GBPCACHE"));
            if (gbCache == 1) {
                st.setGbCache(StorageTemplateDB2.GBCACHE[1]);
            } else if (gbCache == 2) {
                st.setGbCache(StorageTemplateDB2.GBCACHE[2]);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillGbpCache : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL GBP SIZE format near " + line);
        }
    }

    private void fillSegSize(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int segSize = Integer.parseInt(this.getField(line, "TABLESPACE_SEGSIZE"));
            if (segSize > 0) {
                tableSpace.setSegSize(String.valueOf(segSize));
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillSegSize: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL SEGMENT SIZE format near " + line);
        }
    }

    private void fillCloseRule(VarFileLine line, TableSpaceDB2 tableSpace) {
        String closeRule = this.getField(line, "TABLESPACE_CLOSERULE");
        if (closeRule.equals("1")) {
            tableSpace.setClose(true);
        } else {
            tableSpace.setClose(false);
        }
    }

    private void fillEraseRule(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int eraseRule = Integer.parseInt(this.getField(line, "TABLESPACE_ERASERULE"));
            if (eraseRule == 0) {
                st.setSgErase(false);
            } else if (eraseRule == 1) {
                st.setSgErase(true);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillEraseRule : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL ERASE RULE format near " + line);
        }
    }

    private void fillFreePage(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int freepage = Integer.parseInt(this.getField(line, "TABLESPACE_FREEPAGE"));
            if (freepage >= 0) {
                st.setFreePage(freepage);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillFreepage : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL FREE PAGE format near " + line);
        }
    }

    private void fillMaintInterval(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int maintInterval = Integer.parseInt(this.getField(line, "TABLESPACE_MAINT_INTERVAL"));
            tableSpace.setMaintenanceInterval(maintInterval);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillMaintInterval: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL MAINT INTERVAL format near " + line);
        }
    }

    private void fillNActive(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int nact = Integer.parseInt(this.getField(line.getLine(), this.nactive));
            if (nact > 0) {
                tableSpace.setNactive(nact);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillNactive : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL NACTIVE format near " + line);
        }
    }

    private void fillPctFree(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int pctFree = Integer.parseInt(this.getField(line, "TABLESPACE_PCTFREE"));
            if (pctFree >= 0) {
                st.setPctFree(pctFree);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillPctfree : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL PCTFREE format near " + line);
        }
    }

    private void fillPriqty(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int priqty = Integer.parseInt(this.getField(line, "TABLESPACE_PRIQTY"));
            if (priqty > -1) {
                st.setSgPriqty(priqty);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillPriqty : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL PRIQTY format near " + line);
        }
    }

    private void fillSecqty(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int secqty = Integer.parseInt(this.getField(line, "TABLESPACE_SECQTY"));
            if (secqty > -1) {
                st.setSgSeqty(secqty);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillSecqty : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL SECQTY format near " + line);
        }
    }

    private void fillSpaceAlloc(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int spaceAlloc = Integer.parseInt(this.getField(line, "TABLESPACE_SPACE_ALLOC"));
            if (spaceAlloc > 0) {
                tableSpace.setSpaceAllocationInterval(spaceAlloc);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillSpaceAlloc: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL SPACE ALLOC format near " + line);
        }
    }

    private void fillCreateBy(VarFileLine line, TableSpaceDB2 tableSpace) {
        String createBy = this.getField(line, "TABLESPACE_CREATE_BY");
        tableSpace.setCreatedBy(createBy);
    }

    private void fillCatSpace(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            long catSpace = Long.parseLong(this.getField(line, "TABLESPACE_CAT_SPACE"));
            if (catSpace > 0L) {
                tableSpace.setSpace((int)catSpace);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillCatSpace: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL CAT SPACE format near " + line);
        }
    }

    private void fillObid(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int obid = Integer.parseInt(this.getField(line, "TABLESPACE_OBID"));
            if (obid > 0) {
                tableSpace.setObid(obid);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillObid: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL OBID format near " + line);
        }
    }

    private void fillPsid(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int psid = Integer.parseInt(this.getField(line, "TABLESPACE_PSID"));
            if (psid > 0) {
                tableSpace.setPsid(psid);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillPsid: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL PSID format near " + line);
        }
    }

    private void fillCompress(VarFileLine line, TableSpaceDB2 tableSpace) {
        String compress = this.getField(line, "TABLESPACE_COMPRESS");
        if (compress.equals("0")) {
            tableSpace.setCompress(false);
        } else if (compress.equals("1")) {
            tableSpace.setCompress(true);
        }
    }

    private void fillCompressRatio(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int compressRatio = Integer.parseInt(this.getField(line, "TABLESPACE_COMPRESS_RATIO"));
            if (compressRatio > 0) {
                tableSpace.setCompressionRatio(compressRatio);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillCompressRatio: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL COMPRESS RATIO format near " + line);
        }
    }

    private void fillPageSave(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int pageSave = Integer.parseInt(this.getField(line, "TABLESPACE_PAGESAVE"));
            if (pageSave > 0) {
                tableSpace.setPageSave(pageSave);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillPageSave: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL PAGE SAVE format near " + line);
        }
    }

    private void fillBufferpool(VarFileLine line, TableSpaceDB2 tableSpace) {
        String bufferpoolKey = this.getField(line, "TABLESPACE_BUFFER_POOL");
        BufferPoolDB2 bufferpool = (BufferPoolDB2)this.getCreatedObject(bufferpoolKey);
        if (bufferpool != null) {
            tableSpace.setBufferPool(bufferpool);
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        if (!this.getField(line, "TABLESPACE_TEXT_ID").equalsIgnoreCase("0")) {
            VarFileLine commentLine = this.getCommentLine(this.getField(line, "TABLESPACE_TEXT_ID"), "TEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "text_comment");
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private void fillMaxRows(VarFileLine line, TableSpaceDB2 tableSpace) {
        try {
            int maxRows = Integer.parseInt(this.getField(line.getLine(), this.max_rows));
            tableSpace.setMaxRows(maxRows);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTableSpace.fillMaxRows : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong Max Rows format near " + line);
        }
    }

    private void fillCCSID(VarFileLine line, TableSpaceDB2 tableSpace) {
        String ccsid_number = this.getField(line.getLine(), this.ccsid1);
        if (!ccsid_number.equalsIgnoreCase(this.CCSID_DEF_NUM)) {
            String ccs2 = this.getField(line.getLine(), this.ccsid2);
            if ("1".equalsIgnoreCase(ccs2)) {
                tableSpace.setCcsid("EBCDIC");
            } else if ("0".equalsIgnoreCase(ccs2)) {
                tableSpace.setCcsid("ASCII");
            }
        }
    }
}

