/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHLoginSqlServer
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "LOGIN";
    private static final Logger LOGGER = new Logger(MOHLoginSqlServer.class);

    public MOHLoginSqlServer(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected boolean imported(List list, DBUserSqlServer dbo) {
        int position = list.lastIndexOf(dbo);
        for (int i = 0; i < position; ++i) {
            DBObject dboNext = (DBObject)list.get(i);
            if (!(dboNext instanceof DBUserSqlServer) || !dboNext.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer) || this.imported(schemas, (DBUserSqlServer)dboNext)) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("NAME").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("master.dbo.syslogins").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("sid").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("getLogins(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String sid = rs.getString(1);
                    DBObjectSqlServer dboTable = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), sid, OBJECT_TYPE, "");
                    list.add(dboTable);
                }
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("dbname").append(' ');
                buffer.append(',').append(' ');
                buffer.append("LANGUAGE").append(' ');
                buffer.append(',').append(' ');
                buffer.append("isntname").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("master.dbo.syslogins").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("LOGINNAME").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append(name).append('\'').append(' ');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHLoginSqlServer.generate():", e);
            }
            if (rs != null && rs.next()) {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                    LoginSqlServer login = (LoginSqlServer)storage.getLoginSet().getByName(name);
                    if (login == null) {
                        login = storage.getLoginSet().createLogin();
                        login.setName(name);
                        this.stampModelObject(login, dbo);
                    }
                    this.setProperties(login, storage, rs);
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void setProperties(LoginSqlServer login, StorageDesignSqlServer storage, ResultSet rs) throws Exception {
        String dbName = rs.getString(1);
        String language = rs.getString(2);
        int nt = rs.getInt(3);
        DataBaseSqlServer database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(dbName);
        if (database == null) {
            database = storage.getDataBaseSet().createDataBase();
            database.setName(dbName);
            this.stampModelObject((ModelObject)database, "", dbName);
        }
        login.setDefaultDatabase(database);
        login.setLanguage(language);
        if (nt == 0) {
            login.setAuthentication(LoginSqlServer.AUTH_CHOICES[1]);
        } else {
            login.setAuthentication(LoginSqlServer.AUTH_CHOICES[0]);
        }
    }
}

