/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatatypeSqlServer
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "DATATYPE";
    private static final Logger LOGGER = new Logger(MOHDatatypeSqlServer.class);

    public MOHDatatypeSqlServer(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("st").append('.');
                buffer.append("NAME").append(' ');
                buffer.append("SYSTYPE").append(' ');
                buffer.append(',').append(' ');
                buffer.append("LENGTH").append(' ');
                buffer.append(',').append(' ');
                buffer.append("PREC").append(' ');
                buffer.append(',').append(' ');
                buffer.append("SCALE").append(' ');
                buffer.append(',').append(' ');
                buffer.append("ALLOWNULLS").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHDatatypeSqlServer.getFormattedName(db)).append('.').append("dbo.systypes t").append(' ');
                buffer.append(',').append(' ');
                buffer.append('(').append(' ');
                buffer.append("SELECT").append(' ');
                buffer.append("NAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("XTYPE").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHDatatypeSqlServer.getFormattedName(db)).append('.').append("dbo.systypes").append(' ');
                buffer.append("WHERE").append(' ').append("XUSERTYPE").append(' ');
                buffer.append('=').append(' ').append("XTYPE").append(' ');
                buffer.append(')').append(' ');
                buffer.append("st").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("t").append('.').append("NAME").append(' ');
                buffer.append('=').append(' ').append('\'');
                buffer.append(name).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("t").append('.').append("XTYPE").append(' ');
                buffer.append('=').append(' ');
                buffer.append("st").append('.').append("XTYPE").append(' ');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHDatatypeSqlServer.generate():", e);
            }
            if (rs != null && rs.next()) {
                DistinctType type = this.getDesign().getDataTypesDesign().createDistinctType();
                type.setName(name);
                this.stampModelObject(type, dbo);
                this.setProperties(type, rs);
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void setProperties(DistinctType type, ResultSet rs) throws Exception {
        String systype = rs.getString("SYSTYPE");
        String size = rs.getString("LENGTH");
        int prec = 0;
        int scale = 0;
        try {
            prec = rs.getInt("PREC");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            scale = rs.getInt("SCALE");
        }
        catch (Exception e) {
            // empty catch block
        }
        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(systype);
        LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getDbmeHandler().getRDBMSSite().getType(), usedDatatype);
        if (logicalDT == null) {
            logicalDT = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(usedDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName());
        }
        if (logicalDT != null) {
            type.setLogicalDataType(logicalDT);
            type.setSize(size);
            type.setScale(scale);
            type.setPrecision(prec);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            DBUserSqlServer dbo;
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer) || this.containsDboForDb(schemas, dbo = (DBUserSqlServer)dboNext)) continue;
            list.addAll(this.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private List extractByUser(Connection sqlConnection, DBUserSqlServer dbo) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String dbName = dbo.getDb();
        String uid = dbo.getUid();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
            buffer.append("t").append('.').append("NAME").append(' ');
            buffer.append("userdef_name").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHDatatypeSqlServer.getFormattedName(dbName)).append('.').append("dbo.systypes t").append(' ');
            buffer.append(',').append(' ');
            buffer.append('(').append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHDatatypeSqlServer.getFormattedName(dbName)).append('.').append("dbo.systypes").append(' ');
            buffer.append(')').append(' ');
            buffer.append("st").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("t").append('.').append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(uid).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("t").append('.').append("XTYPE").append(' ');
            buffer.append("<>").append(' ');
            buffer.append("t").append('.').append("XUSERTYPE").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("t").append('.').append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append("st").append('.').append("XTYPE").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHDatatypeSqlServer.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String defName = rs.getString(1);
                DBObjectSqlServer dboDef = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), defName, OBJECT_TYPE, dbo.getSchema());
                dboDef.setDb(dbName);
                list.add(dboDef);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }
}

