/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public class MOHSequenceOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SEQUENCE";
    private static final Logger LOGGER = new Logger(MOHSequenceOracle.class);
    protected boolean dbaUser;

    public MOHSequenceOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHSequenceOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract Sequence begin");
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            if (statement == null) {
                String filterCondition = this.getFilterConditionOracle("SEQUENCE_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("SEQUENCE_NAME").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? DBA_SEQUENCES : ALL_SEQUENCES).append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("SEQUENCE_OWNER").append('=').append(' ').append('?').append(' ');
                if (filterCondition != null) {
                    buffer.append("AND").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ');
                buffer.append("SEQUENCE_NAME");
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHSequenceOracle.extract(): " + e.getMessage());
                LOGGER.error("MOHSequenceOracle.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String sequenceName = rs.getString(1);
                DBObject dboSequence = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), sequenceName, OBJECT_TYPE, dboNext.getName());
                list.add(dboSequence);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("Extract Sequence end");
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        if (this.getStorageDesign() instanceof StorageDesignOracle) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            Statement statement = null;
            for (int i = 0; i < selectedObjects.size(); ++i) {
                DBObject dbo = (DBObject)selectedObjects.get(i);
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ');
                        buffer.append("MIN_VALUE").append(',');
                        buffer.append("MAX_VALUE").append(',');
                        buffer.append("INCREMENT_BY").append(',');
                        buffer.append("CYCLE_FLAG").append(',');
                        buffer.append("ORDER_FLAG").append(',');
                        buffer.append("CACHE_SIZE");
                        if (storageDesign instanceof StorageDesignOraclev12c) {
                            buffer.append(',');
                            buffer.append("SESSION_FLAG");
                        }
                        buffer.append(' ');
                        buffer.append("FROM").append(' ');
                        buffer.append(this.dbaUser ? DBA_SEQUENCES : ALL_SEQUENCES).append(' ');
                        buffer.append("WHERE").append(' ');
                        buffer.append("SEQUENCE_OWNER").append('=').append('?').append(' ');
                        buffer.append("AND").append(' ');
                        buffer.append("SEQUENCE_NAME").append('=').append('?');
                        statement = sqlConnection.prepareStatement(buffer.toString());
                    }
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, dbo.getName());
                    rs = statement.executeQuery();
                }
                catch (Exception e) {
                    System.out.println("MOHSequenceOracle.generate(): " + e.getMessage());
                    LOGGER.error("MOHSequenceOracle.generate():", e);
                }
                if (rs != null) {
                    if (rs.next()) {
                        SequenceOracle sequence = storageDesign.getSequenceSet().createSequence();
                        this.setUser(sequence, storageDesign, dbo.getSchema());
                        String seqName = dbo.getName();
                        sequence.setName(seqName);
                        if (!seqName.equals(seqName.toUpperCase())) {
                            sequence.setNameHasQuotes(true);
                        }
                        this.setProperties(sequence, rs);
                        this.stampModelObject(sequence, dbo);
                    }
                    rs.close();
                }
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void setUser(SequenceOracle sequence, StorageDesignOracle storageDesign, String userName) {
        UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
        sequence.setUser(user);
    }

    private void setProperties(SequenceOracle sequence, ResultSet resultSet) throws Exception {
        try {
            String minValue = resultSet.getString("MIN_VALUE");
            String maxValue = resultSet.getString("MAX_VALUE");
            String incrementBy = resultSet.getString("INCREMENT_BY");
            String cycleFlag = resultSet.getString("CYCLE_FLAG");
            String orderFlag = resultSet.getString("ORDER_FLAG");
            String cacheSize = resultSet.getString("CACHE_SIZE");
            String sessionFlag = "";
            if (this.getStorageDesign() instanceof StorageDesignOraclev12c) {
                sessionFlag = resultSet.getString("SESSION_FLAG");
            }
            sequence.setMinValue(minValue.trim());
            sequence.setMaxValue(maxValue.trim());
            sequence.setIncrementBy(incrementBy.trim());
            if ("Y".equalsIgnoreCase(cycleFlag.trim())) {
                sequence.setCycle("YES");
            } else {
                sequence.setCycle("NO");
            }
            if ("Y".equalsIgnoreCase(orderFlag.trim())) {
                sequence.setOrder("YES");
            } else {
                sequence.setOrder("NO");
            }
            int cacheSizeInt = 0;
            if (StringUtilities.isNotEmpty(cacheSize)) {
                cacheSizeInt = Integer.parseInt(cacheSize);
            }
            if (cacheSizeInt > 0) {
                sequence.setCache(cacheSize);
            } else {
                sequence.setNoCache("YES");
            }
            if ("Y".equalsIgnoreCase(sessionFlag.trim())) {
                sequence.setSession("YES");
            }
        }
        catch (Exception e) {
            LOGGER.error("MOHSequenceOracle.setProperties()", e);
        }
    }
}

