/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.MOHForeignKey;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHForeignKeyDB2
extends MOHForeignKey {
    private static final Logger LOGGER = new Logger(MOHForeignKeyDB2.class);

    public MOHForeignKeyDB2(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)this.getStorageDesign();
        TableProxySetDB2 tableProxySet = (TableProxySetDB2)storage.getTableProxySet();
        if (tableProxySet.size() > 0) {
            Statement statement = null;
            Iterator it = tableProxySet.iterator();
            while (it.hasNext()) {
                TableProxyDB2 pr = (TableProxyDB2)it.next();
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT A.RELNAME, A.REFTBNAME, ");
                        buffer.append("A.IXNAME, A.DELETERULE, ");
                        buffer.append("A.TBNAME, A.CREATOR, A.REFTBCREATOR ");
                        buffer.append("FROM SYSIBM.SYSRELS A ");
                        buffer.append("WHERE A.TBNAME = ? AND A.CREATOR = ?");
                        statement = sqlConnection.prepareStatement(buffer.toString());
                    }
                    statement.setString(1, pr.getName());
                    statement.setString(2, pr.getOwner().getName());
                    rs = statement.executeQuery();
                }
                catch (SQLException e) {
                    LOGGER.error("MOHForeignKeyDB2.initForeignKeys():", e);
                }
                Table table = (Table)pr.getObject();
                RelationalDesign rdes = (RelationalDesign)table.getDesignPart();
                if (rs == null) continue;
                while (rs.next()) {
                    String fkName = rs.getString(1);
                    String refTableName = rs.getString(2);
                    String indName = rs.getString(3);
                    String deleteRule = rs.getString(4);
                    String tabName = rs.getString(5);
                    String ownerName = rs.getString(6).trim();
                    String refTableOwner = rs.getString(7).trim();
                    TableProxyDB2 tableProxy = pr;
                    RelationalDesign rd = tableProxy.getStorageDesign().getPhysicalDesign().getRelatedSyncModel();
                    Table refTable = rdes.getTableSet().getBySchemaAndName(refTableOwner, refTableName);
                    if (refTable == null && rd != null) {
                        refTable = rd.getTableSet().getBySchemaAndName(refTableOwner, refTableName);
                    }
                    if (refTable == null) continue;
                    FKIndexAssociation fkass = null;
                    FKIndexAssociation[] assoc = table.getFKIndexAssociationsWith(refTable);
                    for (int i = 0; i < assoc.length; ++i) {
                        if (!assoc[i].getName().equals(fkName)) continue;
                        fkass = assoc[i];
                        break;
                    }
                    if (fkass == null) {
                        Index index = null;
                        if (indName.trim().equalsIgnoreCase("")) {
                            index = (Index)refTable.getPK();
                        } else {
                            TableProxyDB2 indexTableProxy = (TableProxyDB2)storage.getTableProxySet().getProxy(refTable.getObjectID());
                            IndexProxyDB2 indexProxy = (IndexProxyDB2)indexTableProxy.getIntIndexes().getByName(indName);
                            if (indexProxy != null) {
                                index = (Index)indexProxy.getObject();
                            } else {
                                System.out.println();
                            }
                        }
                        if (index != null) {
                            fkass = table.addFK(index);
                            if (fkName != null) {
                                fkass.setName(fkName);
                                fkass.getLocalFKIndex().setName(fkName);
                                this.stampModelObject((ModelObject)fkass, ownerName, fkName);
                            }
                            this.initColumns(sqlConnection, fkass, table, index, tabName, ownerName);
                        }
                    }
                    if (fkass != null) {
                        fkass.resetMandatoryUsingColumns();
                        if ("A".equals(deleteRule)) {
                            fkass.setDeleteRule("NO ACTION");
                            continue;
                        }
                        if ("C".equals(deleteRule)) {
                            fkass.setDeleteRule("CASCADE");
                            continue;
                        }
                        if ("N".equals(deleteRule)) {
                            fkass.setDeleteRule("SET NULL");
                            continue;
                        }
                        if (!"R".equals(deleteRule)) continue;
                        fkass.setDeleteRule("RESTRICT");
                        continue;
                    }
                    System.out.println();
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void initColumns(Connection sqlConnection, FKIndexAssociation fkass, Table table, Index index, String tabName, String ownerName) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT B.COLNAME, B.COLSEQ ");
            buffer.append("FROM SYSIBM.SYSFOREIGNKEYS B ");
            buffer.append("WHERE B.TBNAME = '").append(tabName).append("'");
            buffer.append(" AND B.RELNAME = '").append(fkass.getName().trim()).append("'");
            buffer.append(" AND B.CREATOR = '").append(ownerName).append("'");
            buffer.append(" ORDER BY B.RELNAME, B.COLSEQ");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHForeignKeyDB2.initColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                int colSeq = rs.getInt(2);
                Column col = (Column)table.getElementByName(colName);
                Column refCol = null;
                try {
                    refCol = (Column)index.getElement(colSeq - 1);
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
                if (col == null || refCol == null) continue;
                col.addFKAssociation(refCol, fkass);
                fkass.getLocalFKIndex().add(col);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private TableProxyDB2 getTableProxy(TableProxySetDB2 tableProxySet, String tabName, String ownerName) {
        Iterator it = tableProxySet.iterator();
        while (it.hasNext()) {
            TableProxyDB2 proxy = (TableProxyDB2)it.next();
            if (!proxy.getName().equalsIgnoreCase(tabName) || !proxy.getOwner().getName().equalsIgnoreCase(ownerName)) continue;
            return proxy;
        }
        return null;
    }
}

