/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxySetDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHAliasDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "ALIAS";
    private static final Logger LOGGER = new Logger(MOHAliasDB2.class);

    public MOHAliasDB2(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String ownerName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TBNAME from SYSIBM.SYSTABLES").append(' ');
                buffer.append("WHERE TYPE = 'A' and NAME = '");
                buffer.append(dbo.getName()).append("' and CREATOR = '").append(ownerName).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHAliasDB2.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        TableProxyDB2 t;
                        AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                        String tbname = rs.getString(1);
                        AliasDB2 alias = storage.getAliasSet().createAlias();
                        alias.setName(name);
                        this.stampModelObject(alias, dbo);
                        Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                        if (owner == null) {
                            owner = (Owner)storage.getOwnerSet().createElement(ownerName);
                            owner.setName(ownerName);
                            this.stampModelObject((ModelObject)owner, "", ownerName);
                        }
                        if (owner != null) {
                            alias.setOwner(owner);
                        }
                        if ((t = ((TableProxySetDB2)storage.getTableProxySet()).getByName(tbname)) != null) {
                            alias.setTable(t);
                        } else {
                            TableViewProxyDB2 v = ((TableViewProxySetDB2)storage.getTableViewProxySet()).getByName(tbname);
                            if (v != null) {
                                alias.setView(v);
                            } else {
                                AliasDB2 a = (AliasDB2)storage.getAliasSet().getByName(tbname);
                                if (a != null) {
                                    alias.setAnotherAlias(a);
                                }
                            }
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT name from SYSIBM.SYSTABLES").append(' ');
                buffer.append("WHERE TYPE = 'A' and CREATOR = '");
                buffer.append(dboNext.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHAliasDB2.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, OBJECT_TYPE, dboNext.getName());
                    list.add(dboTable);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

