/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.db2.MOHAliasDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHAuxTableDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHDatabaseDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHDatatypeDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHForeignKeyDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHOwnerDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHProcedureDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHStorageGroupDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHTableDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHTablespaceDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHViewDB2;
import oracle.dbtools.crest.imports.metadata.db2.v80.MOHProcedureDB2v80;
import oracle.dbtools.crest.imports.metadata.db2.v80.MOHSequenceDB2v80;
import oracle.dbtools.crest.imports.metadata.db2.v80.MOHTableDB2v80;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public final class DBMExtractionHandlerDB2
extends AbstractDBMExtractionHandler {
    private static DBMExtractionHandlerDB2 dbmExtractionHandler;
    private List mohObjectsv70 = null;
    private List mohObjectsv80 = null;
    private ApplicationView view;
    private static final Logger LOGGER;

    private DBMExtractionHandlerDB2(ApplicationView view) {
        this.view = view;
    }

    public static AbstractDBMExtractionHandler getInstance(ApplicationView view) {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerDB2(view);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.getMOHObjectsv70();
            }
            case 8: {
                return this.getMOHObjectsv80();
            }
        }
        return this.getMOHObjectsv80();
    }

    @Override
    public List getDBObjects(Connection conn, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        List mhoList = this.getMOHObjects();
        if (mhoList.size() > 0 && conn != null) {
            for (AbstractMOHandler moHandler : mhoList) {
                moHandler.reset();
                List extracted = moHandler.extract(conn, schemas);
                for (Object obj : extracted) {
                    if (!(obj instanceof DBObject)) continue;
                    list.add((DBObject)obj);
                }
            }
            for (DBObject dboNext : this.getDB2Schemas(conn)) {
                DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dboNext.getName(), "OWNER", dboNext.getName());
                list.add(dbo);
            }
        }
        return list;
    }

    public List getMOHObjectsv70() {
        if (this.mohObjectsv70 == null) {
            this.mohObjectsv70 = new ArrayList();
            this.mohObjectsv70.add(new MOHDatatypeDB2(this, this.view));
            this.mohObjectsv70.add(new MOHOwnerDB2(this, this.view));
            this.mohObjectsv70.add(new MOHStorageGroupDB2(this, this.view));
            this.mohObjectsv70.add(new MOHDatabaseDB2(this, this.view));
            this.mohObjectsv70.add(new MOHTablespaceDB2(this, this.view));
            this.mohObjectsv70.add(new MOHTableDB2(this, this.view));
            this.mohObjectsv70.add(new MOHForeignKeyDB2(this, this.view));
            this.mohObjectsv70.add(new MOHAuxTableDB2(this, this.view));
            this.mohObjectsv70.add(new MOHAliasDB2(this, this.view));
            this.mohObjectsv70.add(new MOHViewDB2(this, this.view));
            this.mohObjectsv70.add(new MOHProcedureDB2(this, this.view));
        }
        return this.mohObjectsv70;
    }

    public List getMOHObjectsv80() {
        if (this.mohObjectsv80 == null) {
            this.mohObjectsv80 = new ArrayList();
            this.mohObjectsv80.add(new MOHDatatypeDB2(this, this.view));
            this.mohObjectsv80.add(new MOHOwnerDB2(this, this.view));
            this.mohObjectsv80.add(new MOHStorageGroupDB2(this, this.view));
            this.mohObjectsv80.add(new MOHDatabaseDB2(this, this.view));
            this.mohObjectsv80.add(new MOHTablespaceDB2(this, this.view));
            this.mohObjectsv80.add(new MOHTableDB2v80(this, this.view));
            this.mohObjectsv80.add(new MOHForeignKeyDB2(this, this.view));
            this.mohObjectsv80.add(new MOHAuxTableDB2(this, this.view));
            this.mohObjectsv80.add(new MOHAliasDB2(this, this.view));
            this.mohObjectsv80.add(new MOHViewDB2(this, this.view));
            this.mohObjectsv80.add(new MOHSequenceDB2v80(this, this.view));
            this.mohObjectsv80.add(new MOHProcedureDB2v80(this, this.view));
        }
        return this.mohObjectsv80;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignDB2v70.RDBMS_TYPE);
            }
            case 8: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignDB2v80.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignDB2v80.RDBMS_TYPE);
    }

    @Override
    public List getSchemas(Connection conn) throws Exception {
        ArrayList list = new ArrayList();
        if (conn != null) {
            DatabaseMetaData dbmd = conn.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
            return this.getDB2Schemas(conn);
        }
        return list;
    }

    public List getDB2Schemas(Connection sqlConnection) throws Exception {
        ArrayList<DBObject> list = null;
        try {
            list = super.getSchemas(sqlConnection);
        }
        catch (Exception e) {
            LOGGER.error("MOHOwnerDB2.extract(): problem when getSchemas is used " + e.getMessage());
        }
        if (list == null) {
            list = new ArrayList<DBObject>();
        }
        if (list.size() > 0) {
            return list;
        }
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select distinct a.grantee from ");
            buffer.append("(SELECT distinct GRANTEE FROM SYSIBM.SYSPACKAUTH WHERE GRANTEETYPE = ' ' ");
            buffer.append("UNION ");
            buffer.append("SELECT distinct GRANTEE FROM SYSIBM.SYSTABAUTH WHERE GRANTEETYPE = ' ' ");
            buffer.append("UNION ");
            buffer.append("SELECT distinct GRANTEE FROM SYSIBM.SYSCOLAUTH WHERE GRANTEETYPE = ' ' ");
            buffer.append("UNION ");
            buffer.append("SELECT distinct GRANTEE FROM SYSIBM.SYSROUTINEAUTH WHERE GRANTEETYPE = ' ' ");
            buffer.append(") a ");
            buffer.append("where ");
            buffer.append("a.grantee not in ('PUBLIC','SYSIBM', 'PUBLIC*')");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1).trim();
                DBObject dbo = new DBObject(false, name);
                list.add(dbo);
            }
            rs.close();
        }
        return list;
    }

    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        if (!this.isNullStorageDesign(this.view.getCurrentDesign().getRelationalDesign().getStorageDesign())) {
            super.generateDesign(conn, selectedObjects, importLog, monitor);
        }
    }

    static {
        LOGGER = new Logger(DBMExtractionHandlerDB2.class);
    }
}

