/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class MOHView
extends AbstractMOHandler {
    PreparedStatement viewDefSt;
    PreparedStatement nullSchemaSt;
    public static final String OBJECT_TYPE = "VIEW";

    public MOHView(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected ResultSet getTables(DatabaseMetaData dbmd, DBObject dbo, boolean all) throws Exception {
        if (all) {
            return dbmd.getTables(null, dbo.getName(), "%", new String[]{OBJECT_TYPE, "VIRTUAL_VIEW"});
        }
        return dbmd.getTables(null, dbo.getSchema(), dbo.getName(), new String[]{OBJECT_TYPE, "VIRTUAL_VIEW"});
    }

    protected ResultSet getColumns(DatabaseMetaData dbmd, DBObject dboTableView) throws Exception {
        return dbmd.getColumns(null, dboTableView.getSchema(), dboTableView.getName(), "%");
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        DatabaseMetaData dbmd = sqlConnection.getMetaData();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            ResultSet rs = this.getTables(dbmd, dboNext, true);
            while (rs.next()) {
                String objName = rs.getString("TABLE_NAME");
                String schema = rs.getString(2);
                if (schema == null) {
                    schema = dboNext.getName();
                }
                DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), objName, OBJECT_TYPE, schema);
                list.add(dbo);
            }
            rs.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        int i;
        this.viewDefSt = null;
        this.nullSchemaSt = null;
        boolean first = true;
        DatabaseMetaData dbmd = sqlConnection.getMetaData();
        String dbProductName = dbmd.getDatabaseProductName().toUpperCase();
        String syntaxProvider = null;
        for (i = 0; i < AbstractView.DB_SYNTAX_PROVIDERS.length; ++i) {
            if (!dbProductName.startsWith(AbstractView.DB_SYNTAX_PROVIDERS[i].toUpperCase())) continue;
            syntaxProvider = AbstractView.DB_SYNTAX_PROVIDERS[i];
            break;
        }
        for (i = 0; i < selectedObjects.size(); ++i) {
            DBObject dboTableView = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dboTableView.getType())) continue;
            if ("Hive".equalsIgnoreCase(dbProductName)) {
                Statement stmt = sqlConnection.createStatement();
                String sql = "describe formatted " + dboTableView.getName();
                boolean col = false;
                boolean empty = false;
                ResultSet rs = stmt.executeQuery(sql);
                if (rs != null) {
                    boolean defStarted = false;
                    TableView tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                    tableView.setSchema(dboTableView.getSchema());
                    tableView.setName(dboTableView.getName());
                    while (rs.next()) {
                        String usql;
                        String val = rs.getString(1);
                        if ("# col_name".equals(val.trim())) {
                            col = true;
                            continue;
                        }
                        if (col && (val == null || "".equals(val.trim()))) {
                            if (empty = !empty) continue;
                            col = false;
                            continue;
                        }
                        if (col && empty) {
                            String col_name = val.trim();
                            String dataType = rs.getString(2);
                            AbstractViewElement cvExp = tableView.createViewElement(tableView.getDesignPart());
                            cvExp.setName(col_name);
                            cvExp.setHeaderAlias(col_name);
                            this.stampModelObject((ModelObject)cvExp, tableView.getName(), col_name);
                            cvExp.setDesign(tableView.getDesign());
                            cvExp.setAlias(col_name);
                            cvExp.setDataType(dataType);
                            cvExp.setContainer(tableView);
                            tableView.add(cvExp);
                            continue;
                        }
                        if ("View Original Text:".equals(val.trim())) {
                            usql = rs.getString(2);
                            tableView.setUserDefined(true);
                            tableView.setUserDefinedSQL(this.parseAsSelect(usql));
                            defStarted = true;
                            continue;
                        }
                        if ("View Expanded Text:".equals(val.trim())) {
                            defStarted = false;
                            continue;
                        }
                        if (!defStarted) continue;
                        usql = tableView.getUserDefinedSQL();
                        tableView.setUserDefined(true);
                        tableView.setUserDefinedSQL(this.parseAsSelect(usql) + "\n" + val);
                    }
                    rs.close();
                }
            } else {
                ResultSet rs = this.getTables(dbmd, dboTableView, false);
                if (rs.next() || rs != null) {
                    ResultSet rsc;
                    TableView tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                    tableView.setSchema(dboTableView.getSchema());
                    tableView.setName(dboTableView.getName());
                    this.stampModelObject(tableView, dboTableView);
                    if (first || this.isSupportInformation_Schema()) {
                        first = false;
                        this.getViewDefinition(sqlConnection, tableView, dboTableView);
                        if (syntaxProvider != null && !"".equals(tableView.getUserDefinedSQL())) {
                            tableView.setSyntaxProvider(syntaxProvider);
                        }
                    }
                    if ((rsc = this.getColumns(dbmd, dboTableView)) != null) {
                        while (rsc.next()) {
                            String col_name = rsc.getString(4);
                            AbstractViewElement cvExp = tableView.createViewElement(tableView.getDesignPart());
                            cvExp.setName(col_name);
                            cvExp.setHeaderAlias(col_name);
                            this.stampModelObject((ModelObject)cvExp, tableView.getName(), col_name);
                            cvExp.setDesign(tableView.getDesign());
                            cvExp.setAlias(col_name);
                            cvExp.setContainer(tableView);
                            tableView.add(cvExp);
                        }
                        rsc.close();
                    }
                }
                if (rs != null) {
                    rs.close();
                }
            }
            importLog.incrementImportedStatements();
        }
        if (this.viewDefSt != null) {
            this.viewDefSt.close();
            this.viewDefSt = null;
        }
        if (this.nullSchemaSt != null) {
            this.nullSchemaSt.close();
            this.nullSchemaSt = null;
        }
    }

    private String parseAsSelect(String userDef) {
        String beforeAs = Token.getStringBefore2(userDef, "AS");
        String afterAs = Token.getStringAfter(userDef, "AS");
        if (!"".equals(beforeAs) && !"".equals(afterAs) && afterAs.startsWith("(")) {
            afterAs = Token.getValBetweenBrackets(afterAs);
            return beforeAs + ' ' + "AS" + ' ' + afterAs;
        }
        return userDef;
    }

    private void getViewDefinition(Connection sqlConnection, TableView tableView, DBObject dbo) {
        try {
            String query;
            ResultSet rs = null;
            if (dbo.getSchema() != null && !"".equals(dbo.getSchema())) {
                if (this.viewDefSt == null) {
                    query = "select view_definition from information_schema.views where table_name = ? and table_schema = ?";
                    this.viewDefSt = sqlConnection.prepareStatement(query);
                }
                this.viewDefSt.setString(1, dbo.getName());
                this.viewDefSt.setString(2, dbo.getSchema());
                rs = this.viewDefSt.executeQuery();
            } else {
                if (this.nullSchemaSt == null) {
                    query = "select view_definition from information_schema.views where table_name = ?";
                    this.nullSchemaSt = sqlConnection.prepareStatement(query);
                }
                this.nullSchemaSt.setString(1, dbo.getName());
                rs = this.nullSchemaSt.executeQuery();
            }
            if (rs != null) {
                if (rs.next()) {
                    String view_def = rs.getString(1);
                    String definition = "CREATE VIEW " + tableView.getName();
                    tableView.setUserDefinedSQL(definition + " \nAS \n" + this.parseAsSelect(view_def));
                    tableView.setUserDefined(true);
                }
                rs.close();
            }
            this.setSupportInformation_Schema(true);
        }
        catch (SQLException e) {
            this.setSupportInformation_Schema(false);
            e.printStackTrace();
        }
    }
}

