/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDBPartitionGroupUDBv81
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateDBPartitionGroupUDBv81.class);
    public static final String DBPARTITIONNUMS = "DBPARTITIONNUMS";

    public SHCreateDBPartitionGroupUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDBPartitionGroupUDBv81.clearCR(line);
        if (Token.startsWithString(statement, "create nodegroup")) {
            try {
                this.parseNodeGroup(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateDBPartitionGroupUDBv81.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "create database partition group")) {
            try {
                this.parseDBPartitionGroup(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateDBPartitionGroupUDBv81.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseDBPartitionGroup(String statement) {
        this.statement = statement;
        String nodeGroupName = Token.getTokenAfter(this.statement, "GROUP").trim();
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        DBPartitionGroupUDBv81 group = (DBPartitionGroupUDBv81)storageDesign.getNodeGroupSet().createNodeGroup();
        if (group != null) {
            group.setName(nodeGroupName);
            String onNodes = Token.getTokenAfter(this.statement, "ON").trim();
            if (onNodes.equalsIgnoreCase(DBPARTITIONNUMS)) {
                group.setScope("ON SOME DBPARTITIONNUMS");
                if (Token.hasCloseAndOpenBrackets(this.statement)) {
                    String nodes = Token.getValBetweenBrackets(this.statement).trim();
                    group.setNodeNumbers(nodes);
                }
            }
        }
    }

    public void parseNodeGroup(String statement) {
        this.statement = statement;
        String nodeGroupName = Token.getTokenAfter(this.statement, "NODEGROUP").trim();
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        DBPartitionGroupUDBv81 group = (DBPartitionGroupUDBv81)storageDesign.getNodeGroupSet().createNodeGroup();
        if (group != null) {
            group.setName(nodeGroupName);
            String onNodes = Token.getTokenAfter(this.statement, "ON").trim();
            if (onNodes.equalsIgnoreCase("NODES")) {
                group.setScope("ON SOME NODES");
                if (Token.hasCloseAndOpenBrackets(this.statement)) {
                    String nodes = Token.getValBetweenBrackets(this.statement).trim();
                    group.setNodeNumbers(nodes);
                }
            }
        }
    }
}

