/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateTriggerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TriggerSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTriggerSqlServerv2k5
extends SHCreateTriggerSqlServer {
    private static final String TRIGGERNAME = "@triggername";
    private static final String ORDER = "@order";
    private static final String STMTTYPE = "@stmttype";
    private static final Logger LOGGER = new Logger(SHCreateTriggerSqlServerv2k5.class);
    private TriggerSqlServerv2k5 trigger;
    private StorageDesignSqlServerv2k5 storageDesign;

    public SHCreateTriggerSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTriggerSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create trigger")) {
            try {
                this.parseTrigger(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateTriggerSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else if (statement.toUpperCase().indexOf("sp_settriggerorder") > -1) {
            try {
                this.setTriggerOrder(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for SQLServer failed!", e);
                this.importLog.addFailedStatement(SHCreateTriggerSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void setTriggerOrder(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            String exp = Token.getStringAfter(this.statement, "sp_settriggerorder").trim();
            StringTokenizer tokenizer = new StringTokenizer(exp, ",");
            if (tokenizer.countTokens() == 3) {
                String name = tokenizer.nextToken().trim();
                String order = tokenizer.nextToken().trim();
                String stmttype = tokenizer.nextToken().trim();
                if (name.startsWith(TRIGGERNAME)) {
                    name = Token.getStringAfter(name, "=").trim();
                }
                if (name.toUpperCase().startsWith("N'")) {
                    name = name.substring(1);
                }
                if (name.startsWith("'")) {
                    name = Token.getValBetweenQuotationMarks(name);
                }
                name = Token.getValBetweenSquareBrackets(name);
                if (order.startsWith(ORDER)) {
                    order = Token.getStringAfter(order, "=").trim();
                }
                if (order.toUpperCase().startsWith("N'")) {
                    order = order.substring(1);
                }
                if (order.startsWith("'")) {
                    order = Token.getValBetweenQuotationMarks(order);
                }
                order = Token.getValBetweenSquareBrackets(order);
                if (stmttype.startsWith(STMTTYPE)) {
                    stmttype = Token.getStringAfter(stmttype, "=").trim();
                }
                if (stmttype.toUpperCase().startsWith("N'")) {
                    stmttype = stmttype.substring(1);
                }
                if (stmttype.startsWith("'")) {
                    stmttype = Token.getValBetweenQuotationMarks(stmttype);
                }
                stmttype = Token.getValBetweenSquareBrackets(stmttype);
                this.trigger = (TriggerSqlServerv2k5)this.storageDesign.getTriggerSet().getByName(name.toUpperCase());
                if (this.trigger != null) {
                    this.trigger.setExecutionOrder(order);
                }
            } else {
                LOGGER.error(statement + " SHCreateTriggerSqlServer.sp_settriggerorder: wrong number of arguments!");
                this.importLog.addError("sp_settriggerorder: wrong number of arguments");
            }
        }
    }

    private void parseTrigger(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            this.trigger = (TriggerSqlServerv2k5)this.storageDesign.getTriggerSet().createTrigger();
            if (this.trigger != null) {
                try {
                    this.initTriggerName();
                    this.initOnTable();
                    this.initWithEncription();
                    this.initTriggeringTime();
                    this.initAction();
                    this.initNotForReplication();
                    this.initBody();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.trigger);
                }
                catch (Exception e) {
                    LOGGER.error(" Parsing " + statement + " for SQLServer failed!", e);
                }
            }
        }
    }

    private void initTriggerName() {
        String temp = Token.getTokenAfter(this.statement, "TRIGGER").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "TRIGGER", '[', ']').trim() : (temp.startsWith("\"") ? Token.getNameAfterToken(this.statement, "TRIGGER", '\"', '\"').trim() : temp);
        if (name.indexOf(46) > -1) {
            String schemaName = name.substring(0, name.indexOf(46));
            schemaName = Token.getValBetweenSquareBrackets(schemaName);
            SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)this.storageDesign.getSchemaSet().getByName(schemaName);
            if (schema == null) {
                schema = (SchemaSqlServerv2k5)this.storageDesign.getSchemaSet().createSchema();
                schema.setName(schemaName);
                this.design.getRelationalDesign().stampModelObjectDDL(schema);
                schema.setDatabase(this.getCurrentDB());
            }
            if (schema != null) {
                this.trigger.setSchema(schema);
            }
            name = name.substring(name.indexOf(46) + 1);
            name = Token.getValBetweenSquareBrackets(name);
            name = Token.removeQuotes(name);
        }
        this.trigger.setName(name);
    }

    private void initOnTable() throws ParseException {
        String str = this.statement.substring(this.statement.toUpperCase().indexOf(" ON ") + 3).trim();
        String table = Token.getLastToken(str = Token.getFirstToken(str));
        int index = table.lastIndexOf(".");
        if (index > -1) {
            table = table.substring(index + 1);
        }
        table = Token.getValBetweenSquareBrackets(table);
        if (((TableProxySetSqlServerv2k5)this.storageDesign.getTableProxySet()).getByName(table) != null) {
            this.trigger.setTable(((TableProxySetSqlServerv2k5)this.storageDesign.getTableProxySet()).getByName(table));
        } else if (((TableViewProxySetSqlServerv2k5)this.storageDesign.getTableViewProxySet()).getByName(table) != null) {
            this.trigger.setView(((TableViewProxySetSqlServerv2k5)this.storageDesign.getTableViewProxySet()).getByName(table));
        } else {
            throw new ParseException(this.statement + " Specified table or view on trigger " + this.trigger.getName() + "does not exist ");
        }
    }

    private void initWithEncription() {
        if (Token.hasString(this.statement, "WITH ENCRYPTION")) {
            this.trigger.setEncription("YES");
        } else {
            this.trigger.setEncription("NO");
        }
    }

    private void initTriggeringTime() {
        String trigTime = Token.getStringAfterToken(this.statement, "ON").toUpperCase();
        if (Token.hasString(trigTime = trigTime.substring(0, trigTime.indexOf(" AS ")), "INSTEAD OF")) {
            this.trigger.setTriggerTime(TriggerSqlServer.TRIGGER_TIMES[1]);
        } else if (Token.hasString(trigTime, "AFTER")) {
            this.trigger.setTriggerTime(TriggerSqlServer.TRIGGER_TIMES[0]);
        } else {
            this.trigger.setTriggerTime("FOR");
        }
    }

    private void initAction() {
        String actions = Token.getStringAfterToken(this.statement, "ON").toUpperCase();
        if (Token.hasString(actions = actions.substring(0, actions.indexOf(" AS ")), "INSERT")) {
            this.trigger.setActions("INSERT");
        }
        if (Token.hasString(actions, "DELETE")) {
            this.trigger.setActions("DELETE");
        }
        if (Token.hasString(actions, "UPDATE")) {
            this.trigger.setActions("UPDATE");
        }
    }

    private void initNotForReplication() {
        if (Token.hasString(this.statement, "NOT FOR REPLICATION")) {
            this.trigger.setForReplication("YES");
        } else {
            this.trigger.setForReplication("NO");
        }
    }

    private void initBody() {
        this.trigger.setBody(Token.getStringAfterToken(this.statement, "AS"));
    }
}

