/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateIndexSqlServer;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexOnViewSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SecondaryXmlIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexSqlServerv2k5
extends SHCreateIndexSqlServer {
    protected Index index;
    protected Table table;
    protected TableViewProxySqlServerv2k5 viewProxy;
    protected String indexName = "";
    protected StorageDesignSqlServerv2k5 stoDesign;
    protected TableView view;
    protected IndexOnViewSqlServerv2k5 iov;
    protected RDBMSSite site;
    private static final Logger LOGGER = new Logger(SHCreateIndexSqlServer.class);

    public SHCreateIndexSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateIndexSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create index") || Token.startsWithString(statement, "create unique index") || Token.startsWithString(statement, "create unique clustered index") || Token.startsWithString(statement, "create unique nonclustered index") || Token.startsWithString(statement, "create clustered index") || Token.startsWithString(statement, "create nonclustered index") || Token.startsWithString(statement, "create primary xml index") || Token.startsWithString(statement, "create xml index")) {
            this.index = null;
            this.indexName = "";
            try {
                this.parseIndex(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateIndexSqlServerv2k5.FormatCR(line, "\n"));
            }
            this.index = null;
            this.table = null;
            this.viewProxy = null;
            this.indexName = "";
            this.stoDesign = null;
            this.view = null;
            this.iov = null;
        } else {
            this.nextHandler(line);
        }
    }

    private void parseIndex(String statement) {
        this.statement = statement;
        if (this.isPK()) {
            this.parsePK(statement);
        } else if (this.isUK()) {
            this.parseUK(statement);
        } else if (this.isIOV()) {
            this.parseIOV(statement);
        } else if (this.isSecondaryXMLIndex()) {
            this.parseSecondaryXMLIndex(statement);
        } else {
            this.parseInd();
        }
    }

    @Override
    public void parseInd() {
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.index != null && this.index.getName().equals(this.indexName)) {
                IndexProxySqlServerv2k5 indexProxy;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (indexProxy = (IndexProxySqlServerv2k5)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initClustered(indexProxy);
                    this.initPadIndex(indexProxy);
                    this.initFillFactor(indexProxy);
                    this.initIgnoreDupKey(indexProxy);
                    this.initStatisticNoRecompute(indexProxy);
                    this.initSortInTempDB(indexProxy);
                    this.initDropExisting(indexProxy);
                    this.initOnline(indexProxy);
                    this.initAllowRowLocks(indexProxy);
                    this.initAllowPageLocks(indexProxy);
                    this.initMaxdop(indexProxy);
                    this.initIncludeColumn(indexProxy);
                    this.initFileGroup(indexProxy);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    protected void initFileGroup(IndexProxySqlServerv2k5 indexProxy) {
        int index = Token.getCloseBracketIndex(this.statement);
        String str = this.statement.substring(index + 1);
        if (Token.getCloseBracketIndex(str) > -1) {
            str = str.substring(Token.getCloseBracketIndex(str) + 1);
        }
        if (Token.startsWithString(str, "ON")) {
            String name = Token.getTokenAfter(str, "ON");
            name = Token.getValBetweenDoubleQuotes(name).trim();
            FileGroupSqlServerv2k5 object = (FileGroupSqlServerv2k5)this.stoDesign.getFileGroupSet().getByName(name);
            if (object == null) {
                PartitionSchemeSqlServerv2k5 partSchema = (PartitionSchemeSqlServerv2k5)this.stoDesign.getPartitionSchemeSet().getByName(name);
                if (partSchema != null) {
                    String partColName = Token.getStringAfter(this.statement, name);
                    partColName = Token.getValBetweenBrackets(partColName);
                    Column col = (Column)this.design.getRelationalDesign().getColumnSet().getByName(partColName);
                    if (col != null) {
                        ColumnProxySqlServerv2k5 columnProxy = (ColumnProxySqlServerv2k5)this.stoDesign.getColumnProxySet().getProxy(col.getObjectID());
                        indexProxy.setPartitioningColumn(columnProxy);
                    }
                }
            } else {
                indexProxy.setFilegroup(object);
            }
        }
    }

    private void initIncludeColumn(IndexProxySqlServerv2k5 indexProxy) {
        String includeCol;
        if (Token.hasToken(this.statement, "INCLUDE") && Token.hasCloseAndOpenBrackets(includeCol = Token.getStringAfter(this.statement, "INCLUDE"))) {
            String columns = Token.getValBetweenBrackets(includeCol, 1);
            StringTokenizer tokenizer = new StringTokenizer(columns, ",");
            while (tokenizer.hasMoreTokens()) {
                String colName = tokenizer.nextToken();
                Column col = (Column)this.table.getElementByName(colName.trim());
                if (col == null) continue;
                indexProxy.setIncludeColumns(col.getObjectID());
            }
        }
    }

    private void initClustered(IndexProxy indexProxy) {
        if (Token.hasToken(this.statement, "CLUSTERED")) {
            indexProxy.setClustered(true);
        } else {
            indexProxy.setClustered(false);
        }
    }

    @Override
    public void parseIOV(String statement) {
        this.statement = statement;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.view != null) {
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && this.iov != null) {
                    this.initUnique(this.iov);
                    this.initClustered(this.iov);
                    this.initPadIndex(this.iov);
                    this.initFillFactor(this.iov);
                    this.initIgnoreDupKey(this.iov);
                    this.initSortInTempDB(this.iov);
                    this.initStatisticNoRecompute(this.iov);
                    this.initDropExisting(this.iov);
                    this.initOnline(this.iov);
                    this.initAllowRowLocks(this.iov);
                    this.initAllowPageLocks(this.iov);
                    this.initMaxdop(this.iov);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    @Override
    public void parsePK(String statement) {
        this.statement = statement;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.table != null) {
                PKProxySqlServerv2k5 pk;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (pk = new PKProxySqlServerv2k5(this.index, (StorageDesign)this.stoDesign)) != null) {
                    this.initClustered(pk);
                    this.initFillFactorPK(pk);
                    this.initFileGroupPK(pk);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    protected boolean isIOV() {
        String name = this.getName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(name);
        return this.table == null;
    }

    protected boolean isPK() {
        return Token.hasToken(this.statement, "ADD") && Token.hasToken(this.statement, "PRIMARY");
    }

    private String getIndexOption(String optionName) {
        String afterOptionName = Token.getStringAfter(this.statement, optionName);
        if (afterOptionName.startsWith("=")) {
            String optionValue = Token.getFirstToken(afterOptionName.substring(1).trim());
            int commaInd = optionValue.indexOf(44);
            if (commaInd > -1) {
                optionValue = optionValue.substring(0, commaInd);
            }
            return optionValue;
        }
        return "";
    }

    private void initSortInTempDB(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (this.getIndexOption("SORT_IN_TEMPDB").equalsIgnoreCase("ON")) {
            indexOnViewSqlServer.setSortInTempDB("YES");
        }
    }

    private void initStatisticNoRecompute(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (this.getIndexOption("STATISTICS_NORECOMPUTE").equalsIgnoreCase("ON")) {
            indexOnViewSqlServer.setRecomputeStatistics("OFF");
        }
    }

    private void initIgnoreDupKey(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (this.getIndexOption("IGNORE_DUP_KEY").equalsIgnoreCase("ON")) {
            indexOnViewSqlServer.setIgnoreDupKey("YES");
        }
    }

    private void initDropExisting(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (this.getIndexOption("DROP_EXISTING").equalsIgnoreCase("ON")) {
            indexOnViewSqlServer.setDropExisting("ON");
        }
    }

    private void initOnline(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (this.getIndexOption("ONLINE").equalsIgnoreCase("ON")) {
            indexOnViewSqlServer.setOnlineChoise("ON");
        }
    }

    private void initAllowRowLocks(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (this.getIndexOption("ALLOW_ROW_LOCKS").equalsIgnoreCase("OFF")) {
            indexOnViewSqlServer.setAllowRowLocks("OFF");
        }
    }

    private void initAllowPageLocks(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (this.getIndexOption("ALLOW_PAGE_LOCKS").equalsIgnoreCase("OFF")) {
            indexOnViewSqlServer.setAllowPageLocks("OFF");
        }
    }

    private void initFillFactor(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        String fillFactorValue = this.getIndexOption("FILLFACTOR");
        if (!fillFactorValue.equals("")) {
            try {
                indexOnViewSqlServer.setFillFactor(Integer.parseInt(fillFactorValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Fill factor is unknown on index on view " + indexOnViewSqlServer.getName());
            }
        }
    }

    private void initUnique(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (Token.hasToken(this.statement, "UNIQUE")) {
            indexOnViewSqlServer.setUnique("YES");
        } else {
            indexOnViewSqlServer.setUnique("NO");
        }
    }

    private void initClustered(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (Token.hasToken(this.statement, "CLUSTERED")) {
            indexOnViewSqlServer.setClustered("YES");
            indexOnViewSqlServer.setUnique("YES");
        } else if (Token.hasToken(this.statement, "NONCLUSTERED")) {
            indexOnViewSqlServer.setClustered("NO");
        }
    }

    private void initPadIndex(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        if (this.getIndexOption("PAD_INDEX").equalsIgnoreCase("ON")) {
            indexOnViewSqlServer.setPadIndex("YES");
        }
    }

    private void initMaxdop(IndexOnViewSqlServerv2k5 indexOnViewSqlServer) {
        String maxdopValue = this.getIndexOption("MAXDOP");
        if (!maxdopValue.equals("")) {
            try {
                indexOnViewSqlServer.setMaxdop(Integer.parseInt(maxdopValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Max degree of parallelism is unknown on index on view " + indexOnViewSqlServer.getName());
            }
        }
    }

    private void initSortInTempDB(IndexProxySqlServerv2k5 indexProxy) {
        if (this.getIndexOption("SORT_IN_TEMPDB").equalsIgnoreCase("ON")) {
            indexProxy.setSortInTempDB("YES");
        }
    }

    private void initStatisticNoRecompute(IndexProxySqlServerv2k5 indexProxy) {
        if (this.getIndexOption("STATISTICS_NORECOMPUTE").equalsIgnoreCase("ON")) {
            indexProxy.setRecomputeStatistics("OFF");
        }
    }

    private void initIgnoreDupKey(IndexProxySqlServerv2k5 indexProxy) {
        if (this.getIndexOption("IGNORE_DUP_KEY").equalsIgnoreCase("ON")) {
            indexProxy.setIgnoreDupKey("YES");
        }
    }

    protected void initDropExisting(IndexProxySqlServerv2k5 indexProxy) {
        if (this.getIndexOption("DROP_EXISTING").equalsIgnoreCase("ON")) {
            indexProxy.setDropExisting("ON");
        }
    }

    private void initOnline(IndexProxySqlServerv2k5 indexProxy) {
        if (this.getIndexOption("ONLINE").equalsIgnoreCase("ON")) {
            indexProxy.setOnlineChoise("ON");
        }
    }

    private void initAllowRowLocks(IndexProxySqlServerv2k5 indexProxy) {
        if (this.getIndexOption("ALLOW_ROW_LOCKS").equalsIgnoreCase("OFF")) {
            indexProxy.setAllowRowLocks("OFF");
        }
    }

    private void initAllowPageLocks(IndexProxySqlServerv2k5 indexProxy) {
        if (this.getIndexOption("ALLOW_PAGE_LOCKS").equalsIgnoreCase("OFF")) {
            indexProxy.setAllowPageLocks("OFF");
        }
    }

    protected void initMaxdop(IndexProxySqlServerv2k5 indexProxy) {
        String maxdopValue = this.getIndexOption("MAXDOP");
        if (!maxdopValue.equals("")) {
            try {
                indexProxy.setMaxdop(Integer.parseInt(maxdopValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Max degree of parallelism is unknown on index on view " + indexProxy.getName());
            }
        }
    }

    private void initFillFactor(IndexProxySqlServerv2k5 indexProxy) {
        String fillFactorValue = this.getIndexOption("FILLFACTOR");
        if (!fillFactorValue.equals("")) {
            try {
                indexProxy.setFillFactor(Integer.parseInt(fillFactorValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Fill factor is unknown on index " + indexProxy.getName());
            }
        }
    }

    private void initPadIndex(IndexProxySqlServerv2k5 indexProxy) {
        if (this.getIndexOption("PAD_INDEX").equalsIgnoreCase("ON")) {
            indexProxy.setPadIndex("YES");
        }
    }

    protected String initIndexName() {
        String temp = Token.getTokenAfter(this.statement, "INDEX").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "INDEX", '[', ']').trim() : Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            name = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "INDEX"), '.');
        }
        return name;
    }

    private void constructIndex() {
        String name = this.getName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(name);
        if (this.table == null) {
            this.view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(name);
            this.viewProxy = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).getTableViewProxySet()).getByName(name);
        }
        if (this.table != null) {
            Index[] indexes = (Index[])this.table.getKeys();
            for (int i = 0; i < indexes.length; ++i) {
                Index ind = indexes[i];
                if (!ind.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = ind;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        } else if (this.viewProxy != null) {
            this.iov = (IndexOnViewSqlServerv2k5)((StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.design.getSelectedRDBMSSite())).getIndexOnViewSet().createIndexOnView();
            this.iov.setName(this.indexName);
            this.iov.setView(this.viewProxy);
            this.design.getRelationalDesign().stampModelObjectDDL(this.iov);
        }
    }

    private void initUnique() {
        boolean unique;
        if (!this.index.isPK() && (unique = Token.hasToken(this.statement, "UNIQUE"))) {
            this.index.setIndexState("Unique Constraint");
        }
    }

    private void setColumnForIndex() throws ObjectDoesNotExistException {
        block20: {
            Map columnCollection;
            block19: {
                columnCollection = null;
                if (this.table == null) break block19;
                columnCollection = this.getColumnsForTable();
                if (columnCollection.size() <= 0) break block20;
                String columnString = Token.getValBetweenBrackets(this.statement, 1);
                if ("".equalsIgnoreCase(columnString.trim())) {
                    return;
                }
                boolean functionString = Token.hasCloseAndOpenBrackets(columnString);
                if (functionString) {
                    this.index.setIndexExpression(columnString);
                    return;
                }
                StringTokenizer columnToken = new StringTokenizer(columnString, ",");
                while (columnToken.hasMoreTokens()) {
                    Column columnTable;
                    String columnName = columnToken.nextToken().trim();
                    columnName = Token.getValBetweenSquareBrackets(columnName);
                    columnName = Token.getNamesOnly(columnName);
                    String sortOrder = "ASC";
                    int posColumnSpace = columnName.indexOf(" ");
                    if (posColumnSpace > 0) {
                        try {
                            if (columnName.substring(posColumnSpace + 1).trim().equalsIgnoreCase("DESC")) {
                                sortOrder = "DESC";
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                        columnName = columnName.substring(0, posColumnSpace);
                    }
                    if ((columnTable = (Column)columnCollection.get(columnName = Token.getValBetweenSquareBrackets(columnName))) != null) {
                        try {
                            this.index.add(columnTable);
                            this.index.setColumnSortOrder(columnTable, sortOrder);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception occured while adding column to index:" + this.statement);
                            this.importLog.addError("Error in adding column " + columnName + " to index " + this.indexName);
                        }
                        continue;
                    }
                    throw new ObjectDoesNotExistException("Column");
                }
                break block20;
            }
            if (this.viewProxy != null && (columnCollection = this.getColumnsForView()).size() > 0) {
                String columnString = Token.getValBetweenBrackets(this.statement, 1);
                StringTokenizer columnToken = new StringTokenizer(columnString, ",");
                while (columnToken.hasMoreTokens()) {
                    ColumnView columnView;
                    String columnName = columnToken.nextToken().trim();
                    columnName = Token.getValBetweenSquareBrackets(columnName);
                    columnName = Token.getNamesOnly(columnName);
                    String sortOrder = "ASC";
                    int posColumnSpace = columnName.indexOf(" ");
                    if (posColumnSpace > 0) {
                        try {
                            if (columnName.substring(posColumnSpace + 1).trim().equalsIgnoreCase("DESC")) {
                                sortOrder = "DESC";
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                        columnName = columnName.substring(0, posColumnSpace);
                    }
                    if ((columnView = (ColumnView)columnCollection.get(columnName = Token.getValBetweenSquareBrackets(columnName))) != null) {
                        try {
                            this.iov.setCols(columnName);
                            this.iov.setCols(sortOrder);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception occured while adding column to index on view:" + this.statement);
                            this.importLog.addError("Error in adding column " + columnName + " to view index " + this.indexName);
                        }
                        continue;
                    }
                    throw new ObjectDoesNotExistException("Column");
                }
            }
        }
    }

    protected String getName() {
        String name = Token.getQuotedNameAfterToken(this.statement, "ON");
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            name = Token.getValAfterCharacter(name, '.');
        }
        if (name.indexOf(40) > -1) {
            name = name.substring(0, name.indexOf(40));
        }
        return Token.getValBetweenSquareBrackets(name);
    }

    protected Map getColumnsForTable() {
        HashMap<String, Column> collectionColumns = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columns = (Column[])this.table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                collectionColumns.put(columns[i].getName(), columns[i]);
            }
        }
        return collectionColumns;
    }

    private Map getColumnsForView() {
        HashMap<String, ColumnView> collectionColumns = new HashMap<String, ColumnView>();
        if (this.viewProxy != null) {
            ColumnView[] columns = (ColumnView[])this.view.getElements();
            for (int i = 0; i < columns.length; ++i) {
                collectionColumns.put(columns[i].getName(), columns[i]);
            }
        }
        return collectionColumns;
    }

    @Override
    public void parseUK(String statement) {
        this.statement = statement;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.initUnique();
            this.setColumnForIndex();
            if (this.table != null) {
                UniqueProxySqlServerv2k5 uk;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (uk = new UniqueProxySqlServerv2k5(this.index, (StorageDesign)this.stoDesign)) != null) {
                    this.initClustered(uk);
                    this.initFillFactorUK(uk);
                    this.initFileGroupUK(uk);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Error in creating unique key " + this.indexName);
        }
    }

    private void initFileGroupUK(UniqueProxySqlServerv2k5 uk) {
        if (Token.hasToken(this.statement, "ON")) {
            String fileGroupUK = Token.getTokenAfter(this.statement, "ON");
            fileGroupUK = Token.getValBetweenQuotationMarks(fileGroupUK);
            uk.setFilegroup((FileGroupSqlServerv2k5)this.stoDesign.getFileGroupSet().getByName(fileGroupUK));
        }
    }

    private void initFillFactorUK(UniqueProxySqlServerv2k5 uk) {
        String fillFactorValue = this.getIndexOption("FILLFACTOR");
        if (!fillFactorValue.equals("")) {
            try {
                uk.setFillFactor(Integer.parseInt(fillFactorValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Unknown fill factor of unique key " + uk.getName());
            }
        }
    }

    protected boolean isUK() {
        return Token.hasToken(this.statement, "UNIQUE") && !this.isIOV();
    }

    private void initFileGroupPK(PKProxySqlServerv2k5 pk) {
        if (Token.hasToken(this.statement, "ON")) {
            String fileGroupUK = Token.getTokenAfter(this.statement, "ON");
            fileGroupUK = Token.getValBetweenQuotationMarks(fileGroupUK);
            pk.setFilegroup((FileGroupSqlServerv2k5)this.stoDesign.getFileGroupSet().getByName(fileGroupUK));
        }
    }

    private void initFillFactorPK(PKProxySqlServerv2k5 pk) {
        String fillFactorValue = this.getIndexOption("FILLFACTOR");
        if (!fillFactorValue.equals("")) {
            try {
                pk.setFillFactor(Integer.parseInt(fillFactorValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Unknown fill factor of primary key " + pk.getName());
            }
        }
    }

    protected void parseSecondaryXMLIndex(String statement) {
        this.indexName = this.initIndexName();
        String primaryIndName = "";
        if (Token.hasString(statement.toLowerCase(), "using xml index")) {
            String line = Token.getStringAfter(statement.toLowerCase(), "using xml index");
            primaryIndName = Token.getFirstToken(line);
        }
        if (primaryIndName != "") {
            this.site = this.design.getSelectedRDBMSSite();
            this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
            if (this.stoDesign != null) {
                SecondaryXmlIndexSqlServerv2k5 seconmdaryInd = (SecondaryXmlIndexSqlServerv2k5)this.stoDesign.getSecondaryXmlIndexSetv2k5().createXmlIndex();
                seconmdaryInd.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(seconmdaryInd);
                String name = this.getName();
                this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(name);
                if (this.table != null) {
                    Index primaryInd = (Index)((ContainerObjectPlaceHolder)this.table.getIndexes().getByName(primaryIndName)).getObject();
                    IndexProxySqlServerv2k5 indexProxy = (IndexProxySqlServerv2k5)this.stoDesign.getIndexProxySet().getProxy(primaryInd.getObjectID());
                    seconmdaryInd.setPrimaryXmlIndex(indexProxy);
                }
            }
        }
    }

    protected boolean isSecondaryXMLIndex() {
        return !Token.hasToken(this.statement, "PRIMARY") && Token.hasToken(this.statement, "XML");
    }
}

