/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHColumnElementsOraclev9i;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;

public class DomainHandlerReadDDLOraclev9i
implements StatementsConstants,
SectionConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;

    public DomainHandlerReadDDLOraclev9i(Design design) {
        this.design = design;
    }

    public void createDomains(LinkedList statements) {
        Iterator itStat = statements.iterator();
        while (itStat.hasNext()) {
            String statement = DDLStatementHandler.clearCR((String)itStat.next());
            if (!Token.startsWithString(statement, "CREATE TABLE") && !Token.startsWithString(statement, "CREATE GLOBAL TEMPORARY TABLE") && (!Token.startsWithString(statement, "ALTER TABLE") || statement.toUpperCase().indexOf(" ADD (") <= -1 && statement.toUpperCase().indexOf(" MODIFY (") <= -1)) continue;
            ArrayList columns = this.getColumns(statement);
            for (String oneColumn : columns) {
                this.createOneDomain(oneColumn);
            }
        }
    }

    private ArrayList getColumns(String statement) {
        ArrayList<String> tableColumns = new ArrayList<String>();
        String columnStatement = Token.getValBetweenBrackets(statement, 1);
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracket(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracket(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString();
                }
            }
            tableColumns.add(oneColumn.trim());
        }
        return tableColumns;
    }

    private void createOneDomain(String statement) {
        SHColumnElementsOraclev9i columnElements = new SHColumnElementsOraclev9i();
        Map elements = columnElements.getElementsColumn(statement);
        String columnName = (String)elements.get("columnname");
        if (!"".equalsIgnoreCase(columnName)) {
            String datatype = (String)elements.get("datatype");
            String[] parameters = new String[]{(String)elements.get("precision"), (String)elements.get("scale"), (String)elements.get("size")};
            if (datatype != null) {
                String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                nameDatatype = StandardDatatypeNames.getTransformedDatatypeName(nameDatatype, StorageDesignOraclev9i.RDBMS_TYPE);
                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignOraclev9i.RDBMS_TYPE, nameDatatype);
                this.factory.getInstance(this.design, logicalDT, null, 2, parameters, null);
            }
        }
    }
}

