/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHGrantPermissionsOraclev10g
extends DDLStatementHandler {
    private PermissionsOracle permissions;
    private StorageDesignOracle storageDesign;
    private TableProxyOracle table = null;
    private static final Logger LOGGER = new Logger(SHGrantPermissionsOraclev10g.class);

    public SHGrantPermissionsOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHGrantPermissionsOraclev10g.clearCR(line);
        if (statement.toUpperCase().startsWith("GRANT") && Token.hasToken(statement, "TO")) {
            try {
                this.statement = statement.replaceAll("\"", "");
                this.grantPermissions();
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHGrantPermissionsOraclev10g.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void grantPermissions() throws ObjectDoesNotExistException {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            String on = Token.getStringAfterToken(this.statement, "ON");
            if (on.toUpperCase().startsWith("COMMIT REFRESH")) {
                on = Token.getStringAfterToken(on, "ON");
            }
            ArrayList users = this.initUsersOrRoles();
            for (int i = 0; i < users.size(); ++i) {
                if (on.isEmpty()) {
                    this.initSystemPrivileges(users.get(i));
                    continue;
                }
                StorageObject onObject = this.initOn(on);
                if (onObject == null) continue;
                this.initObjectPrivileges(onObject, (StorageObject)users.get(i));
            }
        }
        this.permissions = null;
        this.table = null;
    }

    private void initObjectPrivileges(StorageObject onObject, StorageObject userOrRole) {
        int onCommitIndex;
        this.permissions = null;
        String priv = Token.getStringAfterToken(this.statement, "GRANT");
        boolean hasGrantOption = this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1;
        String privUpper = priv.toUpperCase();
        int onIndex = privUpper.indexOf(" ON ", (onCommitIndex = privUpper.indexOf("ON COMMIT REFRESH")) + 1);
        if (onIndex >= 0) {
            priv = priv.substring(0, onIndex);
        }
        StringTokenizer tokenizer = new StringTokenizer(priv, ",");
        while (tokenizer.hasMoreTokens()) {
            priv = tokenizer.nextToken().trim();
            while (Token.hasOpenBracketNoClose(priv) && tokenizer.hasMoreTokens()) {
                priv = priv + ", " + tokenizer.nextToken().trim();
            }
            if (Token.hasCloseAndOpenBrackets(priv)) {
                String columns = Token.getValBetweenBrackets(priv).trim();
                priv = Token.getStringBefore(priv, "(");
                this.initColumns(columns, priv, userOrRole, hasGrantOption);
                continue;
            }
            if (this.permissions == null) {
                this.permissions = this.getPermissionForUser(userOrRole, onObject);
                if (this.permissions == null) {
                    this.permissions = this.storageDesign.getPermissionsSet().createPermissions();
                    this.initOnObject(onObject);
                    this.initTo(userOrRole);
                }
            }
            if (hasGrantOption) {
                this.permissions.setPrivilegesWithGrantOption(priv);
            } else {
                this.permissions.setPrivileges(priv);
            }
            this.initHierarchyOption();
        }
    }

    private void initSystemPrivileges(Object userOrRole) {
        if (userOrRole != null) {
            String priv = Token.getStringAfterToken(this.statement, "GRANT");
            priv = Token.getStringBeforeToken(priv, "TO");
            StringTokenizer tokenizer = new StringTokenizer(priv, ",");
            while (tokenizer.hasMoreTokens()) {
                String pr = tokenizer.nextToken().trim().toUpperCase();
                this.addPrivileges(userOrRole, pr);
            }
        }
    }

    private void addPrivileges(Object object, String privileges) {
        boolean withAdminOption = this.statement.toUpperCase().indexOf("WITH ADMIN OPTION") > -1;
        RoleOracle grantedRole = (RoleOracle)this.storageDesign.getRoleSet().getByName(privileges);
        if (object instanceof UserOracle) {
            if (grantedRole != null) {
                if (withAdminOption) {
                    ((UserOracle)object).setRolesWithAdminOption(privileges);
                } else {
                    ((UserOracle)object).setRoles(privileges);
                }
            } else if (withAdminOption) {
                ((UserOracle)object).setPrivilegesWithAdminOption(privileges);
            } else {
                ((UserOracle)object).setPrivileges(privileges);
            }
        } else if (object instanceof RoleOracle) {
            if (grantedRole != null) {
                if (withAdminOption) {
                    ((RoleOracle)object).setRolesWithAdminOption(privileges);
                } else {
                    ((RoleOracle)object).setRoles(privileges);
                }
            } else if (withAdminOption) {
                ((RoleOracle)object).setPrivilegesWithAdminOption(privileges);
            } else {
                ((RoleOracle)object).setPrivileges(privileges);
            }
        }
    }

    private void initColumns(String columns, String priv, StorageObject userOrRole, boolean hasGrantOption) {
        if (this.table != null) {
            StringTokenizer tokenizer = new StringTokenizer(columns, ",");
            String column = null;
            while (tokenizer.hasMoreTokens()) {
                column = tokenizer.nextToken();
                ColumnProxy columnProxy = this.table.getColumnProxyByName(Token.getFirstName(column, '\"', '\"'));
                if (columnProxy == null) continue;
                String colName = columnProxy.getName();
                PermissionsOracle colPermissions = this.getColumnPermissionsObject(colName, this.table, userOrRole);
                if (colPermissions == null) {
                    colPermissions = this.storageDesign.getPermissionsSet().createPermissions();
                    if (userOrRole instanceof UserOracle) {
                        colPermissions.setUser((UserOracle)userOrRole);
                    } else if (userOrRole instanceof RoleOracle) {
                        colPermissions.setRole((RoleOracle)userOrRole);
                    }
                    colPermissions.setColumnsTable(this.table);
                }
                String colNameAndPrivilege = colName + ", " + priv;
                if (hasGrantOption) {
                    colPermissions.setColumnListWithGrantOption(colNameAndPrivilege);
                    continue;
                }
                colPermissions.setColumnList(colNameAndPrivilege);
            }
        }
    }

    private void initOnObject(StorageObject proxy) {
        if (proxy instanceof TableProxyOracle) {
            this.permissions.setTable((TableProxyOracle)proxy);
        } else if (proxy instanceof TableViewProxyOracle) {
            this.permissions.setView((TableViewProxyOracle)proxy);
        } else if (proxy instanceof SnapshotOracle) {
            this.permissions.setSnapshot((SnapshotOracle)proxy);
        } else if (proxy instanceof SequenceOracle) {
            this.permissions.setSequence((SequenceOracle)proxy);
        } else if (proxy instanceof StoredProcedureOracle) {
            this.permissions.setProc((StoredProcedureOracle)proxy);
        } else if (proxy instanceof FunctionOracle) {
            this.permissions.setFunctionOracle((FunctionOracle)proxy);
        } else if (proxy instanceof PackageOracle) {
            this.permissions.setPackage((PackageOracle)proxy);
        } else if (proxy instanceof DirectoryOracle) {
            this.permissions.setDirectoryOracle((DirectoryOracle)proxy);
        } else if (proxy instanceof StructuredTypeProxyOracle) {
            this.permissions.setStructuredTypeOracle((StructuredTypeProxyOracle)proxy);
        } else if (proxy instanceof CollectionTypeProxyOracle) {
            this.permissions.setCollectionTypeOracle((CollectionTypeProxyOracle)proxy);
        } else if (proxy instanceof ExternalTableOracle) {
            this.permissions.setExternalTableOracle((ExternalTableOracle)proxy);
        }
    }

    private PermissionsOracle getPermissionForUser(StorageObject userOrRole, StorageObject proxy) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        PermissionsOracle perm = null;
        while (it.hasNext()) {
            perm = (PermissionsOracle)it.next();
            if (perm.getUser() != userOrRole && perm.getRole() != userOrRole || perm.getTable() != proxy && perm.getView() != proxy && perm.getSnapshot() != proxy && perm.getSequence() != proxy && perm.getProc() != proxy && perm.getFunctionOracle() != proxy && perm.getPackage() != proxy && perm.getDirectoryOracle() != proxy && perm.getStructuredTypeOracle() != proxy && perm.getCollectionTypeOracle() != proxy && perm.getExternalTableOracle() != proxy) continue;
            return perm;
        }
        return null;
    }

    private PermissionsOracle getColumnPermissionsObject(String columnName, TableProxyOracle tableProxy, StorageObject userOrRole) {
        for (PermissionsOracle perm : this.storageDesign.getPermissionsSet()) {
            String permColumnName;
            if (perm.getColumnsTable() != tableProxy || perm.getUser() != userOrRole && perm.getRole() != userOrRole) continue;
            String permColumnList = perm.getColumnList();
            if (permColumnList.isEmpty()) {
                permColumnList = perm.getColumnWithGrantOptionList();
            }
            if (!(permColumnName = permColumnList.substring(0, permColumnList.indexOf(44))).equalsIgnoreCase(columnName)) continue;
            return perm;
        }
        return null;
    }

    private StorageObject initOn(String on) throws ObjectDoesNotExistException {
        if (on.toUpperCase().startsWith("DIRECTORY ")) {
            String dirName = Token.getQuotedNameAfterToken(on, "DIRECTORY");
            DirectoryOracle doR = (DirectoryOracle)this.storageDesign.getDirectorySet().getByName(dirName);
            if (doR != null) {
                return doR;
            }
            throw new ObjectDoesNotExistException(dirName);
        }
        if (!(on = Token.getFirstName(on, '\"', '\"')).equalsIgnoreCase("")) {
            RelationalDesign relationalDesign = this.storageDesign.getPhysicalDesign();
            Table relationalTable = (Table)relationalDesign.getTableSet().getByName(on);
            if (relationalTable != null) {
                this.table = (TableProxyOracle)this.storageDesign.getProxy(relationalTable);
                if (this.table != null) {
                    if (this.table.getSnapshot() != null) {
                        return this.table.getSnapshot();
                    }
                    return this.table;
                }
            } else {
                SequenceOracle sequence;
                TableView relationalView = (TableView)relationalDesign.getTableViewSet().getByName(on);
                if (relationalView != null) {
                    return this.storageDesign.getProxy(relationalView);
                }
                String userName = "";
                String objName = on;
                int dotIndex = on.indexOf(46);
                if (dotIndex > -1) {
                    userName = on.substring(0, dotIndex);
                    objName = on.substring(dotIndex + 1);
                }
                if ((sequence = userName.equals("") ? (SequenceOracle)this.storageDesign.getSequenceSet().getByName(objName) : (SequenceOracle)this.storageDesign.getSequenceSet().getByUserSchemaAndName(userName, objName)) != null) {
                    return sequence;
                }
                StoredProcedureOracle proc = userName.equals("") ? (StoredProcedureOracle)this.storageDesign.getStoredProcedureSet().getByName(objName) : this.storageDesign.getStoredProcedureSet().getByOwnerAndName(userName, objName);
                if (proc != null) {
                    return proc;
                }
                FunctionOracle func = userName.equals("") ? (FunctionOracle)this.storageDesign.getFunctionSet().getByName(objName) : this.storageDesign.getFunctionSet().getByOwnerAndName(userName, objName);
                if (func != null) {
                    return func;
                }
                PackageOracle pack = userName.equals("") ? (PackageOracle)this.storageDesign.getPackageSet().getByName(objName) : this.storageDesign.getPackageSet().getByOwnerAndName(userName, objName);
                if (pack != null) {
                    return pack;
                }
                ExternalTableOracle extTable = userName.equals("") ? (ExternalTableOracle)this.storageDesign.getExternalTableSet().getByName(objName) : this.storageDesign.getExternalTableSet().getByOwnerAndName(userName, objName);
                if (extTable != null) {
                    return extTable;
                }
                CollectionTypeProxy ct = userName.equals("") ? this.storageDesign.getCollectionTypeProxySet().getByName(objName) : this.storageDesign.getCollectionTypeProxySet().getByOwnerAndName(userName, objName);
                if (ct != null) {
                    return ct;
                }
                StructuredTypeProxy st = userName.equals("") ? this.storageDesign.getStructuredTypeProxySet().getByName(objName) : this.storageDesign.getStructuredTypeProxySet().getBySchemaAndName(userName, objName);
                if (st != null) {
                    return st;
                }
            }
        }
        return null;
    }

    private void initTo(Object object) {
        String to = Token.getStringAfterToken(this.statement, "TO").trim();
        if (Token.hasToken(to, "WITH")) {
            to = Token.getStringBeforeToken(to, "WITH");
        }
        if (!to.equalsIgnoreCase("")) {
            if (object instanceof UserOracle) {
                this.permissions.setUser((UserOracle)object);
            } else if (object instanceof RoleOracle) {
                this.permissions.setRole((RoleOracle)object);
            }
        } else {
            LOGGER.error("SHGrantPermissionsOracle.initTo(): wrong syntax!");
        }
    }

    private ArrayList initUsersOrRoles() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        String to = Token.getStringAfterToken(this.statement, "TO").trim();
        if (Token.hasToken(to, "WITH")) {
            to = Token.getStringBeforeToken(to, "WITH");
        }
        if (!to.equalsIgnoreCase("")) {
            UserSetOracle users = this.storageDesign.getUserSet();
            RoleSetOracle roles = this.storageDesign.getRoleSet();
            StringTokenizer tokenizer = new StringTokenizer(to, ",");
            String userOrRole = null;
            while (tokenizer.hasMoreTokens()) {
                userOrRole = tokenizer.nextToken().trim();
                ModelObject user = users.getByName(userOrRole = Token.getValBetweenSquareBrackets(userOrRole));
                if (user != null) {
                    list.add(user);
                    continue;
                }
                ModelObject role = roles.getByName(userOrRole);
                if (role != null) {
                    list.add(role);
                    continue;
                }
                user = users.createUser();
                user.setName(userOrRole);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
                list.add(user);
            }
        } else {
            LOGGER.error("SHGrantPermissionsOracle.initTo(): wrong syntax!");
        }
        return list;
    }

    private void initHierarchyOption() {
        if (this.statement.toUpperCase().indexOf("WITH_HIERARCHY_OPTION") > -1) {
            ((PermissionsOraclev9i)this.permissions).setHierarchyOption("YES");
        } else {
            ((PermissionsOraclev9i)this.permissions).setHierarchyOption("NO");
        }
    }
}

