/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.oracle.AggregateFunctionsOracle;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSnapshotOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateSnapshotOraclev10g.class);
    private SnapshotOraclev10g snapshot;
    private StorageDesignOraclev10g storageDesign;
    private SHCreateTableOraclev10g shCreateTableOraclev10g = null;
    public static final String FAST = "FAST";
    public static final String COMPLETE = "COMPLETE";
    public static final String NEVER = "NEVER";

    public SHCreateSnapshotOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateSnapshotOraclev10g.clearCR(line);
        if (Token.startsWithString(statement, "CREATE MATERIALIZED VIEW") || Token.startsWithString(statement, "CREATE SNAPSHOT")) {
            this.parseSnapshot(statement, line);
        } else {
            this.nextHandler(line);
        }
    }

    private void parseSnapshot(String statement, String line) {
        try {
            this.statement = statement;
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(site);
            if (this.storageDesign != null) {
                this.snapshot = (SnapshotOraclev10g)this.storageDesign.getSnapshotSet().createSnapshot();
                if (this.snapshot != null) {
                    String afterName = this.initSnapshotName();
                    Table relationalTable = null;
                    this.initPrebuild();
                    TableProxyOracle prebuiltTableProxy = this.snapshot.getOnPrebuildTable();
                    if (prebuiltTableProxy != null) {
                        relationalTable = (Table)prebuiltTableProxy.getObject();
                    } else {
                        TableProxyOracle implementedTableProxy = this.initSnapshotTable(afterName);
                        relationalTable = (Table)implementedTableProxy.getObject();
                        if (Token.hasToken(statement, "CLUSTER")) {
                            this.initCluster();
                        } else {
                            this.initSegment(implementedTableProxy);
                        }
                        this.initPartitioning(implementedTableProxy);
                        this.initParallelClause();
                    }
                    this.initUsingIndex();
                    this.initRefreshClause();
                    this.initForUpdate();
                    this.initQueryRewrite();
                    this.initSubquery(line, relationalTable);
                    this.design.getRelationalDesign().stampModelObjectDDL(this.snapshot);
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
            this.importLog.addFailedStatement(line);
        }
    }

    private String initSnapshotName() {
        String afterName;
        String startOfName = Token.getTokenAfter(this.statement, "CREATE").equalsIgnoreCase("SNAPSHOT") ? Token.getStringAfter(this.statement, "SNAPSHOT") : Token.getStringAfter(this.statement, "VIEW");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        int dotIndex = name.indexOf(46);
        if (dotIndex > -1) {
            String ownerName = name.substring(0, dotIndex);
            UserOraclev10g owner = (UserOraclev10g)this.storageDesign.getUserSet().getByName(ownerName);
            if (owner == null && !ownerName.trim().equalsIgnoreCase("")) {
                owner = (UserOraclev10g)this.storageDesign.getUserSet().createUser();
                owner.setName(ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            this.snapshot.setUser(owner);
            name = name.substring(dotIndex + 1);
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
        }
        this.snapshot.setName(name);
        if (startOfName.startsWith("\"")) {
            startOfName = startOfName.substring(1);
            if (!name.equals(name.toUpperCase())) {
                this.snapshot.setNameHasQuotes(true);
            }
        }
        if ((afterName = startOfName.substring(name.length())).startsWith("\"")) {
            afterName = afterName.substring(1);
        }
        return afterName.trim();
    }

    private void initSegment(TableProxyOracle implementedTableProxy) {
        SegmentOracle segment;
        int lastBracketInd;
        String text = this.statement;
        if (Token.hasToken(text, "PARTITION")) {
            text = Token.getStringBeforeToken(text, "PARTITION");
        }
        if (Token.hasToken(text, "XMLTYPE")) {
            text = Token.getStringBeforeToken(text, "XMLTYPE");
        }
        if (Token.hasToken(text, "VARRAY")) {
            text = Token.getStringBeforeToken(text, "VARRAY");
        }
        if (text.toUpperCase().indexOf("NESTED TABLE") > -1) {
            text = Token.getStringBefore(text, "NESTED TABLE");
        }
        if (Token.hasToken(text, "LOB")) {
            this.initLobStorage(text);
            text = Token.getStringBeforeToken(text, "LOB");
        }
        if (text.length() < this.statement.length() && (lastBracketInd = this.statement.lastIndexOf(")")) > -1) {
            text = text + ' ' + this.statement.substring(lastBracketInd + 1).trim();
        }
        if (text.toUpperCase().indexOf("USING INDEX") > -1) {
            text = Token.getStringBefore(text, "USING INDEX");
        }
        if (Token.getTokenAfter(text, "ORGANIZATION").equalsIgnoreCase("INDEX") && implementedTableProxy != null) {
            implementedTableProxy.setOrganization("INDEX");
            if (Token.hasToken(text, "OVERFLOW")) {
                String afterOverflow = Token.getStringAfter(text, "OVERFLOW");
                this.initOverflowProps(afterOverflow, implementedTableProxy);
                text = Token.getStringBeforeToken(text, "OVERFLOW");
            }
            this.initIOTProperties(text, implementedTableProxy);
        }
        if ((Token.hasToken(text, "PCTFREE") || Token.hasToken(text, "PCTUSED") || Token.hasToken(text, "INITRANS") || Token.hasToken(text, "MAXTRANS") || Token.hasToken(text, "STORAGE")) && (segment = this.storageDesign.createSegmentOracle()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            this.initPhysicalAttributesClause(text, segment);
            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
            this.snapshot.setSegment(equalSegment);
        }
        this.initTableSpace(text);
        this.initLogging(text);
        this.initCache(text);
    }

    private void initIOTProperties(String beforeOverflow, TableProxyOracle tableProxy) {
        if (Token.hasToken(beforeOverflow, "PCTTHRESHOLD")) {
            String threshold = Token.getTokenAfter(beforeOverflow, "PCTTHRESHOLD");
            try {
                tableProxy.setIotPctThreshold(Integer.parseInt(threshold));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Wrong PCTTHRESHOLD format near " + beforeOverflow, e);
                this.importLog.addWarning("Wrong PCTTHRESHOLD format in statement " + this.statement);
            }
        }
        if (Token.hasToken(beforeOverflow, "COMPRESS")) {
            String compress = Token.getTokenAfter(beforeOverflow, "COMPRESS");
            try {
                tableProxy.setIotCompress(Integer.parseInt(compress));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (Token.hasToken(beforeOverflow, "INCLUDING")) {
            String colName = Token.getQuotedNameAfterToken(beforeOverflow, "INCLUDING");
            tableProxy.setIotIncluding(tableProxy.getColumnProxyByName(colName));
        }
    }

    private void initOverflowProps(String afterOverflow, TableProxyOracle tableProxy) {
        if (!afterOverflow.isEmpty()) {
            if (Token.hasToken(afterOverflow, "PCTFREE") || Token.hasToken(afterOverflow, "PCTUSED") || Token.hasToken(afterOverflow, "INITRANS") || Token.hasToken(afterOverflow, "MAXTRANS") || Token.hasToken(afterOverflow, "STORAGE")) {
                SegmentOracle segment = this.storageDesign.createSegmentOracle();
                this.design.getRelationalDesign().stampModelObjectDDL(segment);
                this.initPhysicalAttributesClause(afterOverflow, segment);
                SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
                tableProxy.setIotOverflowSegment(equalSegment);
            }
            if (Token.hasToken(afterOverflow, "NOLOGGING")) {
                tableProxy.setIotOverflowLogging("NO");
            } else if (Token.hasToken(afterOverflow, "LOGGING")) {
                tableProxy.setIotOverflowLogging("YES");
            }
            if (Token.hasToken(afterOverflow, "TABLESPACE")) {
                String tsName = Token.getQuotedNameAfterToken(afterOverflow, "TABLESPACE");
                TableSpaceOracle ts = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(tsName);
                if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                    ts = this.storageDesign.createTableSpaceOracle();
                    ts.setName(tsName);
                    this.design.getRelationalDesign().stampModelObjectDDL(ts);
                }
                if (ts != null) {
                    tableProxy.setIotOverflowTablespace(ts);
                }
            }
        }
    }

    private void initPhysicalAttributesClause(String statement, SegmentOracle segment) {
        this.initPctFree(statement, segment);
        this.initPctUsed(statement, segment);
        this.initInitrans(statement, segment);
        this.initMaxtrans(statement, segment);
        this.initStorage(statement, segment);
    }

    private void initPctFree(String line, SegmentOracle segment) {
        if (Token.hasToken(line, "PCTFREE") && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
            String pctFreeStr = Token.getTokenAfter(line, "PCTFREE").trim();
            try {
                int pctFree = Integer.parseInt(pctFreeStr);
                segment.setPCTFree(pctFree);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPctFree : " + e.getMessage());
            }
        }
    }

    private void initPctUsed(String line, SegmentOracle segment) {
        if (Token.hasToken(line, "PCTUSED") && this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
            String strValue = Token.getTokenAfter(line, "PCTUSED").trim();
            try {
                int value = Integer.parseInt(strValue);
                segment.setPCTUsed(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTUSED format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPctUsed : " + e.getMessage());
            }
        }
    }

    private void initInitrans(String line, SegmentOracle segment) {
        if (Token.hasToken(line, "INITRANS") && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
            String strValue = Token.getTokenAfter(line, "INITRANS").trim();
            try {
                int value = Integer.parseInt(strValue);
                segment.setInitrans(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initInitrans : " + e.getMessage());
            }
        }
    }

    private void initMaxtrans(String line, SegmentOracle segment) {
        if (Token.hasToken(line, "MAXTRANS") && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
            String strValue = Token.getTokenAfter(line, "MAXTRANS").trim();
            try {
                int value = Integer.parseInt(strValue);
                segment.setMaxTrans(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initMaxtrans : " + e.getMessage());
            }
        }
    }

    private void initStorage(String line, SegmentOracle segment) {
        String stLine;
        if (Token.hasToken(line, "STORAGE") && Token.getFirstToken(stLine = Token.getStringAfter(line, "STORAGE")).equalsIgnoreCase("(")) {
            stLine = Token.getValBetweenBrackets(stLine, 1).trim();
            this.initInitial(stLine, segment, null);
            this.initNext(stLine, segment, null);
            this.initPCtIncrease(stLine, segment, null);
            this.initMinExtents(stLine, segment, null);
            this.initMaxExtents(stLine, segment, null);
            this.initFreeLists(stLine, segment, null);
            this.initFreeListGroups(stLine, segment, null);
            this.initSegBufferPool(stLine, segment, null);
        }
    }

    private void initTableSpace(String text) {
        if (Token.hasToken(text, "TABLESPACE")) {
            String tsName = Token.getQuotedNameAfterToken(text, "TABLESPACE");
            TableSpaceOracle ts = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(tsName);
            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                ts = this.storageDesign.createTableSpaceOracle();
                ts.setName(tsName);
                this.design.getRelationalDesign().stampModelObjectDDL(ts);
            }
            this.snapshot.setTablespace(ts);
        }
    }

    private void initLogging(String text) {
        if (Token.hasToken(text, "NOLOGGING")) {
            this.snapshot.setLogging("NO");
        } else if (Token.hasToken(text, "LOGGING")) {
            this.snapshot.setLogging("YES");
        }
    }

    private void initCache(String text) {
        if (Token.hasToken(text, "NOCACHE")) {
            this.snapshot.setCache("NO");
        } else if (Token.hasToken(text, "CACHE")) {
            this.snapshot.setCache("YES");
        }
    }

    private void initLobStorage(String text) {
        String lobString = text;
        while (Token.hasToken(lobString, "LOB")) {
            String params;
            String tsName;
            LobStorageOraclev10g lobStorage = (LobStorageOraclev10g)this.storageDesign.getLobStorageSet().createLobStorage();
            this.design.getRelationalDesign().stampModelObjectDDL(lobStorage);
            lobStorage.setSnapshot(this.snapshot);
            String temp = Token.getStringAfter(lobString, "LOB");
            String lobColumns = Token.getValBetweenBrackets(temp, 1).replaceAll("\"", "").trim();
            lobStorage.setColumn(lobColumns);
            String saToken = "STORE AS";
            if (Token.getTokenAfter(temp.toUpperCase(), "STORE AS").equalsIgnoreCase("SECUREFILE")) {
                saToken = "SECUREFILE";
                if (lobStorage instanceof LobStorageOraclev11g) {
                    lobStorage.setLobStorageType("SECUREFILE");
                }
            } else if (Token.getTokenAfter(temp.toUpperCase(), "STORE AS").equalsIgnoreCase("BASICFILE")) {
                saToken = "BASICFILE";
                if (lobStorage instanceof LobStorageOraclev11g) {
                    lobStorage.setLobStorageType("BASICFILE");
                }
            }
            temp = Token.getStringAfter(temp, saToken);
            String lsName = Token.getFirstToken(temp).trim();
            if (!(lsName = Token.getName(lsName)).equalsIgnoreCase("(")) {
                lobStorage.setLobSegmentName(lsName);
            }
            if (!(tsName = Token.getQuotedNameAfterToken(params = Token.getValBetweenBrackets(temp, 1).trim(), "TABLESPACE")).equals("")) {
                TableSpaceOracle tableSpace = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(tsName);
                if (tableSpace == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                    tableSpace = this.storageDesign.createTableSpaceOracle();
                    tableSpace.setName(tsName);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
                }
                if (tableSpace != null) {
                    lobStorage.setTableSpace(tableSpace);
                }
            }
            this.initLobStorageStorage(params, lobStorage);
            lobString = temp;
        }
    }

    private void initLobStorageStorage(String line, LobStorageOraclev10g lobStorage) {
        String stLine;
        if (Token.hasToken(line, "STORAGE") && Token.getFirstToken(stLine = Token.getStringAfter(line, "STORAGE")).equalsIgnoreCase("(")) {
            stLine = Token.getValBetweenBrackets(stLine, 1).trim();
            this.initInitial(stLine, null, lobStorage);
            this.initNext(stLine, null, lobStorage);
            this.initPCtIncrease(stLine, null, lobStorage);
            this.initMinExtents(stLine, null, lobStorage);
            this.initMaxExtents(stLine, null, lobStorage);
            this.initFreeLists(stLine, null, lobStorage);
            this.initFreeListGroups(stLine, null, lobStorage);
            this.initSegBufferPool(stLine, null, lobStorage);
        }
        this.initChunk(line, lobStorage);
        this.initRetention(line, lobStorage);
        this.initPctVersion(line, lobStorage);
        this.initFreePools(line, lobStorage);
        this.initStorageInRow(line, lobStorage);
        this.initCompression(line, lobStorage);
        this.initDuplication(line, lobStorage);
        this.initLSCache(line, lobStorage);
        this.initLogging(line, lobStorage);
    }

    private void initChunk(String line, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "CHUNK")) {
            try {
                int value = Integer.parseInt(Token.getTokenAfter(line, "CHUNK").trim());
                lobStorage.setChunk(value);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initChunk : ", e);
                this.importLog.addWarning("Wrong CHUNK format in statement " + this.statement);
            }
        }
    }

    private void initPctVersion(String line, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "PCTVERSION")) {
            try {
                int value = Integer.parseInt(Token.getTokenAfter(line, "PCTVERSION").trim());
                lobStorage.setPCTVersion(value);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPctVersion : ", e);
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
            }
        }
    }

    private void initRetention(String line, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "RETENTION")) {
            lobStorage.setOldVersions("RETENTION");
        }
    }

    private void initFreePools(String line, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "FREEPOOLS")) {
            try {
                int value = Integer.parseInt(Token.getTokenAfter(line, "FREEPOOLS").trim());
                lobStorage.setFreepools(value);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initFreePools : ", e);
                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + this.statement);
            }
        }
    }

    private void initStorageInRow(String line, LobStorageOraclev10g lobStorage) {
        if (Token.hasString(line, "STORAGE IN ROW")) {
            String value = Token.getTokenBefore(line, "STORAGE IN ROW");
            lobStorage.setStorageInRow(value.toUpperCase());
        }
    }

    private void initCompression(String line, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "COMPRESS")) {
            lobStorage.setCompression("YES");
            String compressionOption = Token.getTokenAfter(line, "COMPRESS");
            if (compressionOption.equalsIgnoreCase("HIGH") || compressionOption.equalsIgnoreCase("MEDIUM") || compressionOption.equalsIgnoreCase("LOW")) {
                lobStorage.setCompressionType(compressionOption.toUpperCase());
            }
        } else if (Token.hasToken(line, "NOCOMPRESS")) {
            lobStorage.setCompression("NO");
        }
    }

    private void initDuplication(String line, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "DEDUPLICATE")) {
            lobStorage.setDuplication("DEDUPLICATE");
        } else if (Token.hasToken(line, "KEEP_DUPLICATES")) {
            lobStorage.setDuplication("KEEP_DUPLICATES");
        }
    }

    private void initLSCache(String line, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "CACHE")) {
            if (Token.hasString(line.toUpperCase(), "CACHE READS")) {
                lobStorage.setCache("CACHE READS");
            } else {
                lobStorage.setCache("CACHE");
            }
        } else if (Token.hasToken(line, "NOCACHE")) {
            lobStorage.setCache("NOCACHE");
        }
    }

    private void initLogging(String line, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "NOLOGGING")) {
            lobStorage.setLogging("NO");
        } else if (Token.hasToken(line, "LOGGING")) {
            lobStorage.setLogging("YES");
        } else if (Token.hasToken(line, "FILESYSTEM_LIKE_LOGGING")) {
            lobStorage.setLogging("FILESYSTEM_LIKE_LOGGING");
        }
    }

    private void initInitial(String line, SegmentOracle segment, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "INITIAL") && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "INITIAL").trim());
            try {
                long valueIE = Long.parseLong(str);
                if (segment != null) {
                    segment.setSCInitialExtent(valueIE);
                } else if (lobStorage != null) {
                    lobStorage.setSCInitialExtent(valueIE);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initInitial : ", e);
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
            }
        }
    }

    private void initNext(String line, SegmentOracle segment, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "NEXT") && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "NEXT").trim());
            try {
                long valueSO = Long.parseLong(str);
                if (segment != null) {
                    segment.setSCNextExtent(valueSO);
                } else if (lobStorage != null) {
                    lobStorage.setSCNextExtent(valueSO);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initNext: ", e);
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
            }
        }
    }

    private void initPCtIncrease(String line, SegmentOracle segment, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "PCTINCREASE") && this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "PCTINCREASE").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCPctIncrease(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCPctIncrease(value);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPCtIncrease: ", e);
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
            }
        }
    }

    private void initMinExtents(String line, SegmentOracle segment, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "MINEXTENTS") && this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MINEXTENTS").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCMinExtents(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCMinExtents(value);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initMinExtents: ", e);
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
            }
        }
    }

    private void initMaxExtents(String line, SegmentOracle segment, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "MAXEXTENTS") && this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MAXEXTENTS").trim());
            if (segment != null) {
                segment.setSCMaxExtents(str);
            } else {
                lobStorage.setSCMaxExtents(str);
            }
        }
    }

    private void initFreeLists(String line, SegmentOracle segment, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "FREELISTS") && this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "FREELISTS").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCFreeLists(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCFreeLists(value);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initFreeLists: ", e);
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
            }
        }
    }

    private void initFreeListGroups(String line, SegmentOracle segment, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "GROUPS") && this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "GROUPS").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCFreelistGroups(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCFreelistGroups(value);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initFreeListGroups: ", e);
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
            }
        }
    }

    private void initSegBufferPool(String line, SegmentOracle segment, LobStorageOraclev10g lobStorage) {
        if (Token.hasToken(line, "BUFFER_POOL") && this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
            String str = Token.getQuotedNameAfterToken(line, "BUFFER_POOL").trim();
            if (segment != null) {
                segment.setSCBufferPool(str);
            } else if (lobStorage != null) {
                lobStorage.setSCBufferPool(str);
            }
        }
    }

    private void initCluster() {
        String clusterName = Token.getQuotedNameAfterToken(this.statement, "CLUSTER");
        clusterName = clusterName.substring(clusterName.lastIndexOf(46) + 1);
        ClusterOraclev10g cluster = (ClusterOraclev10g)this.storageDesign.getClusterSet().getByName(clusterName);
        if (cluster != null) {
            this.snapshot.setCluster(cluster);
            String columns = Token.getStringAfterToken(this.statement, "CLUSTER");
            columns = Token.getValBetweenBrackets(columns, 1);
            this.snapshot.setClusterColumns(columns);
        }
    }

    private void initPartitioning(TableProxyOracle implementedTableProxy) {
        int partitionByInd = this.statement.toUpperCase().indexOf("PARTITION BY ");
        if (partitionByInd > -1) {
            String partitionText = this.statement.substring(partitionByInd);
            String partitionClause = Token.getStringBeforeToken(partitionText, "SELECT");
            if (partitionClause.length() == 0) {
                partitionClause = Token.getStringBefore(partitionText, "(SELECT ");
            }
            while (partitionClause.endsWith("(")) {
                partitionClause = partitionClause.substring(0, partitionClause.length() - 1).trim();
            }
            if (Token.hasToken(partitionClause, "USING")) {
                partitionClause = Token.getStringBeforeToken(partitionClause, "USING");
            }
            if (this.shCreateTableOraclev10g == null) {
                this.shCreateTableOraclev10g = new SHCreateTableOraclev10g(this.design);
            }
            this.shCreateTableOraclev10g.initPartitionsForSnapshotTable(partitionClause, (TableProxyOraclev10g)implementedTableProxy);
        }
    }

    private void initParallelClause() {
        if (Token.hasToken(this.statement, "PARALLEL")) {
            this.snapshot.setParalelClause("YES");
            String degree = Token.getTokenAfter(this.statement, "PARALLEL");
            try {
                this.snapshot.setDegree(Integer.parseInt(degree));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void initPrebuild() {
        TableProxyOraclev10g prebuildTable;
        if (Token.hasToken(this.statement, "BUILD")) {
            this.snapshot.setBuild(Token.getTokenAfter(this.statement, "BUILD").toUpperCase());
        } else if (Token.hasString(this.statement.toUpperCase(), "ON PREBUILT TABLE") && (prebuildTable = (TableProxyOraclev10g)((TableProxySetOraclev10g)this.storageDesign.getTableProxySet()).getByName(this.snapshot.getName())) != null) {
            this.snapshot.setOnPrebuildTable(prebuildTable);
            Table table = (Table)prebuildTable.getObject();
            table.setOnPrebuiltTable(true);
            table.setTypeID("4");
            if (Token.hasString(this.statement.toUpperCase(), "WITH REDUCED PRECISION")) {
                this.snapshot.setReducedPrecision("YES");
            }
        }
    }

    private void initUsingIndex() {
        if (Token.hasString(this.statement.toUpperCase(), "USING INDEX")) {
            SegmentOracle indexSegment;
            String indexTablespace;
            this.snapshot.setUseIndex("YES");
            String indexStatement = Token.getStringAfter(this.statement, "USING INDEX");
            if (Token.hasToken(indexStatement, "TABLESPACE") && !"".equalsIgnoreCase(indexTablespace = Token.getNameAfterToken(indexStatement, "TABLESPACE", '\"', '\"'))) {
                TableSpaceOracle tablespace = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(indexTablespace);
                if (tablespace == null && !"SYSTEM".equalsIgnoreCase(indexTablespace)) {
                    tablespace = this.storageDesign.createTableSpaceOracle();
                    tablespace.setName(indexTablespace);
                    this.design.getRelationalDesign().stampModelObjectDDL(tablespace);
                }
                this.snapshot.setIndexTablespace(tablespace);
            }
            if ((Token.hasToken(indexStatement, "INITRANS") || Token.hasToken(indexStatement, "MAXTRANS") || Token.hasToken(indexStatement, "STORAGE")) && (indexSegment = this.storageDesign.createSegmentOracle()) != null) {
                this.design.getRelationalDesign().stampModelObjectDDL(indexSegment);
                this.initPhysicalAttributesClause(indexStatement, indexSegment);
                SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(indexSegment);
                this.snapshot.setIndexSegment(equalSegment);
            }
        } else if (Token.hasString(this.statement.toUpperCase(), "USING NO INDEX")) {
            this.snapshot.setUseIndex("NO");
        }
    }

    private void initRefreshClause() {
        if (Token.hasToken(this.statement, "REFRESH")) {
            if (Token.getTokenBefore(this.statement, "REFRESH").equalsIgnoreCase(NEVER)) {
                this.snapshot.setRefresh(NEVER);
            } else {
                String date;
                this.snapshot.setRefresh("YES");
                String refresh = Token.getStringAfterToken(this.statement, "REFRESH");
                if (Token.hasToken(refresh, FAST)) {
                    this.snapshot.setRefreshType(FAST);
                } else if (Token.hasToken(refresh, COMPLETE)) {
                    this.snapshot.setRefreshType(COMPLETE);
                } else if (Token.hasToken(refresh, "FORCE")) {
                    this.snapshot.setRefreshType("FORCE");
                }
                if (Token.hasString(refresh.toUpperCase(), "ON COMMIT")) {
                    this.snapshot.setAction("ON COMMIT");
                } else if (Token.hasString(refresh.toUpperCase(), "ON DEMAND")) {
                    this.snapshot.setAction("ON DEMAND");
                }
                if (Token.hasToken(refresh, "NEXT")) {
                    date = Token.getStringAfterToken(refresh, "NEXT");
                    date = this.parseDate(date);
                    this.snapshot.setNextDate(date);
                }
                if (Token.hasString(refresh.toUpperCase(), "START WITH ")) {
                    date = refresh.substring(refresh.toUpperCase().indexOf("START WITH ") + 11);
                    date = this.parseDate(date);
                    this.snapshot.setStartDate(date);
                }
                if (Token.hasString(refresh.toUpperCase(), "WITH ROWID")) {
                    this.snapshot.setWith("ROWID");
                } else if (Token.hasString(refresh.toUpperCase(), "WITH PRIMARY KEY")) {
                    this.snapshot.setWith("PRIMARY KEY");
                }
                if (Token.hasString(refresh.toUpperCase(), "USING")) {
                    String usingConstraint;
                    if (Token.getTokenAfter(refresh, "USING").equalsIgnoreCase("DEFAULT")) {
                        this.snapshot.setDefaultSegment("YES");
                    } else if (Token.getTokenAfter(refresh, "USING").equalsIgnoreCase("ENFORCED")) {
                        usingConstraint = Token.getTokenAfter(refresh, "USING");
                        this.snapshot.setUsingConstraint(usingConstraint);
                    } else if (Token.getTokenAfter(refresh, "USING").equalsIgnoreCase("TRUSTED")) {
                        usingConstraint = Token.getTokenAfter(refresh, "USING");
                        this.snapshot.setUsingConstraint(usingConstraint);
                    } else {
                        this.snapshot.setUsingConstraint("ENFORCED");
                        String rollbackSegment = Token.getTokenAfter(refresh, "SEGMENT");
                        RollbackSegmentOracle segment = (RollbackSegmentOracle)this.storageDesign.getRollbackSegmentSet().getByName(rollbackSegment);
                        if (segment != null) {
                            this.snapshot.setRollbackSegment(segment);
                        }
                    }
                    if (Token.hasToken(refresh, "LOCAL")) {
                        this.snapshot.setSegmentType("LOCAL");
                    }
                }
            }
        }
    }

    private String parseDate(String text) {
        String[] match = new String[]{"ON", "START", "NEXT", "WITH", "USING", "FOR", "DISABLE", "ENABLE", "AS"};
        return Token.getStringToFirstMatch(text.toUpperCase(), match);
    }

    private void initForUpdate() {
        if (Token.hasString(this.statement.toUpperCase(), "FOR UPDATE")) {
            this.snapshot.setForUpdate("YES");
        }
    }

    private void initQueryRewrite() {
        if (Token.hasString(this.statement.toUpperCase(), "QUERY REWRITE")) {
            this.snapshot.setQueryRewrite(Token.getTokenBefore(this.statement.toUpperCase(), "QUERY"));
        }
    }

    private void initSubquery(String line, Table table) {
        String query = Token.getStringAfter(line, "AS");
        int afterSelectLength = Token.getStringAfter(query, "SELECT").length();
        if (afterSelectLength > 0) {
            String nextAs;
            while ((nextAs = Token.getStringAfter(query, "AS")).length() > afterSelectLength) {
                query = nextAs;
            }
            if (table != null) {
                table.setMaterializedQueryTable(true);
                table.setUserDefinedSQL(query);
            } else {
                this.snapshot.setSubquery(query);
            }
        }
    }

    private TableProxyOracle initSnapshotTable(String afterName) {
        TableProxyOracle proxy = null;
        try {
            Table table = this.storageDesign.getPhysicalDesign().createTable();
            proxy = (TableProxyOracle)this.storageDesign.getProxy(table);
            UserOracle user = this.snapshot.getUser();
            if (user != null) {
                String userName = user.getName();
                SchemaObjectSet schemaSet = ((RelationalDesign)table.getDesignPart()).getSchemaObjectSet();
                SchemaObject so = (SchemaObject)schemaSet.getByName(userName);
                if (so == null && !userName.trim().equalsIgnoreCase("")) {
                    so = schemaSet.createSchemaObject(null);
                    so.setName(userName);
                    this.design.getRelationalDesign().stampModelObjectDDL(so);
                }
                if (user.getSchemaObject() == null) {
                    user.setSchemaObject(so);
                }
                if (user.getSchemaObject() != so && proxy != null) {
                    proxy.setUser(user);
                }
                table.setSchemaObject(so);
            }
            table.setName(this.snapshot.getName());
            table.setNameHasQuotes(this.snapshot.getNameHasQuotes());
            this.design.getRelationalDesign().stampModelObjectDDL(table);
            table.setTypeID("4");
            this.initColumns(table);
            this.doColumnList(table, afterName);
            if (proxy != null) {
                proxy.setSnapshot(this.snapshot);
            }
        }
        catch (Exception e) {
            LOGGER.error("wrong format in SHCreateSnapshotOracle10g.initSnapshotTable: ", e);
            this.importLog.addWarning("Unable to import Snapshot " + this.statement);
        }
        return proxy;
    }

    private void doColumnList(Table table, String afterName) {
        String cols;
        if (afterName.startsWith("(") && !"".equalsIgnoreCase(cols = Token.getValBetweenBrackets(afterName, 1))) {
            ArrayList<String> columnList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(cols, ",");
            while (tokenizer.hasMoreTokens()) {
                columnList.add(tokenizer.nextToken().trim());
            }
            ContainedObject[] tableColumns = table.getElements();
            if (tableColumns.length == columnList.size()) {
                for (int i = 0; i < tableColumns.length; ++i) {
                    String entry = (String)columnList.get(i);
                    String columnName = Token.getFirstName(entry, '\"', '\"');
                    boolean columnNameHasQuotes = entry.startsWith("\"") && !columnName.equals(columnName.toUpperCase());
                    tableColumns[i].setName(columnName);
                    tableColumns[i].setNameHasQuotes(columnNameHasQuotes);
                }
            }
        }
    }

    private void initColumns(Table table) {
        String query = Token.getStringAfter(this.statement, "SELECT");
        if (!"".equalsIgnoreCase(query)) {
            String stmt = query;
            String afterFrom = "";
            if (Token.hasToken(stmt, "FROM")) {
                int fromInd = stmt.toUpperCase().indexOf(" FROM ");
                String beforeFrom = stmt.substring(0, fromInd);
                afterFrom = stmt.substring(fromInd + 6);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")") && (fromInd = stmt.toUpperCase().indexOf(" FROM ", fromInd + 1)) > -1) {
                    beforeFrom = stmt.substring(0, fromInd);
                    afterFrom = stmt.substring(fromInd + 6);
                }
                stmt = beforeFrom;
            }
            ArrayList<String> tableAliasList = new ArrayList<String>();
            HashMap<String, Table> tableAliasMap = new HashMap<String, Table>();
            if (Token.hasToken(afterFrom, "WHERE")) {
                afterFrom = Token.getStringBeforeToken(afterFrom, "WHERE");
            }
            String[] match = new String[]{"CONNECT", "START", "GROUP", "HAVING", "MODEL", "UNION", "INTERSECT", "MINUS", "ORDER"};
            String afterFromUC = Token.getStringToFirstMatch(afterFrom.toUpperCase(), match);
            afterFrom = afterFrom.substring(0, afterFromUC.length());
            StringTokenizer fromTokenizer = new StringTokenizer(afterFrom, ",");
            while (fromTokenizer.hasMoreTokens()) {
                FKContainer tableOrView = null;
                String fromEntry = fromTokenizer.nextToken();
                String objectName = Token.getFirstName(fromEntry, '\"', '\"');
                String userName = "";
                int dotIndex = objectName.indexOf(46);
                if (dotIndex > -1) {
                    userName = objectName.substring(0, dotIndex);
                    userName = Token.removeQuotes(userName);
                    objectName = objectName.substring(dotIndex + 1);
                }
                objectName = Token.removeQuotes(objectName);
                if (!"".equals(userName) && (tableOrView = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(userName, objectName)) == null) {
                    tableOrView = (TableView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(userName, objectName);
                }
                if (tableOrView == null && (tableOrView = (Table)this.design.getRelationalDesign().getTableSet().getByName(objectName)) == null) {
                    tableOrView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(objectName);
                }
                if (tableOrView == null) continue;
                String aliasName = "";
                int objectNameIndex = fromEntry.indexOf(objectName);
                if (objectNameIndex > -1) {
                    String afterObject = fromEntry.substring(objectNameIndex + objectName.length());
                    if (afterObject.startsWith("\"")) {
                        afterObject = afterObject.substring(1);
                    }
                    if (!(afterObject = afterObject.trim()).startsWith(")")) {
                        aliasName = Token.getFirstName(afterObject, '\"', '\"');
                    }
                }
                if (aliasName.equals("")) {
                    aliasName = objectName;
                }
                tableAliasList.add(aliasName);
                tableAliasMap.put(aliasName, (Table)tableOrView);
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("UNIQUE")) {
                stmt = Token.getStringAfterToken(stmt, "UNIQUE").trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            String columnAlias = null;
            block2: while (tokenizer.hasMoreTokens()) {
                Column newColumn;
                boolean hasAlias;
                int dotIndex;
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")") && tokenizer.hasMoreTokens()) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                boolean isExpression = false;
                if (!column.endsWith("*") && (Token.hasCloseAndOpenBrackets(column) || column.indexOf(43) > -1 || column.indexOf(45) > -1 || column.indexOf(42) > -1 || column.indexOf(47) > -1 || column.indexOf("||") > -1 || Token.hasToken(column, "PRIOR"))) {
                    isExpression = true;
                }
                if (Token.hasToken(column, "AS")) {
                    columnAlias = Token.getStringAfter(column, "AS");
                    column = Token.getStringBeforeToken(column, "AS");
                    column = Token.encodeQuotedString(column);
                } else if ((column = Token.encodeQuotedString(column)).indexOf(32) > -1) {
                    if (column.charAt(column.length() - 1) == '\"') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = columnAlias.lastIndexOf(34);
                        columnAlias = columnAlias.substring(lastIndex) + "\"";
                        column = column.substring(0, lastIndex - 1);
                    } else {
                        String last = Token.getLastToken(column);
                        if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                            columnAlias = last;
                            column = column.substring(0, column.indexOf(last)).trim();
                        }
                    }
                }
                String columnQualifier = "";
                if (!isExpression && (dotIndex = column.lastIndexOf(46)) > -1) {
                    columnQualifier = column.substring(0, dotIndex);
                    int anotherDotIndex = columnQualifier.lastIndexOf(46);
                    if (anotherDotIndex > -1) {
                        columnQualifier = columnQualifier.substring(anotherDotIndex + 1);
                    }
                    columnQualifier = Token.removeQuotes(Token.decodeQuotedString(columnQualifier)).trim();
                    column = column.substring(dotIndex + 1);
                }
                if ((column = Token.removeQuotes(Token.decodeQuotedString(column))).equalsIgnoreCase("*")) {
                    for (String tableAlias : tableAliasList) {
                        Column newColumn2;
                        if (!columnQualifier.equals("") && !columnQualifier.equalsIgnoreCase(tableAlias)) continue;
                        ContainerObject containerObject = (ContainerObject)tableAliasMap.get(tableAlias);
                        if (containerObject instanceof Table) {
                            Table fromTable = (Table)containerObject;
                            for (Column fromColumn : fromTable.getElementsCollection()) {
                                String columnName = fromColumn.getName();
                                newColumn2 = table.createColumn(columnName);
                                newColumn2.setNameHasQuotes(fromColumn.getNameHasQuotes());
                                this.design.getRelationalDesign().stampModelObjectDDL(newColumn2);
                                this.copyColumnDef(fromColumn, newColumn2);
                            }
                            continue;
                        }
                        if (!(containerObject instanceof TableView)) continue;
                        ContainedObject[] viewCols = ((TableView)containerObject).getColumns();
                        for (int i = 0; i < viewCols.length; ++i) {
                            ColumnView viewColumn = (ColumnView)viewCols[i];
                            String columnName = viewColumn.getName();
                            newColumn2 = table.createColumn(columnName);
                            newColumn2.setNameHasQuotes(viewColumn.getNameHasQuotes());
                            this.design.getRelationalDesign().stampModelObjectDDL(newColumn2);
                        }
                    }
                    continue;
                }
                if (column.equalsIgnoreCase("")) continue;
                boolean bl = hasAlias = columnAlias != null && !columnAlias.isEmpty();
                if (hasAlias) {
                    String aliasName = Token.removeQuotes(Token.decodeQuotedString(columnAlias));
                    newColumn = table.createColumn(aliasName);
                    if (columnAlias.startsWith("\"") && !aliasName.equals(aliasName.toUpperCase())) {
                        newColumn.setNameHasQuotes(true);
                    }
                } else {
                    newColumn = table.createColumn(column);
                }
                this.design.getRelationalDesign().stampModelObjectDDL(newColumn);
                if (isExpression) {
                    if (this.isAggregateFunction(column)) {
                        newColumn.setSourceType("Aggregate");
                    } else {
                        newColumn.setSourceType("Derived");
                    }
                    newColumn.setFormulaDesc(column);
                    continue;
                }
                for (String tableAlias : tableAliasList) {
                    if (!columnQualifier.equals("") && !columnQualifier.equalsIgnoreCase(tableAlias)) continue;
                    ContainerObject container = (ContainerObject)tableAliasMap.get(tableAlias);
                    ContainedObject refObject = container.getElementByName(column);
                    if (refObject == null) continue block2;
                    if (!hasAlias) {
                        newColumn.setName(refObject.getName());
                        newColumn.setNameHasQuotes(refObject.getNameHasQuotes());
                    }
                    if (!(refObject instanceof Column)) continue block2;
                    this.copyColumnDef((Column)refObject, newColumn);
                    continue block2;
                }
            }
        }
    }

    private void copyColumnDef(Column fromColumn, Column toColumn) {
        short use = fromColumn.getUse();
        toColumn.setUse(use);
        toColumn.setReference(fromColumn.isReference());
        if (use == 0) {
            toColumn.setDomain(fromColumn.getDomain());
        } else if (use == 1) {
            toColumn.setLogicalDatatype(fromColumn.getLogicalDatatype());
            toColumn.setDataTypeSize(fromColumn.getSize());
            toColumn.setDataTypePrecision(fromColumn.getPrecision());
            toColumn.setDataTypeScale(fromColumn.getScale());
        } else if (use == 3) {
            toColumn.setStructuredType(fromColumn.getStructuredType());
        } else if (use == 4) {
            toColumn.setCollectionType(fromColumn.getCollectionType());
        } else if (use == 2) {
            toColumn.setDistinctType(fromColumn.getDistinctType());
        }
        toColumn.setNullsAllowed(fromColumn.getNullsAllowed());
    }

    private boolean isAggregateFunction(String function) {
        String[] functions = AggregateFunctionsOracle.FUNCTIONS_V10;
        for (int i = 0; i < functions.length; ++i) {
            String token = functions[i];
            if (!function.toUpperCase().startsWith(token.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

