/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.CollectionTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateCollectionTypeOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateCollectionTypeOraclev10g.class);
    private StorageDesignOracle storageDesign;

    public SHCreateCollectionTypeOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        boolean canHandle = false;
        this.statement = SHCreateCollectionTypeOraclev10g.clearCR(line);
        if (Token.getFirstToken(this.statement).equalsIgnoreCase("CREATE")) {
            String firstToken;
            String restOfText = Token.cutTokenFromFront(this.statement, "CREATE");
            if (Token.startsWithString(restOfText, "OR REPLACE")) {
                restOfText = Token.cutTokenFromFront(restOfText, "OR REPLACE");
            }
            if ((firstToken = Token.getFirstToken(restOfText)).equalsIgnoreCase("EDITIONABLE") || firstToken.equalsIgnoreCase("NONEDITIONABLE")) {
                restOfText = Token.cutTokenFromFront(restOfText, firstToken);
            }
            if (Token.getFirstToken(restOfText).equalsIgnoreCase("TYPE")) {
                restOfText = Token.cutTokenFromFront(restOfText, "TYPE");
                String typeName = Token.getFirstName(restOfText, '\"', '\"');
                String ucText = (restOfText = restOfText.substring(typeName.length())).toUpperCase();
                if (Token.hasString(ucText, " TABLE OF ")) {
                    canHandle = true;
                } else {
                    while (ucText.length() > 0) {
                        firstToken = Token.getFirstToken(ucText);
                        if (firstToken.equals("VARRAY") || firstToken.equals("ARRAY")) {
                            canHandle = true;
                            break;
                        }
                        if (firstToken.equals("OBJECT") || firstToken.equals("UNDER")) {
                            canHandle = false;
                            break;
                        }
                        ucText = Token.cutTokenFromFront(ucText, firstToken);
                    }
                }
            }
        }
        if (canHandle) {
            try {
                RDBMSSite site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
                this.parseType(this.statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + this.statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateCollectionTypeOraclev10g.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseType(String statement) {
        if (this.storageDesign != null) {
            String afterType = Token.getStringAfter(statement, "TYPE");
            String name = Token.getFirstName(afterType, '\"', '\"');
            String ownerName = null;
            int posPoint = name.indexOf(46);
            if (posPoint > 0) {
                ownerName = Token.getValBeforeCharacter(name, '.');
                name = Token.getValAfterCharacter(name, '.');
            }
            CollectionType type = this.design.getDataTypesDesign().createCollectionType();
            CollectionTypeProxyOraclev10g typeProxy = (CollectionTypeProxyOraclev10g)this.storageDesign.getCollectionTypeProxySet().getProxy(type.getObjectID());
            if (typeProxy != null) {
                int nameIndex;
                String afterName;
                if (ownerName != null) {
                    UserOraclev10g user = (UserOraclev10g)this.storageDesign.getUserSet().getByName(ownerName);
                    if (user == null) {
                        user = (UserOraclev10g)this.storageDesign.getUserSet().createUser();
                        user.setName(ownerName);
                        this.design.getRelationalDesign().stampModelObjectDDL(user);
                    }
                    typeProxy.setOwner(user);
                }
                if ((afterName = afterType.substring((nameIndex = afterType.indexOf(name, posPoint)) + name.length())).startsWith("\"")) {
                    if (!name.equals(name.toUpperCase())) {
                        type.setNameHasQuotes(true);
                    }
                    afterName = afterName.substring(1);
                }
                if (Token.getFirstToken(afterName).equalsIgnoreCase("FORCE")) {
                    typeProxy.setForceReplace("YES");
                }
            }
            type.setName(name);
            this.design.getRelationalDesign().stampModelObjectDDL(type);
            this.initCollectionType(type);
            this.initDataType(type);
            this.initOid(typeProxy);
        }
    }

    private void initCollectionType(CollectionType type) {
        String ucStatement = this.statement.toUpperCase();
        if (Token.hasString(ucStatement, " VARRAY ") || Token.hasString(ucStatement, " VARRAY(") || Token.hasString(ucStatement, " VARYING ARRAY")) {
            type.setArrayType();
            String number = Token.getValBetweenBrackets(this.statement, 1).trim();
            if (!"".equalsIgnoreCase(number)) {
                try {
                    type.setMaxElement(Integer.parseInt(number));
                }
                catch (Exception exc) {}
            }
        } else {
            type.setCollectionType();
        }
    }

    private void initDataType(CollectionType type) {
        if (Token.hasToken(this.statement, "OF")) {
            String datatypename = Token.getStringAfterToken(this.statement, "OF");
            boolean isRef = Token.getFirstToken(datatypename).equalsIgnoreCase("REF");
            if (isRef) {
                datatypename = Token.cutFirstToken(datatypename);
            }
            TypeElement element = new TypeElement(type.getDesignPart(), null);
            element.setDesign(type.getDesign());
            element.setParent(type);
            boolean hasBrackets = Token.hasCloseAndOpenBrackets(datatypename);
            if (hasBrackets) {
                String value = Token.getValBetweenBrackets(datatypename);
                datatypename = Token.getStringBefore(datatypename, "(");
                int commaPos = value.indexOf(",");
                if (commaPos != -1) {
                    element.setSize("");
                    element.setPrecision(Integer.valueOf(value.substring(0, commaPos).trim()));
                    element.setScale(Integer.valueOf(value.substring(commaPos + 1).trim()));
                } else if (datatypename.equalsIgnoreCase("NUMBER") || datatypename.equalsIgnoreCase("DECIMAL")) {
                    element.setSize("");
                    element.setScale(0);
                    element.setPrecision(Integer.valueOf(value.trim()));
                } else {
                    element.setScale(0);
                    element.setPrecision(0);
                    element.setSize(value.trim());
                }
            }
            type.setElementType(element);
            datatypename = Token.getFirstName(datatypename, '\"', '\"');
            String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatypename);
            LogicalDatatype logicalDT = null;
            if (!isRef) {
                logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
            }
            if (logicalDT != null && !usedDatatype.equalsIgnoreCase("UNKNOWN")) {
                element.setType(logicalDT);
            } else {
                String schemaName = "";
                int dotIndex = datatypename.indexOf(46);
                if (dotIndex > 0) {
                    schemaName = datatypename.substring(0, dotIndex);
                    datatypename = datatypename.substring(dotIndex + 1);
                }
                DesignObject structOrCollType = null;
                if (!schemaName.equals("") && (structOrCollType = element.getDesign().getDataTypesDesign().getStructuredTypeSet().getBySchemaAndName(schemaName, datatypename)) == null) {
                    structOrCollType = element.getDesign().getDataTypesDesign().getCollectionTypeSet().getBySchemaAndName(schemaName, datatypename);
                }
                if (structOrCollType == null && (structOrCollType = element.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(datatypename)) == null) {
                    structOrCollType = element.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(datatypename);
                }
                if (structOrCollType != null) {
                    element.setType(structOrCollType);
                    if (isRef) {
                        element.setReference(true);
                    }
                }
            }
        }
    }

    private void initOid(CollectionTypeProxyOraclev10g typeProxy) {
        if (Token.hasToken(this.statement, "OID")) {
            String oid = Token.getStringAfterToken(this.statement, "OID");
            oid = Token.getValBetweenQuotes(oid);
            typeProxy.setGlobalOid(oid);
        }
    }
}

