/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports;

import java.util.Locale;
import java.util.StringTokenizer;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public class Token {
    public static final String ENCODED_STR = "`~`";
    public static final String TOKEN_SEPARATORS = " ()\n";
    public static final String TOKEN_SEPARATORS_AND_WHITESPACE = " ()\t\n\f\r";
    public static final String TOKEN_SEPARATORS_AND_COMMA = " (),\n";
    public static final String SPACE_SEPARATOR = " ";
    private static final Logger LOGGER = new Logger(Token.class);

    public static boolean hasToken(String string, String compare) {
        String trimmed = compare.trim();
        try {
            StringTokenizer tokens = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            while (tokens.hasMoreTokens()) {
                if (!tokens.nextToken().equalsIgnoreCase(trimmed)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error in hasToken:", e);
            return false;
        }
    }

    public static boolean hasToken(String string, String compare, String beforeToken) {
        try {
            StringTokenizer tokens = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            String token = "";
            String before = "";
            while (tokens.hasMoreTokens()) {
                String tokenSep = tokens.nextToken();
                if (tokenSep.equals(SPACE_SEPARATOR)) continue;
                before = token;
                token = tokenSep;
                if (!token.equalsIgnoreCase(compare) || before.equalsIgnoreCase(beforeToken)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error in hasToken:", e);
            return false;
        }
    }

    public static int tokenNumber(String string, String token) {
        int num = 0;
        while (string.indexOf(token) > -1) {
            ++num;
            string = string.substring(string.indexOf(token) + token.length());
        }
        return num;
    }

    public static boolean hasString(String string, String compare) {
        try {
            return string.indexOf(compare) > -1;
        }
        catch (Exception e) {
            LOGGER.error("Error in hasString:", e);
            return false;
        }
    }

    public static String getLastToken(String string) {
        try {
            StringTokenizer tokens = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            String last = "";
            while (tokens.hasMoreTokens()) {
                String tokenSep = tokens.nextToken();
                if (tokenSep.equals(SPACE_SEPARATOR)) continue;
                last = tokenSep;
            }
            return last.trim();
        }
        catch (Exception e) {
            LOGGER.error("Error in getLastToken:", e);
            return "";
        }
    }

    public static String getFirstToken(String string) {
        try {
            StringTokenizer tokens = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            while (tokens.hasMoreTokens()) {
                String tokenSep = tokens.nextToken();
                if (tokenSep.equals(SPACE_SEPARATOR)) continue;
                return tokenSep;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in getFirstToken:", e);
        }
        return "";
    }

    public static boolean isBetweenQuotes(String string, String token) {
        int closeQuotes;
        int pos = string.indexOf(token);
        int openQuotes = string.indexOf(39);
        if (openQuotes > -1 && openQuotes < pos && (closeQuotes = string.indexOf(39, pos)) > -1) {
            return true;
        }
        openQuotes = string.indexOf(34);
        return openQuotes > -1 && openQuotes < pos && (closeQuotes = string.indexOf(34, pos)) > -1;
    }

    public static String getTokenBefore(String string, String token) {
        try {
            String result = "";
            String ttoken = token.trim();
            if (ttoken.indexOf(SPACE_SEPARATOR) > 0) {
                int tokenInd = StringUtilities.indexOf(string, token);
                if (tokenInd > -1) {
                    result = Token.getLastToken(string.substring(0, tokenInd));
                }
            } else {
                StringTokenizer tokens = new StringTokenizer(string, TOKEN_SEPARATORS, true);
                while (tokens.hasMoreTokens()) {
                    String tokenOrSep = tokens.nextToken();
                    if (tokenOrSep.equals(SPACE_SEPARATOR)) continue;
                    if (tokenOrSep.equalsIgnoreCase(ttoken)) break;
                    result = tokenOrSep;
                }
            }
            return result.trim();
        }
        catch (Exception e) {
            LOGGER.error("Error in getTokenBefore:", e);
            return "";
        }
    }

    public static String getStringBefore(String string, String token) {
        try {
            int pos = StringUtilities.indexOf(string, token);
            if (pos > -1) {
                return string.substring(0, pos).trim();
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getStringBefore:", e);
            return "";
        }
    }

    public static String getStringBeforeToken(String string, String token) {
        try {
            token = token.trim();
            int tokenLength = token.length();
            int startPos = 0;
            int pos = 0;
            while (pos > -1) {
                pos = StringUtilities.indexOf(string, token, startPos);
                if (pos > -1 && (pos == 0 || Token.isSeparator(string.charAt(pos - 1))) && (pos + tokenLength >= string.length() || Token.isSeparator(string.charAt(pos + tokenLength)))) {
                    return string.substring(0, pos).trim();
                }
                startPos = pos + 1;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in getStringBeforeToken:", e);
        }
        return "";
    }

    public static String getStringAfter(String line, String string) {
        try {
            if ("".equalsIgnoreCase(string)) {
                return "";
            }
            int sLength = string.length();
            int index = StringUtilities.indexOf(line, string);
            while (index > -1) {
                if ((index == 0 || Token.isSeparator(line.charAt(index - 1))) && (line.length() <= index + sLength || Token.isSeparator(line.charAt(index + sLength)))) {
                    return line.substring(index + sLength).trim();
                }
                index = StringUtilities.indexOf(line, string, index + 1);
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getStringAfter:", e);
            return "";
        }
    }

    public static String getStringBefore2(String line, String string) {
        return Token.getStringBeforeToken(line, string);
    }

    public static boolean isSeparator(char character) {
        return Character.isWhitespace(character) || character == '(' || character == ')' || character == ',' || character == '\"' || character == '[' || character == ']' || character == '\'';
    }

    public static String getStringAfter(String line, String string, String beforeToken) {
        try {
            int pos = StringUtilities.indexOf(line, string + SPACE_SEPARATOR);
            if (pos > -1) {
                String bef = line.substring(0, pos);
                if (Token.getLastToken(bef).equalsIgnoreCase(beforeToken)) {
                    return Token.getStringAfter(line.substring(pos + 1), string, beforeToken);
                }
                return line.substring(pos + string.length()).trim();
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getStringAfter:", e);
            return "";
        }
    }

    public static String getStringAfterToken(String string, String token) {
        try {
            StringBuffer result = new StringBuffer();
            String ttoken = token.trim();
            StringTokenizer tokens = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            boolean found = false;
            while (tokens.hasMoreTokens()) {
                String tokenOrSep = tokens.nextToken();
                if (found) {
                    result.append(tokenOrSep);
                    continue;
                }
                if (!tokenOrSep.equalsIgnoreCase(ttoken)) continue;
                found = true;
            }
            return result.toString().trim();
        }
        catch (Exception e) {
            LOGGER.error("Error in getStringAfterToken:", e);
            return "";
        }
    }

    public static String getToken(String string, int number) {
        try {
            string = string.replaceAll("[\n]", SPACE_SEPARATOR);
            StringTokenizer tokens = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            String token = "";
            int count = 1;
            while (tokens.hasMoreTokens()) {
                String tokenSep = tokens.nextToken();
                if (tokenSep.equals(SPACE_SEPARATOR)) continue;
                if (count > number) break;
                token = tokenSep;
                ++count;
            }
            if (count < number) {
                token = "";
            }
            return token.trim();
        }
        catch (Exception e) {
            LOGGER.error("Error in getToken:", e);
            return "";
        }
    }

    public static String getTokenAfter(String string, String after, String separator) {
        try {
            string = string.replaceAll("[\n]", SPACE_SEPARATOR);
            StringTokenizer tokens = new StringTokenizer(string, separator);
            String token = "";
            block2: while (tokens.hasMoreTokens()) {
                String tokenOrSep = tokens.nextToken();
                if (!tokenOrSep.equalsIgnoreCase(after)) continue;
                while (tokens.hasMoreTokens()) {
                    tokenOrSep = tokens.nextToken();
                    if (tokenOrSep.equals(SPACE_SEPARATOR)) continue;
                    token = tokenOrSep;
                    break block2;
                }
                break block2;
            }
            return token.trim();
        }
        catch (Exception e) {
            LOGGER.error("Error in getTokenAfter:", e);
            return "";
        }
    }

    public static String getTokens(String string, int start, int end) {
        try {
            StringTokenizer tokens = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            StringBuffer result = new StringBuffer("");
            int count = 1;
            while (tokens.hasMoreTokens()) {
                String tokenSep = tokens.nextToken();
                if (tokenSep.equals(SPACE_SEPARATOR)) continue;
                if (count >= start && count <= end) {
                    result.append(tokenSep).append(SPACE_SEPARATOR);
                }
                ++count;
            }
            return result.toString().trim();
        }
        catch (Exception e) {
            LOGGER.error("Error in getTokens:", e);
            return "";
        }
    }

    public static boolean endsWithOpenBracket(String string) {
        return Token.hasOpenBracketNoClose(string);
    }

    public static boolean hasOpenBracketNoClose(String string) {
        try {
            if (string != null) {
                int open = string.lastIndexOf("(");
                int close = string.lastIndexOf(")");
                return close < open;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in hasOpenBracketNoClose:", e);
        }
        return false;
    }

    public static boolean hasOpenBracket(String string) {
        try {
            int openCount = 0;
            int closeCount = 0;
            if (string != null) {
                int open = Token.getNextCharIndex(string, '(', 0);
                while (open >= 0) {
                    ++openCount;
                    open = Token.getNextCharIndex(string, '(', open + 1);
                }
                int close = Token.getNextCharIndex(string, ')', 0);
                while (close >= 0) {
                    ++closeCount;
                    close = Token.getNextCharIndex(string, ')', close + 1);
                }
            }
            return openCount > closeCount;
        }
        catch (Exception e) {
            LOGGER.error("Error in hasOpenBracket:", e);
            return false;
        }
    }

    public static int getCloseBracketIndex(String string) {
        try {
            int openCount = 0;
            int closeCount = 0;
            if (string != null) {
                int open = string.indexOf("(");
                int close = string.indexOf(")");
                if (open >= 0 && close > 0) {
                    for (int i = open; i < string.length(); ++i) {
                        if (string.charAt(i) == '(') {
                            ++openCount;
                        } else if (string.charAt(i) == ')') {
                            ++closeCount;
                        }
                        if (openCount != closeCount) continue;
                        return i;
                    }
                }
            }
            return -1;
        }
        catch (Exception e) {
            LOGGER.error("Error in getCloseBracketIndex:", e);
            return -1;
        }
    }

    public static boolean hasCloseAndOpenBrackets(String string) {
        try {
            if (string != null) {
                int open = string.lastIndexOf("(");
                int close = string.lastIndexOf(")");
                return open >= 0 && close > 0;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error in hasCloseAndOpenBrackets:", e);
            return false;
        }
    }

    public static boolean hasCloseBracket(String string) {
        try {
            if (string != null) {
                int close = string.lastIndexOf(")");
                return close >= 0;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error in hasCloseBracket:", e);
            return false;
        }
    }

    public static String getValBetweenBrackets(String string) {
        try {
            if (string != null) {
                int first = string.indexOf("(");
                int last = string.lastIndexOf(")");
                if (first > -1 && last > -1) {
                    if (first < string.length()) {
                        return string.substring(first + 1, last).trim();
                    }
                    return string.substring(first, last).trim();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBetweenBrackets:", e);
        }
        return "";
    }

    public static String getValBetweenQuotes(String string) {
        try {
            if (string != null && !"".equalsIgnoreCase(string)) {
                int first = string.indexOf(39);
                int last = string.indexOf(39, first + 1);
                if (first > -1 && last > -1) {
                    if (first < string.length()) {
                        return string.substring(first + 1, last).trim();
                    }
                    return string.substring(first, last).trim();
                }
                return string;
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBetweenQuotes:", e);
            return "";
        }
    }

    public static String getValBetweenDoubleQuotes(String string) {
        try {
            if (string != null && !"".equalsIgnoreCase(string)) {
                int first = string.indexOf(34);
                int last = string.indexOf(34, first + 1);
                if (first > -1 && last > -1) {
                    if (first < string.length()) {
                        return string.substring(first + 1, last).trim();
                    }
                    return string.substring(first, last).trim();
                }
                return string;
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBetweenDoubleQuotes:", e);
            return "";
        }
    }

    public static String getValBetweenBrackets(String string, int bracketNr) {
        try {
            int firstOpen = 0;
            int secondOpen = 0;
            int firstClose = 0;
            if (string != null) {
                for (int i = 1; i <= bracketNr; ++i) {
                    firstOpen = Token.getNextCharIndex(string, '(', firstClose);
                    secondOpen = Token.getNextCharIndex(string, '(', firstOpen + 1);
                    firstClose = Token.getNextCharIndex(string, ')', firstOpen + 1);
                    while (secondOpen != -1 && secondOpen < firstClose) {
                        secondOpen = Token.getNextCharIndex(string, '(', secondOpen + 1);
                        firstClose = Token.getNextCharIndex(string, ')', firstClose + 1);
                    }
                }
            }
            if (firstOpen == firstClose) {
                return "";
            }
            return string.substring(firstOpen + 1, firstClose);
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBetweenBrackets:", e);
            return "";
        }
    }

    private static int getNextCharIndex(String string, char character, int startIndex) {
        String toCheck;
        int bracketIndex = string.indexOf(character, startIndex);
        while (bracketIndex > -1 && !Token.bracketsEquals(toCheck = string.substring(startIndex, bracketIndex), '\'', '\'') && toCheck.indexOf("Q'") == -1 && toCheck.indexOf("q'") == -1) {
            bracketIndex = string.indexOf(character, bracketIndex + 1);
        }
        return bracketIndex;
    }

    public static String getValBetweenQuotationMarks(String string) {
        try {
            if (string != null && string.indexOf(39) == 0 && string.indexOf(39, 1) == string.length() - 1) {
                return string.substring(1, string.length() - 1);
            }
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBetweenQuotationMarks:", e);
            return "";
        }
    }

    public static String getValBetweenQuotationMarks2(String string) {
        try {
            if (string != null && (string.indexOf(39) == 0 || string.indexOf(8217) == 0)) {
                int end = string.indexOf(39, 1);
                if (end <= 0) {
                    end = string.indexOf(8217, 1);
                }
                return string.substring(1, end).trim();
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBetweenQuotationMarks:", e);
            return "";
        }
    }

    public static String getValBetweenSquareBrackets(String string) {
        try {
            if (string != null && string.indexOf(91) == 0 && string.indexOf(93, 1) == string.length() - 1) {
                return string.substring(1, string.length() - 1);
            }
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBetweenSquareBrackets:", e);
            return "";
        }
    }

    public static String getValBetweenFirstQuotationMarks(String string) {
        try {
            if (string != null && string.indexOf(39) > -1) {
                int begin = string.indexOf(39);
                String next = string.substring(begin + 1);
                int end = next.indexOf(39);
                return string.substring(begin + 1, end + begin + 1).trim();
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBetweenQuotationMarks:", e);
            return "";
        }
    }

    public static String getValAfterBrackets(String string, int bracketNr) {
        try {
            if (string != null) {
                int firstOpen = 0;
                int secondOpen = 0;
                int firstClose = 0;
                for (int i = 1; i <= bracketNr; ++i) {
                    firstOpen = Token.getNextCharIndex(string, '(', firstClose);
                    secondOpen = Token.getNextCharIndex(string, '(', firstOpen + 1);
                    firstClose = Token.getNextCharIndex(string, ')', firstOpen + 1);
                    while (secondOpen != -1 && secondOpen < firstClose) {
                        secondOpen = Token.getNextCharIndex(string, '(', secondOpen + 1);
                        firstClose = Token.getNextCharIndex(string, ')', firstClose + 1);
                    }
                }
                return string.substring(firstClose + 1).trim();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in getValAfterBrackets:", e);
        }
        return "";
    }

    public static String getValOutsideBrackets(String string) {
        try {
            if (string != null) {
                StringBuffer value = new StringBuffer();
                int firstOpen = string.indexOf(40);
                int lastClose = string.lastIndexOf(41);
                if (firstOpen != -1 && lastClose != -1) {
                    value.append(string.substring(0, firstOpen));
                    value.append(' ');
                    value.append(string.substring(lastClose + 1, string.length()));
                }
                return value.toString();
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getValOutsideBrackets:", e);
            return "";
        }
    }

    public static String getValBeforeBrackets(String string) {
        try {
            if (string != null) {
                StringBuffer value = new StringBuffer();
                int firstOpen = string.indexOf(40);
                int lastClose = string.lastIndexOf(41);
                if (firstOpen != -1 && lastClose != -1) {
                    value.append(string.substring(0, firstOpen));
                }
                return value.toString().trim();
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBeforeBrackets:", e);
            return "";
        }
    }

    public static boolean isTokenEqualTo(String string, int number, String compare) {
        try {
            return Token.getToken(string, number).equalsIgnoreCase(compare);
        }
        catch (Exception e) {
            LOGGER.error("Error in isTokenEqualTo:", e);
            return false;
        }
    }

    public static String getTokenAfter(String line, String string) {
        try {
            String token;
            block11: {
                token = "";
                if (string.indexOf(SPACE_SEPARATOR) > 0) {
                    int number;
                    String[] subs = string.split(SPACE_SEPARATOR);
                    int index = number = 1;
                    token = Token.getToken(line, number);
                    boolean found = false;
                    while (!found && !"".equals(token)) {
                        for (int i = 0; i < subs.length; ++i) {
                            if (!(token = Token.getToken(line, index++)).equalsIgnoreCase(subs[i])) {
                                found = false;
                                break;
                            }
                            found = true;
                        }
                        if (found) {
                            token = Token.getToken(line, index);
                            continue;
                        }
                        index = ++number;
                    }
                } else {
                    StringTokenizer tokens = new StringTokenizer(line, TOKEN_SEPARATORS, true);
                    while (tokens.hasMoreTokens()) {
                        String tokenOrSep = tokens.nextToken();
                        if (!tokenOrSep.equalsIgnoreCase(string)) continue;
                        while (tokens.hasMoreTokens()) {
                            tokenOrSep = tokens.nextToken();
                            if (tokenOrSep.equals(SPACE_SEPARATOR)) continue;
                            token = tokenOrSep;
                            break block11;
                        }
                        break;
                    }
                }
            }
            if (token.endsWith(";")) {
                token = token.substring(0, token.length() - 1);
            }
            return token;
        }
        catch (Exception e) {
            LOGGER.error("Error in getTokenAfter:", e);
            return "";
        }
    }

    public static String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    public static boolean bracketsEquals(String string, char openChar, char closeChar) {
        int open = 0;
        int close = 0;
        int pos = string.indexOf(openChar);
        while (pos > -1) {
            ++open;
            pos = string.indexOf(openChar, pos + 1);
        }
        if (openChar != closeChar) {
            pos = string.indexOf(closeChar);
            while (pos > -1) {
                ++close;
                pos = string.indexOf(closeChar, pos + 1);
            }
            return open == close;
        }
        return open % 2 == 0;
    }

    public static String getFirstTextLiteral(String line) {
        if (line.length() > 1) {
            int startQuotePos = 0;
            char firstChar = Character.toUpperCase(line.charAt(0));
            if (firstChar == 'N') {
                startQuotePos = 1;
                firstChar = Character.toUpperCase(line.charAt(1));
            }
            if (firstChar == '\'') {
                int terminatingQuoteInd = line.indexOf(39, startQuotePos + 1);
                if (terminatingQuoteInd > -1) {
                    boolean checkRepeatedQuote = true;
                    while (checkRepeatedQuote) {
                        int newTerminatingQuoteInd;
                        checkRepeatedQuote = false;
                        if (line.length() <= terminatingQuoteInd + 1 || line.charAt(terminatingQuoteInd + 1) != '\'' || (newTerminatingQuoteInd = line.indexOf(39, terminatingQuoteInd + 2)) <= -1) continue;
                        terminatingQuoteInd = newTerminatingQuoteInd;
                        checkRepeatedQuote = true;
                    }
                    return line.substring(0, terminatingQuoteInd + 1);
                }
            } else if (line.substring(startQuotePos).toUpperCase(Locale.ROOT).startsWith("Q'") && line.length() > startQuotePos + 2) {
                int openDelimiter;
                int closeDelimiter = openDelimiter = line.charAt(startQuotePos + 2);
                if (openDelimiter == 91) {
                    closeDelimiter = 93;
                } else if (openDelimiter == 123) {
                    closeDelimiter = 125;
                } else if (openDelimiter == 60) {
                    closeDelimiter = 62;
                } else if (openDelimiter == 40) {
                    closeDelimiter = 41;
                }
                int endIndex = line.indexOf((char)closeDelimiter + "'", startQuotePos);
                if (endIndex > -1) {
                    return line.substring(0, endIndex + 2);
                }
            }
        }
        return "";
    }

    public static String getQuotedNameAfterToken(String line, String string) {
        return Token.getNameAfterToken(line, string, '\"', '\"');
    }

    public static String getNameAfterToken(String line, String token, char openChar, char closeChar) {
        return Token.getFirstName(Token.getStringAfter(line, token), openChar, closeChar);
    }

    public static String getFirstName(String line, char openChar, char closeChar) {
        try {
            String name = "";
            StringTokenizer tokens = new StringTokenizer(line.trim(), TOKEN_SEPARATORS_AND_COMMA, true);
            if (tokens.hasMoreTokens()) {
                name = tokens.nextToken();
                if (name.indexOf(openChar) > -1 && !Token.bracketsEquals(name, openChar, closeChar)) {
                    String tokenOrSep;
                    while (tokens.hasMoreTokens()) {
                        tokenOrSep = tokens.nextToken();
                        name = name + tokenOrSep;
                        if (tokenOrSep.indexOf(closeChar) <= -1) continue;
                        break;
                    }
                    if (!Token.bracketsEquals(name, openChar, closeChar) && name.indexOf("." + openChar) > -1) {
                        while (tokens.hasMoreTokens()) {
                            tokenOrSep = tokens.nextToken();
                            name = name + tokenOrSep;
                            if (tokenOrSep.indexOf(closeChar) <= -1) continue;
                            break;
                        }
                    }
                }
                if (name.endsWith(";")) {
                    name = name.substring(0, name.length() - 1);
                }
                name = Token.removeChar(name, openChar);
                if (closeChar != openChar) {
                    name = Token.removeChar(name, closeChar);
                }
            }
            return name;
        }
        catch (Exception e) {
            LOGGER.error("Error in getFirstName:", e);
            return "";
        }
    }

    public static String getValBeforeCharacter(String string, char character) {
        try {
            if (string != null) {
                int position = string.indexOf(character);
                if (position != -1) {
                    return string.substring(0, position);
                }
                return "";
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getValBeforeCharacter:", e);
            return "";
        }
    }

    public static String getValAfterCharacter(String string, char character) {
        try {
            if (string != null) {
                int position = string.lastIndexOf(character);
                if (position != -1) {
                    return string.substring(position + 1, string.length());
                }
                return "";
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getValAfterCharacter:", e);
            return "";
        }
    }

    public static String cutTokenFromFront(String statement, String token) {
        try {
            int lengthCut = token.length();
            String result = statement.trim().substring(lengthCut).trim();
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error in cutTokenFromFront:", e);
            return "";
        }
    }

    public static String cutFirstToken(String string) {
        try {
            StringTokenizer tokens = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            StringBuffer str = new StringBuffer();
            boolean first = true;
            while (tokens.hasMoreTokens()) {
                String tokenOrSep = tokens.nextToken();
                if (first) {
                    if (tokenOrSep.equals(SPACE_SEPARATOR)) continue;
                    first = false;
                    continue;
                }
                str.append(tokenOrSep);
            }
            return str.toString().trim();
        }
        catch (Exception e) {
            LOGGER.error("Error in cutFirstToken:", e);
            return "";
        }
    }

    public static String cutFirstToken2(String string) {
        try {
            String first = Token.getFirstToken(string);
            int k = string.indexOf(first);
            if (k > -1) {
                String res = Token.trimLeft(string.substring(k + first.length()));
                return res;
            }
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error in cutFirstToken2:", e);
            return "";
        }
    }

    public static String replaceFirst(String string, String oldStr, String newStr) {
        try {
            int index = StringUtilities.indexOf(string, oldStr);
            if (index > -1) {
                String s1 = string.substring(0, index).trim();
                String s2 = string.substring(index + oldStr.length()).trim();
                return s1 + SPACE_SEPARATOR + newStr + SPACE_SEPARATOR + s2;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in replaceFirst:", e);
        }
        return string;
    }

    public static String replaceAll(String string, String s1, String s2) {
        try {
            String[] strings = string.split(s1);
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < strings.length; ++i) {
                String token = strings[i];
                if (i == 0) {
                    str.append(token);
                    continue;
                }
                str.append(s2).append(token);
            }
            return str.toString().trim();
        }
        catch (Exception e) {
            LOGGER.error("Error in replaceAll:", e);
            return string;
        }
    }

    public static String getStringToFirstMatch(String string, String[] match) {
        try {
            String extendedString = SPACE_SEPARATOR + string + SPACE_SEPARATOR;
            String token = "";
            int tokenInd = 999999;
            for (int i = 0; i < match.length; ++i) {
                int ind = extendedString.indexOf(SPACE_SEPARATOR + match[i] + SPACE_SEPARATOR);
                if (ind <= -1 || ind >= tokenInd) continue;
                token = match[i];
                tokenInd = ind;
            }
            if (!"".equalsIgnoreCase(token)) {
                return Token.getStringBeforeToken(string, token);
            }
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error in getStringToFirstMatch:", e);
            return "";
        }
    }

    public static String getStringToFirstMatch2(String inputString, String[] match) {
        try {
            StringBuffer buffer = new StringBuffer();
            StringTokenizer tokens = new StringTokenizer(inputString, TOKEN_SEPARATORS_AND_WHITESPACE, true);
            while (tokens.hasMoreTokens()) {
                String nextToken = tokens.nextToken();
                if (!nextToken.trim().isEmpty()) {
                    for (int i = 0; i < match.length; ++i) {
                        if (!nextToken.equalsIgnoreCase(match[i])) continue;
                        return buffer.toString().trim();
                    }
                }
                buffer.append(nextToken);
            }
            return inputString;
        }
        catch (Exception e) {
            LOGGER.error("Error in getStringToFirstMatch2:", e);
            return "";
        }
    }

    public static String getName(String string) {
        int secondQuote;
        if ((string = string.trim()).startsWith("\"") && (secondQuote = string.indexOf("\"", 1)) > -1) {
            return string.substring(1, secondQuote);
        }
        return string;
    }

    public static String getNamesOnly(String string) {
        String result = "";
        StringTokenizer tok = new StringTokenizer(string, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            if (Token.hasOpenBracketNoClose(token)) {
                StringBuffer oneTokenPast = new StringBuffer(token);
                while (Token.hasOpenBracketNoClose(token) && tok.hasMoreTokens()) {
                    oneTokenPast.append(", ").append(tok.nextToken().trim());
                    token = oneTokenPast.toString().trim();
                }
            }
            String firstToken = "";
            String theRest = "";
            if (token.startsWith("\"")) {
                int secondQuote = token.indexOf("\"", 1);
                if (secondQuote > -1) {
                    firstToken = token.substring(1, secondQuote);
                    theRest = token.substring(secondQuote + 1).trim();
                } else {
                    firstToken = Token.getFirstToken(token);
                    theRest = Token.getStringAfter(token, Token.getFirstToken(token));
                }
            }
            token = theRest.equalsIgnoreCase("") ? firstToken : firstToken.concat(SPACE_SEPARATOR).concat(theRest);
            if (result.equalsIgnoreCase("")) {
                result = token;
                continue;
            }
            result = result.concat(",").concat(token);
        }
        if (result.trim().equalsIgnoreCase("")) {
            result = string;
        }
        return result;
    }

    public static String cutN(String string) {
        if (string.toUpperCase(Locale.ROOT).startsWith("N'")) {
            return string.substring(1);
        }
        return string;
    }

    public static boolean startsWithString(String statement, String string) {
        if (statement.toUpperCase(Locale.ROOT).trim().startsWith(string.toUpperCase(Locale.ROOT).trim() + SPACE_SEPARATOR)) {
            return true;
        }
        statement = Token.replaceAll(statement, SPACE_SEPARATOR, SPACE_SEPARATOR);
        return statement.toUpperCase(Locale.ROOT).trim().startsWith(string.toUpperCase(Locale.ROOT).trim() + SPACE_SEPARATOR);
    }

    public static boolean startsWithString2(String statement, String string) {
        if (statement.toUpperCase(Locale.ROOT).trim().startsWith(string.toUpperCase(Locale.ROOT).trim() + SPACE_SEPARATOR)) {
            return true;
        }
        String temp = statement.replaceAll("[ \t\n\f\r\u000b]+", SPACE_SEPARATOR);
        return temp.toUpperCase(Locale.ROOT).trim().startsWith(string.toUpperCase(Locale.ROOT).trim() + SPACE_SEPARATOR);
    }

    public static String encodeQuotedString(String string) {
        int openQuote = string.indexOf(34);
        if (openQuote == -1) {
            return string;
        }
        int closeQuote = string.indexOf(34, openQuote + 1);
        if (closeQuote == -1) {
            return string;
        }
        String result = string.substring(openQuote, closeQuote + 1);
        StringBuffer buffer = new StringBuffer();
        if (openQuote > 0) {
            buffer.append(string.substring(0, openQuote));
        }
        buffer.append(result.replaceAll(SPACE_SEPARATOR, ENCODED_STR));
        int lastIndex = closeQuote + 1;
        while (openQuote > -1) {
            openQuote = string.indexOf(34, closeQuote + 1);
            if (openQuote > -1) {
                closeQuote = string.indexOf(34, openQuote + 1);
            }
            if (openQuote <= -1 || closeQuote <= -1) continue;
            if (openQuote > lastIndex) {
                buffer.append(string.substring(lastIndex, openQuote));
            }
            lastIndex = closeQuote + 1;
            result = string.substring(openQuote, closeQuote + 1);
            buffer.append(result.replaceAll(SPACE_SEPARATOR, ENCODED_STR));
        }
        buffer.append(string.substring(closeQuote + 1));
        return buffer.toString();
    }

    public static String encodeSquareBracketsString(String string) {
        int openQuote = string.indexOf(91);
        if (openQuote == -1) {
            return string;
        }
        int closeQuote = string.indexOf(93, openQuote + 1);
        if (closeQuote == -1) {
            return string;
        }
        String result = string.substring(openQuote, closeQuote + 1);
        StringBuffer buffer = new StringBuffer();
        if (openQuote > 0) {
            buffer.append(string.substring(0, openQuote));
        }
        buffer.append(result.replaceAll(SPACE_SEPARATOR, ENCODED_STR));
        int lastIndex = closeQuote + 1;
        while (openQuote > -1) {
            openQuote = string.indexOf(91, closeQuote + 1);
            if (openQuote > -1) {
                closeQuote = string.indexOf(93, openQuote + 1);
            }
            if (openQuote <= -1 || closeQuote <= -1) continue;
            if (openQuote > lastIndex) {
                buffer.append(string.substring(lastIndex, openQuote));
            }
            lastIndex = closeQuote + 1;
            result = string.substring(openQuote, closeQuote + 1);
            buffer.append(result.replaceAll(SPACE_SEPARATOR, ENCODED_STR));
        }
        buffer.append(string.substring(closeQuote + 1));
        return buffer.toString();
    }

    public static String decodeQuotedString(String string) {
        return string.replaceAll(ENCODED_STR, SPACE_SEPARATOR);
    }

    public static String removeQuotes(String string) {
        return string.replaceAll("\"", "").trim();
    }

    public static String trimLeft(String string) {
        return string.replaceAll("^[ \t\n\f\r\u000b]+", "");
    }

    public static String trimRight(String string) {
        return string.replaceAll("$[ \t\n\f\r\u000b]+", "");
    }

    public static void main(String[] args) {
        String delim = "\\$\\%\\@\\*\\$";
        String message = "aaa$%@*$bbbb$%@*$ccc$%@*$ddd";
        String[] splat = message.split(delim);
        for (int k = 0; k < splat.length; ++k) {
            System.out.println(k + ": " + splat[k]);
        }
    }
}

