/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.ide.Ide;
import oracle.jdeveloper.vcs.generic.ActionCommand;

public class StorableObjectPropertiesCommand
extends ActionCommand {
    public static final String COMMAND_ID = "oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand";
    private static final String SEPARATOR = ": ";
    private static final int MAX_LINE_LENGTH = 50;
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public StorableObjectPropertiesCommand() {
        super(COMMAND_ID);
    }

    protected boolean isAvailableImpl() throws Exception {
        return SVN_CLIENT_HELPER.actionsEnabled(null, this.context, true, true, true, false, false, true, false, false);
    }

    protected int doitImpl() throws Exception {
        DataModelerChangeList dataModelerChangeList = (DataModelerChangeList)((SVNChangeListWindow)this.context.getView()).getContextChangeList();
        VersioningTreeNode selectedNode = dataModelerChangeList.getPanel().getSelectedNode();
        StorableObjectStatus storableObjectStatus = selectedNode.getStorableObjectStatus();
        StringBuilder stringBuilder = new StringBuilder();
        if (storableObjectStatus != null) {
            stringBuilder.append(Messages.getString("StorableObjectPropertiesCommand.Name"));
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(storableObjectStatus.getStorableObjectName());
            stringBuilder.append('\n');
            stringBuilder.append(Messages.getString("StorableObjectPropertiesCommand.ID"));
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(storableObjectStatus.getStorableObjectID());
            stringBuilder.append('\n');
            stringBuilder.append(Messages.getString("StorableObjectPropertiesCommand.TextStatus"));
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(storableObjectStatus.getTextStatus());
            if (storableObjectStatus.getTextStatus() == "!") {
                stringBuilder.append(" - missing");
            }
            stringBuilder.append('\n');
            stringBuilder.append(Messages.getString("StorableObjectPropertiesCommand.PropertyStatus"));
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(storableObjectStatus.getPropertyStatus());
            stringBuilder.append('\n');
            stringBuilder.append(Messages.getString("StorableObjectPropertiesCommand.Revision"));
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(storableObjectStatus.getRevision());
            stringBuilder.append('\n');
        }
        stringBuilder.append(Messages.getString("StorableObjectPropertiesCommand.Path"));
        stringBuilder.append(SEPARATOR);
        stringBuilder.append(this.format(selectedNode.getFilePath().getPath()));
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), stringBuilder.toString(), Messages.getString("StorableObjectPropertiesCommand.Properties"), 1);
        return 0;
    }

    private StringBuffer format(String string) {
        StringBuffer result = new StringBuffer(string);
        for (int lineEnd = 50; result.length() > lineEnd; lineEnd += 50) {
            result.insert(lineEnd, '\n');
        }
        return result;
    }
}

