/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.io.File;
import java.net.URL;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class SVNCleanupCommand
extends AbstractSVNOperation {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.cleanup" : SVNCleanupCommand.class.getName();
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNCleanupCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public boolean isAvailableImpl() {
        return ApplicationView.getInstance().getCurrentDesign().isVersioned();
    }

    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        Design selectedDesign = DataModelerChangeList.getSelectedDesign();
        if (selectedDesign != null) {
            SVN_CLIENT_HELPER.doCleanup(new File(selectedDesign.getDesignPath()));
            String spath = selectedDesign.getAppView().getSettings().getDefaultSystemTypesPath();
            if (SVNClientHelper.getInstance().isVersioned(spath)) {
                SVN_CLIENT_HELPER.doCleanup(new File(spath));
            }
        }
        return 0;
    }

    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        URL projectURL = this.getContext().getWorkspace().getActiveProjectURL();
        URL workingCopyRoot = SVNUtil.resolveWorkingCopy((URL)projectURL);
        if (workingCopyRoot == null) {
            return false;
        }
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository((URL)workingCopyRoot);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, repos);
            client.cleanup(SVNUtil.toFile((URL)workingCopyRoot));
        }
        catch (Exception e) {
            throw SVNExceptionWrapper.wrapException((Exception)e);
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return true;
    }
}

