/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangesTimerTask;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DMSVNOSGiController;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateAllCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateWorkingCopyCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareCurrentCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareCurrentCommand;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatus;

public class SVNIncomingChangesChangeList
extends DataModelerChangeList {
    DataModelerChangesTimerTask timerTask;
    private ActionMenuToolButton updateToolButton;

    public SVNIncomingChangesChangeList() {
        super(Messages.getString("SVNIncomingChangesChangeList.IncomingChanges"));
        System.setProperty("ide.vcs.noapplications", "true");
        this.setStatusCacheBridge(this.getStatusCacheBridge());
    }

    @Override
    protected void addActions() {
        Menubar menubar = Ide.getMenubar();
        JMenuItem updateMenuItem = null;
        IdeAction action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"DataModelingAddin.Update"));
        if (action != null) {
            action.setCommand("DataModelingAddin.Update");
            action.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"update.png"));
            updateMenuItem = menubar.createMenuItem((ToggleAction)action);
            DMSVNOSGiController.getInstance().register(action, (Command)new SVNUpdateCommand());
            this.popupMenu.add(updateMenuItem);
        }
        if ((action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"DataModelingAddin.UpdateAll"))) != null) {
            action.setCommand("oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateAllCommand");
            DMSVNOSGiController.getInstance().register(action, (Command)new SVNUpdateAllCommand());
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
    }

    @Override
    protected IdeAction addCompareActions() {
        IdeAction action;
        JMenu compareWithMenu = null;
        IdeAction defaultAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareCurrentCommand"));
        if (defaultAction != null) {
            defaultAction.setCommand("oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareCurrentCommand");
            defaultAction.setName(Messages.getString("DataModelingAddin.CompareCurrent"));
            DMSVNOSGiController.getInstance().register(defaultAction, (Command)new SVNCompareCurrentCommand());
            compareWithMenu = this.createCompareWithMenu(this.popupMenu);
            compareWithMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)defaultAction));
        }
        if ((action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareCurrentCommand"))) != null) {
            action.setCommand("oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareCurrentCommand");
            action.setName(Messages.getString("DataModelingAddin.TextCompareCurrent"));
            DMSVNOSGiController.getInstance().register(action, (Command)new SVNTextCompareCurrentCommand());
            if (compareWithMenu == null) {
                compareWithMenu = this.createCompareWithMenu(this.popupMenu);
            }
            compareWithMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
        return defaultAction;
    }

    protected TimerTask createStatusTask(VCSThreadPool threadPool) {
        this.timerTask = new DataModelerChangesTimerTask(this){

            @Override
            protected VCSClientHelper getVCSClientHelper() {
                return SVNClientHelper.getInstance();
            }

            @Override
            protected boolean checkRemoteStatus() {
                return true;
            }
        };
        return this.timerTask;
    }

    @Override
    public void clear() {
        if (this.timerTask != null) {
            try {
                this.setBusy(true);
                this.timerTask.updateUI(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.setBusy(false);
            }
        }
    }

    @Override
    protected ChangeListStatus[] getChangeListStatuses() {
        return new ChangeListStatus[]{SVNRemoteStatus.TEXT_MODIFIED, SVNRemoteStatus.PROP_MODIFIED, SVNRemoteStatus.TEXT_PROP_MODIFIED, SVNRemoteStatus.ADDED, SVNRemoteStatus.DELETED};
    }

    @Override
    protected void addToolbarActions(ChangeListWindow window, Toolbar toolbar) {
        super.addToolbarActions(window, toolbar);
        IdeAction updateAllAction = SVNUpdateAllCommand.getAction();
        if (updateAllAction != null) {
            DMSVNOSGiController.getInstance().register(updateAllAction, (Command)new SVNUpdateAllCommand());
            IdeAction updateWorkingCopyAction = SVNUpdateWorkingCopyCommand.getAction();
            if (updateWorkingCopyAction != null) {
                this.updateToolButton = new ActionMenuToolButton((Action)updateWorkingCopyAction);
                DMSVNOSGiController.getInstance().register(updateWorkingCopyAction, (Command)new SVNUpdateWorkingCopyCommand());
                this.updateToolButton.setMenuActions(new Action[]{updateWorkingCopyAction, updateAllAction});
                toolbar.add((Component)this.updateToolButton);
                if (this.timerTask != null && this.timerTask.containsConflicts()) {
                    this.updateToolButton.setVisible(false);
                }
            }
        }
    }

    @Override
    public void updateUI(List<StorableObjectStatus> statuses) {
        if (statuses != null) {
            super.updateUI(statuses);
        } else {
            super.updateUI(Collections.EMPTY_LIST);
        }
    }
}

