/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DeletedFile;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.RevisionRange;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.model.Displayable;
import oracle.jdeveloper.vcs.util.CheckboxProperty;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.DisplayableCellRenderer;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNClientHelper
extends VCSClientHelper<ISVNLogMessage, org.tigris.subversion.svnclientadapter.SVNRevision, ISVNStatus, SVNUrl, ISVNInfo, SVNDiffSummary, ISVNProperty> {
    private static final Logger LOGGER = new Logger(SVNClientHelper.class);
    private static final PathComparator PATH_COMPARATOR = new PathComparator();
    protected static final SVNClientHelper instance = new SVNClientHelper();
    ISVNClientAdapter client;
    protected SVNExceptionHandler svnExceptionHandler;
    protected SVNOperationLogger svnOperationLogger;
    private SVNMergedObjectsEventHandler mergedObjectsEventHandler = new SVNMergedObjectsEventHandler(this);
    private Design currentDesign;
    private static SVNClientManager svnClientManager = null;

    private SVNClientHelper() {
        this.svnExceptionHandler = new SVNExceptionHandler();
        this.svnOperationLogger = SVNOperationLogger.getInstance();
        try {
            this.client = SVNUtil.getIDEClientAdapter();
        }
        catch (SVNClientException e) {
            this.logException((Exception)((Object)e));
        }
    }

    public static SVNClientHelper getInstance() {
        return instance;
    }

    @Override
    public boolean isVersioned(File workingCopyRoot) {
        if (workingCopyRoot == null || this.client == null) {
            return false;
        }
        try {
            try {
                org.tmatesoft.svn.core.wc.SVNStatus svnStatus = SVNUtil.getStatusClient().doStatus(workingCopyRoot, false);
                return svnStatus.isVersioned();
            }
            catch (SVNException e) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean exists(String url) {
        try {
            SVNUrl svnUrl = new SVNUrl(url);
            return this.exists(svnUrl);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public boolean exists(SVNUrl svnUrl) {
        try {
            return this.isRemotelyExisiting(svnUrl, this.client);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemotelyExisiting(SVNUrl svnurl, ISVNClientAdapter client) throws SVNClientException {
        boolean isRemoteExisiting = false;
        if (svnurl != null) {
            try {
                this.beginOperation(svnurl, null, "isRemotelyExisiting");
                ISVNInfo info = client.getInfo(svnurl);
                if (info == null || info.getRevision() == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.endOperation();
            }
        }
        return isRemoteExisiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRevision(File filePath) {
        try {
            this.beginOperation(null, filePath, "getRevision");
            SVNRevision.Number n = this.client.getInfoFromWorkingCopy(filePath).getRevision();
            if (n != null) {
                long l = n.getNumber();
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (SVNClientException e) {
            long l = 0L;
            return l;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastChangedRevision(File filePath) {
        try {
            this.beginOperation(null, filePath, "getLastChangedRevision");
            SVNRevision.Number lastChangedRevision = this.client.getInfoFromWorkingCopy(filePath).getLastChangedRevision();
            long l = lastChangedRevision == null ? 0L : lastChangedRevision.getNumber();
            return l;
        }
        catch (SVNClientException e) {
            long l = 0L;
            return l;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLastMergedRevision(File filePath, Long revision, String mergeUrl) {
        try {
            this.beginOperation(null, filePath, "getLastMergedRevision");
            ISVNMergeInfo mergeInfo = this.client.getMergeInfo(filePath, revision == null ? org.tigris.subversion.svnclientadapter.SVNRevision.HEAD : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)revision.toString()));
            if (mergeInfo != null) {
                String[] paths;
                for (String path : paths = mergeInfo.getPaths()) {
                    if (!path.equals(mergeUrl)) continue;
                    org.tigris.subversion.svnclientadapter.SVNRevisionRange[] revisions = mergeInfo.getRevisions(mergeUrl);
                    if (revisions != null && revisions.length > 0) {
                        Long l = Long.valueOf(revisions[0].getToRevision().toString());
                        return l;
                    }
                    Long l = null;
                    return l;
                }
            }
        }
        catch (SVNClientException e) {
            this.logException("getLastMergedRevision", (Exception)((Object)e));
        }
        catch (ParseException e) {
            this.logException("getLastMergedRevision", e);
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    @Override
    public ISVNInfo doInfo(File filePath) {
        try {
            this.beginOperation(null, filePath, "doInfo");
            ISVNInfo iSVNInfo = this.client.getInfoFromWorkingCopy(filePath);
            return iSVNInfo;
        }
        catch (SVNClientException e) {
            this.logException("doInfo", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAdd(File filePath, boolean recursively) {
        try {
            this.beginOperation(null, filePath, "doAdd");
            if (filePath.isDirectory()) {
                this.client.addDirectory(filePath, recursively);
            } else {
                this.client.addFile(filePath);
            }
        }
        catch (SVNClientException e) {
            this.logException("doAdd", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public void doRemove(File[] filePaths) {
        try {
            this.beginOperation(null, filePaths[0], "doRemove");
            this.client.remove(filePaths, true);
        }
        catch (SVNClientException e) {
            this.logException("doRemove", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    public void doRemoveLocalFolder(File[] filePaths) {
        for (int i = 0; i < filePaths.length; ++i) {
            if (!filePaths[i].isDirectory()) continue;
            this.doRemoveLocalFilesFirst(filePaths[i]);
        }
        this.doRemove(filePaths);
    }

    public boolean isDeletedStatusLocal(org.tmatesoft.svn.core.wc.SVNStatus status) {
        SVNStatusType contentsStatus = status.getNodeStatus();
        return contentsStatus == SVNStatusType.STATUS_DELETED;
    }

    @Override
    public boolean isDeleted(File file) {
        if (file == null || this.client == null) {
            return false;
        }
        try {
            try {
                org.tmatesoft.svn.core.wc.SVNStatus svnStatus = SVNUtil.getStatusClient().doStatus(file, false);
                return this.isDeletedStatusLocal(svnStatus);
            }
            catch (SVNException e) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ISVNStatus> doStatus(File workingCopyRoot, boolean remoteStatus) {
        try {
            if (!this.isVersioned(workingCopyRoot)) return new ArrayList<ISVNStatus>();
            try {
                this.beginOperation(null, workingCopyRoot, "doStatus");
                ISVNStatus[] statuses = null;
                try {
                    statuses = this.client.getStatus(workingCopyRoot, true, false, remoteStatus);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (statuses == null) return new ArrayList<ISVNStatus>();
                List<ISVNStatus> list = Arrays.asList(statuses);
                return list;
            }
            finally {
                this.endOperation();
            }
        }
        catch (SVNClientException e) {
            this.logException("doStatus", (Exception)((Object)e));
        }
        return new ArrayList<ISVNStatus>();
    }

    public List<org.tmatesoft.svn.core.wc.SVNStatus> doStatusSVN(File workingCopyRoot, boolean remoteStatus) {
        return this.doStatusSVN(workingCopyRoot, remoteStatus, SVNDepth.INFINITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<org.tmatesoft.svn.core.wc.SVNStatus> doStatusSVN(File workingCopyRoot, boolean remoteStatus, SVNDepth depth) {
        if (this.isVersioned(workingCopyRoot)) {
            try {
                SVNUrl svnUrl = this.findSVNUrl(workingCopyRoot);
                SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository((SVNUrl)svnUrl);
                StatusHandler sh = new StatusHandler(remoteStatus);
                if (repoInfo == null) {
                    SVNUtil.getStatusClient().doStatus(workingCopyRoot, SVNRevision.HEAD, depth, remoteStatus, true, false, false, (ISVNStatusHandler)sh, null);
                } else {
                    SVNUtil.getStatusClient((SVNRepositoryInfo)repoInfo).doStatus(workingCopyRoot, SVNRevision.HEAD, depth, remoteStatus, !remoteStatus, false, false, (ISVNStatusHandler)sh, null);
                }
                List<org.tmatesoft.svn.core.wc.SVNStatus> list = sh.getCollectedStateses();
                return list;
            }
            catch (Exception e) {
                this.logException("doStatusSVN", e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISVNStatus getSingleStatusLocal(File workingCopyRoot) {
        ISVNStatus stat = null;
        try {
            try {
                this.beginOperation(null, workingCopyRoot, "doStatus");
                try {
                    stat = this.client.getSingleStatus(workingCopyRoot);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            finally {
                this.endOperation();
            }
        }
        catch (SVNClientException e) {
            this.logException("doStatus", (Exception)((Object)e));
        }
        return stat;
    }

    public ISVNStatus getSingleStatus(File file) {
        block5: {
            if (!this.isVersioned(file)) break block5;
            try {
                this.beginOperation(null, file, "doStatus");
                ISVNStatus iSVNStatus = this.client.getSingleStatus(file);
                this.endOperation();
                return iSVNStatus;
            }
            catch (Throwable throwable) {
                try {
                    this.endOperation();
                    throw throwable;
                }
                catch (SVNClientException e) {
                    this.logException("doStatus", (Exception)((Object)e));
                }
            }
        }
        return null;
    }

    public boolean isLockedInWC(File file) {
        ISVNStatus status = this.getSingleStatus(file);
        return status.getLockOwner() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdate(File[] filePaths, boolean recursively) {
        ArrayList<File> updatedFilePaths = new ArrayList<File>();
        for (File file : filePaths) {
            if (!this.isVersioned(file)) continue;
            updatedFilePaths.add(file);
        }
        if (updatedFilePaths.size() > 0) {
            try {
                this.beginOperation(null, filePaths[0], "doUpdate");
                this.client.update(updatedFilePaths.toArray(new File[0]), org.tigris.subversion.svnclientadapter.SVNRevision.HEAD, recursively, true);
            }
            catch (SVNClientException e) {
                this.logException("doUpdate", (Exception)((Object)e));
            }
            finally {
                this.endOperation();
            }
        }
    }

    public void doUpdate(File[] filePaths, boolean recursively, List<File> conflicted) {
        SVNDepth depth = SVNDepth.INFINITY;
        if (!recursively) {
            depth = SVNDepth.EMPTY;
        }
        this.doUpdate(filePaths, recursively, conflicted, null, null, org.tigris.subversion.svnclientadapter.SVNRevision.HEAD, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(File[] filePaths, boolean recursively, List<File> conflicted, List<File> changed, List<File> merged, org.tigris.subversion.svnclientadapter.SVNRevision revision, SVNDepth depth) {
        ArrayList<File> updatedFilePaths = new ArrayList<File>();
        for (File file : filePaths) {
            if (!this.isVersioned(file)) continue;
            updatedFilePaths.add(file);
        }
        if (updatedFilePaths.size() > 0) {
            try {
                SVNRepositoryInfo repInfo = this.beginOperation(null, filePaths[0], "doUpdate");
                SVNUpdateClient updClient = SVNUtil.getUpdateClient((SVNRepositoryInfo)repInfo);
                SVNRevision svnRevision = null;
                svnRevision = revision != null && !revision.toString().equalsIgnoreCase(SVNRevision.HEAD.toString()) ? SVNRevision.create((long)new Long(revision.toString())) : SVNRevision.HEAD;
                UpdateEventHandler eh = new UpdateEventHandler();
                updClient.setEventHandler((ISVNEventHandler)eh);
                updClient.doUpdate(updatedFilePaths.toArray(new File[0]), svnRevision, depth, recursively, true);
                if (conflicted != null) {
                    conflicted.addAll(eh.getConflictedFiles());
                }
                if (changed != null) {
                    changed.addAll(eh.getChangedFiles());
                }
                if (merged != null) {
                    merged.addAll(eh.getMergedFiles());
                }
            }
            catch (SVNException e) {
                this.logException("doUpdate", (Exception)((Object)e));
            }
            finally {
                this.endOperation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommit(File[] filePaths, String message, boolean recursively, boolean keepLocks) {
        if (filePaths.length == 0) {
            return;
        }
        String commonpath = SVNClientHelper.commonPath(filePaths);
        if (!this.isVersioned(new File(commonpath))) {
            for (File filePath : filePaths) {
                try {
                    this.beginOperation(null, filePath, "doCommit");
                    this.client.commit(new File[]{filePath}, message, recursively, keepLocks);
                }
                catch (SVNClientException e) {
                    this.logException("doCommit", (Exception)((Object)e));
                }
                finally {
                    this.endOperation();
                }
            }
        } else {
            try {
                this.beginOperation(null, filePaths[0], "doCommit");
                this.client.commit(filePaths, message, recursively, keepLocks);
            }
            catch (SVNClientException e) {
                this.logException("doCommit", (Exception)((Object)e));
            }
            finally {
                this.endOperation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRevert(File[] filePaths, boolean recursively) {
        try {
            this.beginOperation(null, filePaths[0], "doRevert");
            for (File filePath : filePaths) {
                this.client.revert(filePath, recursively);
            }
        }
        catch (SVNClientException e) {
            this.logException("doRevert", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public void doCleanup(File filePath) {
        try {
            this.beginOperation(null, filePath, "doCleanup");
            this.client.cleanup(filePath);
        }
        catch (SVNClientException e) {
            this.logException("doCleanup", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream doGetRevision(SVNUrl url, org.tigris.subversion.svnclientadapter.SVNRevision revision) {
        try {
            this.beginOperation(url, null, "doGetRevision");
            InputStream inputStream = this.client.getContent(url, revision);
            return inputStream;
        }
        catch (SVNClientException e) {
            this.logException("doGetRevision", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream doGetRevision(File filePath, org.tigris.subversion.svnclientadapter.SVNRevision revision) {
        try {
            this.beginOperation(null, filePath, "doGetRevision");
            InputStream inputStream = this.client.getContent(filePath, revision);
            return inputStream;
        }
        catch (SVNClientException e) {
            this.logException("doGetRevision", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ISVNLogMessage> doGetLogMessages(SVNUrl url, Long startRevision, Long endRevision, boolean stopOnCopy, boolean getChangePaths, int limit) {
        try {
            this.beginOperation(url, null, "doGetLogMessages");
            List<ISVNLogMessage> list = Arrays.asList(this.client.getLogMessages(url, org.tigris.subversion.svnclientadapter.SVNRevision.HEAD, startRevision == null ? org.tigris.subversion.svnclientadapter.SVNRevision.START : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)startRevision.toString()), endRevision == null ? org.tigris.subversion.svnclientadapter.SVNRevision.HEAD : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)endRevision.toString()), stopOnCopy, getChangePaths, (long)limit));
            return list;
        }
        catch (SVNClientException e) {
            this.logException("doGetLogMessages", (Exception)((Object)e));
        }
        catch (ParseException e) {
            this.logException("doGetLogMessages", e);
        }
        finally {
            this.endOperation();
        }
        return new ArrayList<ISVNLogMessage>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ISVNLogMessage> doGetLogMessages(File filePath, Long startRevision, Long endRevision, boolean stopOnCopy, boolean getChangePaths, int limit) {
        try {
            this.beginOperation(null, filePath, "doGetLogMessages");
            List<ISVNLogMessage> list = Arrays.asList(this.client.getLogMessages(filePath, startRevision == null ? org.tigris.subversion.svnclientadapter.SVNRevision.START : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)startRevision.toString()), endRevision == null ? org.tigris.subversion.svnclientadapter.SVNRevision.HEAD : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)endRevision.toString()), stopOnCopy, getChangePaths, (long)limit));
            return list;
        }
        catch (SVNClientException e) {
            this.logException("doGetLogMessages", (Exception)((Object)e));
        }
        catch (ParseException e) {
            this.logException("doGetLogMessages", e);
        }
        finally {
            this.endOperation();
        }
        return new ArrayList<ISVNLogMessage>();
    }

    @Override
    public void doResolved(File file) {
        try {
            this.beginOperation(null, file, "doResolved");
            this.client.resolved(file);
        }
        catch (SVNClientException e) {
            this.logException("doMarkAsMerged", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doIgnore(File filePath, String pattern) {
        try {
            this.beginOperation(null, filePath, "doIgnore");
            this.client.addToIgnoredPatterns(filePath, pattern);
        }
        catch (SVNClientException e) {
            this.logException("doIgnore", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLock(File[] files, boolean force, String comment) {
        try {
            this.beginOperation(null, files[0], "doLock");
            this.client.lock(files, comment, force);
        }
        catch (SVNClientException e) {
            this.logException("doLock", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUnlock(File[] files, boolean force) {
        try {
            this.beginOperation(null, files[0], "doUnlock");
            this.client.unlock(files, force);
        }
        catch (SVNClientException e) {
            this.logException("doUnlock", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doGetProperty(SVNUrl url, String propertyName, Long revision) {
        try {
            org.tigris.subversion.svnclientadapter.SVNRevision svnRevision = revision == null ? org.tigris.subversion.svnclientadapter.SVNRevision.HEAD : new SVNRevision.Number(revision.longValue());
            this.beginOperation(url, null, "doGetProperty");
            ISVNProperty property = this.client.propertyGet(url, svnRevision, svnRevision, propertyName);
            String string = property != null ? property.getValue() : null;
            return string;
        }
        catch (SVNClientException e) {
            this.logException("doGetProperty " + url, (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetPropertyForDeleted(SVNUrl url, String propertyName, Long revision) {
        org.tigris.subversion.svnclientadapter.SVNRevision svnRevision = null;
        if (revision == null) {
            svnRevision = org.tigris.subversion.svnclientadapter.SVNRevision.HEAD;
        } else if (revision > -1L) {
            svnRevision = new SVNRevision.Number(revision.longValue());
        }
        if (svnRevision != null) {
            try {
                this.beginOperation(url, null, "doGetProperty");
                ISVNProperty property = this.client.propertyGet(url, svnRevision, svnRevision, propertyName);
                String string = property != null ? property.getValue() : null;
                return string;
            }
            catch (SVNClientException e) {
                this.logException("doGetProperty " + url, (Exception)((Object)e));
            }
            finally {
                this.endOperation();
            }
        }
        return null;
    }

    @Override
    public String doGetProperty(File file, String propertyName) {
        return this.doGetProperty(file, propertyName, false);
    }

    public String doGetProperty(File file, String propertyName, boolean deleted) {
        block7: {
            try {
                SVNPropertyData prop;
                SVNClientManager clientManager = this.getSVNClientManagerInstance();
                SVNRevision oprev = SVNRevision.WORKING;
                if (deleted) {
                    oprev = SVNRevision.BASE;
                }
                if ((prop = clientManager.getWCClient().doGetProperty(file, propertyName, SVNRevision.BASE, oprev)) != null) {
                    return new String(prop.getValue().getBytes());
                }
                int extIndex = file.toString().lastIndexOf(46);
                if (extIndex <= 0 || !file.toString().substring(extIndex + 1).equalsIgnoreCase("dmd")) break block7;
                for (int loopCount = 0; loopCount < 4; ++loopCount) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        this.logException("doGetProperty " + file.getName(), e);
                    }
                    prop = clientManager.getWCClient().doGetProperty(file, propertyName, SVNRevision.BASE, SVNRevision.WORKING);
                    if (prop == null) continue;
                    return new String(prop.getValue().getBytes());
                }
            }
            catch (SVNException e) {
                this.logException("doGetProperty " + file.getName(), (Exception)((Object)e));
            }
        }
        return null;
    }

    public String getRepositoryURLForFile(File file) {
        try {
            SVNClientManager clientManager = this.getSVNClientManagerInstance();
            SVNInfo svnInfo = clientManager.getWCClient().doInfo(file, SVNRevision.WORKING);
            return svnInfo.getURL().toString();
        }
        catch (SVNException e) {
            this.logException("getRepositoryURL " + file.getName(), (Exception)((Object)e));
            return null;
        }
    }

    public String getRepositoryURL(File file) {
        try {
            SVNClientManager clientManager = this.getSVNClientManagerInstance();
            SVNInfo svnInfo = clientManager.getWCClient().doInfo(file, SVNRevision.WORKING);
            return svnInfo.getRepositoryRootURL().toString();
        }
        catch (SVNException e) {
            this.logException("getRepositoryURL " + file.getName(), (Exception)((Object)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNProperty[] doGetProperties(String url, Long revision) {
        try {
            SVNUrl svnUrl = new SVNUrl(url);
            this.beginOperation(svnUrl, null, "doGetProperties");
            ISVNProperty[] iSVNPropertyArray = this.client.getProperties(svnUrl);
            return iSVNPropertyArray;
        }
        catch (MalformedURLException e) {
            this.logException("doGetProperties " + url, e);
        }
        catch (SVNClientException e) {
            LOGGER.error((Object)e);
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    @Override
    public void doSetProperty(File file, String propertyName, String propertyValue) {
        this.doSetProperty(file, propertyName, propertyValue, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetProperty(File file, String propertyName, String propertyValue, boolean recurse) {
        try {
            this.beginOperation(null, file, "doSetProperty");
            this.client.propertySet(file, propertyName, propertyValue, recurse);
        }
        catch (SVNClientException e) {
            this.logException("doSetProperty " + file.getName(), (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SVNDiffSummary> doDiffSummarize(SVNUrl urlFrom, SVNUrl urlTo) {
        try {
            this.beginOperation(urlFrom, null, "doDiffSummarize");
            List<SVNDiffSummary> list = Arrays.asList(this.client.diffSummarize(urlFrom, null, urlTo, null, 3, false));
            return list;
        }
        catch (SVNClientException e) {
            this.logException("doDiffSummarize", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
        return new ArrayList<SVNDiffSummary>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MergeConflict> doMerge(SVNUrl urlFrom, File pathTo, List<RevisionRange> revisionRanges, boolean recordOnly, boolean dryRun) {
        ArrayList<MergeConflict> mergeConflicts = new ArrayList<MergeConflict>();
        try {
            SVNRepositoryInfo repositoryInfo = this.beginOperation(urlFrom, null, "doMerge");
            this.doLowLevelMerge(urlFrom, pathTo, revisionRanges, repositoryInfo, mergeConflicts, recordOnly, dryRun);
        }
        catch (Exception e) {
            this.logException("doMerge", e);
        }
        finally {
            this.endOperation();
        }
        File[] updRoot = new File[]{pathTo};
        this.doUpdate(updRoot, false);
        return mergeConflicts;
    }

    private void doLowLevelMerge(SVNUrl urlFrom, File pathTo, List<RevisionRange> revisionRanges, SVNRepositoryInfo repositoryInfo, final List<MergeConflict> mergeConflicts, boolean recordOnly, boolean dryRun) throws SVNException {
        SVNClientManager clientManager = SVNClientManager.newInstance();
        SVNDiffClient diffClient = clientManager.getDiffClient();
        SVNAuthInfo authInfo = repositoryInfo.getAuthInfo();
        DefaultSVNOptions options = (DefaultSVNOptions)diffClient.getOptions();
        SVNDiffOptions diffOptions = diffClient.getMergeOptions();
        final StringBuilder log = new StringBuilder();
        diffOptions.setIgnoreEOLStyle(true);
        if (dryRun) {
            diffClient.setEventHandler(new ISVNEventHandler(){

                public void handleEvent(SVNEvent svnEvent, double v) throws SVNException {
                    if (svnEvent.getContentsStatus() == SVNStatusType.CONFLICTED || svnEvent.getContentsStatus() == SVNStatusType.CONFLICTED_UNRESOLVED) {
                        log.append("Conflict ").append(svnEvent.getFile().getPath()).append('\n');
                    } else if (svnEvent.getAction() == SVNEventAction.TREE_CONFLICT) {
                        log.append("Tree Conflict ").append(svnEvent.getFile().getPath()).append('\n');
                    } else if (svnEvent.getAction() == SVNEventAction.UPDATE_ADD) {
                        log.append("Add ").append(svnEvent.getFile().getPath()).append('\n');
                    } else if (svnEvent.getAction() == SVNEventAction.UPDATE_DELETE) {
                        log.append("Delete ").append(svnEvent.getFile().getPath()).append('\n');
                    } else if (svnEvent.getAction() == SVNEventAction.UPDATE_UPDATE) {
                        log.append("Update ").append(svnEvent.getFile().getPath()).append('\n');
                    } else if (svnEvent.getAction() == SVNEventAction.MERGE_COMPLETE) {
                        log.append("Merge finished").append('\n');
                    }
                }

                public void checkCancelled() throws SVNCancelException {
                }
            });
            options.setConflictHandler(new ISVNConflictHandler(){

                public SVNConflictResult handleConflict(SVNConflictDescription svnConflictDescription) throws SVNException {
                    SVNMergeFileSet mergeFiles = svnConflictDescription.getMergeFiles();
                    MergeConflict mergeConflict = new MergeConflict(svnConflictDescription);
                    mergeConflicts.add(mergeConflict);
                    return new SVNConflictResult(SVNConflictChoice.POSTPONE, mergeFiles.getWCFile());
                }
            });
            diffClient.setOptions((ISVNOptions)options);
        } else {
            options.setConflictHandler(new ISVNConflictHandler(){

                public SVNConflictResult handleConflict(SVNConflictDescription svnConflictDescription) throws SVNException {
                    SVNConflictReason reason = svnConflictDescription.getConflictReason();
                    SVNConflictChoice choice = SVNConflictChoice.POSTPONE;
                    if (reason == SVNConflictReason.OBSTRUCTED && svnConflictDescription.isTreeConflict()) {
                        choice = SVNConflictChoice.POSTPONE;
                    } else {
                        MergeConflict mergeConflict = new MergeConflict(svnConflictDescription);
                        mergeConflicts.add(mergeConflict);
                    }
                    SVNConflictResult res = new SVNConflictResult(choice, null);
                    return res;
                }
            });
            diffClient.setOptions((ISVNOptions)options);
            this.mergedObjectsEventHandler.clearSVNStatuses();
            diffClient.setEventHandler((ISVNEventHandler)this.mergedObjectsEventHandler);
        }
        clientManager.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager((String)authInfo.getUserName(), (String)new String(authInfo.getPassword())));
        diffClient.doMerge(SVNURL.parseURIEncoded((String)urlFrom.toString()), SVNRevision.HEAD, this.convertRevisionRanges(revisionRanges), pathTo, SVNDepth.INFINITY, true, false, dryRun, recordOnly);
        if (dryRun) {
            LogReport lr = new LogReport(ApplicationView.getInstance());
            lr.setName("");
            lr.setLog(log.toString());
            lr.showDialog(new Dimension(750, 550));
        } else {
            for (MergeConflict mergeConflict : mergeConflicts) {
                SVNClientHelper.copyOverConflicted(mergeConflict.getLocalFile(), mergeConflict.getLocalLabel());
            }
        }
    }

    private List<SVNRevisionRange> convertRevisionRanges(List<RevisionRange> revisionRanges) {
        ArrayList<SVNRevisionRange> svnRevisionRanges = new ArrayList<SVNRevisionRange>(revisionRanges.size());
        for (RevisionRange revisionRange : revisionRanges) {
            Long startRevisionNumber = revisionRange.getStartRevision() - 1L;
            Long endRevisionNumber = revisionRange.getEndRevision();
            SVNRevision startRevision = SVNRevision.create((long)startRevisionNumber);
            SVNRevision endRevision = SVNRevision.create((long)endRevisionNumber);
            svnRevisionRanges.add(new SVNRevisionRange(startRevision, endRevision));
        }
        return svnRevisionRanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doMergeReintegrate(SVNUrl urlFrom, File pathTo, final List<MergeConflict> mergeConflicts) {
        SVNClientManager clientManager = SVNClientManager.newInstance();
        SVNDiffClient diffClient = clientManager.getDiffClient();
        DefaultSVNOptions options = (DefaultSVNOptions)diffClient.getOptions();
        boolean result = true;
        try {
            SVNRepositoryInfo repositoryInfo = this.beginOperation(urlFrom, null, "doMergeReintegrate");
            SVNAuthInfo authInfo = repositoryInfo.getAuthInfo();
            clientManager.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager((String)authInfo.getUserName(), (String)new String(authInfo.getPassword())));
            SVNURL urlf = SVNURL.parseURIDecoded((String)urlFrom.toString());
            this.mergedObjectsEventHandler.clearSVNStatuses();
            diffClient.setEventHandler((ISVNEventHandler)this.mergedObjectsEventHandler);
            SVNDiffOptions diffOptions = diffClient.getMergeOptions();
            diffOptions.setIgnoreEOLStyle(true);
            options.setConflictHandler(new ISVNConflictHandler(){

                public SVNConflictResult handleConflict(SVNConflictDescription svnConflictDescription) throws SVNException {
                    SVNConflictReason reason = svnConflictDescription.getConflictReason();
                    SVNConflictChoice choice = SVNConflictChoice.POSTPONE;
                    if (reason == SVNConflictReason.OBSTRUCTED && svnConflictDescription.isTreeConflict()) {
                        choice = SVNConflictChoice.POSTPONE;
                    } else {
                        MergeConflict mergeConflict = new MergeConflict(svnConflictDescription);
                        mergeConflicts.add(mergeConflict);
                    }
                    SVNConflictResult res = new SVNConflictResult(choice, null);
                    return res;
                }
            });
            diffClient.doMergeReIntegrate(urlf, null, pathTo, false);
        }
        catch (Exception e) {
            result = false;
            this.logException("doMergeReintegrate", e);
        }
        finally {
            this.endOperation();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCopy(String urlFrom, File pathTo, Long revision) {
        try {
            SVNRepositoryInfo repositoryInfo = this.beginOperation(new SVNUrl(urlFrom), null, "doCopy");
            SVNAuthInfo authInfo = repositoryInfo.getAuthInfo();
            SVNClientManager clientManager = SVNClientManager.newInstance();
            SVNCopyClient client = clientManager.getCopyClient();
            SVNRevision pegRevision = SVNRevision.create((long)revision);
            clientManager.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager((String)authInfo.getUserName(), (String)new String(authInfo.getPassword())));
            SVNCopySource copySource = new SVNCopySource(pegRevision, pegRevision, SVNURL.parseURIDecoded((String)urlFrom));
            client.doCopy(new SVNCopySource[]{copySource}, pathTo, false, false, true);
        }
        catch (Exception e) {
            this.logException("doCopy", e);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExport(SVNUrl urlFrom, File pathTo) {
        try {
            this.beginOperation(urlFrom, null, "doExport");
            this.client.doExport(urlFrom, pathTo, org.tigris.subversion.svnclientadapter.SVNRevision.HEAD, true);
        }
        catch (SVNClientException e) {
            this.logException("doExport", (Exception)((Object)e));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StorableObjectStatus> getStatuses(Design design, boolean remoteStatus, boolean acceptAll, boolean versionedOnly) {
        HashSet<org.tmatesoft.svn.core.wc.SVNStatus> svnStatuses = new HashSet<org.tmatesoft.svn.core.wc.SVNStatus>();
        HashSet<org.tmatesoft.svn.core.wc.SVNStatus> svnNormalStatuses = new HashSet<org.tmatesoft.svn.core.wc.SVNStatus>();
        String defaultSystemTypesPath = XMLTransformationManager.getDefaultSystemTypesPath();
        String designPath = design.getDesignStoragePath(design.getDesignID());
        List<org.tmatesoft.svn.core.wc.SVNStatus> allStatuses = null;
        if (!"".equals(designPath)) {
            allStatuses = this.doStatusSVN(new File(designPath), remoteStatus);
            org.tmatesoft.svn.core.wc.SVNStatus designDmdFileStatus = null;
            try {
                SVNStatusClient svnStatusClient;
                File dmdFile = new File(design.getStorageName());
                SVNRepositoryInfo repInfo = this.beginOperation(null, dmdFile, "doStatus");
                if (dmdFile != null && repInfo != null && (svnStatusClient = SVNUtil.getStatusClient((SVNRepositoryInfo)repInfo)) != null) {
                    try {
                        designDmdFileStatus = svnStatusClient.doStatus(dmdFile, remoteStatus);
                    }
                    catch (SVNException e) {
                        LOGGER.error((Object)e);
                        designDmdFileStatus = null;
                    }
                }
            }
            finally {
                this.endOperation();
            }
            if (designDmdFileStatus != null) {
                allStatuses.add(designDmdFileStatus);
            }
            this.filterStatusesSVN(svnStatuses, allStatuses, svnNormalStatuses, remoteStatus, versionedOnly);
        }
        if (!this.isSubfolder(new File(defaultSystemTypesPath), new File(designPath))) {
            allStatuses = this.doStatusSVN(new File(defaultSystemTypesPath), remoteStatus, SVNDepth.FILES);
            Object[] allStatusesArray = allStatuses.toArray();
            for (int i = 0; i < allStatusesArray.length; ++i) {
                org.tmatesoft.svn.core.wc.SVNStatus svnStatus = (org.tmatesoft.svn.core.wc.SVNStatus)allStatusesArray[i];
                String fileName = svnStatus.getFile().getName();
                if (fileName == null || fileName.endsWith(".xml") || fileName.endsWith(".udposdm")) continue;
                allStatuses.remove(svnStatus);
            }
            this.filterStatusesSVN(svnStatuses, allStatuses, svnNormalStatuses, remoteStatus, versionedOnly);
            if (!svnNormalStatuses.isEmpty() && Preferences.getPreferences().getProperties().getHashStructure("oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs").getBoolean("useLabelDecorations")) {
                List<StorableObjectStatus> normalStorableObjectStatuses = this.convertToStorableObjectStatusesSVN(design, svnNormalStatuses, remoteStatus, acceptAll);
                this.postProcessSVNStorableStatuses(design, normalStorableObjectStatuses);
            }
        }
        List<StorableObjectStatus> list = this.convertToStorableObjectStatusesSVN(design, svnStatuses, remoteStatus, acceptAll);
        try {
            this.postProcessSVNStorableStatuses(design, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    void postProcessSVNStorableStatuses(Design design, List<StorableObjectStatus> normalStorableObjectStatuses) {
        for (int i = 0; i < normalStorableObjectStatuses.size(); ++i) {
            SVNStorableObjectStatus svnStorableObjectStatus = (SVNStorableObjectStatus)normalStorableObjectStatuses.get(i);
            StorableObject storableObject = svnStorableObjectStatus.getStorableObject();
            ModelIDObject modelIDObject = null;
            if (storableObject != null && storableObject instanceof ModelIDObject) {
                modelIDObject = (ModelIDObject)storableObject;
                modelIDObject.setSVNStorableObjectStatus(svnStorableObjectStatus);
            }
            Design.SVNStatusAndPropertiesPair svnStatusAndPropertiesPair = null;
            SVNUrl furl = null;
            String svnProp = "";
            try {
                if (modelIDObject != null) {
                    svnProp = SVNClientHelper.getProperties(modelIDObject);
                    furl = new SVNUrl("file://" + modelIDObject.getSegmentedStorageName());
                } else {
                    furl = new SVNUrl("file://" + svnStorableObjectStatus.getFilePath().toString());
                }
                svnStatusAndPropertiesPair = design.getSVNPropertiesCache().get(furl);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (svnStatusAndPropertiesPair == null && svnStorableObjectStatus.getSVNStatus().getURL() != null) {
                try {
                    svnStatusAndPropertiesPair = design.getSVNPropertiesCache().get(new SVNUrl(svnStorableObjectStatus.getSVNStatus().getURL().toString()));
                }
                catch (MalformedURLException e) {
                    LOGGER.error(e);
                }
            }
            if (svnStatusAndPropertiesPair != null) {
                svnStatusAndPropertiesPair.svnStatus = svnStorableObjectStatus;
                if (StringUtilities.isEmpty(svnStatusAndPropertiesPair.svnProperties)) {
                    svnStatusAndPropertiesPair.svnProperties = svnProp;
                }
                try {
                    Map<SVNUrl, Design.SVNStatusAndPropertiesPair> map = design.getSVNPropertiesCache();
                    Design design2 = design;
                    design2.getClass();
                    map.put(furl, new Design.SVNStatusAndPropertiesPair(design2, svnStorableObjectStatus, svnStatusAndPropertiesPair.svnProperties));
                }
                catch (Exception e) {
                    LOGGER.error(e);
                }
                continue;
            }
            if (!svnStorableObjectStatus.getSVNStatus().getFile().isFile()) continue;
            try {
                SVNUrl svnUrl = furl;
                Map<SVNUrl, Design.SVNStatusAndPropertiesPair> map = design.getSVNPropertiesCache();
                Design design3 = design;
                design3.getClass();
                map.put(svnUrl, new Design.SVNStatusAndPropertiesPair(design3, svnStorableObjectStatus, svnProp));
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e);
            }
        }
    }

    public List<StorableObjectStatus> getRemoteStatuses(Design design, boolean remoteStatus, boolean acceptAll, boolean versionedOnly) {
        List<ISVNStatus> allStatuses;
        HashSet<ISVNStatus> svnStatuses = new HashSet<ISVNStatus>();
        String defaultSystemTypesPath = XMLTransformationManager.getDefaultSystemTypesPath();
        String designPath = design.getDesignPath();
        if (!"".equals(designPath)) {
            allStatuses = this.doStatus(new File(designPath), remoteStatus);
            this.filterStatuses(svnStatuses, allStatuses, remoteStatus, versionedOnly);
        }
        if (!this.isSubfolder(new File(defaultSystemTypesPath), new File(designPath))) {
            allStatuses = this.doStatus(new File(defaultSystemTypesPath), remoteStatus);
            this.filterStatuses(svnStatuses, allStatuses, remoteStatus, versionedOnly);
        }
        return this.convertToStorableObjectStatuses(design, svnStatuses, remoteStatus, acceptAll);
    }

    private void filterStatuses(Set<ISVNStatus> filteredStatuses, List<ISVNStatus> allStatuses, boolean remoteStatus, boolean versionedOnly) {
        if (remoteStatus) {
            for (ISVNStatus status : allStatuses) {
                SVNRevision.Number lastChangedRevision = status.getLastChangedRevision();
                if (lastChangedRevision == null || lastChangedRevision.getNumber() <= 0L) continue;
                if (status.getRepositoryPropStatus() != SVNStatusKind.NONE || status.getRepositoryTextStatus() != SVNStatusKind.NONE || status.getFile().isDirectory()) {
                    if (status.getFile().isDirectory()) {
                        if (this.exists(status.getUrl())) continue;
                        filteredStatuses.add(status);
                        continue;
                    }
                    filteredStatuses.add(status);
                    continue;
                }
                if (this.exists(status.getUrl()) || status.getPropStatus() != SVNStatusKind.NONE && status.getPropStatus() != SVNStatusKind.NORMAL || status.getTextStatus() != SVNStatusKind.NONE && status.getTextStatus() != SVNStatusKind.NORMAL || !versionedOnly && status.getRevision() == null) continue;
                filteredStatuses.add(status);
            }
        } else {
            for (ISVNStatus status : allStatuses) {
                if (versionedOnly && status.getPropStatus() == SVNStatusKind.NONE && (status.getTextStatus() == SVNStatusKind.UNVERSIONED || status.getTextStatus() == SVNStatusKind.NONE)) continue;
                if (status.getPropStatus() != SVNStatusKind.NONE && status.getPropStatus() != SVNStatusKind.NORMAL || status.getTextStatus() != SVNStatusKind.NONE && status.getTextStatus() != SVNStatusKind.NORMAL || !versionedOnly && status.getRevision() == null) {
                    filteredStatuses.add(status);
                    continue;
                }
                if (status.getLockOwner() != null && !"".equals(status.getLockOwner())) continue;
                filteredStatuses.add(status);
            }
        }
    }

    private void filterStatusesSVN(Set<org.tmatesoft.svn.core.wc.SVNStatus> filteredStatuses, List<org.tmatesoft.svn.core.wc.SVNStatus> allStatuses, Set<org.tmatesoft.svn.core.wc.SVNStatus> svnNormalStatuses, boolean remoteStatus, boolean versionedOnly) {
        if (remoteStatus) {
            for (org.tmatesoft.svn.core.wc.SVNStatus status : allStatuses) {
                SVNRevision lastChangedRevision = status.getCommittedRevision();
                if (SVNRevision.UNDEFINED == lastChangedRevision) {
                    lastChangedRevision = status.getRemoteRevision();
                }
                if (lastChangedRevision == null || lastChangedRevision.getNumber() <= 0L || status.getRemotePropertiesStatus() == SVNStatusType.STATUS_NONE && status.getRemoteNodeStatus() == SVNStatusType.STATUS_NONE) continue;
                filteredStatuses.add(status);
            }
        } else {
            for (org.tmatesoft.svn.core.wc.SVNStatus status : allStatuses) {
                if (status.getNodeStatus() == SVNStatusType.STATUS_NORMAL || status.getNodeStatus() == SVNStatusType.STATUS_NONE) {
                    svnNormalStatuses.add(status);
                    continue;
                }
                if (versionedOnly && status.getPropertiesStatus() == SVNStatusType.STATUS_NONE && (status.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED || status.getNodeStatus() == SVNStatusType.STATUS_NONE || status.getNodeStatus() == SVNStatusType.STATUS_NORMAL)) continue;
                if (status.getPropertiesStatus() != SVNStatusType.STATUS_NONE && status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL || status.getNodeStatus() != SVNStatusType.STATUS_NONE && status.getNodeStatus() != SVNStatusType.STATUS_NORMAL || !versionedOnly && status.getRevision() == null) {
                    filteredStatuses.add(status);
                    continue;
                }
                if (status.getLocalLock() != null && !"".equals(status.getLocalLock().getOwner())) {
                    filteredStatuses.add(status);
                    continue;
                }
                filteredStatuses.add(status);
            }
        }
    }

    private boolean isSubfolder(File file1, File file2) {
        if (file1 == null || file2 == null) {
            return false;
        }
        if (file1.equals(file2)) {
            return true;
        }
        return this.isSubfolder(file1.getParentFile(), file2);
    }

    @Override
    public VersionOperationSelectTablePanel createVersionOperationTablePanel(List<DisplayableLocatableNode> nodes) {
        DisplayProperty[] extraProperties = new DisplayProperty[]{new ClientDisplayProperty(Messages.getString("SVNClientHelper.Status"), null, 2, (Object)"M", null, String.class, 50), new CheckboxProperty()};
        MutableVersionOperationModel model = VCSComponents.createFileListerModel(nodes, (DisplayProperty[])extraProperties);
        for (int i = 0; i < model.getCount(); ++i) {
            DisplayableLocatableNode locatable = (DisplayableLocatableNode)model.getItem(i);
            if (locatable instanceof VersioningTreeNode) {
                VersioningTreeNode node = (VersioningTreeNode)locatable;
                TreeNode parent = node.getParent();
                if (parent != null) {
                    String rootStr;
                    StringBuilder location = new StringBuilder();
                    String parentStr = parent.toString();
                    TreeNode root = parent.getParent();
                    if (root != null && StringUtilities.isNotEmpty(rootStr = root.toString())) {
                        location.append(rootStr);
                        location.append(" \\ ");
                    }
                    if (StringUtilities.isNotEmpty(parentStr)) {
                        location.append(parentStr);
                    }
                    model.setProperty(i, model.getProperties()[0], (Object)location.toString());
                }
                model.setProperty(i, extraProperties[0], (Object)node.getStorableObjectStatus().getTextStatus());
            }
            model.setProperty(i, extraProperties[1], extraProperties[1].getPrototypeValue());
        }
        VersionOperationSelectTablePanel panel = new VersionOperationSelectTablePanel();
        panel.installModel((VersionOperationModel)model);
        panel.setDefaultRenderer(Displayable.class, (TableCellRenderer)new DisplayableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                this.setText(((Displayable)value).getLongLabel());
                return this;
            }
        });
        return panel;
    }

    public SVNObjectHelper createSVNObjectHelper(File file, SVNUrl url, boolean remoteStatus, String storageDesignID) {
        String svnProperties;
        if (remoteStatus) {
            svnProperties = this.doGetProperty(url, "dm:properties", (Long)null);
        } else {
            svnProperties = this.doGetProperty(file, "dm:properties");
            if (svnProperties == null && url != null && remoteStatus) {
                svnProperties = this.doGetProperty(url, "dm:properties", (Long)null);
            }
        }
        SVNObjectHelper svnObjectHelper = this.createSVNObjectHelper(file, svnProperties);
        if (svnObjectHelper == null) {
            return this.createBackupSVNObjectHelper(file, storageDesignID);
        }
        return svnObjectHelper;
    }

    protected SVNObjectHelper createSVNObjectHelper(File file, String svnProperties) {
        SVNObjectHelper svnOH = null;
        String objectID = this.getProperty(svnProperties, 0);
        if (objectID != null) {
            svnOH = new SVNObjectHelper();
            svnOH.propID = objectID;
            svnOH.propName = this.getProperty(svnProperties, 5);
            svnOH.className = this.getProperty(svnProperties, 1);
            svnOH.parentID = this.getProperty(svnProperties, 2);
            svnOH.fileName = file.getPath();
        }
        return svnOH;
    }

    protected SVNObjectHelper createBackupSVNObjectHelper(File file, String storageDesignID) {
        SVNObjectHelper svnOH = new SVNObjectHelper();
        svnOH.propID = file.getName().indexOf(46) > -1 ? file.getName().substring(0, file.getName().indexOf(46)) : file.getName();
        svnOH.propName = svnOH.propID;
        svnOH.className = ModelIDObject.class.getName();
        svnOH.parentID = storageDesignID;
        svnOH.fileName = file.getPath();
        return svnOH;
    }

    public List<StorableObjectStatus> convertToStorableObjectStatuses(Design design, Collection<ISVNStatus> svnStatuses, boolean remoteStatus, boolean acceptAll) {
        File file;
        Map<String, SVNObjectHelper> svnOHMap = design.getSVNObjectHelperMap();
        ArrayList<StorableObjectStatus> result = new ArrayList<StorableObjectStatus>();
        File sfile = null;
        String spath = design.getAppView().getSettings().getDefaultSystemTypesPath();
        if (!"".equals(spath) && !this.isVersioned(sfile = new File(spath))) {
            sfile = null;
        }
        File svnStatusFile = new File("");
        File designStoragePathFile = new File(design.getStoragePath());
        for (ISVNStatus svnStatus : svnStatuses) {
            SVNObjectHelper svnOH;
            file = svnStatus.getFile();
            if (!SVNClientHelper.accept(file) || SVNClientHelper.isSystemFile(file, sfile) || (svnOH = this.createSVNObjectHelper(svnStatus.getFile(), this.readProperties(design, svnStatus, remoteStatus))) == null) continue;
            try {
                Class<?> aClass = Class.forName(svnOH.className);
                if (aClass == null) continue;
                if (RelationalObjectProxy.class.isAssignableFrom(aClass)) {
                    String parentID = svnOH.parentID;
                    if (parentID != null && parentID.length() > 0) {
                        svnOHMap.put(parentID + "_" + svnOH.propID, svnOH);
                        continue;
                    }
                    svnOHMap.put(svnOH.propID, svnOH);
                    if (RelationalDesign.class != aClass || !"rel".equals(svnStatus.getFile().getParentFile().getName())) continue;
                    String fileName = svnStatus.getFile().getName();
                    String shortID = FileUtils.removeExt(fileName);
                    svnOHMap.put(shortID, svnOH);
                    continue;
                }
                svnOHMap.put(svnOH.propID, svnOH);
                if (RelationalDesign.class != aClass || !"rel".equals(svnStatus.getFile().getParentFile().getName())) continue;
                String fileName = svnStatus.getFile().getName();
                String shortID = FileUtils.removeExt(fileName);
                svnOHMap.put(shortID, svnOH);
            }
            catch (Exception e) {
                LOGGER.error(e);
            }
        }
        for (ISVNStatus svnStatus : svnStatuses) {
            SVNStorableObjectStatus storableObjectStatus;
            file = svnStatus.getFile();
            boolean deletedDir = false;
            if (remoteStatus && file.isDirectory() && (svnStatus.getTextStatus() == SVNStatusKind.NORMAL || svnStatus.getTextStatus() == SVNStatusKind.NONE) && svnStatus.getPropStatus() != SVNStatusKind.MODIFIED) {
                boolean bl = deletedDir = !this.exists(svnStatus.getUrl());
            }
            if (SVNClientHelper.accept(file)) {
                String svnProperties;
                String string = svnProperties = SVNClientHelper.isSystemFile(file, sfile) ? null : this.readProperties(design, svnStatus, remoteStatus);
                SVNStorableObjectStatus storableObjectStatus2 = new SVNStorableObjectStatus(design, svnStatus, remoteStatus, false);
                if (storableObjectStatus2 == null) continue;
                String propID = this.getProperty(svnProperties, 0);
                String propName = this.getProperty(svnProperties, 5);
                String propParentID = this.getProperty(svnProperties, 2);
                if (remoteStatus && svnStatus.getRepositoryTextStatus() == SVNStatusKind.ADDED || remoteStatus || svnStatus.getTextStatus() == SVNStatusKind.DELETED || svnStatus.getTextStatus() == SVNStatusKind.MISSING) {
                    // empty if block
                }
                if (propID != null) {
                    storableObjectStatus2.setStorableObjectID(propID);
                }
                if (propName != null) {
                    storableObjectStatus2.setStorableObjectName(propName);
                } else if (storableObjectStatus2.getStorableObjectName() == null) {
                    storableObjectStatus2.setStorableObjectName(storableObjectStatus2.getStorableObjectID());
                }
                storableObjectStatus2.setStorableObjectParentID(propParentID);
                result.add(storableObjectStatus2);
                continue;
            }
            if (!design.getDesignPath().equals(file.getPath()) && !acceptAll && !deletedDir && !file.getPath().startsWith(design.getStoragePath() + File.separator + "files") || (storableObjectStatus = new SVNStorableObjectStatus(design, svnStatus, remoteStatus, deletedDir)) == null) continue;
            result.add(storableObjectStatus);
        }
        Collections.sort(result, PATH_COMPARATOR);
        for (StorableObjectStatus sos : result) {
            if (!sos.getTextStatus().equals("?") || !(svnStatusFile = sos.getFilePath()).getAbsolutePath().startsWith(designStoragePathFile.getAbsolutePath() + File.separator + "files")) continue;
            this.doAdd(sos.getFilePath(), true);
            sos.setTextStatus("A");
        }
        return result;
    }

    public List<StorableObjectStatus> convertToStorableObjectStatusesSVN(Design design, Collection<org.tmatesoft.svn.core.wc.SVNStatus> svnStatuses, boolean remoteStatus, boolean acceptAll) {
        Map<String, SVNObjectHelper> svnOHMap = design.getSVNObjectHelperMap();
        ArrayList<StorableObjectStatus> result = new ArrayList<StorableObjectStatus>();
        File sfile = null;
        String spath = design.getAppView().getSettings().getDefaultSystemTypesPath();
        if (!"".equals(spath) && !this.isVersioned(sfile = new File(spath))) {
            sfile = null;
        }
        for (org.tmatesoft.svn.core.wc.SVNStatus svnStatus : svnStatuses) {
            SVNStorableObjectStatus storableObjectStatus;
            File file = svnStatus.getFile();
            boolean deletedDir = false;
            SVNStatusType stat = svnStatus.getNodeStatus();
            if (remoteStatus && file.isDirectory() && (stat == SVNStatusType.STATUS_NORMAL || stat == SVNStatusType.STATUS_NONE) && svnStatus.getPropertiesStatus() != SVNStatusType.STATUS_MODIFIED) {
                boolean bl = deletedDir = svnStatus.getURL() != null && !this.exists(SVNUtil.toSVNUrl((SVNURL)svnStatus.getURL()));
            }
            if (SVNClientHelper.accept(file) && stat != SVNStatusType.STATUS_NORMAL && stat != SVNStatusType.STATUS_NONE) {
                String svnProperties;
                storableObjectStatus = new SVNStorableObjectStatus(design, svnStatus, remoteStatus, false);
                String string = svnProperties = SVNClientHelper.isSystemFile(file, sfile) ? null : this.readProperties(design, svnStatus, remoteStatus, storableObjectStatus);
                if (storableObjectStatus == null) continue;
                String propID = this.getProperty(svnProperties, 0);
                String propName = this.getProperty(svnProperties, 5);
                String propParentID = this.getProperty(svnProperties, 2);
                if (remoteStatus && svnStatus.getRemoteNodeStatus() == SVNStatusType.STATUS_ADDED || remoteStatus || stat == SVNStatusType.STATUS_DELETED || stat == SVNStatusType.MISSING) {
                    // empty if block
                }
                if (propID != null) {
                    storableObjectStatus.setStorableObjectID(propID);
                }
                if (propName != null) {
                    storableObjectStatus.setStorableObjectName(propName);
                } else if (storableObjectStatus.getStorableObjectName() == null) {
                    storableObjectStatus.setStorableObjectName(storableObjectStatus.getStorableObjectID());
                }
                storableObjectStatus.setStorableObjectParentID(propParentID);
                result.add(storableObjectStatus);
                continue;
            }
            if (!design.getDesignPath().equals(file.getPath()) && stat != SVNStatusType.STATUS_NORMAL && stat != SVNStatusType.STATUS_NONE && !acceptAll && !deletedDir && (!file.isDirectory() || stat != SVNStatusType.STATUS_UNVERSIONED) && !file.getPath().startsWith(design.getStoragePath() + File.separator + "files") || (storableObjectStatus = new SVNStorableObjectStatus(design, svnStatus, remoteStatus, deletedDir)) == null) continue;
            result.add(storableObjectStatus);
        }
        File svnStatusFile = new File("");
        File designStoragePathFile = new File(design.getStoragePath());
        for (org.tmatesoft.svn.core.wc.SVNStatus svnStatus : svnStatuses) {
            SVNObjectHelper svnOH;
            File file = svnStatus.getFile();
            SVNStatusType stat = svnStatus.getNodeStatus();
            if (!SVNClientHelper.accept(file) || SVNClientHelper.isSystemFile(file, sfile) || stat == SVNStatusType.STATUS_NORMAL || stat == SVNStatusType.STATUS_NONE || (svnOH = this.createSVNObjectHelper(svnStatus.getFile(), this.readProperties(design, svnStatus, remoteStatus, null))) == null) continue;
            try {
                Class<?> aClass = Class.forName(svnOH.className);
                if (aClass == null) continue;
                if (RelationalObjectProxy.class.isAssignableFrom(aClass)) {
                    String parentID = svnOH.parentID;
                    if (parentID != null && parentID.length() > 0) {
                        svnOHMap.put(parentID + "_" + svnOH.propID, svnOH);
                        continue;
                    }
                    svnOHMap.put(svnOH.propID, svnOH);
                    if (RelationalDesign.class != aClass || !"rel".equals(svnStatus.getFile().getParentFile().getName())) continue;
                    String fileName = svnStatus.getFile().getName();
                    String shortID = FileUtils.removeExt(fileName);
                    svnOHMap.put(shortID, svnOH);
                    continue;
                }
                svnOHMap.put(svnOH.propID, svnOH);
                if (RelationalDesign.class != aClass || !"rel".equals(svnStatus.getFile().getParentFile().getName())) continue;
                String fileName = svnStatus.getFile().getName();
                String shortID = FileUtils.removeExt(fileName);
                svnOHMap.put(shortID, svnOH);
            }
            catch (Exception e) {
                LOGGER.error(e);
            }
        }
        Collections.sort(result, PATH_COMPARATOR);
        for (StorableObjectStatus sos : result) {
            if (!sos.getTextStatus().equals("?") || !(svnStatusFile = sos.getFilePath()).getAbsolutePath().startsWith(designStoragePathFile.getAbsolutePath() + File.separator + "files")) continue;
            this.doAdd(sos.getFilePath(), true);
            sos.setTextStatus("A");
        }
        return result;
    }

    protected String readProperties(Design design, ISVNStatus svnStatus, boolean remoteStatus) {
        SVNUrl svnUrl = svnStatus.getUrl();
        Design.SVNStatusAndPropertiesPair svnStatusAndPropertiesPair = design.getSVNPropertiesCache().get(svnUrl);
        String svnProperties = "";
        if (svnStatusAndPropertiesPair != null) {
            svnProperties = svnStatusAndPropertiesPair.svnProperties;
        }
        if (StringUtilities.isEmpty(svnProperties)) {
            File file = svnStatus.getFile();
            if (file != null && this.isVersioned(file)) {
                svnProperties = this.doGetProperty(file, "dm:properties");
            }
            if (StringUtilities.isEmpty(svnProperties)) {
                SVNStatusKind textStatus = svnStatus.getTextStatus();
                if (remoteStatus && textStatus == SVNStatusKind.DELETED || !remoteStatus && (textStatus == SVNStatusKind.ADDED || textStatus == SVNStatusKind.UNVERSIONED || textStatus == SVNStatusKind.MISSING)) {
                    return svnProperties;
                }
                if (svnStatus.getUrl() != null && textStatus == SVNStatusKind.NORMAL) {
                    svnProperties = this.doGetPropertyForDeleted(svnStatus.getUrl(), "dm:properties", null);
                }
            }
            if (!StringUtilities.isEmpty(svnProperties)) {
                // empty if block
            }
        }
        return svnProperties;
    }

    protected String readProperties(Design design, org.tmatesoft.svn.core.wc.SVNStatus svnStatus, boolean remoteStatus, SVNStorableObjectStatus storableObjectStatus) {
        ModelIDObject mobj;
        StorableObject obj;
        File file;
        SVNURL url = svnStatus.getURL();
        if (url == null && remoteStatus) {
            url = svnStatus.getRemoteURL();
        }
        SVNUrl svnUrl = null;
        if (url != null) {
            svnUrl = SVNUtil.toSVNUrl((SVNURL)url);
        }
        Design.SVNStatusAndPropertiesPair svnStatusAndPropertiesPair = null;
        if (svnUrl != null) {
            svnStatusAndPropertiesPair = design.getSVNPropertiesCache().get(svnUrl);
        }
        String svnProperties = "";
        if (svnStatusAndPropertiesPair != null) {
            svnProperties = svnStatusAndPropertiesPair.svnProperties;
        }
        if (StringUtilities.isEmpty(svnProperties)) {
            file = svnStatus.getFile();
            try {
                svnStatusAndPropertiesPair = design.getSVNPropertiesCache().get(new SVNUrl("file://" + file.getPath()));
                if (svnStatusAndPropertiesPair != null) {
                    svnProperties = svnStatusAndPropertiesPair.svnProperties;
                }
            }
            catch (MalformedURLException e) {
                this.logException("readProperties MalformedURLException ", e);
            }
        }
        if (StringUtilities.isEmpty(svnProperties) && storableObjectStatus != null && (obj = storableObjectStatus.getStorableObject()) != null && obj instanceof ModelIDObject && (mobj = (ModelIDObject)obj).isLoadedCompletely()) {
            svnProperties = SVNClientHelper.getProperties(mobj);
        }
        if (StringUtilities.isEmpty(svnProperties)) {
            file = svnStatus.getFile();
            if (file != null && StringUtilities.isEmpty(svnProperties) && svnStatus.isVersioned()) {
                boolean deleted = false;
                if (storableObjectStatus != null) {
                    deleted = storableObjectStatus.isDeleted();
                }
                svnProperties = this.doGetProperty(file, "dm:properties", deleted);
            }
            if (StringUtilities.isEmpty(svnProperties)) {
                SVNStatusType textStatus = svnStatus.getNodeStatus();
                if (remoteStatus) {
                    textStatus = svnStatus.getRemoteNodeStatus();
                }
                if (remoteStatus && textStatus == SVNStatusType.STATUS_DELETED || !remoteStatus && (textStatus == SVNStatusType.STATUS_ADDED || textStatus == SVNStatusType.STATUS_UNVERSIONED || textStatus == SVNStatusType.MISSING)) {
                    return svnProperties;
                }
                if (svnUrl != null && (textStatus == SVNStatusType.STATUS_NORMAL || remoteStatus && textStatus == SVNStatusType.STATUS_ADDED)) {
                    if (svnStatus.getRemoteRevision() != null) {
                        try {
                            svnProperties = this.doGetPropertyForDeleted(svnUrl, "dm:properties", svnStatus.getRemoteRevision().getNumber());
                        }
                        catch (Exception e) {
                            this.logException("readProperties doGetPropertyForDeleted ", e);
                        }
                    } else {
                        try {
                            svnProperties = this.doGetPropertyForDeleted(svnUrl, "dm:properties", null);
                        }
                        catch (Exception e) {
                            this.logException("readProperties doGetPropertyForDeleted remoteRevision null", e);
                        }
                    }
                }
            }
            if (storableObjectStatus != null) {
                if (svnProperties == null) {
                    svnProperties = "";
                }
                Design design2 = design;
                design2.getClass();
                Design.SVNStatusAndPropertiesPair pair = new Design.SVNStatusAndPropertiesPair(design2, storableObjectStatus, svnProperties);
                SVNUrl fileURL = null;
                try {
                    fileURL = new SVNUrl("file://" + svnStatus.getFile().getPath());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                if (fileURL != null) {
                    design.getSVNPropertiesCache().put(fileURL, pair);
                } else {
                    design.getSVNPropertiesCache().put(svnUrl, pair);
                }
            }
        }
        return svnProperties;
    }

    public static boolean isSystemFile(File file, File stype) {
        String fileName = file.getName();
        String objName = FileUtils.removeExt(fileName);
        if ("dl_settings.xml".equalsIgnoreCase(fileName) || "ExtendedMap".equalsIgnoreCase(objName) || "defaultRDBMSSites.xml".equalsIgnoreCase(fileName) || "defaultdomains.xml".equalsIgnoreCase(fileName) || "types.xml".equalsIgnoreCase(fileName) || fileName.endsWith("_RDBMSSites.xml") || "domains".equals(file.getParentFile().getName()) || fileName.startsWith("ExtendedMap_RM") || fileName.startsWith("DeletedMap_RM")) {
            return true;
        }
        return file.getParentFile().equals(stype);
    }

    protected SVNRepositoryInfo beginOperation(SVNUrl svnUrl, File file, String operationName) {
        SVNRepositoryInfo repoInfo = null;
        try {
            if (svnUrl == null && file != null) {
                svnUrl = this.findSVNUrl(file);
            }
            repoInfo = SVNUtil.resolveRepository((SVNUrl)svnUrl);
            this.svnOperationLogger.beginOperation(this.client, repoInfo);
        }
        catch (MalformedURLException e) {
            this.logException("SVNClientHelper.beginOperation " + operationName, e);
        }
        catch (SVNClientException e) {
            this.logException("SVNClientHelper.beginOperation " + operationName, (Exception)((Object)e));
        }
        return repoInfo;
    }

    private SVNUrl findSVNUrl(File file) throws MalformedURLException, SVNClientException {
        if (file != null) {
            SVNUrl result = null;
            try {
                result = SVNURLInfoCache.getInstance().getURL(file.toURI().toURL());
            }
            catch (SVNException e) {
                LOGGER.error((Object)e);
            }
            catch (IOException e) {
                LOGGER.error(e);
            }
            if (result == null) {
                return this.findSVNUrl(file.getParentFile());
            }
            return result;
        }
        return null;
    }

    protected void endOperation() {
        try {
            this.svnOperationLogger.endOperation();
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    protected void logException(Exception e) {
        this.logException(null, e);
    }

    protected void logException(String operationName, Exception e) {
        int errorCode;
        if (operationName != null) {
            LOGGER.warn(operationName, e);
        } else {
            LOGGER.warn(e);
        }
        if (e.getCause() instanceof ClientException && ((errorCode = ((ClientException)e.getCause()).getAprError()) == 200015 || errorCode == 150000 || errorCode == 200015 || errorCode == 200030 || errorCode == 200007 || errorCode == 235000 || errorCode == 175002 || errorCode == 125002 || errorCode == 155007)) {
            return;
        }
        this.svnExceptionHandler.handleExceptionWithOption((Exception)SVNExceptionWrapper.wrapSVNClientException((Exception)e));
    }

    public SVNMergedObjectsEventHandler getMergedObjectsEventHandler() {
        return this.mergedObjectsEventHandler;
    }

    public List<VersioningTreeNode> getLastMergedObjects() {
        List<ISVNStatus> statuses;
        List<StorableObjectStatus> list;
        Design design = this.getCurrentDesign();
        if (design != null && (list = this.convertToStorableObjectStatuses(design, statuses = this.getMergedObjectsEventHandler().getSVNStatuses(), false, false)).size() > 0) {
            ArrayList<VersioningTreeNode> result = new ArrayList<VersioningTreeNode>();
            for (StorableObjectStatus storableObjectStatus : list) {
                if (!(storableObjectStatus instanceof SVNStorableObjectStatus)) continue;
                VersioningTreeNode node = new VersioningTreeNode(storableObjectStatus);
                result.add(node);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public List<VersioningTreeNode> getLastConflictedObjects() {
        List<ISVNStatus> statuses;
        List<StorableObjectStatus> list;
        Design design = this.getCurrentDesign();
        if (design != null && (list = this.convertToStorableObjectStatuses(design, statuses = this.getMergedObjectsEventHandler().getSVNStatuses(), false, false)).size() > 0) {
            ArrayList<VersioningTreeNode> result = new ArrayList<VersioningTreeNode>();
            for (StorableObjectStatus storableObjectStatus : list) {
                if (!(storableObjectStatus instanceof SVNStorableObjectStatus)) continue;
                VersioningTreeNode node = new VersioningTreeNode(storableObjectStatus);
                result.add(node);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public Design getCurrentDesign() {
        return this.currentDesign;
    }

    public void setCurrentDesign(Design currentDesign) {
        this.currentDesign = currentDesign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveLocalFilesFirst(File filePath) {
        Design currentDesign = ApplicationView.getInstance().getCurrentDesign();
        if (filePath.isDirectory()) {
            List<File> localFilesList = new ArrayList<File>();
            if ((localFilesList = this.getFilesList(filePath, localFilesList)).size() > 0) {
                File[] localFiles = localFilesList.toArray(new File[localFilesList.size()]);
                this.collectFiles(localFilesList);
                try {
                    this.beginOperation(null, filePath, "doRemoveLocalFilesFirst");
                    this.client.remove(localFiles, true);
                }
                catch (SVNClientException e) {
                    this.logException("doRemoveLocalFilesFirst", (Exception)((Object)e));
                }
                finally {
                    this.endOperation();
                }
                this.refresh(localFiles);
                if (this.commit()) {
                    this.doCommit(localFiles, Messages.getString("SVNMergeWindow.DeleteLocalCommitMessage"), false, false);
                    this.doUpdate(new File[]{new File(currentDesign.getDesignPath())}, true);
                }
            }
        }
    }

    protected void refresh(File[] filePaths) {
        ArrayList<VersioningTreeNode> nodesForRefreshing = new ArrayList<VersioningTreeNode>();
        Design design = ApplicationView.getInstance().getCurrentDesign();
        for (File filePath : filePaths) {
            SVNStorableObjectStatus storableObjectStatus = new SVNStorableObjectStatus(design, filePath, "D", null, null);
            nodesForRefreshing.add(new VersioningTreeNode(storableObjectStatus));
        }
        VersioningTreeNode.refresh(nodesForRefreshing, false, true);
    }

    protected boolean commit() {
        int commitOption = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SVNMergeWindow.DeleteLocalFilesCommitDialogText"), Messages.getString("SVNMergeWindow.DeleteLocalCommitDialogTitle"), 0, 3);
        return commitOption == 0;
    }

    protected void collectFiles(List<File> filePaths) {
        Design design = ApplicationView.getInstance().getCurrentDesign();
        List<DeletedFile> deletedFiles = design.getDesignLevelSettings().getDeletedFiles();
        for (File file : filePaths) {
            ISVNInfo svnInfo = this.doInfo(file);
            String url = svnInfo.getUrlString();
            if (svnInfo.getRevision() == null) continue;
            Long currentRevision = svnInfo.getRevision().getNumber();
            deletedFiles.add(new DeletedFile(file, url, currentRevision));
        }
        design.saveDesignLevelSettings();
    }

    public List<File> getFilesList(File filePath, List<File> localFilesList) {
        File dir = filePath;
        File[] files = dir.listFiles();
        if (files.length != 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (files[i].getName().equals(".svn")) continue;
                    this.getFilesList(files[i], localFilesList);
                    continue;
                }
                localFilesList.add(files[i]);
            }
        }
        return localFilesList;
    }

    public static String commonPath(File ... commitFiles) {
        String[] paths = new String[commitFiles.length];
        for (int i = 0; i < commitFiles.length; ++i) {
            paths[i] = commitFiles[i].getAbsolutePath();
        }
        String commonPath = "";
        String[][] folders = new String[paths.length][];
        String regExp = "\\" + File.separator;
        for (int i = 0; i < paths.length; ++i) {
            folders[i] = paths[i].split(regExp);
        }
        for (int j = 0; j < folders[0].length; ++j) {
            String thisFolder = folders[0][j];
            boolean allMatched = true;
            for (int i = 1; i < folders.length && allMatched; allMatched &= folders[i][j].equals(thisFolder), ++i) {
                if (folders[i].length >= j) continue;
                allMatched = false;
                break;
            }
            if (!allMatched) break;
            commonPath = commonPath + thisFolder + File.separator;
        }
        return commonPath;
    }

    public void createSVNClientManagerInstance() {
        if (svnClientManager == null) {
            svnClientManager = SVNClientManager.newInstance();
        }
    }

    public void disposeSVNClientManagerInstance() {
        svnClientManager = null;
    }

    private SVNClientManager getSVNClientManagerInstance() {
        if (svnClientManager == null) {
            svnClientManager = SVNClientManager.newInstance();
        }
        return svnClientManager;
    }

    public static class UpdateEventHandler
    implements ISVNEventHandler {
        List<File> conflicted = new ArrayList<File>();
        List<File> changed = new ArrayList<File>();
        List<File> merged = new ArrayList<File>();

        public List<File> getConflictedFiles() {
            return this.conflicted;
        }

        public void handleEvent(SVNEvent event, double progress) {
            SVNEventAction action = event.getAction();
            String pathChangeType = " ";
            if (action == SVNEventAction.UPDATE_ADD) {
                pathChangeType = "A";
            } else if (action == SVNEventAction.UPDATE_DELETE) {
                pathChangeType = "D";
            } else if (action == SVNEventAction.UPDATE_UPDATE) {
                SVNStatusType contentsStatus = event.getContentsStatus();
                if (contentsStatus == SVNStatusType.CHANGED) {
                    pathChangeType = "U";
                    if (!event.getFile().isDirectory()) {
                        this.changed.add(event.getFile());
                    }
                } else if (contentsStatus == SVNStatusType.CONFLICTED || contentsStatus == SVNStatusType.CONFLICTED_UNRESOLVED) {
                    pathChangeType = "C";
                    if (!event.getFile().isDirectory()) {
                        this.conflicted.add(event.getFile());
                    }
                } else if (contentsStatus == SVNStatusType.MERGED) {
                    pathChangeType = "G";
                    if (!event.getFile().isDirectory()) {
                        this.merged.add(event.getFile());
                    }
                }
            } else {
                if (action == SVNEventAction.UPDATE_EXTERNAL) {
                    return;
                }
                if (action == SVNEventAction.UPDATE_COMPLETED) {
                    System.out.println("At revision " + event.getRevision());
                    return;
                }
            }
            SVNStatusType propertiesStatus = event.getPropertiesStatus();
            String propertiesChangeType = " ";
            if (propertiesStatus == SVNStatusType.CHANGED) {
                propertiesChangeType = "U";
            } else if (propertiesStatus == SVNStatusType.CONFLICTED) {
                propertiesChangeType = "C";
            } else if (propertiesStatus == SVNStatusType.MERGED) {
                propertiesChangeType = "G";
            }
            String lockLabel = " ";
            SVNStatusType lockType = event.getLockStatus();
            if (lockType == SVNStatusType.LOCK_UNLOCKED) {
                lockLabel = "B";
            }
        }

        public void checkCancelled() throws SVNCancelException {
        }

        public List<File> getChangedFiles() {
            return this.changed;
        }

        public List<File> getMergedFiles() {
            return this.merged;
        }
    }

    public static class StatusHandler
    implements ISVNStatusHandler,
    ISVNEventHandler {
        private boolean myIsRemote;
        private List<org.tmatesoft.svn.core.wc.SVNStatus> list = new ArrayList<org.tmatesoft.svn.core.wc.SVNStatus>();

        public StatusHandler(boolean isRemote) {
            this.myIsRemote = isRemote;
        }

        public void handleStatus(org.tmatesoft.svn.core.wc.SVNStatus status) {
            this.list.add(status);
        }

        public void checkCancelled() throws SVNCancelException {
        }

        public void handleEvent(SVNEvent arg0, double arg1) throws SVNException {
        }

        public List<org.tmatesoft.svn.core.wc.SVNStatus> getCollectedStateses() {
            return this.list;
        }
    }

    static class SVNMergedObjectsEventHandler
    implements ISVNEventHandler {
        List<ISVNStatus> svnStatuses = new ArrayList<ISVNStatus>();
        SVNClientHelper clientHelper;

        public SVNMergedObjectsEventHandler(SVNClientHelper clientHelper) {
            this.clientHelper = clientHelper;
        }

        public void handleEvent(SVNEvent svnEvent, double v) throws SVNException {
            boolean processed = false;
            boolean conflicted = false;
            if (svnEvent.getContentsStatus() == SVNStatusType.CONFLICTED || svnEvent.getContentsStatus() == SVNStatusType.CONFLICTED_UNRESOLVED) {
                conflicted = true;
            } else if (svnEvent.getAction() == SVNEventAction.TREE_CONFLICT) {
                conflicted = true;
            } else if (svnEvent.getAction() == SVNEventAction.UPDATE_ADD) {
                processed = true;
            } else if (svnEvent.getAction() == SVNEventAction.UPDATE_DELETE) {
                processed = true;
            } else if (svnEvent.getAction() == SVNEventAction.UPDATE_UPDATE) {
                processed = true;
            } else if (svnEvent.getAction() == SVNEventAction.MERGE_COMPLETE) {
                // empty if block
            }
            if (processed && svnEvent.getFile().isFile() && VCSClientHelper.acceptFile(svnEvent.getFile())) {
                ISVNStatus stat = this.clientHelper.getSingleStatusLocal(svnEvent.getFile());
                this.svnStatuses.add(stat);
            }
            if (!conflicted || !svnEvent.getFile().isFile() || VCSClientHelper.acceptFile(svnEvent.getFile())) {
                // empty if block
            }
        }

        public void checkCancelled() throws SVNCancelException {
        }

        public List<ISVNStatus> getSVNStatuses() {
            return this.svnStatuses;
        }

        public void clearSVNStatuses() {
            this.svnStatuses.clear();
        }
    }

    static class SVNLogEventHandler
    implements ISVNEventHandler {
        StringBuilder log = new StringBuilder();

        SVNLogEventHandler() {
        }

        public void handleEvent(SVNEvent svnEvent, double v) throws SVNException {
            if (svnEvent.getContentsStatus() == SVNStatusType.CONFLICTED || svnEvent.getContentsStatus() == SVNStatusType.CONFLICTED_UNRESOLVED) {
                this.log.append("Conflict ").append(svnEvent.getFile().getPath()).append('\n');
            } else if (svnEvent.getAction() == SVNEventAction.TREE_CONFLICT) {
                this.log.append("Tree Conflict ").append(svnEvent.getFile().getPath()).append('\n');
            } else if (svnEvent.getAction() == SVNEventAction.UPDATE_ADD) {
                this.log.append("Add ").append(svnEvent.getFile().getPath()).append('\n');
            } else if (svnEvent.getAction() == SVNEventAction.UPDATE_DELETE) {
                this.log.append("Delete ").append(svnEvent.getFile().getPath()).append('\n');
            } else if (svnEvent.getAction() == SVNEventAction.UPDATE_UPDATE) {
                this.log.append("Update ").append(svnEvent.getFile().getPath()).append('\n');
            } else if (svnEvent.getAction() == SVNEventAction.MERGE_COMPLETE) {
                this.log.append("Merge finished").append('\n');
            }
        }

        public void checkCancelled() throws SVNCancelException {
        }

        public StringBuilder getLog() {
            return this.log;
        }
    }

    static class SVNStatus
    implements ISVNStatus {
        private SVNDiffSummary diffSummary;
        private SVNUrl svnUrl;
        private SVNUrl baseUrl;
        private File file;

        private SVNStatus(SVNDiffSummary diffSummary, File designPath, String baseUrl) throws MalformedURLException {
            this.diffSummary = diffSummary;
            String filePath = diffSummary.getPath();
            this.baseUrl = new SVNUrl(baseUrl);
            this.svnUrl = new SVNUrl(baseUrl + "/" + filePath);
            this.file = new File(designPath.getParent(), filePath);
        }

        public SVNUrl getUrl() {
            return this.svnUrl;
        }

        public String getUrlString() {
            return this.svnUrl.toString();
        }

        public SVNUrl getBaseUrl() {
            return this.baseUrl;
        }

        public SVNRevision.Number getLastChangedRevision() {
            return null;
        }

        public Date getLastChangedDate() {
            return null;
        }

        public String getLastCommitAuthor() {
            return null;
        }

        public SVNStatusKind getTextStatus() {
            return this.getRepositoryTextStatus();
        }

        public SVNStatusKind getRepositoryTextStatus() {
            if (SVNDiffSummary.SVNDiffKind.ADDED.equals((Object)this.diffSummary.getDiffKind())) {
                return SVNStatusKind.ADDED;
            }
            if (SVNDiffSummary.SVNDiffKind.DELETED.equals((Object)this.diffSummary.getDiffKind())) {
                return SVNStatusKind.DELETED;
            }
            if (SVNDiffSummary.SVNDiffKind.MODIFIED.equals((Object)this.diffSummary.getDiffKind())) {
                return SVNStatusKind.MODIFIED;
            }
            return SVNStatusKind.NORMAL;
        }

        public SVNStatusKind getPropStatus() {
            return null;
        }

        public SVNStatusKind getRepositoryPropStatus() {
            return null;
        }

        public SVNRevision.Number getRevision() {
            return null;
        }

        public String getPath() {
            return this.file.getPath();
        }

        public File getFile() {
            return this.file;
        }

        public SVNNodeKind getNodeKind() {
            return null;
        }

        public boolean isCopied() {
            return false;
        }

        public boolean isWcLocked() {
            return false;
        }

        public boolean isSwitched() {
            return false;
        }

        public SVNUrl getUrlCopiedFrom() {
            return null;
        }

        public File getConflictNew() {
            return null;
        }

        public File getConflictOld() {
            return null;
        }

        public File getConflictWorking() {
            return null;
        }

        public String getLockOwner() {
            return null;
        }

        public Date getLockCreationDate() {
            return null;
        }

        public String getLockComment() {
            return null;
        }

        public SVNConflictDescriptor getConflictDescriptor() {
            return null;
        }

        public boolean hasTreeConflict() {
            return false;
        }

        public boolean isFileExternal() {
            return false;
        }
    }

    static class PathComparator
    implements Comparator<StorableObjectStatus> {
        PathComparator() {
        }

        @Override
        public int compare(StorableObjectStatus storableObjectStatus1, StorableObjectStatus storableObjectStatus2) {
            return storableObjectStatus2.getPathString().compareTo(storableObjectStatus1.getPathString());
        }
    }
}

