/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.io.File;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.swingui.ApplicationView;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;

public class MergeConflict {
    private File localFile;
    private String baseLabel;
    private String localLabel;
    private String repositoryLabel;
    private StorableObjectStatus storableObjectStatus;
    private VersioningTreeNode nodeForRefreshing;
    private String textStatus;
    private String propertyStatus;

    public MergeConflict(File localFile, String baseLabel, String localLabel, String repositoryLabel, String textStatus, String propertyStatus) {
        this.localFile = localFile;
        this.baseLabel = baseLabel;
        this.localLabel = localLabel;
        this.repositoryLabel = repositoryLabel;
        this.textStatus = textStatus;
        this.propertyStatus = propertyStatus;
    }

    public MergeConflict(SVNConflictDescription descr) {
        SVNMergeFileSet fs = descr.getMergeFiles();
        this.localFile = descr.getPath();
        String localPath = this.localFile.getPath();
        this.baseLabel = fs.getBaseLabel();
        if (this.baseLabel == null) {
            this.baseLabel = this.getLabel(localPath, fs.getBaseFile());
        }
        this.localLabel = fs.getLocalLabel();
        if (this.localLabel == null) {
            this.localLabel = this.getLabel(localPath, fs.getLocalFile());
        }
        this.repositoryLabel = fs.getRepositoryLabel();
        if (this.repositoryLabel == null) {
            this.repositoryLabel = this.getLabel(localPath, fs.getRepositoryFile());
        }
    }

    public MergeConflict(ISVNStatus status) {
        this.localFile = status.getFile();
        String localPath = this.localFile.getPath();
        this.baseLabel = this.getLabel(localPath, status.getConflictWorking());
        this.localLabel = this.getLabel(localPath, status.getConflictOld());
        this.repositoryLabel = this.getLabel(localPath, status.getConflictNew());
    }

    private String getLabel(String path, File suf) {
        String sufPath = suf.getPath();
        String res = sufPath.substring(path.length());
        return res;
    }

    public String getConflictType() {
        return "Merge";
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public String getBaseLabel() {
        return this.baseLabel;
    }

    public String getLocalLabel() {
        return this.localLabel;
    }

    public String getRepositoryLabel() {
        return this.repositoryLabel;
    }

    public StorableObjectStatus getStorableObjectStatus() {
        if (this.storableObjectStatus == null) {
            this.storableObjectStatus = new SVNStorableObjectStatus(ApplicationView.getInstance().getCurrentDesign(), this.localFile, this.textStatus, this.propertyStatus, null);
        }
        return this.storableObjectStatus;
    }

    public VersioningTreeNode getNodeForRefreshing() {
        if (this.nodeForRefreshing == null && this.storableObjectStatus != null) {
            this.nodeForRefreshing = new VersioningTreeNode(this.storableObjectStatus);
        }
        return this.nodeForRefreshing;
    }

    public void setNodeForRefreshing(VersioningTreeNode nodeForRefreshing) {
        this.nodeForRefreshing = nodeForRefreshing;
        this.storableObjectStatus = nodeForRefreshing.getStorableObjectStatus();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof MergeConflict && ((MergeConflict)obj).getLocalFile().equals(this.localFile);
    }
}

