/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ReportsPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TraversableContext;

public class ReportsPP
extends AbstractPP {
    private JPanel pnMain;
    private JTextField companyName;
    private JTextField defaultReportsPath;
    private JTextField defaultSaxonPath;
    private JCheckBox cbUsePageBreaks;

    public ReportsPP() {
        this.setHelpID("REPORTS_PANEL");
        this.pnMain = new JPanel(new GridBagLayout());
        this.initControls();
        this.add(this.pnMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        this.companyName.setText(settings.getReportsCompanyName());
        this.cbUsePageBreaks.setSelected(settings.isUsePageBreaksInReports());
        this.defaultReportsPath.setText(settings.getDefaultReportsPath());
        this.defaultSaxonPath.setText(settings.getDefaultSaxonPath());
        ReportsPP.validateDirectory(this.defaultReportsPath);
        ReportsPP.validateDirectory(this.defaultSaxonPath);
    }

    public void onExit(TraversableContext tc) {
        settings.setReportsCompanyName(this.companyName.getText());
        settings.setUsePageBreaksInReports(this.cbUsePageBreaks.isSelected());
        settings.setDefaultReportsPath(this.defaultReportsPath.getText());
        settings.setDefaultSaxonPath(this.defaultSaxonPath.getText());
        ReportsPreferences preferences = this.getReportsPreferences(tc);
        preferences.setCompanyName(this.companyName.getText());
        preferences.setUsePageBreaks(this.cbUsePageBreaks.isSelected());
        preferences.setDefaultReportsPath(this.defaultReportsPath.getText());
        preferences.setDefaultSaxonPath(this.defaultSaxonPath.getText());
    }

    private void initControls() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsPP.Options")));
        JLabel lblCompanyName = new JLabel(Messages.getString("ReportsPP.CompanyName"));
        this.companyName = new JTextField();
        this.cbUsePageBreaks = new JCheckBox(Messages.getString("ReportsPP.InsertPageBreaks"));
        this.addItem(optionsPanel, lblCompanyName, 0, 0, 1, 1, 17, 0, 1);
        this.addItem(optionsPanel, this.companyName, 1, 0, 1, 1, 17, 1, 1);
        this.addItem(optionsPanel, this.cbUsePageBreaks, 0, 1, 1, 1, 17, 0, 1);
        JPanel pathsPanel = new JPanel(new GridBagLayout());
        pathsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsPP.Paths")));
        JLabel lblDefaultReportsPath = new JLabel(Messages.getString("OptionsDialog.ReportsDirectory"));
        this.defaultReportsPath = new JTextField();
        this.defaultReportsPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ReportsPP.this.defaultReportsPath);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ReportsPP.this.defaultReportsPath);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ReportsPP.this.defaultReportsPath);
            }
        });
        JButton bnSelectDefaultReportsPath = new JButton(Messages.getString("OptionsDialog.Select"));
        bnSelectDefaultReportsPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ReportsPP.this.defaultReportsPath.getText()));
                fileChooser.setPathContext("dataModeler_Reports");
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ReportsPP.this.defaultReportsPath.setText(file.getAbsolutePath());
                }
            }
        });
        JLabel lblDefaultSaxonPath = new JLabel(Messages.getString("OptionsDialog.ReportsDirectorySaxonJarLabel"));
        this.defaultSaxonPath = new JTextField();
        this.defaultSaxonPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ReportsPP.this.defaultSaxonPath);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ReportsPP.this.defaultSaxonPath);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ReportsPP.this.defaultSaxonPath);
            }
        });
        JButton bnSelectS = new JButton(Messages.getString("OptionsDialog.Select"));
        bnSelectS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ReportsPP.this.defaultSaxonPath.getText()));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectSaxonJAR"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ReportsPP.this.defaultSaxonPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(pathsPanel, lblDefaultReportsPath, 0, 0, 1, 1, 17, 0, 1);
        this.addItem(pathsPanel, this.defaultReportsPath, 1, 0, 1, 1, 17, 1, 1);
        this.addItem(pathsPanel, bnSelectDefaultReportsPath, 2, 0, 1, 1, 17, 0, 1);
        this.addItem(pathsPanel, lblDefaultSaxonPath, 0, 1, 1, 1, 17, 0, 1);
        this.addItem(pathsPanel, this.defaultSaxonPath, 1, 1, 1, 1, 17, 1, 1);
        this.addItem(pathsPanel, bnSelectS, 2, 1, 1, 1, 17, 0, 1);
        this.addItem(this.pnMain, optionsPanel, 0, 0, 2, 1, 17, 1, 1);
        this.addItem(this.pnMain, pathsPanel, 0, 1, 2, 1, 17, 1, 1);
    }

    private ReportsPreferences getReportsPreferences(TraversableContext tc) {
        return ReportsPreferences.getInstance(tc.getPropertyStorage());
    }
}

