/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;

public class RSMaskTemplates
extends RSGeneral {
    public static void export(ApplicationView appView, Map map, Connection connection, Design design) throws Exception {
        String checkQuery = "SELECT Object_OVID FROM DMRS_MASK_TEMPLATES WHERE Object_ID = ? ";
        String insertQuery = "INSERT INTO DMRS_MASK_TEMPLATES (Object_OVID, Object_ID, Mask_Template_Name, Function_Type, Data_Type, Input_Format, Output_Format, Mask_Char, Mask_From, Mask_To, Pattern, Replace_String, Position, Occurrence, Match_Parameter, Month, Day, Year, Hour, Minute, Second, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String updateQuery = "UPDATE DMRS_MASK_TEMPLATES SET Mask_Template_Name = ?, Function_Type = ?, Data_Type = ?, Input_Format = ?, Output_Format = ?, Mask_Char = ?, Mask_From = ?, Mask_To = ?, Pattern = ?, Replace_String = ?, Position = ?, Occurrence = ?, Match_Parameter = ?, Month = ?, Day = ?, Year = ?, Hour = ?, Minute = ?, Second = ? WHERE Object_ID = ?";
        PreparedStatement stmtCheck = connection.prepareStatement(checkQuery);
        PreparedStatement insertStmt = connection.prepareStatement(insertQuery);
        PreparedStatement updateStmt = connection.prepareStatement(updateQuery);
        for (MaskTemplate mt : appView.getMaskTemplateSet()) {
            stmtCheck.setString(1, mt.getObjectID());
            ResultSet rsCheck = stmtCheck.executeQuery();
            String functionType = "";
            int ft = mt.getFunctionType();
            if (ft == 0) {
                functionType = "PARTIAL";
            } else if (ft == 1) {
                functionType = "REGEXP";
            }
            String dataType = "";
            int dt = mt.getDataType();
            if (dt == 0) {
                dataType = "Character";
            } else if (dt == 1) {
                dataType = "Numeric";
            } else if (dt == 2) {
                dataType = "Date";
            }
            if (rsCheck.next()) {
                String checkOvid = rsCheck.getString(1);
                map.put(mt.getObjectID(), checkOvid);
                updateStmt.setString(1, mt.getName());
                updateStmt.setString(2, functionType);
                updateStmt.setString(3, dataType);
                updateStmt.setString(4, mt.getInputFormat());
                updateStmt.setString(5, mt.getOutputFormat());
                updateStmt.setString(6, mt.getMaskChar());
                updateStmt.setInt(7, mt.getMaskFrom());
                updateStmt.setInt(8, mt.getMaskTo());
                updateStmt.setString(9, mt.getPattern());
                updateStmt.setString(10, mt.getReplaceString());
                updateStmt.setInt(11, mt.getPosition());
                updateStmt.setInt(12, mt.getOccurrence());
                updateStmt.setString(13, mt.getMatchParameter());
                updateStmt.setString(14, mt.getMonth());
                updateStmt.setString(15, mt.getDay());
                updateStmt.setString(16, mt.getYear());
                updateStmt.setString(17, mt.getHour());
                updateStmt.setString(18, mt.getMinute());
                updateStmt.setString(19, mt.getSecond());
                updateStmt.setString(20, mt.getObjectID());
                updateStmt.executeUpdate();
                continue;
            }
            String ovid = RSMaskTemplates.getOrCreateOVID(map, mt.getObjectID());
            map.put(mt.getObjectID(), ovid);
            insertStmt.setString(1, ovid);
            insertStmt.setString(2, mt.getObjectID());
            insertStmt.setString(3, mt.getName());
            insertStmt.setString(4, functionType);
            insertStmt.setString(5, dataType);
            insertStmt.setString(6, mt.getInputFormat());
            insertStmt.setString(7, mt.getOutputFormat());
            insertStmt.setString(8, mt.getMaskChar());
            insertStmt.setInt(9, mt.getMaskFrom());
            insertStmt.setInt(10, mt.getMaskTo());
            insertStmt.setString(11, mt.getPattern());
            insertStmt.setString(12, mt.getReplaceString());
            insertStmt.setInt(13, mt.getPosition());
            insertStmt.setInt(14, mt.getOccurrence());
            insertStmt.setString(15, mt.getMatchParameter());
            insertStmt.setString(16, mt.getMonth());
            insertStmt.setString(17, mt.getDay());
            insertStmt.setString(18, mt.getYear());
            insertStmt.setString(19, mt.getHour());
            insertStmt.setString(20, mt.getMinute());
            insertStmt.setString(21, mt.getSecond());
            insertStmt.setString(22, (String)map.get(design.getObjectID()));
            insertStmt.execute();
        }
        stmtCheck.close();
        stmtCheck = null;
        insertStmt.close();
        insertStmt = null;
        updateStmt.close();
        updateStmt = null;
    }
}

