/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TriggerUDBv81 trigger = (TriggerUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, trigger);
        this.appendCreate(buffer, trigger);
        this.appendTriggeringTime(buffer, trigger, prettyPrint);
        this.appendAction(buffer, trigger);
        this.appendOn(buffer, trigger);
        this.appendReferencing(buffer, trigger, prettyPrint);
        this.appendScope(buffer, trigger, prettyPrint);
        this.appendCondition(buffer, trigger, prettyPrint);
        this.appendTriggeredAction(buffer, trigger, prettyPrint);
        SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateTrigger();
        if (trigger.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, trigger, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, TriggerUDBv81 trigger, boolean prettyPrint) {
        String comments = trigger.getCommentInRDBMS().trim();
        if (!"".equals(comments)) {
            SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
            SSBTriggerUDBv81.appendStringWithSpace(buffer, "TRIGGER");
            SSBTriggerUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getLongNameDDL()));
            SSBTriggerUDBv81.appendStringWithSpace(buffer, "IS");
            SSBTriggerUDBv81.appendString(buffer, '\'');
            SSBTriggerUDBv81.appendString(buffer, comments);
            SSBTriggerUDBv81.appendStringWithSpace(buffer, '\'');
            SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    private void appendCreate(StringBuffer buffer, TriggerUDBv81 trigger) {
        this.appendCreate(buffer);
        SSBTriggerUDBv81.appendStringWithSpace(buffer, "TRIGGER");
        if (trigger.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBTriggerUDBv81.appendString(buffer, this.storageDesign.getFormatedName(trigger.getSchema().getName()));
            SSBTriggerUDBv81.appendString(buffer, ".");
        }
        SSBTriggerUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getName()));
    }

    private void appendTriggeringTime(StringBuffer buffer, TriggerUDBv81 trigger, boolean prettyPrint) {
        SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getTriggerTime());
    }

    private void appendAction(StringBuffer buffer, TriggerUDBv81 trigger) {
        SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getActions());
        if (trigger.getActions().equalsIgnoreCase(Trigger.ACTION_TYPES[1]) && !trigger.getColumns().equalsIgnoreCase("")) {
            SSBTriggerUDBv81.appendStringWithSpace(buffer, "OF");
            SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getColumns());
        }
    }

    private void appendOn(StringBuffer buffer, TriggerUDBv81 trigger) {
        SSBTriggerUDBv81.appendStringWithSpace(buffer, "ON");
        if (trigger.getTable() != null) {
            SSBTriggerUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getTable().getName()));
        } else {
            SSBTriggerUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getView().getName()));
        }
    }

    private void appendReferencing(StringBuffer buffer, TriggerUDBv81 trigger, boolean prettyPrint) {
        if (!(trigger.getRef_NEW_AS().equalsIgnoreCase("") && trigger.getRef_OLD_AS().equalsIgnoreCase("") && trigger.getNEW_TABLE_AS().equalsIgnoreCase("") && trigger.getOLD_TABLE_AS().equalsIgnoreCase(""))) {
            SSBTriggerUDBv81.appendStringWithSpace(buffer, "REFERENCING");
            if (!trigger.getRef_NEW_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerUDBv81.appendStringWithSpace(buffer, "NEW");
                SSBTriggerUDBv81.appendStringWithSpace(buffer, "AS");
                SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getRef_NEW_AS());
            }
            if (!trigger.getRef_OLD_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerUDBv81.appendStringWithSpace(buffer, "OLD");
                SSBTriggerUDBv81.appendStringWithSpace(buffer, "AS");
                SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getRef_OLD_AS());
            }
            if (!trigger.getOLD_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerUDBv81.appendStringWithSpace(buffer, "OLD TABLE");
                SSBTriggerUDBv81.appendStringWithSpace(buffer, "AS");
                SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getOLD_TABLE_AS());
            }
            if (!trigger.getNEW_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerUDBv81.appendStringWithSpace(buffer, "NEW TABLE");
                SSBTriggerUDBv81.appendStringWithSpace(buffer, "AS");
                SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getNEW_TABLE_AS());
            }
        }
    }

    private void appendScope(StringBuffer buffer, TriggerUDBv81 trigger, boolean prettyPrint) {
        SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getScope());
        if (trigger.isScopeForEachRow()) {
            this.appendMode(buffer);
        }
    }

    private void appendMode(StringBuffer buffer) {
        SSBTriggerUDBv81.appendStringWithSpace(buffer, "MODE DB2SQL");
    }

    private void appendCondition(StringBuffer buffer, TriggerUDBv81 trigger, boolean prettyPrint) {
        if (!trigger.getCondition().equalsIgnoreCase("")) {
            SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerUDBv81.appendStringWithSpace(buffer, "WHEN");
            SSBTriggerUDBv81.appendStringWithSpace(buffer, '(');
            SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getCondition());
            SSBTriggerUDBv81.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTriggeredAction(StringBuffer buffer, TriggerUDBv81 trigger, boolean prettyPrint) {
        SSBTriggerUDBv81.appendNewLine(buffer, prettyPrint, 1);
        if (trigger.getBody().equalsIgnoreCase("")) {
            SSBTriggerUDBv81.appendStringWithSpace(buffer, "-- Empty body");
        } else {
            SSBTriggerUDBv81.appendStringWithSpace(buffer, trigger.getBody());
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerUDBv81 && ((TriggerUDBv81)object).isMarkedGenerate() && (((TriggerUDBv81)object).getTable() != null || ((TriggerUDBv81)object).getView() != null);
    }
}

