/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;

public class SSBSchemaPrivilegesUDBv81
extends AbstractSSBUDB {
    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        PrivilegesUDB priv = (PrivilegesUDB)object;
        if (!(priv.getUser() == null && priv.getGroup() == null || "".equalsIgnoreCase(priv.getSystemPrivileges()))) {
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
            SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, "GRANT");
            SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, priv.getSystemPrivileges());
            SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, "ON");
            SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, "SCHEMA");
            SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, storageDesign.getFormatedName(priv.getSchema().getName()));
            SSBSchemaPrivilegesUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, "TO");
            if (priv.getUser() != null) {
                if (!priv.getUser().getName().equalsIgnoreCase("PUBLIC")) {
                    SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, "USER");
                }
                SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, storageDesign.getFormatedName(priv.getUser().getName()));
            } else {
                SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, "GROUP");
                SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, storageDesign.getFormatedName(priv.getGroup().getName()));
            }
            if ("YES".equalsIgnoreCase(priv.getGrantOption())) {
                SSBSchemaPrivilegesUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBSchemaPrivilegesUDBv81.appendStringWithSpace(buffer, "WITH GRANT OPTION");
            }
            SSBSchemaPrivilegesUDBv81.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBSchemaPrivilegesUDBv81.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof PrivilegesUDB;
    }
}

