/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.FunctionUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFunctionUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        FunctionUDB func = (FunctionUDB)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, func);
        this.appendCreate(buffer, func);
        this.appendBody(buffer, func, prettyPrint);
        SSBFunctionUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBFunctionUDBv81.appendLineFinisherUDB(buffer, prettyPrint);
        DDLFileMaker.incrementCreateFunction();
        if (func.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, func, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, FunctionUDB func, boolean prettyPrint) {
        SSBFunctionUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBFunctionUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
        SSBFunctionUDBv81.appendStringWithSpace(buffer, "FUNCTION");
        SSBFunctionUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(func.getLongNameDDL()));
        SSBFunctionUDBv81.appendStringWithSpace(buffer, "IS");
        SSBFunctionUDBv81.appendString(buffer, '\'');
        SSBFunctionUDBv81.appendString(buffer, func.getCommentInRDBMS());
        SSBFunctionUDBv81.appendStringWithSpace(buffer, '\'');
        SSBFunctionUDBv81.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendCreate(StringBuffer buffer, FunctionUDB func) {
        this.appendCreate(buffer);
        SSBFunctionUDBv81.appendStringWithSpace(buffer, "FUNCTION");
        if (func.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBFunctionUDBv81.appendString(buffer, this.storageDesign.getFormatedName(func.getSchema().getName()));
            SSBFunctionUDBv81.appendString(buffer, ".");
        }
        SSBFunctionUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(func.getName()));
    }

    private void appendBody(StringBuffer buffer, FunctionUDB func, boolean prettyPrint) {
        SSBFunctionUDBv81.appendNewLine(buffer, prettyPrint, 1);
        if (func.getBody() != null && !func.getBody().trim().equalsIgnoreCase("")) {
            SSBFunctionUDBv81.appendStringWithSpace(buffer, func.getBody());
        } else {
            SSBFunctionUDBv81.appendStringWithSpace(buffer, " -- Empty body");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof FunctionUDB && ((FunctionUDB)object).isMarkedGenerate();
    }
}

