/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.TriggerUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TriggerUDBv71 trigger = (TriggerUDBv71)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, trigger);
        this.appendCreate(buffer, trigger);
        this.appendTriggeringTime(buffer, trigger, prettyPrint);
        this.appendAction(buffer, trigger);
        this.appendOnTable(buffer, trigger);
        this.appendReferencing(buffer, trigger, prettyPrint);
        this.appendScope(buffer, trigger, prettyPrint);
        this.appendCondition(buffer, trigger, prettyPrint);
        this.appendTriggeredAction(buffer, trigger, prettyPrint);
        SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateTrigger();
        if (trigger.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, trigger, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, TriggerUDBv71 trigger, boolean prettyPrint) {
        String comments = trigger.getCommentInRDBMS().trim();
        if (!"".equals(comments)) {
            SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
            SSBTriggerUDBv71.appendStringWithSpace(buffer, "TRIGGER");
            SSBTriggerUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getLongNameDDL()));
            SSBTriggerUDBv71.appendStringWithSpace(buffer, "IS");
            SSBTriggerUDBv71.appendString(buffer, '\'');
            SSBTriggerUDBv71.appendString(buffer, comments);
            SSBTriggerUDBv71.appendStringWithSpace(buffer, '\'');
            SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    private void appendCreate(StringBuffer buffer, TriggerUDBv71 trigger) {
        this.appendCreate(buffer);
        SSBTriggerUDBv71.appendStringWithSpace(buffer, "TRIGGER");
        if (trigger.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBTriggerUDBv71.appendString(buffer, this.storageDesign.getFormatedName(trigger.getSchema().getName()));
            SSBTriggerUDBv71.appendString(buffer, ".");
        }
        SSBTriggerUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getName()));
    }

    private void appendTriggeringTime(StringBuffer buffer, TriggerUDBv71 trigger, boolean prettyPrint) {
        SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getTriggerTime());
    }

    private void appendAction(StringBuffer buffer, TriggerUDBv71 trigger) {
        SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getActions());
        if (trigger.getActions().equalsIgnoreCase(Trigger.ACTION_TYPES[1]) && !trigger.getColumns().equalsIgnoreCase("")) {
            SSBTriggerUDBv71.appendStringWithSpace(buffer, "OF");
            SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getColumns());
        }
    }

    private void appendOnTable(StringBuffer buffer, TriggerUDBv71 trigger) {
        SSBTriggerUDBv71.appendStringWithSpace(buffer, "ON");
        SSBTriggerUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getTable().getName()));
    }

    private void appendReferencing(StringBuffer buffer, TriggerUDBv71 trigger, boolean prettyPrint) {
        if (!(trigger.getRef_NEW_AS().equalsIgnoreCase("") && trigger.getRef_OLD_AS().equalsIgnoreCase("") && trigger.getNEW_TABLE_AS().equalsIgnoreCase("") && trigger.getOLD_TABLE_AS().equalsIgnoreCase(""))) {
            SSBTriggerUDBv71.appendStringWithSpace(buffer, "REFERENCING");
            if (!trigger.getRef_NEW_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerUDBv71.appendStringWithSpace(buffer, "NEW");
                SSBTriggerUDBv71.appendStringWithSpace(buffer, "AS");
                SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getRef_NEW_AS());
            }
            if (!trigger.getRef_OLD_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerUDBv71.appendStringWithSpace(buffer, "OLD");
                SSBTriggerUDBv71.appendStringWithSpace(buffer, "AS");
                SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getRef_OLD_AS());
            }
            if (!trigger.getOLD_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerUDBv71.appendStringWithSpace(buffer, "OLD TABLE");
                SSBTriggerUDBv71.appendStringWithSpace(buffer, "AS");
                SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getOLD_TABLE_AS());
            }
            if (!trigger.getNEW_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerUDBv71.appendStringWithSpace(buffer, "NEW TABLE");
                SSBTriggerUDBv71.appendStringWithSpace(buffer, "AS");
                SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getNEW_TABLE_AS());
            }
        }
    }

    private void appendScope(StringBuffer buffer, TriggerUDBv71 trigger, boolean prettyPrint) {
        SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getScope());
        if (trigger.isScopeForEachRow()) {
            this.appendMode(buffer);
        }
    }

    private void appendMode(StringBuffer buffer) {
        SSBTriggerUDBv71.appendStringWithSpace(buffer, "MODE DB2SQL");
    }

    private void appendCondition(StringBuffer buffer, TriggerUDBv71 trigger, boolean prettyPrint) {
        if (!trigger.getCondition().equalsIgnoreCase("")) {
            SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerUDBv71.appendStringWithSpace(buffer, "WHEN");
            SSBTriggerUDBv71.appendStringWithSpace(buffer, '(');
            SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getCondition());
            SSBTriggerUDBv71.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTriggeredAction(StringBuffer buffer, TriggerUDBv71 trigger, boolean prettyPrint) {
        SSBTriggerUDBv71.appendNewLine(buffer, prettyPrint, 1);
        if (trigger.getBody().equalsIgnoreCase("")) {
            SSBTriggerUDBv71.appendStringWithSpace(buffer, "-- Empty body");
        } else {
            SSBTriggerUDBv71.appendStringWithSpace(buffer, trigger.getBody());
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerUDBv71 && ((TriggerUDBv71)object).isMarkedGenerate() && ((TriggerUDB)object).getTable() != null;
    }
}

