/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.exports.ddl.udb.v71.SSBIndexProxyUDBv71;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.ColumnProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableProxyUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableProxyUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDBv71 storageDesign;
    private SSBIndexProxyUDBv71 ssbIndex = new SSBIndexProxyUDBv71();
    private static final String COMPACT = "COMPACT";
    private static final String LINK_TYPE_URL = "LINKTYPE URL";
    private static final String FILE_LINK_CONTROL = "FILE LINK CONTROL";
    private static final String INTEGRITY_ALL = "INTEGRITY ALL";
    private static final String READ_PERMISSION = "READ PERMISSION";
    private static final String WRITE_PERMISSION = "WRITE PERMISSION";
    private static final String ON_UNLINK = "ON UNLINK";
    private static final String INDEX_IN = "INDEX IN";
    private static final String LONG_IN = "LONG IN";
    private static final String PARTITIONING_KEY = "PARTITIONING KEY";
    private static final String USING_HASHING = "USING HASHING";
    private static final String NOT_LOGGED_INITIALLY = "NOT LOGGED INITIALLY";
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxyUDB;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Table table = null;
        TableProxyUDBv71 tableProxy = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
            tableProxy = (TableProxyUDBv71)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxyUDB) {
            tableProxy = (TableProxyUDBv71)object;
            table = (Table)tableProxy.getObject();
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
        }
        if (tableProxy != null && !tableProxy.isMarkedGenerate()) {
            this.appendIndexes(buffer, tableProxy, prettyPrint);
            return;
        }
        if (table != null) {
            if (table.isBST()) {
                if (!table.isRoot() && table.getBasedOnStructuredType().getElements().length == 0 || table.isRoot() && table.getBasedOnStructuredType().getAllElements().size() == 0) {
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "--  ERROR: Table " + table.getName() + " is based on structured type without attributes");
                    SSBTableProxyUDBv71.appendNewLine(buffer, true, 0);
                    DDLFileMaker.incrementErrors();
                    return;
                }
            } else if (table.getElementsCollection().size() == 0) {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "--  ERROR: Table " + table.getName() + " doesn't have columns");
                SSBTableProxyUDBv71.appendNewLine(buffer, true, 0);
                DDLFileMaker.incrementErrors();
                return;
            }
            if (tableProxy != null && tableProxy.isCommentChanged()) {
                this.appendComment(buffer, tableProxy);
            } else {
                this.appendComment(buffer, table);
            }
            if (tableProxy != null && tableProxy.getName().length() > tableProxy.getMaxNameLength()) {
                SSBTableProxyUDBv71.appendNewLine(buffer, true, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBTableProxyUDBv71.appendNewLine(buffer, true, 0);
                DDLFileMaker.incrementErrors();
            }
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendBeforeCreateScript(buffer, prettyPrint, table);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CREATE");
            if (tableProxy == null) {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "TABLE");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(table.getLongNameDDL()));
                this.appendColumns(buffer, table, null, prettyPrint);
            } else {
                if ("YES".equalsIgnoreCase(tableProxy.getSummaryQuery())) {
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "SUMMARY");
                }
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "TABLE");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
                if (table.isBST()) {
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "OF");
                    StructuredTypeProxyUDB stProxy = (StructuredTypeProxyUDB)this.storageDesign.getStructuredTypeProxySet().getProxy(table.getBasedOnStructuredType().getObjectID());
                    if (stProxy != null) {
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(stProxy.getName()));
                    } else {
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(table.getBasedOnStructuredType().getName()));
                    }
                    if (!table.isRoot() && table.isPartOfTypeSubstHierarchy()) {
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "UNDER");
                        TableProxyUDB superTableProxy = (TableProxyUDB)this.storageDesign.getTableProxySet().getProxy(table.getTypeSubstitution().getParentContainerObject().getObjectID());
                        if (superTableProxy != null) {
                            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(superTableProxy.getLongNameDDL()));
                        } else {
                            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(table.getTypeSubstitution().getParentContainerObject().getName()));
                        }
                        SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "INHERIT");
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "SELECT");
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "PRIVILEGES");
                    } else if (table.isRoot() && !"".equalsIgnoreCase(tableProxy.getHierarchyName())) {
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "HIERARCHY");
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getHierarchyName());
                    }
                    this.appendObjectTypeColProperties(buffer, table, tableProxy, prettyPrint);
                } else {
                    this.appendColumns(buffer, table, tableProxy, prettyPrint);
                    this.appendDataCapture(buffer, tableProxy, prettyPrint);
                    this.appendFederated(buffer, tableProxy, prettyPrint);
                    this.appendTableSpace(buffer, tableProxy, prettyPrint);
                    this.appendPartitioningKey(buffer, tableProxy, prettyPrint);
                    this.appendInitialLogging(buffer, tableProxy, prettyPrint);
                }
            }
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateTable();
            if (tableProxy != null) {
                this.appendColumnCheckConstraints(buffer, tableProxy, prettyPrint);
                SSBTableProxyUDBv71.appendExistenceDependencyConstraints(buffer, tableProxy, prettyPrint, this, String.valueOf(DB2_UDB_STATEMENT_TERMINATION_CHAR), 18);
                SSBTableProxyUDBv71.appendOptionalFKCheckConstraints(buffer, tableProxy, prettyPrint, this, String.valueOf(';'), 30);
                if (this.getArcConstrHandler() != null) {
                    this.getArcConstrHandler().appendArcConstraints(buffer, tableProxy, prettyPrint);
                }
                if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(buffer, table, tableProxy, prettyPrint);
                }
                this.appendIndexes(buffer, tableProxy, prettyPrint);
                if (table.getDesign().getAppView().getSettings().isGenerateTypeSubstTriggers()) {
                    this.appendInsertColumnSubstitutionTrigger(buffer, table, tableProxy, prettyPrint);
                    this.appendUpdateColumnSubstitutionTrigger(buffer, table, tableProxy, prettyPrint);
                }
            }
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendAfterCreateScript(buffer, prettyPrint, table);
        }
    }

    protected void appendOidColumnDefinition(StringBuffer buffer, Table table, TableProxyUDBv71 tableProxy, boolean prettyPrint) {
        ContainedObject oidColumn;
        if ((table.isRoot() || !table.isPartOfTypeSubstHierarchy()) && (oidColumn = table.getOidElement()) != null) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendString(buffer, '(');
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendString(buffer, ' ');
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "REF");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "IS");
            ColumnProxy columnProxy = (ColumnProxy)this.storageDesign.getColumnProxySet().getProxy(oidColumn.getObjectID());
            if (columnProxy != null) {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
            } else {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(oidColumn.getName()));
            }
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "USER");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "GENERATED");
            this.appendColumnConstraints(buffer, (Column)oidColumn, (ColumnProxyUDB)columnProxy);
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendString(buffer, ')');
        }
    }

    private void appendIndexes(StringBuffer buffer, TableProxyUDB tableProxy, boolean prettyPrint) {
        for (Object object : tableProxy.getIndexes()) {
            if (!this.ssbIndex.canHandle(object)) continue;
            this.ssbIndex.doAppend(buffer, object, prettyPrint);
        }
        this.appendIndexesForConstraints(buffer, (Table)tableProxy.getObject(), tableProxy);
    }

    private void appendPK(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        Index pk = (Index)((Table)tableProxy.getObject()).getPK();
        if (pk != null && pk.isMarkedGenerate()) {
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(tableProxy);
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendBeforeAlterScript(buffer, prettyPrint, pk.getTable());
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "ALTER");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "TABLE");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "ADD");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk.getName()));
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "PRIMARY KEY");
            Column[] columns = (Column[])pk.getElements();
            if (columns.length > 0) {
                SSBTableProxyUDBv71.appendString(buffer, '(');
                for (int i = 0; i < columns.length; ++i) {
                    if (i != 0) {
                        this.appendComma(buffer);
                        SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    }
                    SSBTableProxyUDBv71.appendString(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
                }
                SSBTableProxyUDBv71.appendString(buffer, ')');
            }
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(buffer, prettyPrint, pk.getTable());
        }
    }

    private void appendUK(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        Index[] indexes = (Index[])((Table)tableProxy.getObject()).getKeys();
        if (indexes.length > 0) {
            for (int i = 0; i < indexes.length; ++i) {
                Index index = indexes[i];
                if (!index.getIndexState().equalsIgnoreCase("Unique Constraint") || !index.isMarkedGenerate()) continue;
                this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(tableProxy);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendBeforeAlterScript(buffer, prettyPrint, index.getTable());
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "ALTER");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "TABLE");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "ADD");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getName()));
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "UNIQUE");
                Column[] columns = (Column[])index.getElements();
                if (columns.length > 0) {
                    SSBTableProxyUDBv71.appendString(buffer, '(');
                    for (int j = 0; j < columns.length; ++j) {
                        if (j != 0) {
                            this.appendComma(buffer);
                            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                        }
                        SSBTableProxyUDBv71.appendString(buffer, this.storageDesign.getFormatedName(columns[j].getName()));
                    }
                    SSBTableProxyUDBv71.appendString(buffer, ')');
                }
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(buffer, prettyPrint, index.getTable());
            }
        }
    }

    protected void appendColumns(StringBuffer buffer, Table table, TableProxyUDBv71 tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        ColumnProxyUDBv71 columnProxy = null;
        boolean first = true;
        if (tableProxy.getSummaryQuery().equalsIgnoreCase("NO")) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            if (columns.length < 1) {
                buffer.append("-- No columns");
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            } else {
                for (int i = 0; i < columns.length; ++i) {
                    if (i == 0) {
                        SSBTableProxyUDBv71.appendString(buffer, '(');
                    } else {
                        buffer.append(", ");
                    }
                    first = false;
                    SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    if (tableProxy != null) {
                        column = columns[i];
                        columnProxy = (ColumnProxyUDBv71)tableProxy.getColumnProxy(column.getObjectID());
                        if (columnProxy.getName().length() > columnProxy.getMaxNameLength()) {
                            SSBTableProxyUDBv71.appendNewLine(buffer, true, 0);
                            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
                            SSBTableProxyUDBv71.appendNewLine(buffer, true, 0);
                            DDLFileMaker.incrementErrors();
                        }
                        if (columnProxy.isCommentChanged() && !"".equalsIgnoreCase(columnProxy.getComment())) {
                            this.appendComment(buffer, columnProxy);
                        } else if (!"".equalsIgnoreCase(columnProxy.getObject().getComment())) {
                            this.appendComment(buffer, columnProxy.getObject());
                        }
                        this.appendColumnNameAndDataType(buffer, columnProxy, prettyPrint);
                        this.appendBitDataDefinition(buffer, columnProxy);
                        this.appendColumnScope(buffer, column, columnProxy, prettyPrint);
                        this.appendColumnNullsAllowed(buffer, columnProxy);
                        this.appendWithDefaultDefinition(buffer, columnProxy);
                        this.appendColumnLobOptions(buffer, columnProxy, prettyPrint);
                        this.appendColumnDatalinkOptions(buffer, columnProxy, prettyPrint);
                    }
                    if (column != null) {
                        this.appendColumnConstraints(buffer, column, columnProxy);
                    }
                    if (columnProxy == null) continue;
                    this.appendIdentityDefinition(buffer, columnProxy, prettyPrint);
                }
                this.appendTableConstraintsDefinition(buffer, table, prettyPrint, first);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableProxyUDBv71.appendString(buffer, ')');
            }
        } else {
            this.appendSummaryQuery(buffer, table, tableProxy, prettyPrint);
        }
    }

    private void appendSummaryQuery(StringBuffer buffer, Table table, TableProxyUDBv71 tableProxy, boolean prettyPrint) {
        if (tableProxy != null) {
            Column[] columns = (Column[])table.getElements();
            Column column = null;
            ColumnProxyUDBv71 columnProxy = null;
            if (columns.length > 0) {
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                for (int i = 0; i < columns.length; ++i) {
                    if (i == 0) {
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
                    } else {
                        this.appendComma(buffer);
                    }
                    SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    column = columns[i];
                    columnProxy = (ColumnProxyUDBv71)tableProxy.getColumnProxy(column.getObjectID());
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                }
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
            }
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "AS");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getSummaryQueryDefinition());
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
            if (tableProxy.getSummaryStatus().equalsIgnoreCase(TableProxyUDB.SUMMARY_STATUS_STATES[1])) {
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "DEFINITION");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "ONLY");
                this.appendCopyOptions(buffer, tableProxy, prettyPrint);
            } else {
                this.appendRefreshableTableOptions(buffer, tableProxy, prettyPrint);
            }
        }
    }

    private void appendRefreshableTableOptions(StringBuffer buffer, TableProxyUDBv71 tableProxy, boolean prettyPrint) {
        SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "DATA");
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "INITIALLY");
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "DEFERRED");
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "REFRESH");
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getSummaryRefreshOptions());
        SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getSummaryQueryOptimization());
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "QUERY");
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "OPTIMIZATION");
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "MAINTAINED");
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getSummaryMaintenance());
    }

    private void appendCopyOptions(StringBuffer buffer, TableProxyUDBv71 tableProxy, boolean prettyPrint) {
        SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        if (!"NONE".equalsIgnoreCase(tableProxy.getSummaryCopyColumnDefaults())) {
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getSummaryCopyColumnDefaults());
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "DEFAULTS");
        }
        SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getSummaryIdentityColumn());
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, "IDENTITY");
    }

    private void appendColumnNameAndDataType(StringBuffer buffer, ColumnProxyUDBv71 columnProxy, boolean prettyPrint) {
        SSBTableProxyUDBv71.appendString(buffer, ' ');
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
        String datatype = columnProxy.getDataTypeName();
        SSBTableProxyUDBv71.appendStringWithSpace(buffer, datatype);
        if (datatype.equalsIgnoreCase("unknown")) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 5);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyUDBv71 columnProxy) {
        String defaultValue = columnProxy.getDefaultValue();
        String defaultConstant = columnProxy.getDefaultValueConstant();
        boolean isDefault = columnProxy.getDefault();
        if (isDefault) {
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "WITH");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "DEFAULT");
            if (!"".equalsIgnoreCase(defaultValue)) {
                if (defaultValue.equalsIgnoreCase(ColumnProxyUDB.getDefaultValueChoices()[1])) {
                    if (!"".equalsIgnoreCase(defaultConstant)) {
                        String dt = columnProxy.getColumn().getDatatypeString("DB2/UDB 7.1");
                        String df = this.addQuotesToDefault(dt, defaultConstant);
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, df);
                    }
                } else if (defaultValue.equalsIgnoreCase(ColumnProxyUDB.getDefaultValueChoices()[4])) {
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, defaultConstant);
                } else {
                    String dt = columnProxy.getColumn().getDatatypeString("DB2/UDB 7.1");
                    String df = this.addQuotesToDefault(dt, defaultValue);
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, df);
                }
            }
        }
    }

    private void appendColumnNullsAllowed(StringBuffer buffer, ColumnProxyUDBv71 columnProxy) {
        if (!columnProxy.getNullsAllowed()) {
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "NOT NULL");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "NULL");
        }
    }

    private void appendColumnLobOptions(StringBuffer buffer, ColumnProxyUDBv71 columnProxy, boolean prettyPrint) {
        if (columnProxy.checkLobColumnTypes(columnProxy.getDataType())) {
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if (columnProxy.getLogging().equalsIgnoreCase("NOT LOGGED")) {
                    SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "NOT LOGGED");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "LOGGED");
                }
            }
            if (columnProxy.getCompact().equalsIgnoreCase("YES")) {
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, COMPACT);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "NOT");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, COMPACT);
            }
        }
    }

    private void appendColumnDatalinkOptions(StringBuffer buffer, ColumnProxyUDBv71 columnProxy, boolean prettyPrint) {
        if (columnProxy.checkDLColumnTypes(columnProxy.getColumn().getDataType("DB2/390 7"))) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, LINK_TYPE_URL);
            if (columnProxy.getLinkControl().equalsIgnoreCase("FILE")) {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, FILE_LINK_CONTROL);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, INTEGRITY_ALL);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, READ_PERMISSION);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, columnProxy.getReadPermission());
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, WRITE_PERMISSION);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, columnProxy.getWritePermission());
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "RECOVERY");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, columnProxy.getRecovery().toUpperCase());
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                if (!columnProxy.getWritePermission().equalsIgnoreCase("FS")) {
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, ON_UNLINK);
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, columnProxy.getOnUnlink());
                }
            }
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer buffer, Table table, boolean prettyPrint, boolean first) {
        if (table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            Iterator it = table.getCheckConstraints().iterator();
            boolean lfirst = true;
            while (it.hasNext()) {
                TableLevelConstraint constraint = (TableLevelConstraint)it.next();
                if (!first || !lfirst) {
                    this.appendComma(buffer);
                }
                lfirst = false;
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableProxyUDBv71.appendString(buffer, ' ');
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(constraint.getName()));
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CHECK");
                SSBTableProxyUDBv71.appendString(buffer, '(');
                SSBTableProxyUDBv71.appendString(buffer, constraint.getRule());
                SSBTableProxyUDBv71.appendString(buffer, ')');
            }
        }
    }

    private void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxyUDB columnProxy) {
        String text;
        if (column.hasConstraintsDefinedForDDL() && !"".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName())))) {
            String cname = column.getConstraintName();
            if (column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                if (!cname.equals("") && cname.length() <= 18) {
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                }
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CHECK");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, text);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendDataCapture(StringBuffer buffer, TableProxyUDB tableProxy, boolean prettyPrint) {
        if (!"NONE".equalsIgnoreCase(tableProxy.getDataCapture())) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "DATA CAPTURE");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getDataCapture());
        }
    }

    protected void appendFederated(StringBuffer buffer, TableProxyUDB tableProxy, boolean prettyPrint) {
        if (!"NONE".equalsIgnoreCase(tableProxy.getFederated())) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getFederated());
        }
    }

    protected void appendTableSpace(StringBuffer buffer, TableProxyUDBv71 tableProxy, boolean prettyPrint) {
        if (tableProxy.getTableSpace() != null && !tableProxy.getTableSpace().getDBDefOnly()) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "IN");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getTableSpace().getLongNameDDL()));
            this.appendTableSpaceOptions(buffer, tableProxy);
        }
    }

    protected void appendTableSpaceOptions(StringBuffer buffer, TableProxyUDBv71 tableProxy) {
        if (tableProxy.getIndexInTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, INDEX_IN);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getIndexInTableSpace().getLongNameDDL()));
        }
        if (tableProxy.getLongInTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, LONG_IN);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongInTableSpace().getLongNameDDL()));
        }
    }

    protected void appendPartitioningKey(StringBuffer buffer, TableProxyUDBv71 tableProxy, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(tableProxy.getPartitioningKey()) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, PARTITIONING_KEY);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, tableProxy.getPartitioningKey());
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
            if (tableProxy.getPartKeyHashing()) {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, USING_HASHING);
            }
        }
    }

    protected void appendInitialLogging(StringBuffer buffer, TableProxyUDBv71 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getInitialLogging() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, NOT_LOGGED_INITIALLY);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        ColumnProxy[] colProxies = tableProxy.getColumnProxies();
        for (int i = 0; i < colProxies.length; ++i) {
            String text;
            ColumnProxy columnProxy = colProxies[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefinedForDDL() || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC() || "".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName())))) continue;
            String cname = column.getConstraintName();
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "ALTER");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "TABLE");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(cname) && cname.length() <= 18) {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
            }
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CHECK");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, text);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        Table table = (Table)tableProxy.getObject();
        if (!table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            for (TableLevelConstraint constraint : table.getCheckConstraints()) {
                String text = constraint.getRule();
                if ("".equals(text)) continue;
                String cname = constraint.getName();
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "ALTER");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "TABLE");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "ADD");
                if (!"".equals(cname) && cname.length() <= 18) {
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                }
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CHECK");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, text);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    protected void appendTableCommentOn(StringBuffer buffer, Table table, TableProxyUDB tableProxy, boolean prettyPrint) {
        block6: {
            block5: {
                if (tableProxy == null) break block5;
                this.appendCommentOn(buffer, tableProxy, prettyPrint);
                ColumnProxy[] columnProxies = tableProxy.getColumnProxies();
                ColumnProxy col = null;
                for (int i = 0; i < columnProxies.length; ++i) {
                    String name;
                    col = columnProxies[i];
                    String comment = "";
                    if (col.getCommentInRDBMS() != null && col.isCommentInRDBMSChanged()) {
                        comment = col.getCommentInRDBMS();
                        name = col.getLongName();
                    } else {
                        comment = col.getObject().getCommentInRDBMS();
                        name = ((Column)col.getObject()).getLongName();
                    }
                    if (comment.equalsIgnoreCase("")) continue;
                    SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "COLUMN");
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(name));
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "IS");
                    SSBTableProxyUDBv71.appendString(buffer, '\'');
                    SSBTableProxyUDBv71.appendString(buffer, comment);
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, '\'');
                    SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                }
                break block6;
            }
            if (table == null) break block6;
            if (table.getCommentInRDBMS() != null && !"".equalsIgnoreCase(table.getCommentInRDBMS())) {
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "TABLE");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(table.getLongNameDDL()));
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "IS");
                SSBTableProxyUDBv71.appendString(buffer, '\'');
                SSBTableProxyUDBv71.appendString(buffer, table.getCommentInRDBMS());
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, '\'');
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
            }
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column col = (Column)columns[i];
                if (col.getCommentInRDBMS() == null || "".equalsIgnoreCase(col.getCommentInRDBMS())) continue;
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "COLUMN");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(col.getLongName()));
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "IS");
                SSBTableProxyUDBv71.appendString(buffer, '\'');
                SSBTableProxyUDBv71.appendString(buffer, col.getCommentInRDBMS());
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, '\'');
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
            }
        }
    }

    protected void appendIdentityDefinition(StringBuffer buffer, ColumnProxyUDB columnProxy, boolean prettyPrint) {
        if (columnProxy.getUseIdentity()) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "GENERATED");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, columnProxy.getGenerate());
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "AS");
            if (!"".equalsIgnoreCase(columnProxy.getGenerationExpression().trim())) {
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, columnProxy.getGenerationExpression());
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
            } else {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "IDENTITY");
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "START");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "WITH");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, columnProxy.getStartWith());
                this.appendComma(buffer);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "INCREMENT");
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "BY");
                this.appendStringWithSpace(buffer, columnProxy.getIncrementBy());
                this.appendComma(buffer);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                if ("NO".equalsIgnoreCase(columnProxy.getCache())) {
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "NO");
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CACHE");
                } else {
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CACHE");
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, columnProxy.getCache());
                }
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendObjectTypeColProperties(StringBuffer buffer, Table table, TableProxyUDB tableProxy, boolean prettyPrint) {
        if (table.isBST() && tableProxy != null) {
            ColumnProxy columnProxy;
            ArrayList cols;
            boolean generate = false;
            if (table.isRoot()) {
                generate = true;
                cols = new ArrayList(table.getElementsCollection());
            } else {
                cols = table.getElementsByStructuredType(table.getBasedOnStructuredType());
            }
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0 || table.getCheckConstraints().size() > 0) {
                generate = true;
            }
            if (!generate) {
                Column column;
                for (int i = 0; i < cols.size() && !(generate = this.shouldGenerateObjectPropDefinition(column = (Column)cols.get(i), (ColumnProxyUDB)(columnProxy = (ColumnProxyUDB)tableProxy.getColumnProxy(column.getObjectID())))); ++i) {
                }
            }
            if (generate) {
                ContainedObject oidColumn;
                boolean first = true;
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
                for (int i = 0; i < cols.size(); ++i) {
                    ColumnProxyUDB columnProxy2;
                    Column column = (Column)cols.get(i);
                    if (!this.shouldGenerateObjectPropDefinition(column, columnProxy2 = (ColumnProxyUDB)tableProxy.getColumnProxy(column.getObjectID()))) continue;
                    if (!first) {
                        this.appendComma(buffer);
                    } else {
                        first = false;
                    }
                    SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy2.getName()) + ' ' + "WITH OPTIONS ");
                    this.appendColumnNullsAllowed(buffer, (ColumnProxyUDBv71)columnProxy2);
                    this.appendColumnScope(buffer, column, columnProxy2, prettyPrint);
                    this.appendColumnConstraints(buffer, column, columnProxy2);
                }
                if (table.getCheckConstraints().size() > 0) {
                    if (!first) {
                        this.appendComma(buffer);
                    } else {
                        first = false;
                    }
                    this.appendTableConstraintsDefinition(buffer, table, prettyPrint, first);
                }
                if (table.isOidIsPK() && table.isRoot()) {
                    if (!first) {
                        this.appendComma(buffer);
                    } else {
                        first = false;
                    }
                    this.appendPK_ObjectType(buffer, table, tableProxy, prettyPrint, table.getOidPKColumns().size() == 0);
                }
                if (table.isRoot() && (oidColumn = table.getOidElement()) != null) {
                    if (!first) {
                        this.appendComma(buffer);
                    } else {
                        first = false;
                    }
                    SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "REF");
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "IS");
                    columnProxy = (ColumnProxy)this.storageDesign.getColumnProxySet().getProxy(oidColumn.getObjectID());
                    if (columnProxy != null) {
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                    } else {
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(oidColumn.getName()));
                    }
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "USER");
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, "GENERATED");
                }
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyUDB columnProxy) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String defaultValue = columnProxy.getDefaultValue();
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            return true;
        }
        if (column.getScope() != null) {
            return true;
        }
        if (!column.getAVTs().isEmpty()) {
            return true;
        }
        ConstraintEnumeration valueList = column.getValueList();
        if (valueList != null && !valueList.isEmpty()) {
            return true;
        }
        CheckConstraint check = column.getCheck();
        return check != null;
    }

    private void appendPK_ObjectType(StringBuffer buffer, Table table, TableProxy tableProxy, boolean prettyPrint, boolean oidpk) {
        String name = tableProxy.getPKName();
        if (!"".equals(name)) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(name));
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "PRIMARY KEY");
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, '(');
            if (oidpk) {
                ContainedObject oidColumn = table.getOidElement();
                ColumnProxy columnProxy = tableProxy.getColumnProxy(oidColumn.getObjectID());
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
            } else {
                boolean first = true;
                for (Column column : table.getOidPKColumns()) {
                    String cname = column.getName();
                    ColumnProxy columnProxy = tableProxy.getColumnProxy(column.getObjectID());
                    if (columnProxy != null) {
                        cname = columnProxy.getName();
                    }
                    if (first) {
                        SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                        first = false;
                        continue;
                    }
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, ',');
                    SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                }
            }
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendColumnScope(StringBuffer buffer, Column column, ColumnProxy columnProxy, boolean prettyPrint) {
        if (column.getScope() != null) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 2);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "SCOPE");
            TableProxy tp = (TableProxy)this.storageDesign.getStorageObject(column.getScope().getObjectID());
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tp.getLongNameDDL()));
        }
    }

    private void appendInsertColumnSubstitutionTrigger(StringBuffer buffer, Table table, TableProxy tableProxy, boolean prettyPrint) {
        List columns = this.getColumnsWithRestrictedSubType(table);
        if (columns.size() > 0) {
            boolean first = true;
            String colnames = "";
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                ColumnProxy cp = tableProxy.getColumnProxy(column.getObjectID());
                String colname = this.storageDesign.getFormatedName(cp == null ? column.getName() : cp.getName());
                names.add(colname);
                if (first) {
                    colnames = colname;
                    first = false;
                    continue;
                }
                colnames = colnames + ", " + colname;
            }
            if (!"".equals(colnames)) {
                String tr_name = this.storageDesign.getFormatedName(COLUMN_INS_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxy.getName(), 18 - COLUMN_INS_SUBST_TR_PREFIX.length()));
                if (tableProxy.getUserSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    tr_name = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + tr_name;
                }
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CREATE TRIGGER " + tr_name);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "NO CASCADE BEFORE INSERT ON " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "REFERENCING NEW AS N");
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "FOR EACH ROW MODE DB2SQL");
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "BEGIN ATOMIC");
                this.appendCWDColumnMeta(buffer, columns, prettyPrint);
                this.appendTriggerConditions(buffer, columns, names, prettyPrint);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "END");
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    private void appendUpdateColumnSubstitutionTrigger(StringBuffer buffer, Table table, TableProxy tableProxy, boolean prettyPrint) {
        List columns = this.getColumnsWithRestrictedSubType(table);
        if (columns.size() > 0) {
            boolean first = true;
            String colnames = "";
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                ColumnProxy cp = tableProxy.getColumnProxy(column.getObjectID());
                String colname = this.storageDesign.getFormatedName(cp == null ? column.getName() : cp.getName());
                names.add(colname);
                if (first) {
                    colnames = colname;
                    first = false;
                    continue;
                }
                colnames = colnames + ", " + colname;
            }
            if (!"".equals(colnames)) {
                String tr_name = this.storageDesign.getFormatedName(COLUMN_UPD_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxy.getName(), 18 - COLUMN_UPD_SUBST_TR_PREFIX.length()));
                if (tableProxy.getUserSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    tr_name = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + tr_name;
                }
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "CREATE TRIGGER " + tr_name);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "NO CASCADE BEFORE UPDATE OF " + colnames + " ON " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "REFERENCING NEW AS N");
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "FOR EACH ROW MODE DB2SQL");
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "BEGIN ATOMIC");
                this.appendCWDColumnMeta(buffer, columns, prettyPrint);
                this.appendTriggerConditions(buffer, columns, names, prettyPrint);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "END");
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    private void appendTriggerConditions(StringBuffer buffer, List columns, List names, boolean prettyPrint) {
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            String colname = (String)names.get(i);
            String types = "";
            if (column.isAllowSubtypeSubstitution()) {
                Iterator it = column.getPermittedSubTypes().iterator();
                boolean first = true;
                while (it.hasNext()) {
                    StructuredType st = (StructuredType)it.next();
                    StructuredTypeProxy stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                    if (stp == null || !st.isInstantiable()) continue;
                    if (first) {
                        types = "ONLY " + this.storageDesign.getFormatedName(stp.getLongNameDDL());
                        first = false;
                        continue;
                    }
                    types = types + ", " + "ONLY" + " " + this.storageDesign.getFormatedName(stp.getLongNameDDL());
                }
            } else {
                StructuredType st = (StructuredType)column.getDataType();
                StructuredTypeProxy stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                if (stp != null) {
                    types = "ONLY " + this.storageDesign.getFormatedName(stp.getLongNameDDL());
                }
            }
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            if (column.isReference()) {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, " IF deref(N." + colname + ") IS NOT OF ( " + types + " ) THEN");
            } else {
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, " IF N." + colname + " IS NOT OF ( " + types + " ) THEN");
            }
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "  signal SQLSTATE '85000' ('Column " + colname + " - Only " + types.replaceAll("ONLY ", "") + " are permitted');");
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, " END IF;");
        }
    }

    private void appendCWDColumnMeta(StringBuffer buffer, List columns, boolean prettyPrint) {
        if (columns.size() > 0) {
            SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(buffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            for (StructuredType st : column.getPermittedSubTypes()) {
                StructuredTypeProxy stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                String name = st.getName();
                if (stp != null) {
                    name = stp.getLongNameDDL();
                }
                SSBTableProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(buffer, "-- <cwd_ts_column column=\"" + column.getName() + "\" type=\"" + name + "\" />");
            }
        }
    }

    private void appendIndexesForConstraints(StringBuffer oldbuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keys = table.getKeys();
        boolean genPK = table.getDesign().getDesignLevelSettings().isAutomaticPKGeneration();
        boolean genUK = table.getDesign().getDesignLevelSettings().isAutomaticUKGeneration();
        boolean genFK = table.getDesign().getDesignLevelSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keys.length; ++i) {
            Index ind;
            ContainedObject[] cols;
            Index index = (Index)keys[i];
            if (!(genPK && "Primary Constraint".equals(index.getIndexState()) || genUK && "Unique Constraint".equals(index.getIndexState())) && (!index.isFK() || !genFK) || (cols = index.getElements()).length <= 0 || (ind = this.getIndexForColumns(table, index, cols, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(oldbuffer, index, tableProxy, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] cols, boolean ascending) {
        Object[] inds = table.getIndexes().toArray();
        for (int i = 0; i < inds.length; ++i) {
            DesignObjectPlaceHolder dph = (DesignObjectPlaceHolder)inds[i];
            Index ind = (Index)dph.getDesignObject();
            ContainedObject[] icols = ind.getElements();
            if (cols.length != icols.length) continue;
            boolean brflag = false;
            for (int j = 0; j < cols.length; ++j) {
                String so;
                if (cols[j] != icols[j]) {
                    brflag = true;
                    break;
                }
                if (!ascending || "ASC".equalsIgnoreCase(so = ind.getColumnSortOrder(icols[j]).trim()) || "".equalsIgnoreCase(so)) continue;
                brflag = true;
                break;
            }
            if (brflag || ind == index) continue;
            return ind;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }

    @Override
    public String appendConstraints(TableProxy tableProxy) {
        StringBuffer sb = new StringBuffer();
        if (tableProxy != null && tableProxy instanceof TableProxyUDBv71) {
            Table table = (Table)tableProxy.getObject();
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignUDBv71)tableProxy.getStorageDesign();
            }
            if (!table.isBST() || table.isRoot()) {
                this.appendPK(sb, tableProxy, true);
            }
            this.appendUK(sb, tableProxy, true);
            this.appendTableCheckConstraints(sb, tableProxy, true);
        }
        return sb.toString();
    }
}

