/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.IndexProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexProxyUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDBv71 storageDesign;
    private static final String PCTFREE = "PCTFREE";
    private static final String MINPCTUSED = "MINPCTUSED";
    private static final String REVERSE_SCAN = "REVERSE SCANS";
    private static final String CLUSTER = "CLUSTER";
    private static final String UNIQUE = "UNIQUE";
    private static final String INCLUDE = "INCLUDE";

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxyUDBv71 && ((IndexProxyUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Index index = null;
        IndexProxyUDBv71 indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
            indexProxy = (IndexProxyUDBv71)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyUDBv71) {
            indexProxy = (IndexProxyUDBv71)object;
            index = (Index)indexProxy.getObject();
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
        }
        if (indexProxy != null) {
            if (indexProxy.isCommentChanged()) {
                this.appendComment(buffer, indexProxy);
            } else {
                this.appendComment(buffer, indexProxy.getObject());
            }
            this.appendCreate(buffer, indexProxy);
            this.appendOnTable(buffer, indexProxy, prettyPrint);
            this.appendInclude(buffer, indexProxy, prettyPrint);
            this.appendCluster(buffer, indexProxy, prettyPrint);
            this.appendPctfree(buffer, indexProxy, prettyPrint);
            this.appendMinPctfree(buffer, indexProxy, prettyPrint);
            this.appendReverseScan(buffer, indexProxy, prettyPrint);
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateIndex();
            if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
            }
            this.appendPrivileges(buffer, indexProxy, prettyPrint);
        } else if (index != null && index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
        }
    }

    private void appendIndexComment(StringBuffer buffer, Index index, IndexProxyUDBv71 indexProxy, boolean prettyPrint) {
        if (indexProxy != null && indexProxy.isCommentInRDBMSChanged()) {
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "INDEX");
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getLongNameDDL()));
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "IS");
            SSBIndexProxyUDBv71.appendString(buffer, '\'');
            SSBIndexProxyUDBv71.appendString(buffer, indexProxy.getCommentInRDBMS());
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, '\'');
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
        } else if (index != null && !"".equalsIgnoreCase(index.getCommentInRDBMS().trim())) {
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "INDEX");
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getLongNameDDL()));
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "IS");
            SSBIndexProxyUDBv71.appendString(buffer, '\'');
            SSBIndexProxyUDBv71.appendString(buffer, index.getCommentInRDBMS());
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, '\'');
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    protected void appendCreate(StringBuffer buffer, IndexProxyUDBv71 indexProxy) {
        this.appendCreate(buffer);
        if (indexProxy.isUnique()) {
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, UNIQUE);
        }
        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "INDEX");
        SSBIndexProxyUDBv71.appendString(buffer, this.storageDesign.getFormatedName(indexProxy.getLongNameDDL()));
    }

    protected void appendOnTable(StringBuffer buffer, IndexProxyUDBv71 indexProxy, boolean prettyPrint) {
        ColumnProxy[] columns;
        SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "ON");
        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableProxy().getLongNameDDL()));
        SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, '(');
        SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
        if (indexProxy.getIndex().hasIndexExpression()) {
            SSBIndexProxyUDBv71.appendString(buffer, "     ");
            SSBIndexProxyUDBv71.appendString(buffer, indexProxy.getIndex().getIndexExpression());
        }
        if ((columns = indexProxy.getColumnProxies()) != null) {
            for (int i = 0; i < columns.length; ++i) {
                SSBIndexProxyUDBv71.appendString(buffer, "     ");
                SSBIndexProxyUDBv71.appendString(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
                SSBIndexProxyUDBv71.appendString(buffer, " ");
                SSBIndexProxyUDBv71.appendString(buffer, indexProxy.getIndex().getColumnSortOrder(columns[i].getColumn()));
                SSBIndexProxyUDBv71.appendString(buffer, " ");
                if (i >= columns.length - 1) continue;
                SSBIndexProxyUDBv71.appendString(buffer, ",\n");
            }
        }
        SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, ')');
    }

    protected void appendInclude(StringBuffer buffer, IndexProxyUDBv71 indexProxy, boolean prettyPrint) {
        if (indexProxy.isUnique() && !indexProxy.getColumnList().equalsIgnoreCase("")) {
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, INCLUDE);
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, '(');
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, indexProxy.getColumnList());
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendCluster(StringBuffer buffer, IndexProxyUDBv71 indexProxy, boolean prettyPrint) {
        if (indexProxy.getCluster() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, CLUSTER);
        }
    }

    protected void appendPctfree(StringBuffer buffer, IndexProxyUDBv71 indexProxy, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL() && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
            if (indexProxy.getPercentageFree() > 0) {
                SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexProxyUDBv71.appendStringWithSpace(buffer, PCTFREE);
                this.appendStringWithSpace(buffer, indexProxy.getPercentageFree());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexProxyUDBv71.appendStringWithSpace(buffer, PCTFREE);
                SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "10");
            }
        }
    }

    protected void appendMinPctfree(StringBuffer buffer, IndexProxyUDBv71 indexProxy, boolean prettyPrint) {
        if (indexProxy.getMinimumPercentageUsed() > 0 && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL() && this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, MINPCTUSED);
            this.appendStringWithSpace(buffer, indexProxy.getMinimumPercentageUsed());
        }
    }

    protected void appendReverseScan(StringBuffer buffer, IndexProxyUDBv71 indexProxy, boolean prettyPrint) {
        SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        this.appendAllowDisallowWithSpace(buffer, indexProxy.getReverseScanSupport());
        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, REVERSE_SCAN);
    }

    private void appendPrivileges(StringBuffer buffer, IndexProxyUDB index, boolean prettyPrint) {
        if (!index.getUsers().equalsIgnoreCase("") || !index.getGroups().equalsIgnoreCase("")) {
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "GRANT");
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "CONTROL");
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "ON");
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "INDEX");
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getName()));
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "TO");
            if (!index.getUsers().equalsIgnoreCase("")) {
                int i;
                for (i = 0; i < index.getUserSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(buffer);
                    }
                    if (!((String)index.getUserSet().elementAt(i)).trim().equalsIgnoreCase("PUBLIC")) {
                        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "USER");
                    }
                    this.appendStringWithSpace(buffer, index.getUserSet().elementAt(i));
                }
                if (!index.getGroups().equalsIgnoreCase("")) {
                    for (i = 0; i < index.getUserGroupSet().size(); ++i) {
                        this.appendComma(buffer);
                        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "GROUP");
                        this.appendStringWithSpace(buffer, index.getUserGroupSet().elementAt(i));
                    }
                }
            } else {
                for (int i = 0; i < index.getUserGroupSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(buffer);
                    }
                    SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "GROUP");
                    this.appendStringWithSpace(buffer, index.getUserGroupSet().elementAt(i));
                }
            }
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    public void appendIndexForConstraint(StringBuffer oldbuffer, Index object, TableProxy tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Index index = null;
        IndexProxy indexProxy = null;
        index = object;
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        if (index.isFK()) {
            indexProxy = (IndexProxy)storageDesign.getFKProxySet().getProxy(index.getObjectID());
        }
        if (index != null && !index.isOidKey()) {
            this.storageDesign = (StorageDesignUDBv71)tableProxy.getStorageDesign();
            if (indexProxy != null && indexProxy.isMarkedGenerate() || indexProxy == null && index.isMarkedGenerate()) {
                if (index.getElements().length > 0) {
                    if (indexProxy != null && indexProxy.isCommentChanged()) {
                        this.appendComment(oldbuffer, indexProxy);
                    } else {
                        this.appendComment(oldbuffer, index);
                    }
                    TableProxy tp = tableProxy;
                    String indName = index.getName();
                    if (indexProxy != null) {
                        indName = indexProxy.getName();
                    }
                    String lname = indName = ApplyNamingStandards.createIndexNameAuto(tp.getName(), indName, index, index.getDesign().getDesignLevelSettings().getNamingStandardRule(), index.getDesignPart().getName(), index.getTable().getAbbreviation());
                    int l = 18;
                    if (indexProxy != null) {
                        l = indexProxy.getMaxNameLength();
                    }
                    if (indName.length() > l) {
                        SSBIndexProxyUDBv71.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBIndexProxyUDBv71.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + l + ")");
                        SSBIndexProxyUDBv71.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "CREATE");
                    if ("Primary Constraint".equals(index.getIndexState()) || "Unique Constraint".equals(index.getIndexState())) {
                        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, UNIQUE);
                    }
                    SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "INDEX");
                    SSBIndexProxyUDBv71.appendStringWithSpace(buffer, storageDesign.getFormatedName(lname));
                    advancedComment = buffer.toString();
                    this.appendTable(buffer, index, true);
                    this.appendConstraintElementList(buffer, index, tableProxy, true);
                    SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexProxyUDBv71.appendNewLine(oldbuffer, prettyPrint, 0);
                    oldbuffer.append("-- Error - Index ");
                    oldbuffer.append(storageDesign.getFormatedName(index.getName()));
                    oldbuffer.append(" has no columns");
                    SSBIndexProxyUDBv71.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer buffer, Index index, TableProxy tableProxy, boolean prettyPrint) {
        ColumnProxy column = null;
        ArrayList<ColumnProxy> list = new ArrayList<ColumnProxy>();
        for (Column col : index.getElementsCollectionImmutable()) {
            ColumnProxy cp = tableProxy.getColumnProxy(col.getObjectID());
            if (cp == null) continue;
            list.add(cp);
        }
        Object[] columns = list.toArray();
        SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "-- No Columns");
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, '(');
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                SSBIndexProxyUDBv71.appendStringWithSpace(buffer, ',');
            }
            column = (ColumnProxy)columns[i];
            SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv71.appendString(buffer, ' ');
            String columnName = this.storageDesign.getFormatedName(column.getName());
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, columnName);
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
        }
        SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexProxyUDBv71.appendStringWithSpace(buffer, ')');
    }

    protected void appendTable(StringBuffer buffer, Index index, boolean prettyPrint) {
        Table table = (Table)index.getTopLevelContainer();
        TableProxy tp = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        SSBIndexProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
        if (tp != null) {
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, "ON");
            SSBIndexProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tp.getLongNameDDL()));
        }
    }
}

