/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.oracle.SSBNoneTransferableFKOracle;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBNoneTransferableFK_UDB
extends AbstractSSBDB2 {
    private StorageDesign storageDesign;
    int arc_index = 0;

    public SSBNoneTransferableFK_UDB(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxy;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        TableProxy tableProxy = (TableProxy)object;
        Table table = (Table)tableProxy.getObject();
        if (table.getDesign().getAppView().getSettings().isGenerateFKNoneTransferableTriggers()) {
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            List columns = SSBNoneTransferableFKOracle.getColumnsInOptionalFK(table);
            if (table != null && columns.size() > 0) {
                advancedComment = "create Arc constraint INSERT trigger for table " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL());
                if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                    SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                }
                this.appendFKNoneTransferableOptionalTrigger(buffer, tableProxy, columns, true);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if ((columns = SSBNoneTransferableFKOracle.getColumnsInMandatoryFK(table)).size() > 0) {
                buffer = new StringBuffer();
                advancedComment = "create Non Transferable FK constraint UPDATE trigger for table " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL());
                if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                    SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                    SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                }
                this.appendFKNoneTransferableMandatoryTrigger(buffer, tableProxy, columns, true);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
        }
    }

    private void appendFKNoneTransferableOptionalTrigger(StringBuffer buffer, TableProxy tableProxy, List columns, boolean prettyPrint) {
        String tr_name = this.makeTriggerName(tableProxy, "O");
        String cols = "";
        boolean first = true;
        for (Column column : columns) {
            String columnName = this.storageDesign.getFormatedName(column.getName());
            if (first) {
                cols = columnName;
                first = false;
                continue;
            }
            cols = cols + "," + columnName;
        }
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "CREATE TRIGGER " + tr_name);
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "NO CASCADE BEFORE UPDATE OF " + cols);
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "ON " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "REFERENCING OLD AS O");
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "FOR EACH ROW MODE DB2SQL");
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "BEGIN ATOMIC");
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        for (Column column : columns) {
            String fkName = "";
            FKIndexAssociation fk = column.getFKIndexAssociation();
            if (fk != null && !fk.isTransferable() && !fk.isMandatory()) {
                fkName = fk.getName();
            }
            SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, " IF O." + this.storageDesign.getFormatedName(column.getName()) + " IS NOT NULL THEN");
            SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "  signal SQLSTATE '85002' ('Non Transferable FK constraint " + fkName + " on table " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()) + " is violated');");
            SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, " END IF;");
            SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        }
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "END");
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendFKNoneTransferableMandatoryTrigger(StringBuffer buffer, TableProxy tableProxy, List columns, boolean prettyPrint) {
        String tr_name = this.makeTriggerName(tableProxy, "M");
        String cols = "";
        boolean first = true;
        HashMap<String, FKIndexAssociation> map = new HashMap<String, FKIndexAssociation>();
        String fkName = "";
        for (Column column : columns) {
            Object obj;
            FKIndexAssociation fk;
            String columnName = this.storageDesign.getFormatedName(column.getName());
            if (first) {
                cols = columnName;
                first = false;
            } else {
                cols = cols + "," + columnName;
            }
            if ((fk = column.getFKIndexAssociation()) == null || fk.isTransferable() || fk.isMandatory() || (obj = map.get(fk.getObjectID())) != null) continue;
            map.put(fk.getObjectID(), fk);
            if (map.size() > 1) {
                fkName = fkName + " ," + fk.getName();
                continue;
            }
            fkName = fk.getName();
        }
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "CREATE TRIGGER " + this.storageDesign.getFormatedName(tr_name));
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "NO CASCADE BEFORE UPDATE OF " + cols);
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "ON " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "FOR EACH ROW MODE DB2SQL");
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "BEGIN ATOMIC");
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "  signal SQLSTATE '85003' ('Non Transferable FK constraint " + fkName + " on table " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()) + " is violated');");
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(buffer, "END");
        SSBNoneTransferableFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    private String makeTriggerName(TableProxy tableProxy, String type) {
        String name = "";
        int size = 18;
        if (this.storageDesign instanceof StorageDesignUDB) {
            name = "FN" + type + "_";
        } else if (this.storageDesign instanceof StorageDesignDB2v70) {
            name = "FN" + type;
            size = 8;
        } else if (this.storageDesign instanceof StorageDesignDB2v80) {
            name = "FKNT_" + type + "_";
            size = 128;
        }
        name = name + this.getStringWithMaxLength(tableProxy.getName(), size - name.length());
        if (tableProxy.getUserSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            name = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + this.storageDesign.getFormatedName(name);
        }
        return name;
    }
}

