/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver;

import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.ColumnProxySqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBAutoIncrementColumnSqlServer
extends AbstractSSBSqlServer {
    private static final int MAX_OBJECT_LENGTH = 30;
    private static final String TRIGGER_SUFFIX = "TRG";
    private static final String SEQUENCE_SUFFIX = "SEQ";
    private StorageDesignSqlServer storageDesign;
    private static Set genSequenceSet = new HashSet();

    public SSBAutoIncrementColumnSqlServer(StorageDesignSqlServer storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return (object instanceof TableProxySqlServer || object instanceof Table) && this.storageDesign instanceof StorageDesignSqlServerv2k12;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (object instanceof TableProxySqlServer && ((TableProxySqlServer)object).isMarkedGenerate() || object instanceof Table && ((Table)object).isMarkedGenerate()) {
            Table table = object instanceof Table ? (Table)object : (Table)((TableProxySqlServer)object).getObject();
            for (Column column : table.getElementsAndNestedElementsCollection()) {
                if (!column.isAutoIncrementColumn()) continue;
                this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint);
            }
        }
    }

    public static void clearGenSequenceSet() {
        genSequenceSet.clear();
    }

    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint) {
        this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint, true);
    }

    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint, boolean tableCreated) {
        boolean genTrigger = true;
        if (this.storageDesign instanceof StorageDesignSqlServerv2k12) {
            ColumnProxySqlServerv2k12 columnProxy = (ColumnProxySqlServerv2k12)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
            if (columnProxy != null) {
                String autoIncDDL = columnProxy.getDDLTypeForAutoIncCol();
                if (autoIncDDL.equalsIgnoreCase("NONE")) {
                    return;
                }
                if (autoIncDDL.equalsIgnoreCase("TRIGGER") && !tableCreated) {
                    return;
                }
                if (autoIncDDL.equalsIgnoreCase("DEFAULT_CLAUSE")) {
                    if (tableCreated) {
                        return;
                    }
                    genTrigger = false;
                }
                if (autoIncDDL.equalsIgnoreCase("IDENTITY_CLAUSE")) {
                    String dt;
                    if (!tableCreated) {
                        return;
                    }
                    if (column.isIdentityColumn() && (dt = column.getDatatypeString(this.storageDesign.getRDBMSType().getName())).toUpperCase().indexOf("CHAR") <= -1) {
                        return;
                    }
                }
            }
        } else {
            return;
        }
        String sequenceName = this.generateSequenceName(buffer, column, prettyPrint);
        if (column.isAutoIncrementGenerateTrigger() && genTrigger) {
            TriggerSqlServer existingTrigger = null;
            String triggerName = column.getAutoIncrementTriggerName();
            if (StringUtilities.isNotEmpty(triggerName)) {
                TableProxySqlServer tableProxy;
                int indexOfDot = triggerName.indexOf(46);
                if (indexOfDot > -1) {
                    triggerName = triggerName.substring(indexOfDot + 1);
                }
                if ((tableProxy = (TableProxySqlServer)this.storageDesign.getTableProxySet().getProxy(column.getTable().getObjectID())) != null) {
                    for (TriggerSqlServer tableTrigger : tableProxy.getTriggers()) {
                        if (!tableTrigger.getName().equalsIgnoreCase(triggerName)) continue;
                        existingTrigger = tableTrigger;
                        break;
                    }
                }
            }
            if (existingTrigger == null) {
                Settings settings = column.getDesign().getAppView().getSettings();
                triggerName = this.generateAutoIncrementObjectName(triggerName, settings.getDefaultSqlServerTriggerName(), TRIGGER_SUFFIX, column);
                this.appendAutoIncrementTrigger(triggerName, sequenceName, column, buffer, prettyPrint);
            }
        }
    }

    public String generateSequenceName(StringBuffer buffer, Column column, boolean prettyPrint) {
        Settings settings = column.getDesign().getAppView().getSettings();
        String sequenceName = column.getAutoIncrementSequenceName();
        if (sequenceName != null) {
            sequenceName = sequenceName.trim();
        }
        String seqLongName = this.generateAutoIncrementObjectName(sequenceName, settings.getDefaultSqlServerSequenceName(), SEQUENCE_SUFFIX, column);
        SequenceSqlServerv2k12 sequence = null;
        String userName = "";
        int dotIndex = seqLongName.indexOf(46);
        if (dotIndex == -1) {
            sequenceName = seqLongName;
        } else {
            sequenceName = seqLongName.substring(dotIndex + 1);
            userName = seqLongName.substring(0, dotIndex);
            sequence = (SequenceSqlServerv2k12)((StorageDesignSqlServerv2k12)this.storageDesign).getSequenceSet().getBySchemaAndName(userName, sequenceName);
        }
        if (sequence == null) {
            sequence = (SequenceSqlServerv2k12)((StorageDesignSqlServerv2k12)this.storageDesign).getSequenceSet().getByName(sequenceName);
        }
        if (sequence != null) {
            return this.storageDesign.getFormatedLongNameDDL(sequence);
        }
        if (buffer != null && !genSequenceSet.contains(seqLongName)) {
            this.appendAutoIncrementSequence(seqLongName, column, buffer, prettyPrint);
            genSequenceSet.add(seqLongName);
        }
        return this.storageDesign.getFormatedName(seqLongName);
    }

    private String generateAutoIncrementObjectName(String objectName, String objectNameTemplate, String suffix, Column column) {
        String result;
        String schema = null;
        if (StringUtilities.isNotEmpty(objectName)) {
            int dotIndex = objectName.indexOf(46);
            if (dotIndex > -1) {
                schema = objectName.substring(0, dotIndex);
                result = objectName.substring(dotIndex + 1);
            } else {
                result = objectName;
            }
        } else {
            String columnAbbr;
            String columnName;
            String tableName;
            Table table = (Table)column.getParent();
            ColumnProxySqlServer columnProxy = (ColumnProxySqlServer)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
            TableProxySqlServer tableProxy = (TableProxySqlServer)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            if (tableProxy == null || columnProxy == null) {
                tableName = table.getName();
                columnName = column.getShortName();
                schema = table.getSchema();
            } else {
                String tableLongName;
                int userNameLength;
                tableName = tableProxy.getName();
                columnName = column.getParentObject() != null ? column.getShortName() : columnProxy.getName();
                SchemaSqlServerv2k5 autoIncSchema = ((ColumnProxySqlServerv2k12)columnProxy).getAutoIncrementSchema();
                schema = autoIncSchema != null ? autoIncSchema.getName() : ((userNameLength = (tableLongName = tableProxy.getLongName()).length() - tableName.length() - 1) > 0 ? tableLongName.substring(0, userNameLength) : "");
            }
            String tableAbbr = table.getAbbreviation();
            if (StringUtilities.isEmpty(tableAbbr)) {
                tableAbbr = tableName;
            }
            if (StringUtilities.isEmpty(columnAbbr = column.getAbbreviation())) {
                columnAbbr = columnName;
            }
            if (StringUtilities.isNotEmpty(objectNameTemplate)) {
                result = objectNameTemplate.replaceAll("\\{table\\}", tableName).replaceAll("\\{table abbr\\}", tableAbbr).replaceAll("\\{column\\}", columnName).replaceAll("\\{column abbr\\}", columnAbbr);
            } else {
                result = tableAbbr + '_' + columnAbbr;
                if (result.length() + suffix.length() + 1 <= 30) {
                    result = result + '_' + suffix;
                }
            }
        }
        result = this.getStringWithMaxLength(result, 30);
        if (StringUtilities.isNotEmpty(schema) && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            result = schema + '.' + result;
        }
        return result;
    }

    private void appendAutoIncrementSequence(String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String autoIncrementStartWith = column.getAutoIncrementStartWith();
        Integer autoIncrementIncrementBy = column.getAutoIncrementIncrementBy();
        String autoIncrementMaxValue = column.getAutoIncrementMaxValue();
        String autoIncrementMinValue = column.getAutoIncrementMinValue();
        Integer autoIncrementCache = column.getAutoIncrementCache();
        SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 0);
        SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "CREATE");
        SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "SEQUENCE");
        SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sequenceName));
        String advancedComment = buffer.toString();
        if (autoIncrementStartWith != null && !"".equals(autoIncrementStartWith)) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "START");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "WITH");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, autoIncrementStartWith);
        }
        if (autoIncrementIncrementBy != null && autoIncrementIncrementBy != 0) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, autoIncrementIncrementBy);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "BY");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "1");
        }
        if (autoIncrementMinValue != null) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "MINVALUE");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, autoIncrementMinValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "MINVALUE");
        }
        if (autoIncrementMaxValue != null) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "MAXVALUE");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, autoIncrementMaxValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "MAXVALUE");
        }
        if (column.isAutoIncrementCycle()) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "CYCLE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "CYCLE");
        }
        if (column.isAutoIncrementDisableCache()) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "CACHE");
        } else if (autoIncrementCache != null) {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "CACHE");
            this.appendStringWithSpace(buffer, autoIncrementCache);
        } else {
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "CACHE");
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBAutoIncrementColumnSqlServer.appendNewLine(oldbuffer, prettyPrint, 0);
        SSBAutoIncrementColumnSqlServer.appendStringWithSpace(oldbuffer, "GO");
        SSBAutoIncrementColumnSqlServer.appendNewLine(oldbuffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateSequence();
    }

    private void appendAutoIncrementTrigger(String triggerName, String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        ColumnProxySqlServer columnProxy;
        Table table = (Table)column.getParent();
        TableProxySqlServer tableProxy = (TableProxySqlServer)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null && (columnProxy = (ColumnProxySqlServer)tableProxy.getColumnProxy(column.getObjectID())) != null) {
            StringBuffer buffer = new StringBuffer();
            String tableLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            String columnName = this.storageDesign.getFormatedName(columnProxy);
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "CREATE");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "TRIGGER");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(triggerName));
            String advancedComment = buffer.toString();
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "ON");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, tableLongName);
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "FOR");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "INSERT");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "NOT FOR REPLICATION");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "AS");
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "BEGIN");
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 2);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "UPDATE");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, tableLongName);
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 2);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "SET");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, columnName);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, '=');
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, '(');
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "NEXT");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "VALUE");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "FOR");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, sequenceName);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, ')');
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 2);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "WHERE");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, columnName);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "IS");
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(buffer, "NULL");
            SSBAutoIncrementColumnSqlServer.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnSqlServer.appendString(buffer, "END");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBAutoIncrementColumnSqlServer.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBAutoIncrementColumnSqlServer.appendStringWithSpace(oldbuffer, "GO");
            SSBAutoIncrementColumnSqlServer.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateTrigger();
        }
    }
}

