/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBUserOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        UserOraclev9i user = (UserOraclev9i)object;
        this.storageDesign = user.getStorageDesign();
        this.appendComment(oldbuffer, user);
        SSBUserOraclev9i.appendStringWithSpace(buffer, "CREATE");
        SSBUserOraclev9i.appendStringWithSpace(buffer, "USER");
        SSBUserOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
        advancedComment = buffer.toString();
        this.appendAuthenticationType(buffer, user, prettyPrint);
        this.appendDefaultTableSpace(buffer, user, prettyPrint);
        this.appendTempTableSpace(buffer, user, prettyPrint);
        this.appendQuotaItems(buffer, user, prettyPrint);
        this.appendProfile(buffer, user, prettyPrint);
        this.appendPasswordExpire(buffer, user, prettyPrint);
        this.appendAccountLock(buffer, user, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateUser();
        this.appendRolesAndPrivileges(oldbuffer, user, prettyPrint);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof UserOraclev9i && ((UserOraclev9i)object).isMarkedGenerate();
    }

    private void appendAuthenticationType(StringBuffer buffer, UserOraclev9i user, boolean prettyPrint) {
        String authType = user.getAuthType();
        SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBUserOraclev9i.appendStringWithSpace(buffer, "IDENTIFIED");
        if (authType.equalsIgnoreCase("BY_PASSWORD")) {
            SSBUserOraclev9i.appendStringWithSpace(buffer, "BY");
            SSBUserOraclev9i.appendStringWithSpace(buffer, user.decodeIdentifier());
        } else if (authType.equalsIgnoreCase("EXTERNALLY")) {
            SSBUserOraclev9i.appendStringWithSpace(buffer, "EXTERNALLY");
        } else {
            SSBUserOraclev9i.appendStringWithSpace(buffer, "GLOBALLY AS");
            SSBUserOraclev9i.appendStringWithSpace(buffer, user.decodeIdentifier());
        }
    }

    private void appendDefaultTableSpace(StringBuffer buffer, UserOraclev9i user, boolean prettyPrint) {
        if (user.getDefTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            String tableSpace = this.storageDesign.getFormatedName(user.getDefTableSpace());
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBUserOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
            SSBUserOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBUserOraclev9i.appendStringWithSpace(buffer, tableSpace);
        }
    }

    private void appendTempTableSpace(StringBuffer buffer, UserOraclev9i user, boolean prettyPrint) {
        if (user.getTempTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBUserOraclev9i.appendStringWithSpace(buffer, "TEMPORARY");
            SSBUserOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBUserOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user.getTempTableSpace()));
        }
    }

    private void appendQuotaItems(StringBuffer buffer, UserOraclev9i user, boolean prettyPrint) {
        for (QuotaItemOracle quotaItem : ((StorageDesignOracle)this.storageDesign).getQuotaItemSet()) {
            if (quotaItem.getUser() == null || quotaItem.getTableSpace() == null || !quotaItem.getUser().toString().equalsIgnoreCase(user.toString())) continue;
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBUserOraclev9i.appendStringWithSpace(buffer, "QUOTA");
            SSBUserOraclev9i.appendStringWithSpace(buffer, quotaItem.getSize());
            SSBUserOraclev9i.appendStringWithSpace(buffer, "ON");
            SSBUserOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(quotaItem.getTableSpace()));
        }
    }

    private void appendProfile(StringBuffer buffer, UserOraclev9i user, boolean prettyPrint) {
        String profile = user.getProfile();
        if (!"".equalsIgnoreCase(profile)) {
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBUserOraclev9i.appendStringWithSpace(buffer, "PROFILE");
            SSBUserOraclev9i.appendStringWithSpace(buffer, profile);
        }
    }

    private void appendPasswordExpire(StringBuffer buffer, UserOraclev9i user, boolean prettyPrint) {
        String passExpire = user.getPasswordExpire();
        if (passExpire.equalsIgnoreCase("YES")) {
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBUserOraclev9i.appendStringWithSpace(buffer, "PASSWORD EXPIRE");
        }
    }

    private void appendAccountLock(StringBuffer buffer, UserOraclev9i user, boolean prettyPrint) {
        String accountLock = user.getAccountLock();
        SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        if (accountLock.equalsIgnoreCase("YES")) {
            SSBUserOraclev9i.appendStringWithSpace(buffer, "ACCOUNT LOCK");
        } else {
            SSBUserOraclev9i.appendStringWithSpace(buffer, "ACCOUNT UNLOCK");
        }
    }

    private void appendRolesAndPrivileges(StringBuffer oldbuffer, UserOraclev9i user, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        String roles = user.getRolesNames();
        String rolesAdminOption = user.getRolesWithAdminOptionNames();
        String privileges = user.getPrivileges();
        String privilegesAdminOption = user.getPrivilegesWithAdminOption();
        if (!"".equalsIgnoreCase(roles)) {
            SSBUserOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBUserOraclev9i.appendStringWithSpace(buffer, roles);
            SSBUserOraclev9i.appendStringWithSpace(buffer, "TO");
            SSBUserOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(rolesAdminOption)) {
            SSBUserOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBUserOraclev9i.appendStringWithSpace(buffer, rolesAdminOption);
            SSBUserOraclev9i.appendStringWithSpace(buffer, "TO");
            SSBUserOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
            buffer.append(" WITH ADMIN OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(privileges)) {
            SSBUserOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBUserOraclev9i.appendStringWithSpace(buffer, privileges);
            SSBUserOraclev9i.appendStringWithSpace(buffer, "TO");
            SSBUserOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(privilegesAdminOption)) {
            SSBUserOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBUserOraclev9i.appendStringWithSpace(buffer, privilegesAdminOption);
            SSBUserOraclev9i.appendStringWithSpace(buffer, "TO");
            SSBUserOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
            buffer.append(" WITH ADMIN OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUserOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }
}

